/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AnnotationFieldName;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.LocalId;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeMaker;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Names;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.model.FieldValue;
import com.redhat.ceylon.model.loader.model.JavaMethod;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.LazyValue;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Naming
extends NamingBase
implements LocalId {
    private static final String IMPL_POSTFIX = NamingBase.Suffix.$impl.toString();
    private static final String ANNO_POSTFIX = NamingBase.Suffix.$annotation$.toString();
    private static final String ANNOS_POSTFIX = NamingBase.Suffix.$annotations$.toString();
    private static final String DELEGATION_POSTFIX = NamingBase.Suffix.$delegation$.toString();
    private static final HashSet<String> QUOTABLE_METHOD_NAMES;
    private static final List<String> COM_REDHAT_CEYLON_LANGUAGE_PACKAGE;
    private final Map<Scope, Integer> locals = new HashMap<Scope, Integer>();
    private TreeMaker maker;
    private Names names;
    private Context context;
    static final int NA_MEMBER = 1;
    static final int NA_WRAPPER = 2;
    static final int NA_WRAPPER_UNQUOTED = 4;
    static final int NA_Q_LOCAL_INSTANCE = 64;
    static final int NA_FQ = 8;
    static final int NA_GETTER = 16;
    static final int NA_SETTER = 32;
    static final int NA_IDENT = 128;
    static final int NA_ALIASED = 256;
    static final int NA_ANNOTATION_MEMBER = 512;
    static final int NA_WRAPPER_WITH_THIS = 1024;
    static final int NA_CANONICAL_METHOD = 2048;
    private static final int __NA_IDENT_PARAMETER_ALIASED = 4096;
    static final int NA_IDENT_PARAMETER_ALIASED = 4224;
    private long id = 0L;
    private Map<Scope, com.redhat.ceylon.langtools.tools.javac.util.List<Substitution>> scopedSubstitutions = new HashMap<Scope, com.redhat.ceylon.langtools.tools.javac.util.List<Substitution>>();

    static String compoundName(String name, String name2) {
        return name + "$" + name2;
    }

    static String compoundName(String ... names) {
        if (names.length == 0) {
            throw new RuntimeException();
        }
        StringBuilder sb = new StringBuilder();
        for (String s : names) {
            sb.append(s).append('$');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String quote(String name) {
        return JVMModuleUtil.quote(name);
    }

    public static boolean isJavaKeyword(String name) {
        return JVMModuleUtil.isJavaKeyword(name);
    }

    public static String quoteIfJavaKeyword(String name) {
        return JVMModuleUtil.quoteIfJavaKeyword(name);
    }

    private static String getMethodName(TypedDeclaration decl, int namingOptions) {
        String methodName;
        if (decl.isClassOrInterfaceMember()) {
            String name = decl.getName();
            if (decl instanceof Value && (namingOptions & 0x200) == 0 && "hash".equals(name)) {
                return "hashCode";
            }
            if (decl instanceof Value && (namingOptions & 0x200) == 0 && "string".equals(name)) {
                return "toString";
            }
            if ("equals".equals(name)) {
                return "equals";
            }
            methodName = Naming.getMethodNameInternal(decl);
        } else {
            methodName = Naming.getMethodNameInternal(decl);
        }
        if ((namingOptions & 0x800) != 0) {
            methodName = Naming.suffixName(NamingBase.Suffix.$canonical$, methodName);
        }
        return methodName;
    }

    private static String getMethodNameInternal(TypedDeclaration decl) {
        String name;
        if (decl.isClassOrInterfaceMember() && decl instanceof Function) {
            Declaration refined = decl.getRefinedDeclaration();
            if (refined instanceof JavaMethod) {
                return ((JavaMethod)refined).getRealName();
            }
            name = Naming.quoteMethodNameIfProperty((Function)decl);
        } else {
            name = decl.getName();
        }
        if (decl.isClassMember() && "readResolve".equals(name) && Strategy.addReadResolve((Class)decl.getContainer())) {
            return Naming.quote(name);
        }
        if (decl.isClassMember() && "writeReplace".equals(name) && Strategy.useSerializationProxy((Class)decl.getContainer())) {
            return Naming.quote(name);
        }
        if (QUOTABLE_METHOD_NAMES.contains(name)) {
            return Naming.quote(name);
        }
        return Naming.quoteIfJavaKeyword(name);
    }

    public static String getVariableName(Tree.Variable var) {
        return var != null ? Naming.quoteIfJavaKeyword(var.getIdentifier().getText()) : null;
    }

    public static String getLocalValueName(Value val) {
        return Naming.quoteIfJavaKeyword(val.getName());
    }

    public static String quoteLocalValueName(String name) {
        return Naming.quoteIfJavaKeyword(name);
    }

    public static String quoteFieldName(String name) {
        return Naming.quoteIfJavaKeyword(name);
    }

    public static String quoteParameterName(String name) {
        return Naming.quoteIfJavaKeyword(name);
    }

    public static String quoteMethodName(String name) {
        return Naming.quoteIfJavaKeyword(name);
    }

    public void assignNames(Tree.CompilationUnit cu) {
        this.locals.clear();
        LocalIdVisitor liv = new LocalIdVisitor();
        cu.visit(liv);
    }

    JCTree.JCExpression makeTypeDeclarationExpression(JCTree.JCExpression qualifyingExpr, TypeDeclaration decl, DeclNameFlag ... options) {
        if (decl == null) {
            return this.make().Erroneous();
        }
        TreeDeclName helper = new TreeDeclName(decl, qualifyingExpr);
        return this.makeTypeDeclaration(helper, decl, options);
    }

    private <R> R makeTypeDeclaration(TypeDeclarationBuilder<R> declarationBuilder, TypeDeclaration decl, DeclNameFlag ... options) {
        EnumSet<DeclNameFlag> flags = EnumSet.noneOf(DeclNameFlag.class);
        flags.addAll(Arrays.asList(options));
        if (flags.contains((Object)DeclNameFlag.ANNOTATION) && !Decl.isAnnotationClass(decl)) {
            throw new BugException(decl.getName());
        }
        if (flags.contains((Object)DeclNameFlag.ANNOTATIONS) && !Decl.isAnnotationClass(decl) && !(decl instanceof Class) && !this.gen().isSequencedAnnotation((Class)decl)) {
            throw new BugException(decl.getName());
        }
        ArrayList<TypeDeclaration> l = new ArrayList<TypeDeclaration>();
        Scope s = decl;
        do {
            l.add((TypeDeclaration)s);
        } while (!((s = s.getContainer()) instanceof Package));
        Collections.reverse(l);
        if (flags.contains((Object)DeclNameFlag.QUALIFIED) && (!decl.isAnonymous() || decl.isNamed())) {
            List<String> packageName;
            List<String> list = packageName = AbstractTransformer.isJavaArray(decl) || AbstractTransformer.isJavaInterop(decl) ? COM_REDHAT_CEYLON_LANGUAGE_PACKAGE : ((Package)s).getName();
            if (packageName.isEmpty() || !packageName.get(0).isEmpty()) {
                declarationBuilder.select("");
            }
            for (int ii = 0; ii < packageName.size(); ++ii) {
                declarationBuilder.select(Naming.quoteIfJavaKeyword(packageName.get(ii)));
            }
        }
        for (int ii = 0; ii < l.size(); ++ii) {
            Scope scope = (Scope)l.get(ii);
            boolean last = ii == l.size() - 1;
            this.appendTypeDeclaration(decl, flags, declarationBuilder, scope, last);
        }
        return declarationBuilder.result();
    }

    private void appendTypeDeclaration(TypeDeclaration decl, EnumSet<DeclNameFlag> flags, TypeDeclarationBuilder<?> typeDeclarationBuilder, Scope scope, boolean last) {
        if (scope instanceof Class || scope instanceof TypeAlias || scope instanceof Constructor && (scope.equals(decl) || !Decl.isLocalNotInitializerScope(scope))) {
            TypeDeclaration klass = (TypeDeclaration)scope;
            if (klass.isAnonymous() && !klass.isNamed()) {
                typeDeclarationBuilder.clear();
            }
            String className = "";
            if (klass.getName() != null) {
                className = ModelUtil.isCeylonDeclaration(klass) ? Naming.escapeClassName(klass.getName()) : Naming.getRealName(klass, 4);
            }
            typeDeclarationBuilder.append(className);
            if (Decl.isCeylon(klass)) {
                if (flags.contains((Object)DeclNameFlag.COMPANION) && Decl.isLocalNotInitializer(klass) && last) {
                    typeDeclarationBuilder.append(IMPL_POSTFIX);
                } else if (flags.contains((Object)DeclNameFlag.ANNOTATION) && last) {
                    typeDeclarationBuilder.append(ANNO_POSTFIX);
                } else if (flags.contains((Object)DeclNameFlag.ANNOTATIONS) && last) {
                    typeDeclarationBuilder.append(ANNOS_POSTFIX);
                } else if (flags.contains((Object)DeclNameFlag.DELEGATION) && last) {
                    typeDeclarationBuilder.append(DELEGATION_POSTFIX);
                }
            }
        } else if (scope instanceof Interface) {
            Interface iface = (Interface)scope;
            String className = "";
            if (iface.getName() != null) {
                className = ModelUtil.isCeylonDeclaration(iface) ? iface.getName() : Naming.getRealName(iface, 4);
            }
            typeDeclarationBuilder.append(className);
            if (Decl.isCeylon(iface) && (decl instanceof Class || decl instanceof Constructor || decl instanceof TypeAlias || scope instanceof Constructor || flags.contains((Object)DeclNameFlag.COMPANION))) {
                typeDeclarationBuilder.append(IMPL_POSTFIX);
            }
        } else {
            if (Decl.isLocalNotInitializerScope(scope)) {
                if (flags.contains((Object)DeclNameFlag.COMPANION) || !(decl instanceof Interface)) {
                    typeDeclarationBuilder.clear();
                } else if (flags.contains((Object)DeclNameFlag.QUALIFIED) || decl instanceof Interface) {
                    Scope nonLocal = scope;
                    while (!(nonLocal instanceof Declaration)) {
                        nonLocal = nonLocal.getContainer();
                    }
                    typeDeclarationBuilder.append(((Declaration)((Object)nonLocal)).getPrefixedName());
                    if (!Decl.equalScopes(scope, nonLocal)) {
                        typeDeclarationBuilder.append('$');
                        typeDeclarationBuilder.append(this.getLocalId(scope));
                    }
                    if (decl instanceof Interface) {
                        typeDeclarationBuilder.append('$');
                    } else if (flags.contains((Object)DeclNameFlag.QUALIFIED)) {
                        typeDeclarationBuilder.selectAppended();
                    } else {
                        typeDeclarationBuilder.clear();
                    }
                }
                return;
            }
            if (!(scope instanceof TypedDeclaration) || ((Declaration)((Object)scope)).isToplevel()) {
                // empty if block
            }
        }
        if (!last) {
            if (decl instanceof Interface && Decl.isCeylon(decl) && !flags.contains((Object)DeclNameFlag.COMPANION)) {
                typeDeclarationBuilder.append('$');
            } else if (decl instanceof Constructor && ((Class)decl.getContainer()).isMember() && decl.getContainer().equals(scope)) {
                typeDeclarationBuilder.append('$');
            } else if (flags.contains((Object)DeclNameFlag.QUALIFIED)) {
                typeDeclarationBuilder.selectAppended();
            } else {
                typeDeclarationBuilder.clear();
            }
        } else {
            typeDeclarationBuilder.selectAppended();
        }
    }

    public static String toplevelClassName(String pkgName, Tree.Declaration declaration) {
        StringBuilder b = new StringBuilder();
        if (!pkgName.isEmpty()) {
            b.append(pkgName).append('.');
        }
        Naming.appendClassName(b, declaration);
        return b.toString();
    }

    private static void appendClassName(StringBuilder b, Tree.Declaration decl) {
        if (decl instanceof Tree.AnyClass) {
            Tree.AnyClass klass = (Tree.AnyClass)decl;
            b.append(klass.getIdentifier().getText());
        } else if (decl instanceof Tree.TypeAliasDeclaration) {
            Tree.TypeAliasDeclaration klass = (Tree.TypeAliasDeclaration)decl;
            b.append(klass.getIdentifier().getText());
        } else if (decl instanceof Tree.AnyInterface) {
            Tree.AnyInterface iface = (Tree.AnyInterface)decl;
            b.append(iface.getIdentifier().getText());
        } else if (decl instanceof Tree.TypedDeclaration) {
            String name = decl.getIdentifier().getText();
            b.append(name);
            if (Naming.isLowerCase(name)) {
                b.append('_');
            }
        } else {
            throw new RuntimeException("Don't know how to get a class name for tree of type " + decl.getClass());
        }
    }

    public static String toplevelClassName(String pkgName, Declaration declaration) {
        StringBuilder b = new StringBuilder();
        if (!pkgName.isEmpty()) {
            b.append(pkgName).append('.');
        }
        Naming.appendClassName(b, declaration);
        return b.toString();
    }

    private static void appendClassName(StringBuilder b, Declaration decl) {
        if (decl instanceof ClassOrInterface || decl instanceof TypeAlias) {
            b.append(decl.getName());
        } else if (decl instanceof TypedDeclaration) {
            b.append(decl.getName());
            b.append('_');
        } else {
            throw new RuntimeException("Don't know how to get a class name for tree of type " + decl.getClass());
        }
    }

    String makeTypeDeclarationName(TypeDeclaration decl, DeclNameFlag ... options) {
        StringDeclName helper = new StringDeclName(decl, null);
        return this.makeTypeDeclaration(helper, decl, options);
    }

    JCTree.JCExpression makeDeclarationName(TypeDeclaration decl, DeclNameFlag ... flags) {
        return this.makeTypeDeclarationExpression(null, decl, flags);
    }

    String getCompanionClassName(TypeDeclaration decl, boolean qualified) {
        if (qualified) {
            return this.makeTypeDeclarationName(decl, DeclNameFlag.QUALIFIED, DeclNameFlag.COMPANION);
        }
        return this.makeTypeDeclarationName(decl, DeclNameFlag.COMPANION);
    }

    JCTree.JCExpression makeCompanionClassName(TypeDeclaration decl) {
        return this.makeTypeDeclarationExpression(null, decl, DeclNameFlag.QUALIFIED, DeclNameFlag.COMPANION);
    }

    private static String quoteMethodNameIfProperty(Function method) {
        String name = method.getName();
        if (!method.isShared()) {
            name = Naming.suffixName(NamingBase.Suffix.$priv$, name);
        }
        if (method instanceof LazyFunction) {
            return ((LazyFunction)method).getRealName();
        }
        if (!method.isClassOrInterfaceMember()) {
            return name;
        }
        Function refinedMethod = (Function)method.getRefinedDeclaration();
        if (refinedMethod instanceof JavaMethod) {
            return ((JavaMethod)refinedMethod).getRealName();
        }
        if ((name.length() >= 4 && name.startsWith("get") || name.length() >= 3 && name.startsWith("is")) && method.getFirstParameterList().getParameters().isEmpty() && !AbstractTransformer.isAnything(method.getType())) {
            return Naming.quote(name);
        }
        if (name.length() >= 4 && name.startsWith("set") && method.getFirstParameterList().getParameters().size() == 1 && AbstractTransformer.isAnything(method.getType())) {
            return Naming.quote(name);
        }
        return name;
    }

    private static String quoteMethodName(Function decl, int namingOptions) {
        Declaration refinedDecl = decl.getRefinedDeclaration();
        return Naming.getMethodName((Function)refinedDecl, namingOptions);
    }

    public static String getDefaultedParamMethodName(Declaration decl, Parameter param) {
        if (Decl.isConstructor(decl)) {
            Constructor constructor = Decl.getConstructor(decl);
            if (Decl.isDefaultConstructor(constructor)) {
                return Naming.compoundName(Decl.getConstructedClass(constructor).getName(), param.getName());
            }
            return Naming.compoundName(Decl.getConstructedClass(constructor).getName(), decl.getName(), param.getName());
        }
        if (decl instanceof Function) {
            if (decl.isAnonymous()) {
                return Naming.prefixName(NamingBase.Prefix.$default$, param.getName());
            }
            return Naming.compoundName(((Function)decl).getName(), CodegenUtil.getTopmostRefinedDeclaration(param.getModel()).getName());
        }
        if (decl instanceof ClassOrInterface) {
            if (decl.isToplevel() || Decl.isLocalNotInitializer(decl)) {
                return Naming.prefixName(NamingBase.Prefix.$default$, param.getName());
            }
            return Naming.prefixName(NamingBase.Prefix.$default$, decl.getName(), param.getName());
        }
        if (decl == null) {
            return Naming.prefixName(NamingBase.Prefix.$default$, param.getName());
        }
        return null;
    }

    String getInstantiatorMethodName(Functional classOrCtor) {
        return Naming.suffixName(NamingBase.Suffix.$new$, classOrCtor.getName());
    }

    JCTree.JCExpression makeInstantiatorMethodName(JCTree.JCExpression qual, Class model) {
        return this.makeQualIdent(qual, this.getInstantiatorMethodName(model));
    }

    static String getAliasedParameterName(Parameter parameter) {
        return Naming.getAliasedParameterName(parameter.getModel());
    }

    static boolean aliasConstructorParameterName(FunctionOrValue mov) {
        return mov.getContainer() instanceof Constructor && !mov.isShared();
    }

    private static String getAliasedParameterName(FunctionOrValue parameter) {
        if (!parameter.isParameter()) {
            throw new BugException();
        }
        FunctionOrValue mov = parameter;
        if (mov instanceof Function && ((Function)mov).isDeferred() || mov instanceof Value && mov.isVariable() && mov.isCaptured() || Naming.aliasConstructorParameterName(mov)) {
            return Naming.suffixName(NamingBase.Suffix.$param$, parameter.getName());
        }
        return Naming.quoteIfJavaKeyword(parameter.getName());
    }

    Naming(TreeMaker maker, Names names) {
        this.maker = maker;
        this.names = names;
    }

    Naming(Context context) {
        this.context = context;
        this.maker = TreeMaker.instance(context);
        this.names = Names.instance(context);
    }

    public static Naming instance(Context context) {
        Naming instance = context.get(Naming.class);
        if (instance == null) {
            instance = new Naming(context);
            context.put(Naming.class, instance);
        }
        return instance;
    }

    private TreeMaker make() {
        return this.maker;
    }

    private Names names() {
        return this.names;
    }

    private CeylonTransformer gen() {
        return CeylonTransformer.getInstance(this.context);
    }

    JCTree.JCIdent makeUnquotedIdent(String ident) {
        return this.make().Ident(this.makeUnquotedName(ident));
    }

    JCTree.JCIdent makeUnquotedIdent(Name ident) {
        return this.make().Ident(ident);
    }

    JCTree.JCIdent makeUnquotedIdent(NamingBase.Unfix ident) {
        return this.make().Ident(this.makeUnquotedName(Naming.name(ident)));
    }

    Name makeUnquotedName(String ident) {
        return this.names().fromString(ident);
    }

    JCTree.JCIdent makeQuotedIdent(String ident) {
        return this.make().Ident(this.makeQuotedName(ident));
    }

    Name makeQuotedName(String ident) {
        return this.names().fromString(Naming.quoteIfJavaKeyword(ident));
    }

    JCTree.JCExpression makeQuotedQualIdentFromString(String qualifiedName) {
        return this.makeQualIdent(null, Util.quoteJavaKeywords(qualifiedName.split("\\.")));
    }

    private JCTree.JCExpression makeQualIdent(JCTree.JCExpression expr, String ... names) {
        if (names != null) {
            for (String component : names) {
                if (component == null) continue;
                expr = expr == null ? this.makeUnquotedIdent(component) : this.makeSelect(expr, component);
            }
        }
        return expr;
    }

    JCTree.JCExpression makeQuotedQualIdent(JCTree.JCExpression expr, String ... names) {
        if (names != null) {
            for (String component : names) {
                if (component == null) continue;
                expr = expr == null ? this.makeQuotedIdent(component) : this.makeSelect(expr, Naming.quoteIfJavaKeyword(component));
            }
        }
        return expr;
    }

    JCTree.JCExpression makeFQIdent(String ... components) {
        return this.makeQualIdent((JCTree.JCExpression)this.makeUnquotedIdent(""), components);
    }

    JCTree.JCExpression makeQuotedFQIdent(String ... components) {
        return this.makeQuotedQualIdent(this.makeUnquotedIdent(""), components);
    }

    JCTree.JCExpression makeQuotedFQIdent(String qualifiedName) {
        return this.makeQuotedFQIdent(Util.quoteJavaKeywords(qualifiedName.split("\\.")));
    }

    JCTree.JCExpression makeIdent(Type type) {
        return this.make().QualIdent(type.tsym);
    }

    JCTree.JCFieldAccess makeSelect(JCTree.JCExpression s1, String s2) {
        return this.make().Select(s1, this.names().fromString(s2));
    }

    JCTree.JCFieldAccess makeSelect(JCTree.JCExpression s1, Name s2) {
        return this.make().Select(s1, s2);
    }

    JCTree.JCFieldAccess makeSelect(String s1, String s2) {
        return this.makeSelect((JCTree.JCExpression)this.makeUnquotedIdent(s1), s2);
    }

    JCTree.JCFieldAccess makeSelect(String s1, Name s2) {
        return this.makeSelect((JCTree.JCExpression)this.makeUnquotedIdent(s1), s2);
    }

    JCTree.JCExpression makeDefaultedParamMethod(JCTree.JCExpression qualifier, Parameter param) {
        if (!Strategy.hasDefaultParameterValueMethod(param)) {
            throw new BugException();
        }
        Declaration decl = param.getDeclaration();
        String methodName = Naming.getDefaultedParamMethodName(decl, param);
        switch (Strategy.defaultParameterMethodOwner(param.getModel())) {
            case SELF: {
                Declaration container = param.getDeclaration().getRefinedDeclaration();
                if (!container.isToplevel()) {
                    container = (Declaration)((Object)container.getContainer());
                }
                JCTree.JCExpression className = this.makeTypeDeclarationExpression(qualifier, (TypeDeclaration)container, DeclNameFlag.COMPANION);
                return this.makeSelect(className, methodName);
            }
            case OUTER: 
            case OUTER_COMPANION: {
                return this.makeQuotedQualIdent(qualifier, methodName);
            }
            case STATIC: {
                Declaration container = param.getDeclaration().getRefinedDeclaration();
                if (!container.isToplevel() && !container.isStatic()) {
                    container = (Declaration)((Object)container.getContainer());
                } else if (container.isStatic() && container instanceof TypedDeclaration) {
                    container = (Declaration)((Object)container.getContainer());
                }
                if (container instanceof TypedDeclaration) {
                    return this.makeSelect(this.makeName((TypedDeclaration)container, 10), methodName);
                }
                return this.makeSelect(this.gen().makeJavaType(((TypeDeclaration)container).getType(), 12), methodName);
            }
        }
        return this.makeQuotedQualIdent(qualifier, methodName);
    }

    JCTree.JCExpression makeQualifiedThis(JCTree.JCExpression qualifier) {
        if (qualifier == null) {
            return this.maker.Ident(this.names._this);
        }
        return this.maker.Select(qualifier, this.names._this);
    }

    JCTree.JCExpression makeThis() {
        return this.makeQualifiedThis(null);
    }

    JCTree.JCExpression makeQuotedThis() {
        return this.makeUnquotedIdent("$this");
    }

    JCTree.JCExpression makeQualifiedDollarThis(JCTree.JCExpression qualifier) {
        return this.maker.Select(qualifier, this.makeUnquotedName("$this"));
    }

    JCTree.JCExpression makeQualifiedSuper(JCTree.JCExpression qualifier) {
        if (qualifier == null) {
            return this.maker.Ident(this.names._super);
        }
        return this.maker.Select(qualifier, this.names._super);
    }

    JCTree.JCExpression makeSuper() {
        return this.makeQualifiedSuper(null);
    }

    String getName(TypedDeclaration decl, int namingOptions) {
        StringDeclName builder = new StringDeclName(decl, "");
        return this.makeQualifiedNameInternal(builder, decl, namingOptions);
    }

    JCTree.JCExpression makeName(TypedDeclaration decl, int namingOptions) {
        TreeDeclName builder = new TreeDeclName(decl, (namingOptions & 8) != 0 ? this.maker.Ident(this.names.empty) : null);
        return this.makeQualifiedNameInternal(builder, decl, namingOptions);
    }

    JCTree.JCExpression makeQualifiedName(JCTree.JCExpression qualifyingExpr, TypedDeclaration decl, int namingOptions) {
        TreeDeclName builder = new TreeDeclName(decl, qualifyingExpr);
        return this.makeQualifiedNameInternal(builder, decl, namingOptions);
    }

    private <R> R makeQualifiedNameInternal(TypeDeclarationBuilder<R> builder, TypedDeclaration decl, int namingOptions) {
        if (namingOptions == 0) {
            throw new BugException();
        }
        this.addNamesForWrapperClass(builder, decl, namingOptions);
        if ((namingOptions & 0x81) != 0) {
            this.addMemberName(builder, decl, namingOptions);
        }
        return builder.result();
    }

    private <R> void addMemberName(TypeDeclarationBuilder<R> builder, TypedDeclaration decl, int namingOptions) {
        if (Decl.isJavaField(decl)) {
            String name = ((FieldValue)decl).getRealName();
            builder.select(name);
        } else if ((namingOptions & 0x80) != 0) {
            if ((namingOptions & 0x10 | 0x20) == 0) {
                throw new BugException();
            }
            String name = (namingOptions & 0x1000) != 0 ? Naming.getAliasedParameterName((FunctionOrValue)decl) : this.substitute(decl);
            builder.select(name);
        } else if ((namingOptions & 0x20) != 0) {
            if (decl instanceof Function) {
                throw new BugException("A method has no setter");
            }
            builder.select(Naming.getSetterName(decl));
        } else if ((namingOptions & 0x10) != 0) {
            if (decl instanceof Function) {
                throw new BugException("A method has no getter");
            }
            builder.select(Naming.getGetterName(decl));
        } else if (decl instanceof Value && !((Value)decl).isParameter()) {
            builder.select(Naming.getGetterName(decl));
        } else if (decl instanceof Setter) {
            builder.select(Naming.getSetterName(decl.getName()));
        } else if (decl instanceof Function && (!decl.isParameter() || decl.isShared() || decl.isCaptured()) && (namingOptions & 0x100) == 0) {
            builder.select(Naming.getMethodName(decl, namingOptions));
        } else if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter()) {
            if ((namingOptions & 0x100) != 0) {
                builder.select(Naming.getAliasedParameterName((FunctionOrValue)decl));
            } else {
                builder.select(decl.getName());
            }
        }
    }

    public static boolean isJavaInterop(Declaration decl) {
        return decl instanceof Class && "java.lang::Types".equals(decl.getQualifiedNameString());
    }

    private <R> void addNamesForWrapperClass(TypeDeclarationBuilder<R> builder, TypedDeclaration decl, int namingOptions) {
        if ((namingOptions & 8) != 0) {
            if ((namingOptions & 2) == 0 && (namingOptions & 4) == 0) {
                throw new BugException("If you pass FQ you must pass WRAPPER or WRAPPER_UNQUOTED too, or there's no class name to qualify!");
            }
            ArrayList<String> outerNames = null;
            boolean isInterop = false;
            for (Scope s = decl.getContainer(); s != null; s = s.getContainer()) {
                if (s instanceof Package) {
                    List<String> packageName = isInterop ? COM_REDHAT_CEYLON_LANGUAGE_PACKAGE : ((Package)s).getName();
                    for (int ii = 0; ii < packageName.size(); ++ii) {
                        if (ii == 0 && packageName.get(ii).isEmpty()) continue;
                        builder.select(Naming.quoteIfJavaKeyword(packageName.get(ii)));
                    }
                    break;
                }
                if (s instanceof ClassOrInterface) {
                    ClassOrInterface c = (ClassOrInterface)s;
                    if (Naming.isJavaInterop(c)) {
                        isInterop = true;
                    }
                    if (outerNames == null) {
                        outerNames = new ArrayList(2);
                    }
                    outerNames.add(Naming.getQuotedClassName(c, 0));
                    continue;
                }
                if (!(s instanceof TypedDeclaration)) continue;
                if (outerNames == null) {
                    outerNames = new ArrayList<String>(2);
                }
                outerNames.add(Naming.quoteIfJavaKeyword(Naming.getRealName((TypedDeclaration)((Object)s), 0)));
            }
            if (outerNames != null) {
                for (int ii = outerNames.size() - 1; ii >= 0; --ii) {
                    String outerName = (String)outerNames.get(ii);
                    builder.select(outerName);
                }
            }
        }
        if ((namingOptions & 2) != 0) {
            builder.select(Naming.getQuotedClassName(decl, namingOptions & 0x30));
        } else if ((namingOptions & 4) != 0) {
            builder.select(Naming.getRealName(decl, namingOptions & 0x34));
        } else if ((namingOptions & 0x40) != 0) {
            if (Decl.isBoxedVariable(decl)) {
                builder.select(this.getVariableBoxName(decl));
            } else {
                builder.select(Naming.getAttrClassName(decl, namingOptions & 0x30));
            }
        }
        if ((namingOptions & 0x400) != 0) {
            builder.select("this");
        }
    }

    JCTree.JCExpression makeQualIdent(JCTree.JCExpression expr, String name) {
        if (expr == null && name == null) {
            throw new BugException();
        }
        if (expr == null) {
            return this.makeUnquotedIdent(name);
        }
        if (name == null) {
            return expr;
        }
        return this.makeSelect(expr, name);
    }

    static String escapeClassName(String name) {
        return name.replace('#', '_');
    }

    static String quoteClassName(String name) {
        return JvmBackendUtil.isInitialLowerCase(name = Naming.escapeClassName(name)) ? name + "_" : name;
    }

    private static String getRealName(Declaration decl, int namingOptions) {
        String name;
        if (decl instanceof LazyValue) {
            name = ((LazyValue)decl).getRealName();
        } else if (decl instanceof FieldValue) {
            name = ((FieldValue)decl).getRealName();
        } else if (decl instanceof LazyFunction) {
            name = ((LazyFunction)decl).getRealName();
        } else if (decl instanceof LazyClass) {
            name = ((LazyClass)decl).getRealName();
        } else if (decl instanceof LazyInterface) {
            name = ((LazyInterface)decl).getRealName();
        } else if (Decl.isGetter(decl)) {
            name = Naming.getAttrClassName((Value)decl, namingOptions);
        } else if (decl instanceof Setter) {
            name = Naming.getAttrClassName((Setter)decl, namingOptions);
        } else if (decl instanceof JavaMethod) {
            name = ((JavaMethod)decl).getRealName();
        } else {
            name = decl.getName();
            if ((namingOptions & 4) == 0) {
                name = Naming.quoteClassName(name);
            }
        }
        return name;
    }

    private static String getQuotedClassName(Declaration decl, int namingOptions) {
        return Naming.getRealName(decl, namingOptions);
    }

    String getVariableBoxName(TypedDeclaration declaration) {
        if (declaration instanceof Value && ModelUtil.isEnumeratedConstructorInLocalVariable((Value)declaration)) {
            return Naming.getValueConstructorFieldNameAsString((Value)declaration);
        }
        return declaration.getName();
    }

    JCTree.JCExpression makeVariableBoxName(TypedDeclaration declaration) {
        return this.makeUnquotedIdent(this.getVariableBoxName(declaration));
    }

    String selector(TypedDeclaration decl) {
        return Naming.selector(decl, 0);
    }

    public static String selector(TypedDeclaration decl, int namingOptions) {
        if ((namingOptions & 0x200) == 0 && (Decl.isGetter(decl) || Decl.isValueOrSharedOrCapturedParam(decl))) {
            if ((namingOptions & 0x20) != 0) {
                return Naming.getSetterName(decl);
            }
            return Naming.getGetterName(decl);
        }
        if (decl instanceof Function) {
            if (decl.isClassMember()) {
                if (decl instanceof JavaMethod) {
                    return ((JavaMethod)decl).getRealName();
                }
                return Naming.getMethodName(decl, namingOptions);
            }
            return Naming.quoteMethodName((Function)decl, namingOptions);
        }
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter()) {
            return Naming.getMethodName(decl, namingOptions);
        }
        throw new BugException();
    }

    static String getAttrClassName(TypedDeclaration decl, int namingOptions) {
        if ((namingOptions & 0xFFFFFFCB) != 0) {
            throw new BugException("unsupported namingOption");
        }
        String name = decl.getName();
        if (Decl.isLocal(decl)) {
            if (Decl.isGetter(decl) && (namingOptions & 0x20) == 0 || (namingOptions & 0x10) != 0) {
                name = Naming.suffixName(NamingBase.Suffix.$getter$, name);
            } else if (decl instanceof Setter && (namingOptions & 0x10) == 0 || (namingOptions & 0x20) != 0) {
                name = Naming.suffixName(NamingBase.Suffix.$setter$, name);
            }
        }
        if ((namingOptions & 4) == 0) {
            name = Naming.quoteClassName(name);
        }
        return name;
    }

    JCTree.JCExpression makeSyntheticClassname(Declaration decl) {
        return this.makeUnquotedIdent(Naming.getQuotedClassName(decl, 0));
    }

    Name getSyntheticInstanceName(Declaration decl) {
        return this.names.fromString(decl.getName());
    }

    final String getCompanionFieldName(Interface def) {
        if (def.isAlias()) {
            def = (Interface)def.getExtendedType().getDeclaration();
        }
        return Naming.suffixName(NamingBase.Suffix.$this$, "$" + Decl.className(def).replace('.', '$'));
    }

    JCTree.JCExpression makeCompanionFieldName(Interface def) {
        return this.makeUnquotedIdent(this.getCompanionFieldName(def));
    }

    final String getCompanionAccessorName(Interface def) {
        return this.getCompanionClassName(def, true).replace('.', '$');
    }

    JCTree.JCExpression makeCompanionAccessorName(JCTree.JCExpression qualExpr, Interface def) {
        return this.makeQualIdent(qualExpr, this.getCompanionAccessorName(def));
    }

    JCTree.JCExpression makeCompanionAccessorCall(JCTree.JCExpression qualExpr, Interface def) {
        return this.make().Apply(null, this.makeCompanionAccessorName(qualExpr, def), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    JCTree.JCExpression makeLanguageValue(String string) {
        Declaration decl = this.gen().typeFact().getLanguageModuleDeclaration(string);
        if (!Decl.isValue(decl)) {
            throw new BugException();
        }
        return this.makeSelect(this.makeName((Value)decl, 10), Naming.getGetterName(decl));
    }

    JCTree.JCExpression makeLanguageFunction(String string) {
        Declaration decl = this.gen().typeFact().getLanguageModuleDeclaration(string);
        if (!Decl.isMethod(decl)) {
            throw new BugException();
        }
        return this.makeSelect(this.makeName((TypedDeclaration)decl, 10), Naming.getMethodNameInternal((TypedDeclaration)decl));
    }

    JCTree.JCExpression makeLanguageSerializationValue(String string) {
        Declaration decl = this.gen().typeFact().getLanguageModuleSerializationDeclaration(string);
        if (!Decl.isValue(decl)) {
            throw new BugException();
        }
        return this.makeSelect(this.makeName((Value)decl, 10), Naming.getGetterName(decl));
    }

    void resetUniqueIds() {
        this.id = 0L;
    }

    private long nextUniqueId() {
        return this.id++;
    }

    String newTemp() {
        String result = Naming.prefixName(NamingBase.Prefix.$ceylontmp$, Long.toString(this.nextUniqueId()));
        return result;
    }

    String newTemp(String prefix) {
        String result = Naming.prefixName(NamingBase.Prefix.$ceylontmp$, prefix, Long.toString(this.nextUniqueId()));
        return result;
    }

    private String newAlias(String name) {
        String result = Naming.compoundName(name, Long.toString(this.nextUniqueId()));
        return result;
    }

    Name tempName() {
        return this.names.fromString(this.newTemp());
    }

    Name tempName(String prefix) {
        return this.names.fromString(this.newTemp(prefix));
    }

    Name aliasName(String name) {
        return this.names.fromString(this.newAlias(name));
    }

    SyntheticName temp() {
        return new SyntheticName(this.tempName());
    }

    SyntheticName temp(String prefix) {
        return new SyntheticName(this.tempName(prefix));
    }

    SyntheticName alias(String name) {
        return new SyntheticName(this.aliasName(name));
    }

    JCTree.JCIdent makeTemp() {
        return new SyntheticName(this.tempName()).makeIdent();
    }

    JCTree.JCIdent makeTemp(String prefix) {
        return new SyntheticName(this.tempName(prefix)).makeIdent();
    }

    JCTree.JCIdent makeAlias(String name) {
        return new SyntheticName(this.aliasName(name)).makeIdent();
    }

    public SubstitutedName substituted(TypedDeclaration decl) {
        return new SubstitutedName(decl);
    }

    private VarMapper getVarMapper() {
        VarMapper map = this.context.get(VarMapper.class);
        if (map == null) {
            map = new VarMapper();
            this.context.put(VarMapper.class, map);
        }
        return map;
    }

    Substitution addVariableSubst(TypedDeclaration decl, String substVarName) {
        return new Substitution(decl, substVarName);
    }

    void removeVariableSubst(Substitution substitution) {
        if (substitution.previous != null) {
            this.getVarMapper().put(substitution.original, substitution.previous);
        } else {
            this.getVarMapper().remove(substitution.original);
        }
    }

    String substitute(Declaration decl) {
        if (decl instanceof TypedDeclaration) {
            return this.getVarMapper().get((TypedDeclaration)decl);
        }
        return Naming.getRealName(decl, 0);
    }

    boolean isSubstituted(Declaration decl) {
        if (decl instanceof TypedDeclaration) {
            return this.getVarMapper().isSubstituted((TypedDeclaration)decl);
        }
        return false;
    }

    public void closeScopedSubstitutions(Scope scope) {
        com.redhat.ceylon.langtools.tools.javac.util.List<Substitution> substitutions = this.scopedSubstitutions.remove(scope);
        if (substitutions != null) {
            for (Substitution substitution : substitutions) {
                substitution.internalClose();
            }
        }
        for (Map.Entry entry : this.scopedSubstitutions.entrySet()) {
            Scope s = (Scope)entry.getKey();
            do {
                if (!s.equals(scope)) continue;
                throw new RuntimeException("Unclosed scoped substitution(s) " + entry.getValue() + " whose scope is contained within " + scope);
            } while ((s = s.getScope()) != null && !(s instanceof Package));
        }
    }

    Substitution substituteAlias(TypedDeclaration decl) {
        return this.addVariableSubst(decl, this.alias(this.substitute(decl)).getName());
    }

    @Deprecated
    SyntheticName synthetic(String name) {
        return new SyntheticName(this.names.fromString(name));
    }

    SyntheticName synthetic(NamingBase.Prefix prefix, String ... name) {
        return new SyntheticName(this.names.fromString(Naming.prefixName(prefix, name)));
    }

    SyntheticName synthetic(NamingBase.Unfix name) {
        return new SyntheticName(this.names.fromString(Naming.name(name)));
    }

    SyntheticName synthetic(NamingBase.Prefix name, int i) {
        return new SyntheticName(this.names.fromString(Naming.prefixName(name, Integer.toString(i))));
    }

    SyntheticName synthetic(Value value) {
        return new SyntheticName(this.names.fromString(Naming.quoteIfJavaKeyword(value.getName())));
    }

    SyntheticName synthetic(Tree.Variable var) {
        return new SyntheticName(this.names.fromString(Naming.getVariableName(var)));
    }

    SyntheticName synthetic(Tree.Pattern pattern) {
        if (pattern instanceof Tree.VariablePattern) {
            return this.synthetic(((Tree.VariablePattern)pattern).getVariable());
        }
        if (pattern instanceof Tree.KeyValuePattern) {
            return this.synthetic(NamingBase.Prefix.$pattern$, "entry").alias();
        }
        if (pattern instanceof Tree.TuplePattern) {
            return this.synthetic(NamingBase.Prefix.$pattern$, "tuple").alias();
        }
        throw BugException.unhandledNodeCase(pattern);
    }

    SyntheticName syntheticDestructure(Tree.Statement varOrDes) {
        if (varOrDes instanceof Tree.Variable) {
            return this.synthetic((Tree.Variable)varOrDes);
        }
        if (varOrDes instanceof Tree.Destructure) {
            return this.synthetic(((Tree.Destructure)varOrDes).getPattern());
        }
        throw BugException.unhandledNodeCase(varOrDes);
    }

    SyntheticName synthetic(Tree.ForIterator forIterator) {
        if (forIterator instanceof Tree.ValueIterator) {
            return this.synthetic(((Tree.ValueIterator)forIterator).getVariable());
        }
        if (forIterator instanceof Tree.PatternIterator) {
            return this.synthetic(((Tree.PatternIterator)forIterator).getPattern());
        }
        throw BugException.unhandledNodeCase(forIterator);
    }

    void clearSubstitutions(Declaration decl) {
        if (decl.isToplevel()) {
            this.getVarMapper().clear();
        }
    }

    @Override
    public String getLocalId(Scope decl) {
        Integer id = this.locals.get(decl);
        if (id == null) {
            throw new RuntimeException(decl + " has no local id");
        }
        return String.valueOf(id);
    }

    public String getMethodSpecifierAttributeName(Function m) {
        return Naming.suffixName(NamingBase.Suffix.$specifier$, m.getName());
    }

    public static String getCallableMethodName() {
        return Naming.name(NamingBase.Unfix.$call$);
    }

    public static String getCallableTypedMethodName() {
        return Naming.name(NamingBase.Unfix.$calltyped$);
    }

    public static String getCallableVariadicMethodName() {
        return Naming.name(NamingBase.Unfix.$callvariadic$);
    }

    public static String getCallableMethodName(Function method) {
        List<Parameter> parameters = method.getFirstParameterList().getParameters();
        boolean variadic = !parameters.isEmpty() && parameters.get(parameters.size() - 1).isSequenced();
        return variadic ? Naming.getCallableVariadicMethodName() : Naming.getCallableMethodName();
    }

    public static String getCallableTempVarName(Parameter param) {
        return Naming.prefixName(NamingBase.Prefix.$ceylontmp$, param.getName());
    }

    public static String getImplClassName(String name) {
        return Naming.suffixName(NamingBase.Suffix.$impl, name);
    }

    public String getTypeArgumentDescriptorName(TypeParameter tp) {
        String name;
        if (tp.isCaptured()) {
            StringBuilder sb = new StringBuilder();
            LinkedList<Declaration> decls = new LinkedList<Declaration>();
            for (Scope scope = tp; scope != null && !(scope instanceof Package); scope = scope.getContainer()) {
                if (!(scope instanceof Declaration)) continue;
                decls.add((Declaration)((Object)scope));
            }
            Iterator iterator = decls.descendingIterator();
            while (iterator.hasNext()) {
                sb.append(((Declaration)iterator.next()).getName());
                if (!iterator.hasNext()) continue;
                sb.append("$");
            }
            name = sb.toString();
        } else {
            name = tp.getName();
        }
        return Naming.prefixName(NamingBase.Prefix.$reified$, name);
    }

    public String getGetTypeMethodName() {
        return Naming.name(NamingBase.Unfix.$getType$);
    }

    public String getRefineTypeParametersMethodName() {
        return Naming.name(NamingBase.Unfix.$refine$);
    }

    public String getTypeDescriptorAliasName() {
        return Naming.name(NamingBase.Unfix.$TypeDescriptor$);
    }

    public static String getAnnotationFieldName(List<AnnotationFieldName> parts) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationFieldName part : parts) {
            sb.append(part.getFieldNamePrefix()).append(part.getFieldName()).append("$");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getSequencedAnnotationMethodName() {
        return Naming.name(NamingBase.Unfix.value);
    }

    public String getAnnotationSequenceMethodName() {
        return Naming.name(NamingBase.Unfix.$annotationSequence$);
    }

    public static String getToplevelAttributeSavedExceptionName() {
        return Naming.name(NamingBase.Unfix.$initException$);
    }

    public static boolean isLowerCase(String name) {
        return !name.isEmpty() && Character.isLowerCase(name.codePointAt(0));
    }

    public static String getInitializationFieldName(String fieldName) {
        return Naming.prefixName(NamingBase.Prefix.$init$, Naming.quoteFieldName(fieldName));
    }

    public JCTree.JCExpression makeNamedConstructorName(Constructor constructor, boolean delegation) {
        DeclNameFlag[] declNameFlagArray;
        if (delegation) {
            DeclNameFlag[] declNameFlagArray2 = new DeclNameFlag[2];
            declNameFlagArray2[0] = DeclNameFlag.QUALIFIED;
            declNameFlagArray = declNameFlagArray2;
            declNameFlagArray2[1] = DeclNameFlag.DELEGATION;
        } else {
            DeclNameFlag[] declNameFlagArray3 = new DeclNameFlag[1];
            declNameFlagArray = declNameFlagArray3;
            declNameFlagArray3[0] = DeclNameFlag.QUALIFIED;
        }
        DeclNameFlag[] flags = declNameFlagArray;
        Class cls = (Class)constructor.getContainer();
        if (cls.isToplevel() || cls.isMember() && ((TypeDeclaration)cls.getContainer()).isToplevel()) {
            return this.makeTypeDeclarationExpression(null, constructor, flags);
        }
        return this.maker.TypeCast(this.makeTypeDeclarationExpression(null, constructor, flags), (JCTree.JCExpression)this.make().Literal(TypeTag.BOT, null));
    }

    public JCTree.JCExpression makeNamedConstructorType(Constructor constructor, boolean delegation) {
        DeclNameFlag[] declNameFlagArray;
        if (delegation) {
            DeclNameFlag[] declNameFlagArray2 = new DeclNameFlag[2];
            declNameFlagArray2[0] = DeclNameFlag.QUALIFIED;
            declNameFlagArray = declNameFlagArray2;
            declNameFlagArray2[1] = DeclNameFlag.DELEGATION;
        } else {
            DeclNameFlag[] declNameFlagArray3 = new DeclNameFlag[1];
            declNameFlagArray = declNameFlagArray3;
            declNameFlagArray3[0] = DeclNameFlag.QUALIFIED;
        }
        DeclNameFlag[] flags = declNameFlagArray;
        return this.makeTypeDeclarationExpression(null, constructor, flags);
    }

    public static boolean isAmbiguousGetterName(TypedDeclaration attr) {
        return !attr.isToplevel() && Naming.isAmbiguousGetterName(attr.getName());
    }

    public static boolean isAmbiguousGetterName(String name) {
        int cpl = name.codePointCount(0, name.length());
        if (cpl < 2) {
            return false;
        }
        int f = name.codePointAt(0);
        if (!Character.isLowerCase(f) && f != 95) {
            return false;
        }
        int s = name.codePointAt(1);
        return Character.isUpperCase(s);
    }

    protected SyntheticName getValueConstructorFieldName(Value singletonModel) {
        return this.synthetic(Naming.getValueConstructorFieldNameAsString(singletonModel));
    }

    static {
        COM_REDHAT_CEYLON_LANGUAGE_PACKAGE = Arrays.asList("com", "redhat", "ceylon", "compiler", "java", "language");
        QUOTABLE_METHOD_NAMES = new HashSet<String>(Arrays.asList("hashCode", "toString", "equals", "wait", "notify", "notifyAll", "getClass", "finalize", "main", "clone"));
    }

    class Substitution
    implements AutoCloseable {
        public final TypedDeclaration original;
        public final String substituted;
        public final String previous;
        private boolean closed = false;
        private boolean scoped = false;

        Substitution(TypedDeclaration decl, String substituted) {
            this.original = decl;
            this.substituted = substituted;
            this.previous = Naming.this.getVarMapper().put(decl, substituted);
        }

        public String toString() {
            if (this.closed) {
                return "Spent substitution";
            }
            return "Substituting " + this.substituted + " for " + this.original + " (masking " + this.previous + ")" + this.original.getScope();
        }

        @Override
        public void close() {
            if (!this.scoped) {
                this.internalClose();
            }
        }

        private void internalClose() {
            if (this.closed) {
                throw new IllegalStateException();
            }
            Naming.this.removeVariableSubst(this);
            this.closed = true;
        }

        public void scopeClose(Scope scope) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.scoped = true;
            com.redhat.ceylon.langtools.tools.javac.util.List<Substitution> list = (com.redhat.ceylon.langtools.tools.javac.util.List<Substitution>)Naming.this.scopedSubstitutions.get(scope);
            if (list == null) {
                list = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
            }
            if (list.contains(this)) {
                throw new IllegalStateException();
            }
            list = list.prepend(this);
            Naming.this.scopedSubstitutions.put(scope, list);
        }
    }

    protected static class VarMapper {
        private Map<SubstitutionKey, String> map = new HashMap<SubstitutionKey, String>();

        protected VarMapper() {
        }

        public String put(TypedDeclaration decl, String value) {
            return this.map.put(new SubstitutionKey(decl), value);
        }

        public String remove(TypedDeclaration decl) {
            return this.map.remove(new SubstitutionKey(decl));
        }

        public String get(TypedDeclaration decl) {
            SubstitutionKey key = new SubstitutionKey(decl);
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            return Naming.quoteIfJavaKeyword(key.name);
        }

        public void clear() {
            this.map.clear();
        }

        public boolean isSubstituted(TypedDeclaration decl) {
            SubstitutionKey key = new SubstitutionKey(decl);
            return this.map.containsKey(key);
        }

        private static class SubstitutionKey {
            private final String name;
            private final Scope scope;

            SubstitutionKey(TypedDeclaration decl) {
                this.name = decl.getName();
                TypedDeclaration orig = decl.getOriginalDeclaration();
                Scope stop = (orig != null ? orig : decl).getContainer();
                Scope scope = decl.getContainer();
                while (!Decl.equalScopes(scope, stop) && scope instanceof ControlBlock) {
                    scope = scope.getContainer();
                }
                this.scope = scope;
            }

            public String toString() {
                return this.name + " in " + this.scope;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SubstitutionKey other = (SubstitutionKey)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
            }
        }
    }

    class SubstitutedName
    implements CName {
        private TypedDeclaration decl;

        private SubstitutedName(TypedDeclaration decl) {
            this.decl = decl;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            String name = this.getName();
            result = 31 * result + (name == null ? 0 : name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SyntheticName other = (SyntheticName)obj;
            String aName = this.getName();
            String bName = other.getName();
            return !(aName == null ? bName != null : !aName.equals(bName));
        }

        @Override
        public String getName() {
            return Naming.this.substitute(this.decl);
        }

        @Override
        public String getUnsubstitutedName() {
            return this.decl.getName();
        }

        @Override
        public Name asName() {
            return Naming.this.names.fromString(this.getName());
        }

        @Override
        public JCTree.JCIdent makeIdent() {
            return Naming.this.make().Ident(this.asName());
        }

        @Override
        public JCTree.JCExpression makeIdentWithThis() {
            return Naming.this.makeSelect("this", this.asName());
        }

        public SyntheticName capture() {
            return new SyntheticName(this.asName());
        }
    }

    class SyntheticName
    implements CName {
        private final Name name;

        private SyntheticName(Name name) {
            this.name = name;
        }

        public String toString() {
            return this.name.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SyntheticName other = (SyntheticName)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public String getUnsubstitutedName() {
            return this.getName();
        }

        @Override
        public Name asName() {
            return this.name;
        }

        @Override
        public JCTree.JCIdent makeIdent() {
            return Naming.this.make().Ident(this.asName());
        }

        @Override
        public JCTree.JCExpression makeIdentWithThis() {
            return Naming.this.makeSelect("this", this.asName());
        }

        SyntheticName suffixedBy(NamingBase.Suffix suffix) {
            return new SyntheticName(Naming.this.names.fromString(NamingBase.suffixName(suffix, this.getName())));
        }

        SyntheticName suffixedBy(NamingBase.Suffix suffix, int i) {
            return new SyntheticName(Naming.this.names.fromString(this.getName() + suffix + Integer.toString(i)));
        }

        SyntheticName suffixedBy(int i) {
            return new SyntheticName(Naming.this.names.fromString(this.getName() + "$" + Integer.toString(i)));
        }

        SyntheticName alias() {
            return Naming.this.alias(this.getName());
        }
    }

    static interface CName {
        public String getName();

        public String getUnsubstitutedName();

        public Name asName();

        public JCTree.JCIdent makeIdent();

        public JCTree.JCExpression makeIdentWithThis();
    }

    class StringDeclName
    extends TypeDeclarationBuilder<String> {
        private final String qualifying;
        private StringBuffer expr;

        StringDeclName(Declaration decl, String expr) {
            super(decl);
            this.qualifying = expr;
            this.expr = expr != null ? new StringBuffer(expr) : null;
        }

        @Override
        void select(String s) {
            if (this.expr == null && s != null) {
                this.expr = new StringBuffer(s);
            } else if (s != null || this.expr == null) {
                this.expr.append(".").append(s);
            }
        }

        @Override
        String result() {
            return this.expr.toString();
        }

        @Override
        public void clear() {
            super.clear();
            this.expr = this.qualifying != null ? new StringBuffer(this.qualifying) : null;
        }
    }

    class TreeDeclName
    extends TypeDeclarationBuilder<JCTree.JCExpression> {
        private final JCTree.JCExpression qualifying;
        private JCTree.JCExpression expr;

        TreeDeclName(Declaration decl, JCTree.JCExpression expr) {
            super(decl);
            this.qualifying = expr;
            this.expr = expr;
        }

        @Override
        void select(String s) {
            this.expr = Naming.this.makeQualIdent(this.expr, s);
        }

        @Override
        JCTree.JCExpression result() {
            return this.expr;
        }

        @Override
        public void clear() {
            super.clear();
            this.expr = this.qualifying;
        }
    }

    abstract class TypeDeclarationBuilder<R> {
        private final StringBuilder sb = new StringBuilder();
        protected final Declaration decl;

        TypeDeclarationBuilder(Declaration decl) {
            this.decl = decl;
        }

        abstract void select(String var1);

        final void append(String s) {
            this.sb.append(s);
        }

        final void append(char ch) {
            this.sb.append(ch);
        }

        private boolean isCeylonTypeDecl() {
            return this.decl instanceof TypeDeclaration && Decl.isCeylon((TypeDeclaration)this.decl);
        }

        final void selectAppended() {
            String name = this.sb.toString();
            this.select(this.isCeylonTypeDecl() ? Naming.quoteClassName(name) : name);
            this.sb.setLength(0);
        }

        abstract R result();

        public void clear() {
            this.sb.setLength(0);
        }

        public final String toString() {
            return this.result().toString() + " plus, maybe " + (this.isCeylonTypeDecl() ? Naming.quoteClassName(this.sb.toString()) : this.sb.toString());
        }
    }

    private class LocalIdVisitor
    extends Visitor {
        private int localId = 0;

        private LocalIdVisitor() {
        }

        private void resetLocals() {
            this.localId = 0;
        }

        private void local(Scope decl) {
            Scope container;
            if (!Naming.this.locals.containsKey(decl)) {
                Naming.this.locals.put(decl, this.localId);
                ++this.localId;
            }
            if ((container = decl.getContainer()) != null && ModelUtil.isLocalNotInitializerScope(container)) {
                this.local(container);
            }
        }

        void noteDecl(Declaration decl) {
            if (decl.isToplevel()) {
                this.resetLocals();
            } else if (Decl.isLocalNotInitializer(decl)) {
                this.local(decl.getContainer());
            }
        }

        @Override
        public void visit(Tree.ClassOrInterface that) {
            this.noteDecl(that.getDeclarationModel());
            super.visit(that);
        }

        @Override
        public void visit(Tree.TypeAliasDeclaration that) {
            this.noteDecl(that.getDeclarationModel());
            super.visit(that);
        }

        @Override
        public void visit(Tree.ObjectDefinition that) {
            this.noteDecl(that.getDeclarationModel());
            super.visit(that);
        }

        @Override
        public void visit(Tree.AnyMethod that) {
            if (Decl.isLocalNotInitializer(that.getDeclarationModel())) {
                this.noteDecl(that.getDeclarationModel());
            }
            super.visit(that);
        }

        @Override
        public void visit(Tree.AttributeGetterDefinition that) {
            if (Decl.isLocalNotInitializer(that.getDeclarationModel())) {
                this.noteDecl(that.getDeclarationModel());
            }
            super.visit(that);
        }

        @Override
        public void visit(Tree.AttributeSetterDefinition that) {
            if (Decl.isLocalNotInitializer(that.getDeclarationModel())) {
                this.noteDecl(that.getDeclarationModel());
            }
            super.visit(that);
        }

        @Override
        public void visit(Tree.NamedArgument that) {
            this.local(that.getScope().getContainer());
            this.local(that.getScope());
            super.visit(that);
        }
    }

    static enum DeclNameFlag {
        QUALIFIED,
        COMPANION,
        ANNOTATION,
        ANNOTATIONS,
        DELEGATION;

    }
}

