/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.HashMap;
import java.util.Map;

public class Operators {
    private static final PrimitiveType[] IntegerByte = new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.BYTE};
    private static final PrimitiveType[] IntegerFloat = new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.FLOAT};
    private static final PrimitiveType[] IntegerFloatByte = new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.FLOAT, PrimitiveType.BYTE};
    private static final PrimitiveType[] IntegerCharacterByte = new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.CHARACTER, PrimitiveType.BYTE};
    private static final PrimitiveType[] IntegerFloatCharacter = new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.FLOAT, PrimitiveType.CHARACTER};
    private static final PrimitiveType[] IntegerFloatStringByte = new PrimitiveType[]{PrimitiveType.INTEGER, PrimitiveType.FLOAT, PrimitiveType.STRING, PrimitiveType.BYTE};
    private static final PrimitiveType[] All = PrimitiveType.values();
    private static final Map<Class<? extends Tree.OperatorExpression>, OperatorTranslation> operators = new HashMap<Class<? extends Tree.OperatorExpression>, OperatorTranslation>();
    private static final Map<String, OperatorTranslation> methodsAsOperators = new HashMap<String, OperatorTranslation>();
    private static final Map<Class<? extends Tree.AssignmentOp>, AssignmentOperatorTranslation> assignmentOperators = new HashMap<Class<? extends Tree.AssignmentOp>, AssignmentOperatorTranslation>();

    public static OperatorTranslation getOperator(Class<? extends Tree.OperatorExpression> operatorClass) {
        return operators.get(operatorClass);
    }

    public static OperatorTranslation getOperator(String signature) {
        return methodsAsOperators.get(signature);
    }

    public static AssignmentOperatorTranslation getAssignmentOperator(Class<? extends Tree.AssignmentOp> operatorClass) {
        return assignmentOperators.get(operatorClass);
    }

    public static void init() {
    }

    static /* synthetic */ PrimitiveType[] access$000() {
        return IntegerFloatByte;
    }

    static /* synthetic */ PrimitiveType[] access$100() {
        return IntegerByte;
    }

    static /* synthetic */ PrimitiveType[] access$200() {
        return IntegerCharacterByte;
    }

    static /* synthetic */ PrimitiveType[] access$300() {
        return IntegerFloatStringByte;
    }

    static /* synthetic */ PrimitiveType[] access$400() {
        return IntegerFloat;
    }

    static /* synthetic */ PrimitiveType[] access$600() {
        return All;
    }

    static /* synthetic */ PrimitiveType[] access$700() {
        return IntegerFloatCharacter;
    }

    static {
        for (OperatorTranslation operatorTranslation : OperatorTranslation.values()) {
            if (operatorTranslation.operatorClass != null) {
                operators.put(operatorTranslation.operatorClass, operatorTranslation);
                continue;
            }
            for (PrimitiveType t : operatorTranslation.optimisableTypes) {
                String optimisedMethod = t.fqn + "." + operatorTranslation.ceylonMethod;
                methodsAsOperators.put(optimisedMethod, operatorTranslation);
            }
        }
        for (Enum enum_ : AssignmentOperatorTranslation.values()) {
            assignmentOperators.put(((AssignmentOperatorTranslation)enum_).operatorClass, (AssignmentOperatorTranslation)enum_);
        }
    }

    public static enum AssignmentOperatorTranslation {
        ADD(Tree.AddAssignOp.class, OperatorTranslation.BINARY_SUM, JCTree.Tag.PLUS_ASG),
        SUBSTRACT(Tree.SubtractAssignOp.class, OperatorTranslation.BINARY_DIFFERENCE, JCTree.Tag.MINUS_ASG),
        MULTIPLY(Tree.MultiplyAssignOp.class, OperatorTranslation.BINARY_PRODUCT, JCTree.Tag.MUL_ASG),
        DIVIDE(Tree.DivideAssignOp.class, OperatorTranslation.BINARY_QUOTIENT, JCTree.Tag.DIV_ASG),
        REMAINDER(Tree.RemainderAssignOp.class, OperatorTranslation.BINARY_REMAINDER, JCTree.Tag.MOD_ASG),
        AND(Tree.AndAssignOp.class, OperatorTranslation.BINARY_AND, JCTree.Tag.BITAND_ASG),
        OR(Tree.OrAssignOp.class, OperatorTranslation.BINARY_OR, JCTree.Tag.BITOR_ASG),
        BINARY_UNION(Tree.UnionAssignOp.class, OperatorTranslation.BINARY_UNION),
        BINARY_INTERSECTION(Tree.IntersectAssignOp.class, OperatorTranslation.BINARY_INTERSECTION),
        BINARY_COMPLEMENT(Tree.ComplementAssignOp.class, OperatorTranslation.BINARY_COMPLEMENT);

        JCTree.Tag javacOperator;
        OperatorTranslation binaryOperator;
        Class<? extends Tree.AssignmentOp> operatorClass;

        private AssignmentOperatorTranslation(Class<? extends Tree.AssignmentOp> operatorClass, OperatorTranslation binaryOperator) {
            this.operatorClass = operatorClass;
            this.binaryOperator = binaryOperator;
        }

        private AssignmentOperatorTranslation(Class<? extends Tree.AssignmentOp> operatorClass, OperatorTranslation binaryOperator, JCTree.Tag javacOperator) {
            this.operatorClass = operatorClass;
            this.javacOperator = javacOperator;
            this.binaryOperator = binaryOperator;
        }
    }

    public static enum OperatorTranslation {
        UNARY_POSITIVE(Tree.PositiveOp.class, 1, "<noop>", JCTree.Tag.POS, Operators.access$000()),
        UNARY_NEGATIVE(Tree.NegativeOp.class, 1, "negated", JCTree.Tag.NEG, Operators.access$000()),
        UNARY_BITWISE_NOT(1, "not", JCTree.Tag.COMPL, Operators.access$100()),
        UNARY_POSTFIX_INCREMENT(Tree.PostfixIncrementOp.class, 1, "getSuccessor", JCTree.Tag.POSTINC, Operators.access$200()),
        UNARY_POSTFIX_DECREMENT(Tree.PostfixDecrementOp.class, 1, "getPredecessor", JCTree.Tag.POSTDEC, Operators.access$200()),
        UNARY_PREFIX_INCREMENT(Tree.IncrementOp.class, 1, "getSuccessor", JCTree.Tag.PREINC, Operators.access$200()),
        UNARY_PREFIX_DECREMENT(Tree.DecrementOp.class, 1, "getPredecessor", JCTree.Tag.PREDEC, Operators.access$200()),
        BINARY_SUM(Tree.SumOp.class, 2, "plus", JCTree.Tag.PLUS, Operators.access$300()),
        BINARY_DIFFERENCE(Tree.DifferenceOp.class, 2, "minus", JCTree.Tag.MINUS, Operators.access$000()),
        BINARY_PRODUCT(Tree.ProductOp.class, 2, "times", JCTree.Tag.MUL, Operators.access$400()),
        BINARY_QUOTIENT(Tree.QuotientOp.class, 2, "divided", JCTree.Tag.DIV, Operators.access$400()),
        BINARY_POWER((Class)Tree.PowerOp.class, 2, "power", null, new PrimitiveType[0]){

            @Override
            public String getCeylonValueTypeMethodName() {
                return "$power$";
            }
        }
        ,
        BINARY_REMAINDER(Tree.RemainderOp.class, 2, "remainder", JCTree.Tag.MOD, PrimitiveType.INTEGER),
        BINARY_SCALE(Tree.ScaleOp.class, 2, "scale"),
        BINARY_BITWISE_AND(2, "and", JCTree.Tag.BITAND, Operators.access$100()),
        BINARY_BITWISE_OR(2, "or", JCTree.Tag.BITOR, Operators.access$100()),
        BINARY_BITWISE_XOR(2, "xor", JCTree.Tag.BITXOR, Operators.access$100()),
        BINARY_BITWISE_LOG_LEFT_SHIFT_INT(2, "leftLogicalShift", JCTree.Tag.SL, PrimitiveType.INTEGER),
        BINARY_BITWISE_LOG_LEFT_SHIFT_BYTE(2, "leftLogicalShift", 0, 7, JCTree.Tag.SL, PrimitiveType.BYTE),
        BINARY_BITWISE_LOG_RIGHT_SHIFT_INT(2, "rightLogicalShift", JCTree.Tag.USR, PrimitiveType.INTEGER),
        BINARY_BITWISE_LOG_RIGHT_SHIFT_BYTE(2, "rightLogicalShift", 255, 7, JCTree.Tag.USR, PrimitiveType.BYTE),
        BINARY_BITWISE_ARI_RIGHT_SHIFT_INT(2, "rightArithmeticShift", JCTree.Tag.SR, PrimitiveType.INTEGER),
        BINARY_BITWISE_ARI_RIGHT_SHIFT_BYTE(2, "rightArithmeticShift", 0, 7, JCTree.Tag.SR, PrimitiveType.BYTE),
        BINARY_AND(Tree.AndOp.class, 2, "<not-used>", JCTree.Tag.AND, PrimitiveType.BOOLEAN),
        BINARY_OR(Tree.OrOp.class, 2, "<not-used>", JCTree.Tag.OR, PrimitiveType.BOOLEAN),
        BINARY_UNION(Tree.UnionOp.class, 2, "union"),
        BINARY_INTERSECTION(Tree.IntersectionOp.class, 2, "intersection"),
        BINARY_COMPLEMENT(Tree.ComplementOp.class, 2, "complement"),
        BINARY_EQUAL((Class)Tree.EqualOp.class, 2, "equals", JCTree.Tag.EQ, Operators.access$600()){

            @Override
            public OptimisationStrategy getBinOpOptimisationStrategy(Tree.Term t, Tree.Term leftTerm, Type leftType, Tree.Term rightTerm, Type rightType, AbstractTransformer gen) {
                if (!t.getUnboxed()) {
                    return OptimisationStrategy.NONE;
                }
                OptimisationStrategy left = this.isTermOptimisable(leftTerm, gen);
                OptimisationStrategy right = this.isTermOptimisable(rightTerm, gen);
                if (left == OptimisationStrategy.OPTIMISE && right == OptimisationStrategy.OPTIMISE) {
                    if (!leftType.isExactly(rightType)) {
                        return OptimisationStrategy.NONE;
                    }
                    if (gen.isCeylonString(leftType) && gen.isCeylonString(rightType)) {
                        return OptimisationStrategy.OPTIMISE_BOXING;
                    }
                }
                return 2.lessPermissive(left, right);
            }
        }
        ,
        BINARY_COMPARE(Tree.CompareOp.class, 2, "compare"),
        BINARY_LARGER(Tree.LargerOp.class, 2, "largerThan", JCTree.Tag.GT, Operators.access$700()),
        BINARY_SMALLER(Tree.SmallerOp.class, 2, "smallerThan", JCTree.Tag.LT, Operators.access$700()),
        BINARY_LARGE_AS(Tree.LargeAsOp.class, 2, "notSmallerThan", JCTree.Tag.GE, Operators.access$700()),
        BINARY_SMALL_AS(Tree.SmallAsOp.class, 2, "notLargerThan", JCTree.Tag.LE, Operators.access$700());

        Class<? extends Tree.OperatorExpression> operatorClass;
        int arity;
        private String ceylonMethod;
        JCTree.Tag javacOperator;
        PrimitiveType[] optimisableTypes;
        String ceylonValue;
        JCTree.Tag javacValueOperator;
        int leftValueMask;
        int rightValueMask;

        private OperatorTranslation(int arity, String ceylonMethod, JCTree.Tag javacOperator, PrimitiveType ... optimisableTypes) {
            this.ceylonMethod = ceylonMethod;
            this.javacOperator = javacOperator;
            this.optimisableTypes = optimisableTypes;
            this.arity = arity;
        }

        private OperatorTranslation(int arity, String ceylonMethod, int leftValueMask, int rightValueMask, JCTree.Tag javacOperator, PrimitiveType ... optimisableTypes) {
            this(arity, ceylonMethod, javacOperator, optimisableTypes);
            this.leftValueMask = leftValueMask;
            this.rightValueMask = rightValueMask;
        }

        private OperatorTranslation(Class<? extends Tree.OperatorExpression> operatorClass, int arity, String ceylonMethod, JCTree.Tag javacOperator, PrimitiveType ... optimisableTypes) {
            this(arity, ceylonMethod, javacOperator, optimisableTypes);
            this.operatorClass = operatorClass;
        }

        private OperatorTranslation(Class<? extends Tree.BinaryOperatorExpression> operatorClass, int arity, String ceylonMethod) {
            this(operatorClass, arity, ceylonMethod, null, new PrimitiveType[0]);
        }

        public final OptimisationStrategy getUnOpOptimisationStrategy(Tree.Term expression, Tree.Term term, AbstractTransformer gen) {
            if (!expression.getUnboxed()) {
                return OptimisationStrategy.NONE;
            }
            return this.isTermOptimisable(term, gen);
        }

        public OptimisationStrategy getBinOpOptimisationStrategy(Tree.Term expression, Tree.Term leftTerm, Tree.Term rightTerm, AbstractTransformer gen) {
            return this.getBinOpOptimisationStrategy(expression, leftTerm, leftTerm.getTypeModel(), rightTerm, rightTerm.getTypeModel(), gen);
        }

        public OptimisationStrategy getBinOpOptimisationStrategy(Tree.Term expression, Tree.Term leftTerm, Type leftType, Tree.Term rightTerm, Type rightType, AbstractTransformer gen) {
            OptimisationStrategy right;
            if (!expression.getUnboxed()) {
                return OptimisationStrategy.NONE;
            }
            OptimisationStrategy left = this.isTermOptimisable(leftTerm, leftType, gen);
            OptimisationStrategy optimisationStrategy = OperatorTranslation.mostAggressive(left, right = this.isTermOptimisable(rightTerm, rightType, gen));
            if (optimisationStrategy != OptimisationStrategy.OPTIMISE) {
                if (Decl.isValueTypeDecl(leftType)) {
                    optimisationStrategy = OptimisationStrategy.OPTIMISE_VALUE_TYPE;
                } else if (leftType.getDeclaration().getSelfType() != null && Decl.isValueTypeDecl(leftType.getTypeArguments().get(leftType.getDeclaration().getSelfType().getDeclaration()))) {
                    optimisationStrategy = OptimisationStrategy.OPTIMISE_VALUE_TYPE;
                }
            }
            return optimisationStrategy;
        }

        protected static OptimisationStrategy lessPermissive(OptimisationStrategy left, OptimisationStrategy right) {
            if (left.ordinal() > right.ordinal()) {
                return left;
            }
            return right;
        }

        protected static OptimisationStrategy mostAggressive(OptimisationStrategy left, OptimisationStrategy right) {
            if (left.ordinal() < right.ordinal()) {
                return left;
            }
            return right;
        }

        final OptimisationStrategy isTermOptimisable(Tree.Term t, AbstractTransformer gen) {
            return this.isTermOptimisable(t, t.getTypeModel(), gen);
        }

        final OptimisationStrategy isTermOptimisable(Tree.Term t, Type pt, AbstractTransformer gen) {
            if (this.javacOperator == null || !t.getUnboxed()) {
                return OptimisationStrategy.NONE;
            }
            if (pt == null) {
                return OptimisationStrategy.NONE;
            }
            if (this.optimisableTypes == null) {
                return OptimisationStrategy.NONE;
            }
            block8: for (PrimitiveType type : this.optimisableTypes) {
                switch (type) {
                    case BOOLEAN: {
                        if (!gen.isCeylonBoolean(pt)) continue block8;
                        return OptimisationStrategy.OPTIMISE;
                    }
                    case BYTE: {
                        if (!gen.isCeylonByte(pt)) continue block8;
                        return OptimisationStrategy.OPTIMISE;
                    }
                    case CHARACTER: {
                        if (!gen.isCeylonCharacter(pt)) continue block8;
                        return OptimisationStrategy.OPTIMISE;
                    }
                    case FLOAT: {
                        if (!gen.isCeylonFloat(pt)) continue block8;
                        return OptimisationStrategy.OPTIMISE;
                    }
                    case INTEGER: {
                        if (!gen.isCeylonInteger(pt)) continue block8;
                        return OptimisationStrategy.OPTIMISE;
                    }
                    case STRING: {
                        if (!gen.isCeylonString(pt)) continue block8;
                        return OptimisationStrategy.OPTIMISE;
                    }
                }
            }
            return OptimisationStrategy.NONE;
        }

        public int getArity() {
            return this.arity;
        }

        public String getCeylonMethodName() {
            return this.ceylonMethod;
        }

        public String getCeylonValueTypeMethodName() {
            return this.ceylonMethod;
        }
    }

    public static enum OptimisationStrategy {
        OPTIMISE(true, false, AbstractTransformer.BoxingStrategy.UNBOXED),
        OPTIMISE_VALUE_TYPE(false, true, AbstractTransformer.BoxingStrategy.UNBOXED),
        OPTIMISE_BOXING(false, false, AbstractTransformer.BoxingStrategy.INDIFFERENT),
        NONE(false, false, AbstractTransformer.BoxingStrategy.BOXED);

        private AbstractTransformer.BoxingStrategy boxingStrategy;
        private boolean useJavaOperator;
        private boolean useValueTypeMethod;

        private OptimisationStrategy(boolean useJavaOperator, boolean useValueTypeMethod, AbstractTransformer.BoxingStrategy boxingStrategy) {
            this.useJavaOperator = useJavaOperator;
            this.useValueTypeMethod = useValueTypeMethod;
            this.boxingStrategy = boxingStrategy;
        }

        public AbstractTransformer.BoxingStrategy getBoxingStrategy() {
            return this.boxingStrategy;
        }

        public boolean useJavaOperator() {
            return this.useJavaOperator;
        }

        public boolean useValueTypeMethod() {
            return this.useValueTypeMethod;
        }
    }

    private static enum PrimitiveType {
        BOOLEAN("ceylon.language.Boolean"),
        BYTE("ceylon.language.Byte"),
        CHARACTER("ceylon.language.Character"),
        INTEGER("ceylon.language.Integer"),
        FLOAT("ceylon.language.Float"),
        STRING("ceylon.language.String");

        public final String fqn;

        private PrimitiveType(String fqn) {
            this.fqn = fqn;
        }
    }
}

