/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ErroneousException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.SmallDeclarationVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Value;

public class SmallVisitor
extends Visitor {
    private static final Value NON_SMALLABLE = new Value();
    private Declaration assigning;

    private static void markSmall(Tree.Term that) {
        that.setSmall(true);
        that.setTypeModel(SmallDeclarationVisitor.smallUnderlyingType(that.getTypeModel()));
    }

    protected void checkSmallAssignment(Tree.Term term) {
        term = TreeUtil.unwrapExpressionUntilTerm(term);
        if (Decl.isSmall(this.assigning) && term != null && !term.getSmall() && (term instanceof Tree.CharLiteral || term instanceof Tree.NaturalLiteral || (term instanceof Tree.NegativeOp || term instanceof Tree.PositiveOp) && ((Tree.UnaryOperatorExpression)term).getTerm() instanceof Tree.NaturalLiteral)) {
            term.addUsageWarning(Warning.literalNotSmall, "literal value is not small but is assignable to small declaration '" + this.assigning.getName(term.getUnit()) + "'", Backend.Java);
        }
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        Declaration preva = this.assigning;
        this.assigning = that.getDeclarationModel();
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.Parameter that) {
        Declaration preva = this.assigning;
        this.assigning = that.getParameterModel().getModel();
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        Declaration preva = this.assigning;
        this.assigning = that.getDeclarationModel().getRefinedDeclaration();
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.SpecifierOrInitializerExpression that) {
        super.visit(that);
        this.checkSmallAssignment(that.getExpression());
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        Declaration d = that.getDeclaration();
        if (d == null && that.getBaseMemberExpression() instanceof Tree.MemberOrTypeExpression) {
            d = ((Tree.MemberOrTypeExpression)that.getBaseMemberExpression()).getDeclaration();
        }
        Declaration preva = this.assigning;
        this.assigning = d;
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.NamedArgument that) {
        FunctionOrValue d = that.getParameter() != null ? that.getParameter().getModel() : null;
        Declaration preva = this.assigning;
        this.assigning = d;
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.Dynamic that) {
    }

    @Override
    public void visit(Tree.SequencedArgument that) {
        FunctionOrValue d = that.getParameter() != null ? that.getParameter().getModel() : null;
        Declaration preva = this.assigning;
        this.assigning = d;
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.PositionalArgument that) {
        FunctionOrValue d = that.getParameter() != null ? that.getParameter().getModel() : null;
        Declaration preva = this.assigning;
        this.assigning = d;
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.Return that) {
        Declaration preva = this.assigning;
        this.assigning = that.getDeclaration();
        super.visit(that);
        this.checkSmallAssignment(that.getExpression());
        this.assigning = preva;
    }

    private boolean isAssigningSmall() {
        return Decl.isSmall(this.assigning);
    }

    @Override
    public void visit(Tree.Expression that) {
        super.visit(that);
        if (this.isAssigningSmall() && that.getTerm().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.MemberOrTypeExpression that) {
        if (this.isAssigningSmall() && Decl.isSmall(that.getDeclaration())) {
            SmallVisitor.markSmall(that);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ValueIterator that) {
        Declaration preva = this.assigning;
        this.assigning = that.getVariable().getDeclarationModel();
        Tree.Term term = TreeUtil.unwrapExpressionUntilTerm(that.getSpecifierExpression().getExpression());
        if (term instanceof Tree.SegmentOp || term instanceof Tree.RangeOp) {
            ((FunctionOrValue)this.assigning).setSmall(true);
        }
        super.visit(that);
        if (term instanceof Tree.SegmentOp || term instanceof Tree.RangeOp) {
            boolean small = ((Tree.BinaryOperatorExpression)term).getLeftTerm().getSmall() && ((Tree.BinaryOperatorExpression)term).getRightTerm().getSmall();
            ((FunctionOrValue)this.assigning).setSmall(small);
            if (small) {
                that.getVariable().getDeclarationModel().setType(SmallDeclarationVisitor.smallUnderlyingType(that.getVariable().getDeclarationModel().getType()));
            }
        }
        this.checkSmallAssignment(that.getSpecifierExpression().getExpression());
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.BinaryOperatorExpression that) {
        super.visit(that);
        if (this.isAssigningSmall() && that.getLeftTerm().getSmall() && that.getRightTerm().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.CompareOp that) {
        Declaration preva = this.assigning;
        this.assigning = NON_SMALLABLE;
        super.visit(that);
        this.assigning = preva;
    }

    @Override
    public void visit(Tree.WithinOp that) {
        Declaration preva = this.assigning;
        this.assigning = NON_SMALLABLE;
        super.visit(that);
        this.assigning = preva;
        if (that.getLowerBound().getSmall() && that.getUpperBound().getSmall() && that.getTerm().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.Bound that) {
        super.visit(that);
        if (that.getTerm().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.AssignmentOp that) {
        if (that.getLeftTerm() instanceof Tree.MemberOrTypeExpression) {
            Declaration d = ((Tree.MemberOrTypeExpression)that.getLeftTerm()).getDeclaration();
            Declaration preva = this.assigning;
            this.assigning = d;
            super.visit(that);
            if (this.isAssigningSmall()) {
                this.checkSmallAssignment(that.getRightTerm());
            }
            this.assigning = preva;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.UnaryOperatorExpression that) {
        super.visit(that);
        if (this.isAssigningSmall() && that.getTerm().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.PostfixOperatorExpression that) {
        if (that.getTerm() instanceof Tree.MemberOrTypeExpression) {
            Declaration d = ((Tree.MemberOrTypeExpression)that.getTerm()).getDeclaration();
            Declaration preva = this.assigning;
            this.assigning = d;
            super.visit(that);
            if (this.isAssigningSmall()) {
                this.checkSmallAssignment(that.getTerm());
            }
            this.assigning = preva;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.PrefixOperatorExpression that) {
        if (that.getTerm() instanceof Tree.MemberOrTypeExpression) {
            Declaration d = ((Tree.MemberOrTypeExpression)that.getTerm()).getDeclaration();
            Declaration preva = this.assigning;
            this.assigning = d;
            super.visit(that);
            if (this.isAssigningSmall()) {
                this.checkSmallAssignment(that.getTerm());
            }
            this.assigning = preva;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.IfExpression that) {
        super.visit(that);
        if (this.isAssigningSmall() && that.getIfClause().getExpression().getSmall() && that.getElseClause().getExpression().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        super.visit(that);
        if (this.isAssigningSmall()) {
            boolean smallCases = true;
            for (Tree.CaseClause c : that.getSwitchCaseList().getCaseClauses()) {
                smallCases &= c.getExpression().getTerm().getSmall();
            }
            boolean smallElse = true;
            if (that.getSwitchCaseList().getElseClause() != null) {
                smallElse = that.getSwitchCaseList().getElseClause().getExpression().getTerm().getSmall();
            }
            if (smallCases && smallElse) {
                SmallVisitor.markSmall(that);
            }
        }
    }

    @Override
    public void visit(Tree.LetExpression that) {
        super.visit(that);
        if (this.isAssigningSmall() && that.getLetClause().getExpression().getTerm().getSmall()) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.CharLiteral that) {
        if (this.isAssigningSmall() && Character.isBmpCodePoint(ExpressionTransformer.literalValue(that))) {
            SmallVisitor.markSmall(that);
        }
    }

    @Override
    public void visit(Tree.NaturalLiteral that) {
        try {
            if (this.isAssigningSmall() && ExpressionTransformer.literalValue(that) instanceof Integer) {
                SmallVisitor.markSmall(that);
            }
        }
        catch (ErroneousException erroneousException) {
            // empty catch block
        }
    }

    @Override
    public void visit(Tree.NegativeOp that) {
        if (that.getTerm() instanceof Tree.NaturalLiteral) {
            try {
                if (this.isAssigningSmall() && ExpressionTransformer.literalValue(that) instanceof Integer) {
                    SmallVisitor.markSmall(that);
                }
            }
            catch (ErroneousException erroneousException) {}
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.PositiveOp that) {
        if (that.getTerm() instanceof Tree.NaturalLiteral) {
            try {
                if (this.isAssigningSmall() && ExpressionTransformer.literalValue(that) instanceof Integer) {
                    SmallVisitor.markSmall(that);
                }
            }
            catch (ErroneousException erroneousException) {}
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.Variable that) {
        Declaration preva = this.assigning;
        this.assigning = that.getDeclarationModel();
        super.visit(that);
        this.assigning = preva;
    }

    static {
        NON_SMALLABLE.setSmall(true);
    }
}

