/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ErroneousException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Strategy {
    private Strategy() {
    }

    public static boolean defaultParameterMethodTakesThis(Tree.Declaration decl) {
        return Strategy.defaultParameterMethodTakesThis(decl.getDeclarationModel());
    }

    public static boolean defaultParameterMethodTakesThis(Declaration decl) {
        return decl instanceof Function && decl.isToplevel();
    }

    public static DefaultParameterMethodOwner defaultParameterMethodOwner(Declaration odecl) {
        Declaration decl = odecl;
        if (Strategy.defaultParameterMethodOnSelf(decl)) {
            return DefaultParameterMethodOwner.SELF;
        }
        if (decl.isParameter() && decl.getContainer() instanceof Declaration) {
            decl = (Declaration)((Object)decl.getContainer());
        }
        if (Decl.isConstructor(decl)) {
            decl = Decl.getConstructedClass(decl);
        }
        if ((decl instanceof Function || decl instanceof Class) && (decl.isToplevel() || decl.isStatic())) {
            return DefaultParameterMethodOwner.STATIC;
        }
        if (Strategy.isInnerClass(decl)) {
            return Decl.getClassOrInterfaceContainer(decl, false) instanceof Class ? DefaultParameterMethodOwner.OUTER : DefaultParameterMethodOwner.OUTER_COMPANION;
        }
        return DefaultParameterMethodOwner.INIT_COMPANION;
    }

    public static boolean defaultParameterMethodStatic(Declaration odecl) {
        return Strategy.defaultParameterMethodOwner(odecl) == DefaultParameterMethodOwner.STATIC;
    }

    public static boolean defaultParameterMethodOnOuter(Declaration odecl) {
        return Strategy.defaultParameterMethodOwner(odecl) == DefaultParameterMethodOwner.OUTER;
    }

    private static boolean isInnerClass(Declaration elem) {
        if (elem instanceof Constructor) {
            elem = (Declaration)((Object)elem.getContainer());
        }
        return elem instanceof Class && !elem.isToplevel() && !Decl.isLocalNotInitializer(elem);
    }

    public static boolean defaultParameterMethodOnSelf(Tree.Declaration decl) {
        return Strategy.defaultParameterMethodOnSelf(decl.getDeclarationModel());
    }

    public static boolean defaultParameterMethodOnSelf(Declaration decl) {
        return decl instanceof Function && !Decl.isConstructor(decl) && !decl.isParameter() && !Decl.withinInterface(decl) && !decl.isToplevel() && !decl.isStatic();
    }

    public static boolean hasDefaultParameterValueMethod(Parameter param) {
        return param.isDefaulted();
    }

    public static boolean hasDefaultParameterOverload(Parameter param) {
        return param.isDefaulted() || Strategy.isCeylonVariadicNeedingEmpty(param);
    }

    private static boolean isCeylonVariadicNeedingEmpty(Parameter param) {
        if (!param.isSequenced() || param.isAtLeastOne()) {
            return false;
        }
        return !Decl.isJavaVariadicIncludingInheritance(param);
    }

    public static boolean hasEmptyDefaultArgument(Parameter param) {
        return param.isSequenced() && !param.isAtLeastOne();
    }

    public static boolean generateMain(Tree.ClassOrInterface def) {
        for (Tree.CompilerAnnotation c : def.getCompilerAnnotations()) {
            if (!c.getIdentifier().getText().equals("nomain")) continue;
            return false;
        }
        return def instanceof Tree.AnyClass && Decl.isToplevel(def) && Decl.isShared(def) && !Decl.isAbstract(def) && !def.getDeclarationModel().isNativeHeader() && Strategy.hasNoRequiredParameters((Class)def.getDeclarationModel());
    }

    private static boolean hasNoRequiredParameters(Functional model) {
        List<ParameterList> parameterLists = model.getParameterLists();
        if (parameterLists == null || parameterLists.size() != 1) {
            return false;
        }
        ParameterList parameterList = parameterLists.get(0);
        if (parameterList == null) {
            return false;
        }
        List<Parameter> parameters = parameterList.getParameters();
        if (parameters == null) {
            return false;
        }
        if (parameters.isEmpty()) {
            return true;
        }
        return parameters.get(0).isDefaulted();
    }

    public static boolean generateMain(Tree.AnyMethod def) {
        return Decl.isToplevel(def) && Decl.isShared(def) && Strategy.hasNoRequiredParameters(def.getDeclarationModel());
    }

    public static boolean generateThisDelegates(Tree.AnyMethod def) {
        return Decl.withinInterface(def.getDeclarationModel()) && def instanceof Tree.MethodDeclaration && ((Tree.MethodDeclaration)def).getSpecifierExpression() == null;
    }

    public static boolean needsOuterMethodInCompanion(ClassOrInterface model) {
        return Decl.withinClassOrInterface(model);
    }

    public static boolean useField(Value attr) {
        return !Decl.withinInterface(attr) && Decl.isCaptured(attr) || attr.isStatic();
    }

    public static boolean createField(Parameter p, Value v) {
        return !Decl.withinInterface(v) && (p == null || Strategy.useField(v));
    }

    static boolean createMethod(Tree.Parameter parameter) {
        return Strategy.createMethod(parameter.getParameterModel());
    }

    static boolean createMethod(Parameter parameter) {
        FunctionOrValue model = parameter.getModel();
        return JvmBackendUtil.createMethod(model);
    }

    public static boolean onlyOnCompanion(Declaration model) {
        return Decl.withinInterface(model) && (model instanceof ClassOrInterface || !Decl.isShared(model));
    }

    static boolean generateInstantiator(Declaration model) {
        if (model instanceof Class) {
            Class cls = (Class)model;
            return !cls.isAbstract() && !cls.isStatic() && (Decl.isRefinableMemberClass(cls) || Decl.isCeylon(cls) && model.isMember() && cls.isShared() && !cls.isAnonymous());
        }
        if (Decl.isConstructor(model)) {
            Constructor ctor = Decl.getConstructor(model);
            Class cls = Decl.getConstructedClass(ctor);
            return cls.isMember() && cls.isShared() && !cls.isStatic() && ctor.isShared();
        }
        return false;
    }

    static boolean isInstantiatorUntyped(Declaration model) {
        return Strategy.generateInstantiator(model) && Decl.isAncestorLocal(model);
    }

    static boolean useBoxedVoid(Function m) {
        return m.isMember() && (m.isDefault() || m.isFormal() || m.isActual()) && m.getType().isAnything() && Decl.isCeylon((TypeDeclaration)m.getRefinedDeclaration().getContainer());
    }

    public static boolean hasDelegatedDpm(Class cls) {
        return Decl.isRefinableMemberClass(cls.getRefinedDeclaration()) && Strategy.defaultParameterMethodOnOuter(cls) && Decl.withinInterface(cls.getRefinedDeclaration());
    }

    public static boolean inlinePowerAsMultiplication(Tree.PowerOp op) {
        try {
            Number power_ = ExpressionTransformer.getIntegerLiteralPower(op);
            if (power_ != null) {
                long power = power_.longValue();
                Unit unit = op.getUnit();
                Type baseType = op.getLeftTerm().getTypeModel();
                if (power > 0L && power <= 64L && baseType.isExactly(unit.getIntegerType())) {
                    return true;
                }
                if (power > 0L && power <= 64L && baseType.isExactly(unit.getFloatType())) {
                    return true;
                }
            }
        }
        catch (ErroneousException e) {
            return false;
        }
        return false;
    }

    public static boolean preferLazySwitchingIterable(List<Tree.PositionalArgument> positionalArguments) {
        return positionalArguments.size() < 128;
    }

    public static boolean generateJpaCtor(Tree.ClassOrInterface def) {
        return Strategy.generateJpaCtor(def.getDeclarationModel());
    }

    static boolean generateJpaCtor(ClassOrInterface declarationModel) {
        if (declarationModel instanceof Class && !(declarationModel instanceof ClassAlias) && declarationModel.isToplevel()) {
            Class cls = (Class)declarationModel;
            if (cls.getCaseValues() != null && !cls.getCaseValues().isEmpty()) {
                return false;
            }
            if (Strategy.hasNullaryNonJpaConstructor(cls)) {
                return false;
            }
            boolean hasDelegatableSuper = false;
            Class superClass = (Class)cls.getExtendedType().getDeclaration();
            if (superClass instanceof LazyClass && !((LazyClass)superClass).isCeylon()) {
                if (superClass.isAbstraction()) {
                    for (Declaration s : superClass.getOverloads()) {
                        if (!(s instanceof Class) || !Strategy.isNullary((Class)s)) continue;
                        hasDelegatableSuper = true;
                        break;
                    }
                } else {
                    hasDelegatableSuper = Strategy.isNullary(superClass);
                }
            } else {
                hasDelegatableSuper = Strategy.hasNullaryNonJpaConstructor(superClass) || Strategy.hasJpaConstructor(superClass);
            }
            boolean constrained = cls.getCaseValues() != null && !cls.getCaseValues().isEmpty() || cls.hasEnumerated() && Decl.hasOnlyValueConstructors(cls);
            return hasDelegatableSuper && !constrained;
        }
        return false;
    }

    private static boolean isNullary(Class superClass) {
        ParameterList parameterList = superClass.getParameterList();
        return parameterList != null && parameterList.getParameters() != null && parameterList.getParameters().isEmpty();
    }

    public static boolean hasJpaConstructor(Class c) {
        if (c instanceof LazyClass && !(c instanceof ClassAlias)) {
            return ((LazyClass)c).hasJpaConstructor();
        }
        return Strategy.generateJpaCtor(c);
    }

    protected static boolean hasNullaryNonJpaConstructor(Class c) {
        if (c.isToplevel() && !(c instanceof ClassAlias)) {
            List<Parameter> parameters = null;
            if (c.hasConstructors()) {
                Constructor defaultConstructor = Decl.getDefaultConstructor(c);
                if (defaultConstructor != null && defaultConstructor.getParameterList() != null) {
                    parameters = defaultConstructor.getParameterList().getParameters();
                }
            } else if (c.getParameterList() != null) {
                parameters = c.getParameterList().getParameters();
            }
            return parameters != null && (parameters.isEmpty() || parameters.get(0).isDefaulted() || parameters.get(0).isSequenced() && !parameters.get(0).isAtLeastOne());
        }
        return false;
    }

    public static boolean introduceJavaIoSerializable(Class cls, Interface ser) {
        return !(cls instanceof ClassAlias) && (Decl.hasOnlyValueConstructors(cls) || cls.isAnonymous() || cls.getExtendedType() != null && (cls.getExtendedType().isBasic() || cls.getExtendedType().isObject())) && !cls.getSatisfiedTypes().contains(ser.getType());
    }

    public static boolean addReadResolve(Class cls) {
        return cls.isAnonymous() && cls.isToplevel();
    }

    public static boolean useSerializationProxy(Class model) {
        return model.hasEnumerated() && (model.isToplevel() || model.isMember());
    }

    public static List<TypeParameter> getEffectiveTypeParameters(Declaration decl) {
        return Strategy.getEffectiveTypeParameters(decl, decl);
    }

    private static boolean isCeylon(Declaration d) {
        while (!d.isToplevel()) {
            d = (Declaration)((Object)Decl.getFirstDeclarationContainer((Scope)((Object)d)));
        }
        return ModelUtil.isCeylonDeclaration(d);
    }

    private static List<TypeParameter> getEffectiveTypeParameters(Declaration original, Declaration decl) {
        if (Decl.isConstructor(original)) {
            original = Decl.getConstructedClass(original);
        }
        if (Decl.isConstructor(decl)) {
            decl = Decl.getConstructedClass(decl);
        }
        Scope container = decl.getContainer();
        if (decl instanceof Value) {
            if (decl.isStatic()) {
                return Strategy.getEffectiveTypeParameters(original, (Declaration)((Object)container));
            }
            return Collections.emptyList();
        }
        if (decl instanceof Function) {
            if (original instanceof ClassAlias || decl.isStatic() && Strategy.isCeylon(decl)) {
                ArrayList<TypeParameter> copyDown = new ArrayList<TypeParameter>(Strategy.getEffectiveTypeParameters(original, (Declaration)((Object)container)));
                copyDown.addAll(decl.getTypeParameters());
                return copyDown;
            }
            return decl.getTypeParameters();
        }
        if (decl instanceof ClassAlias) {
            return ((ClassAlias)decl).getTypeParameters();
        }
        if (decl instanceof Class) {
            if (((Class)decl).isStatic() && ((Class)decl).isMember() && Strategy.isCeylon(decl)) {
                ArrayList<TypeParameter> copyDown = new ArrayList<TypeParameter>(Strategy.getEffectiveTypeParameters(original, (Declaration)((Object)container)));
                copyDown.addAll(((Class)decl).getTypeParameters());
                return copyDown;
            }
            return ((Class)decl).getTypeParameters();
        }
        if (decl instanceof Interface) {
            return ((Interface)decl).getTypeParameters();
        }
        if (decl instanceof TypeAlias) {
            return ((TypeAlias)decl).getTypeParameters();
        }
        throw BugException.unhandledDeclarationCase(decl);
    }

    public static boolean useConstantIterable(Tree.SequencedArgument sequencedArgument) {
        Unit unit = sequencedArgument.getUnit();
        boolean allCtc = true;
        for (Tree.PositionalArgument pa : sequencedArgument.getPositionalArguments()) {
            Tree.Term term;
            if (!(pa instanceof Tree.ListedArgument) || (term = ((Tree.ListedArgument)pa).getExpression().getTerm()) instanceof Tree.StringLiteral || term instanceof Tree.NaturalLiteral || term instanceof Tree.FloatLiteral || term instanceof Tree.CharLiteral || term instanceof Tree.NegativeOp && (((Tree.NegativeOp)term).getTerm() instanceof Tree.NaturalLiteral || ((Tree.NegativeOp)term).getTerm() instanceof Tree.FloatLiteral) || term instanceof Tree.BaseMemberExpression && (((Tree.BaseMemberExpression)term).getDeclaration().equals(unit.getTrueValueDeclaration()) || ((Tree.BaseMemberExpression)term).getDeclaration().equals(unit.getFalseValueDeclaration()))) continue;
            allCtc = false;
            break;
        }
        return allCtc;
    }

    static enum DefaultParameterMethodOwner {
        INIT_COMPANION,
        STATIC,
        OUTER,
        OUTER_COMPANION,
        SELF;

    }
}

