/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.List;

public class TransformedType {
    private final JCTree.JCExpression typeExpression;
    private final JCTree.JCAnnotation typeInfo;
    private final JCTree.JCAnnotation nullability;

    public TransformedType(JCTree.JCExpression typeExpression, JCTree.JCAnnotation typeInfo, JCTree.JCAnnotation nullability) {
        this.typeExpression = typeExpression;
        this.typeInfo = typeInfo;
        this.nullability = nullability;
    }

    public TransformedType(JCTree.JCExpression typeExpression, JCTree.JCAnnotation typeInfo) {
        this(typeExpression, typeInfo, null);
    }

    public TransformedType(JCTree.JCExpression typeExpression) {
        this(typeExpression, null);
    }

    public JCTree.JCExpression getTypeExpression() {
        return this.typeExpression;
    }

    public JCTree.JCAnnotation getTypeInfo() {
        return this.typeInfo;
    }

    public JCTree.JCAnnotation getNullability() {
        return this.nullability;
    }

    public List<JCTree.JCAnnotation> getTypeAnnotations() {
        List<JCTree.JCAnnotation> result = List.nil();
        if (this.typeInfo != null) {
            result = result.prepend(this.typeInfo);
        }
        if (this.nullability != null && !this.isPrimitiveOrVoid()) {
            result = result.prepend(this.nullability);
        }
        return result;
    }

    public boolean isPrimitive() {
        if (this.typeExpression instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)this.typeExpression;
            if (ident.sym != null && ident.sym.type.isPrimitive()) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrimitiveOrVoid() {
        if (this.typeExpression instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)this.typeExpression;
            if (ident.sym != null && ident.sym.type.isPrimitiveOrVoid()) {
                return true;
            }
        } else if (this.typeExpression instanceof JCTree.JCPrimitiveTypeTree) {
            return true;
        }
        return false;
    }
}

