/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen.recovery;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.TypeVisitor;
import com.redhat.ceylon.compiler.java.codegen.recovery.Drop;
import com.redhat.ceylon.compiler.java.codegen.recovery.Errors;
import com.redhat.ceylon.compiler.java.codegen.recovery.ExpressionErrorVisitor;
import com.redhat.ceylon.compiler.java.codegen.recovery.Generate;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.codegen.recovery.PrivateConstructorOnly;
import com.redhat.ceylon.compiler.java.codegen.recovery.ThrowerCatchallConstructor;
import com.redhat.ceylon.compiler.java.codegen.recovery.ThrowerMethod;
import com.redhat.ceylon.compiler.java.codegen.recovery.TransformationPlan;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.List;

class DeclarationErrorVisitor
extends Visitor {
    private static final int TYPE_DECLARATION_DOES_NOT_EXIST = 102;
    private static final int FORMAL_MEMBER_UNIMPLEMENTED_IN_CLASS_HIERARCHY = 300;
    private static final int MEMBER_HAS_WRONG_NUMBER_OF_PARAMETERS = 9100;
    private static final int TYPE_OF_PARAMETER_IS_DIFFERENT_TO_CORRESPONDING_PARAMETER = 9200;
    private static final int COULD_NOT_DETERMINE_PARAMETER_TYPE_SAME_AS_CORRESPONDING_PARAMETER = 9210;
    private static final int REFINED_MEMBER_WRONG_NUM_PL = 9300;
    private static final int MISSING_PL_FUNCTION_DECL = 1000;
    private static final int NO_CONSTRUCTORS = 1001;
    private static final int PL_AND_CONSTRUCTORS = 1002;
    private static final int FORWARD_DECL_NOT_IN_DECL_SECTION = 1450;
    private TransformationPlan plan;
    private final ExpressionErrorVisitor expressionVisitor;
    private boolean expectingError;
    private String errMessage;
    private Declaration model;

    DeclarationErrorVisitor(ExpressionErrorVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public final HasErrorException getFirstErrorMessage(Tree.Declaration target) {
        TransformationPlan plan = this.getRecoveryPlan(target);
        if (plan instanceof Generate) {
            return null;
        }
        return new HasErrorException(plan.getNode(), plan.getErrorMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransformationPlan getRecoveryPlan(Tree.Declaration target) {
        this.model = target.getDeclarationModel();
        TransformationPlan oldPlan = this.plan;
        try {
            this.plan = Errors.GENERATE;
            target.visit(this);
            if (target.getDeclarationModel() != null) {
                target.getDeclarationModel().setDropped(this.plan instanceof Drop);
            }
            TransformationPlan transformationPlan = this.plan;
            return transformationPlan;
        }
        finally {
            this.plan = oldPlan;
        }
    }

    private void newplan(TransformationPlan plan) {
        if (plan.replaces(this.plan)) {
            this.plan = plan;
        }
    }

    @Override
    public final void visitAny(Node that) {
        this.planAccordingToErrors(that);
        super.visitAny(that);
    }

    private void planAccordingToErrors(Node that) {
        List<Message> errors = that.getErrors();
        for (Message message : errors) {
            if (!this.isError(that, message)) continue;
            TransformationPlan plan = message.getCode() == 300 && (this.model instanceof Class || this.model instanceof Value && ((Value)this.model).getTypeDeclaration().isAnonymous()) ? new ThrowerMethod(that, message) : ((message.getCode() == 1002 || message.getCode() == 1001) && (this.model instanceof Class || this.model instanceof Value && ((Value)this.model).getTypeDeclaration().isAnonymous()) ? (message.getCode() == 1001 ? new PrivateConstructorOnly(that, message) : new ThrowerCatchallConstructor(that, message)) : (message.getCode() == 1450 ? Errors.GENERATE : new Drop(that, message)));
            this.newplan(plan);
        }
    }

    private boolean isError(Node that, Message message) {
        if (this.errMessage != null && message.getMessage().equals(this.errMessage)) {
            return false;
        }
        return !(message instanceof UsageWarning);
    }

    @Override
    public void visit(Tree.Annotation that) {
    }

    @Override
    public void visit(Tree.Body that) {
    }

    @Override
    public void visit(Tree.SpecifierOrInitializerExpression that) {
    }

    @Override
    public void visit(Tree.Type that) {
        HasErrorException error = this.expressionVisitor.getFirstErrorMessage(that);
        if (error != null && this.isError(that, error.getErrorMessage())) {
            this.newplan(new Drop(error.getNode(), error.getErrorMessage()));
            return;
        }
        if (this.containsUnknowns(that.getTypeModel())) {
            this.newplan(new Drop(that, new AnalysisError((Node)that, "unknown type", Backend.Java)));
        }
    }

    boolean containsUnknowns(Type t) {
        class UnknownVisitor
        extends TypeVisitor {
            boolean staticJavaMember = false;
            boolean unknowns = false;

            UnknownVisitor() {
            }

            @Override
            public void visitUnknown() {
                this.unknowns = true;
            }

            @Override
            public void visitTypeArguments(Type typeConstructor, List<Type> typeArguments) {
                if (!this.staticJavaMember) {
                    super.visitTypeArguments(typeConstructor, typeArguments);
                }
            }

            @Override
            public void visitQualifyingType(Type qualified, Type qualifying) {
                boolean unknownOk = this.staticJavaMember;
                this.staticJavaMember = this.isJava(qualifying) && qualified.getDeclaration().isStatic();
                super.visitQualifyingType(qualified, qualifying);
                this.staticJavaMember = unknownOk;
            }

            private boolean isJava(Type type) {
                boolean isjava = type.getDeclaration() instanceof LazyClass ? !((LazyClass)type.getDeclaration()).isCeylon() : (type.getDeclaration() instanceof LazyInterface ? !((LazyInterface)type.getDeclaration()).isCeylon() : false);
                return isjava;
            }
        }
        UnknownVisitor uv = new UnknownVisitor();
        uv.visitType(t);
        return uv.unknowns;
    }

    @Override
    public void visit(Tree.InitializerParameter that) {
        this.planAccordingToErrors(that);
    }

    @Override
    public void visit(Tree.StatementOrArgument that) {
        boolean b = this.expectingError;
        this.initExpectingError(that.getCompilerAnnotations());
        super.visit(that);
        this.expectingError = b;
    }

    @Override
    public void visit(Tree.ParameterDeclaration that) {
        boolean b = this.expectingError;
        this.initExpectingError(that.getTypedDeclaration().getCompilerAnnotations());
        super.visit(that);
        this.expectingError = b;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        boolean b = this.expectingError;
        this.initExpectingError(that.getCompilerAnnotations());
        super.visit(that);
        this.expectingError = b;
    }

    protected void initExpectingError(List<Tree.CompilerAnnotation> annotations) {
        for (Tree.CompilerAnnotation c : annotations) {
            if (!c.getIdentifier().getText().equals("error")) continue;
            this.expectingError = true;
            Tree.StringLiteral sl = c.getStringLiteral();
            if (sl == null) continue;
            this.errMessage = sl.getText();
        }
    }

    @Override
    public void visit(Tree.ExtendedType that) {
        that.getType().visit(this);
        if (that.getType().getDeclarationModel() instanceof LazyClass && !((LazyClass)that.getType().getDeclarationModel()).isCeylon()) {
            boolean hasPrivateCtor = false;
            List<Declaration> overloads = ((LazyClass)that.getType().getDeclarationModel()).getOverloads();
            if (overloads != null) {
                for (Declaration ctor : overloads) {
                    if (ctor.isShared()) continue;
                    hasPrivateCtor = true;
                    break;
                }
            }
            if (hasPrivateCtor && that.getInvocationExpression() != null) {
                that.getInvocationExpression().visit(this);
            }
        }
    }
}

