/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen.recovery;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.ClassTransformer;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.recovery.DeclarationErrorVisitor;
import com.redhat.ceylon.compiler.java.codegen.recovery.ExpressionErrorVisitor;
import com.redhat.ceylon.compiler.java.codegen.recovery.Generate;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.codegen.recovery.StatementErrorVisitor;
import com.redhat.ceylon.compiler.java.codegen.recovery.TransformationPlan;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;

public class Errors {
    public static final Generate GENERATE = new Generate();
    private AbstractTransformer gen;
    private final DeclarationErrorVisitor declarationVisitor;
    private final StatementErrorVisitor statementVisitor;
    private final ExpressionErrorVisitor expressionVisitor;

    Errors(Context context) {
        this.gen = ClassTransformer.getInstance(context);
        this.statementVisitor = new StatementErrorVisitor();
        this.expressionVisitor = new ExpressionErrorVisitor();
        this.declarationVisitor = new DeclarationErrorVisitor(this.expressionVisitor);
    }

    public static Errors instance(Context context) {
        Errors instance = context.get(Errors.class);
        if (instance == null) {
            instance = new Errors(context);
            context.put(Errors.class, instance);
        }
        return instance;
    }

    private TransformationPlan annotateBrokenness(TransformationPlan result) {
        if (result != GENERATE && this.gen.current() != null) {
            this.gen.current().broken();
        }
        return result;
    }

    private HasErrorException annotateBrokenness(HasErrorException result) {
        if (result != null && this.gen.current() != null) {
            this.gen.current().broken();
        }
        return result;
    }

    public boolean hasAnyError(Tree.Declaration node) {
        return this.expressionVisitor.getFirstErrorMessage(node) != null;
    }

    public TransformationPlan hasDeclarationAndMarkBrokenness(Tree.Declaration node) {
        return this.annotateBrokenness(this.declarationVisitor.getRecoveryPlan(node));
    }

    public TransformationPlan hasDeclarationError(Tree.Declaration node) {
        return this.declarationVisitor.getRecoveryPlan(node);
    }

    public HasErrorException getFirstExpressionErrorAndMarkBrokenness(Tree.Term node) {
        return this.annotateBrokenness(this.expressionVisitor.getFirstErrorMessage(node));
    }

    public HasErrorException getFirstExpressionErrorAndMarkBrokenness(Tree.ExtendedType node) {
        return this.annotateBrokenness(this.expressionVisitor.getFirstErrorMessage(node));
    }

    public HasErrorException getFirstErrorBlock(Tree.Block block) {
        for (Tree.Statement stmt : block.getStatements()) {
            HasErrorException ex = this.getFirstErrorBlock(stmt);
            if (ex == null) continue;
            return ex;
        }
        return null;
    }

    public HasErrorException getFirstErrorBlock(Tree.Statement blockStatement) {
        if (blockStatement instanceof Tree.Declaration) {
            HasErrorException r = this.declarationVisitor.getFirstErrorMessage((Tree.Declaration)blockStatement);
            if (r == null && Decl.isLocal((Tree.Declaration)blockStatement)) {
                r = this.expressionVisitor.getFirstErrorMessage(blockStatement);
            }
            return this.annotateBrokenness(r);
        }
        if (blockStatement instanceof Tree.ExecutableStatement) {
            return this.annotateBrokenness(this.statementVisitor.getFirstErrorMessage(blockStatement));
        }
        return null;
    }

    public HasErrorException getFirstErrorInitializer(Tree.Statement classBodyStatement) {
        if (classBodyStatement instanceof Tree.Declaration && Decl.isLocalToInitializer((Tree.Declaration)classBodyStatement)) {
            return this.annotateBrokenness(this.declarationVisitor.getFirstErrorMessage((Tree.Declaration)classBodyStatement));
        }
        if (classBodyStatement instanceof Tree.ExecutableStatement) {
            return this.annotateBrokenness(this.statementVisitor.getFirstErrorMessage(classBodyStatement));
        }
        return null;
    }
}

