/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.emptyIterator_;
import ceylon.language.impl.BaseIterable;
import com.redhat.ceylon.compiler.java.language.AbstractArrayIterator;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

public abstract class AbstractArrayIterable<Element, ArrayType>
extends BaseIterable<Element, Null> {
    private final TypeDescriptor $reified$Element;
    private final ArrayType array;
    protected final int start;
    protected final int step;
    protected final int len;

    @Override
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(AbstractArrayIterable.class, this.$reified$Element);
    }

    @Ignore
    public AbstractArrayIterable(TypeDescriptor $reified$Element, ArrayType array, int length) {
        this($reified$Element, array, 0, length, 1);
    }

    @Ignore
    protected AbstractArrayIterable(TypeDescriptor $reified$Element, ArrayType array, int start, int len, int step) {
        super($reified$Element, Null.$TypeDescriptor$);
        if (start < 0) {
            throw new AssertionError("start must be non-negative");
        }
        if (len < 0) {
            throw new AssertionError("len must be non-negative");
        }
        if (step <= 0) {
            throw new AssertionError("step size must be greater than zero");
        }
        this.array = array;
        this.$reified$Element = $reified$Element;
        this.start = start;
        this.len = len;
        this.step = step;
    }

    protected abstract AbstractArrayIterable<Element, ArrayType> newInstance(ArrayType var1, int var2, int var3, int var4);

    protected abstract Element get(ArrayType var1, int var2);

    Element unsafeGet(int index) {
        return this.get(this.array, this.start + this.step * index);
    }

    @Ignore
    public ArrayType arrayValue() {
        return this.array;
    }

    @Override
    public boolean getEmpty() {
        return this.len == 0;
    }

    @Override
    public Element getFirst() {
        return this.getEmpty() ? null : (Element)this.unsafeGet(0);
    }

    @Override
    public Element getLast() {
        return this.getEmpty() ? null : (Element)this.unsafeGet(this.len - 1);
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> getRest() {
        return this.getEmpty() ? this : this.newInstance(this.array, this.start + this.step, this.len - 1, this.step);
    }

    @Override
    @Ignore
    public long getSize() {
        return this.len;
    }

    @Override
    public Iterator<? extends Element> iterator() {
        if (this.getEmpty()) {
            return emptyIterator_.get_();
        }
        return new AbstractArrayIterator<Element>(this.$reified$Element, this.start, this.len, this.step){

            @Override
            protected Element get(int index) {
                return AbstractArrayIterable.this.get(AbstractArrayIterable.this.array, index);
            }
        };
    }

    @Override
    public boolean longerThan(long length) {
        return this.getSize() > length;
    }

    @Override
    public boolean shorterThan(long length) {
        return this.getSize() < length;
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> skip(long skip) {
        if (skip <= 0L) {
            return this;
        }
        int start = this.start + (int)skip * this.step;
        int len = this.len - (int)skip;
        if (len < 0) {
            len = 0;
        }
        int step = this.step;
        return this.newInstance(this.array, start, len, step);
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> take(long take) {
        if (take >= this.getSize()) {
            return this;
        }
        return this.newInstance(this.array, this.start, (int)take, this.step);
    }

    @Override
    public AbstractArrayIterable<Element, ArrayType> by(long step) {
        return this.newInstance(this.array, this.start, (int)(((long)this.len + step - 1L) / step), this.step * (int)step);
    }

    @Override
    public Object each(Callable<? extends Object> step) {
        for (int i = 0; i < this.len; ++i) {
            step.$call$((Object)this.unsafeGet(i));
        }
        return null;
    }

    @Override
    public long count(Callable<? extends Boolean> selecting) {
        int count = 0;
        for (int i = 0; i < this.len; ++i) {
            if (!selecting.$call$((Object)this.unsafeGet(i)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean any(Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.len; ++i) {
            if (!selecting.$call$((Object)this.unsafeGet(i)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean every(Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.len; ++i) {
            if (selecting.$call$((Object)this.unsafeGet(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element find(Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.len; ++i) {
            Element elem = this.unsafeGet(i);
            if (elem == null || !selecting.$call$((Object)elem).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    @Override
    public Element findLast(Callable<? extends Boolean> selecting) {
        for (int i = this.len - 1; i >= 0; --i) {
            Element elem = this.unsafeGet(i);
            if (elem == null || !selecting.$call$((Object)elem).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    @Override
    public <Result> Object reduce(@Ignore TypeDescriptor $reifiedResult, Callable<? extends Result> accumulating) {
        if (this.len == 0) {
            return null;
        }
        Object partial = this.unsafeGet(0);
        for (int i = 1; i < this.len; ++i) {
            partial = accumulating.$call$(partial, (Object)this.unsafeGet(i));
        }
        return partial;
    }
}

