/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Finished;
import ceylon.language.Float;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.Sequential;
import ceylon.language.emptyIterator_;
import ceylon.language.finished_;
import ceylon.language.impl.BaseIterable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

class DoubleArrayIterable
extends BaseIterable<Float, Null> {
    private final double[] array;
    private final int start;
    private final int step;
    private final int end;

    @Ignore
    public DoubleArrayIterable(double[] array) {
        this(array, 0, array.length, 1);
    }

    @Ignore
    private DoubleArrayIterable(double[] array, int start, int end, int step) {
        super(Float.$TypeDescriptor$, Null.$TypeDescriptor$);
        if (start < 0) {
            throw new AssertionError("start must be positive");
        }
        if (end < 0) {
            throw new AssertionError("end must be positive");
        }
        if (step <= 0) {
            throw new AssertionError("step size must be greater than zero");
        }
        this.array = array;
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Override
    public boolean containsAny(Iterable<? extends Object, ? extends Object> arg0) {
        Object item;
        Iterator<? extends Object> iter = arg0.iterator();
        while (!((item = iter.next()) instanceof Finished)) {
            if (!(item instanceof Float)) continue;
            for (int ii = this.start; ii < this.end; ii += this.step) {
                if (this.array[ii] != ((Float)item).doubleValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsEvery(Iterable<? extends Object, ? extends Object> arg0) {
        Object item;
        Iterator<? extends Object> iter = arg0.iterator();
        block0: while (!((item = iter.next()) instanceof Finished)) {
            if (item instanceof Float) {
                for (int ii = this.start; ii < this.end; ii += this.step) {
                    if (this.array[ii] == ((Float)item).doubleValue()) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean any(Callable<? extends Boolean> arg0) {
        for (int ii = this.start; ii < this.end; ii += this.step) {
            if (!arg0.$call$((Object)Float.instance(this.array[ii])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object item) {
        for (int ii = this.start; ii < this.end; ii += this.step) {
            if (!(item instanceof Float) || this.array[ii] != ((Float)item).doubleValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <Default> Iterable<? extends Object, ? extends Null> defaultNullElements(@Ignore TypeDescriptor $reified$Default, Default defaultValue) {
        return this;
    }

    @Override
    public Iterable<? extends Float, ? extends Object> getCoalesced() {
        return this;
    }

    @Override
    public boolean getEmpty() {
        return this.end <= this.start;
    }

    @Override
    public long getSize() {
        return Math.max(0, (this.end - this.start + this.step - 1) / this.step);
    }

    @Override
    public Float getFirst() {
        return this.getEmpty() ? null : Float.instance(this.array[this.start]);
    }

    @Override
    public Float getLast() {
        return this.getEmpty() ? null : Float.instance(this.array[this.end - 1]);
    }

    public DoubleArrayIterable getRest() {
        return new DoubleArrayIterable(this.array, this.start + 1, this.end, this.step);
    }

    @Override
    public Sequential<? extends Float> sequence() {
        return super.sequence();
    }

    @Override
    public Iterator<? extends Float> iterator() {
        if (this.getEmpty()) {
            return emptyIterator_.get_();
        }
        return new Iterator<Float>(){
            private int index;
            {
                this.index = DoubleArrayIterable.this.start;
            }

            @Override
            public Object next() {
                if (this.index < DoubleArrayIterable.this.end) {
                    Float result = Float.instance(DoubleArrayIterable.this.array[this.index]);
                    this.index += DoubleArrayIterable.this.step;
                    return result;
                }
                return finished_.get_();
            }
        };
    }

    @Override
    public boolean longerThan(long length) {
        return this.getSize() > length;
    }

    @Override
    public boolean shorterThan(long length) {
        return this.getSize() < length;
    }

    public DoubleArrayIterable by(long step) {
        return new DoubleArrayIterable(this.array, this.start, this.end, Util.toInt((long)this.step * step));
    }

    public DoubleArrayIterable skip(long skip) {
        if (skip <= 0L) {
            return this;
        }
        return new DoubleArrayIterable(this.array, Util.toInt((long)this.start + skip * (long)this.step), this.end, this.step);
    }

    public DoubleArrayIterable take(long take) {
        if (take < 0L) {
            take = 0L;
        }
        if (take >= this.getSize()) {
            return this;
        }
        return new DoubleArrayIterable(this.array, this.start, Util.toInt((long)this.start + take * (long)this.step), this.step);
    }
}

