/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Finished;
import ceylon.language.Float;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.Sequential;
import ceylon.language.emptyIterator_;
import ceylon.language.finished_;
import ceylon.language.impl.BaseIterable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

class FloatArrayIterable
extends BaseIterable<Float, Null> {
    private final float[] array;
    private final int start;
    private final int step;
    private final int end;

    @Ignore
    public FloatArrayIterable(float[] array) {
        this(array, 0, array.length, 1);
    }

    @Ignore
    private FloatArrayIterable(float[] array, int start, int end, int step) {
        super(Float.$TypeDescriptor$, Null.$TypeDescriptor$);
        if (start < 0) {
            throw new AssertionError("start must be positive");
        }
        if (end < 0) {
            throw new AssertionError("end must be positive");
        }
        if (step <= 0) {
            throw new AssertionError("step size must be greater than zero");
        }
        this.array = array;
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Override
    public boolean containsAny(Iterable<? extends Object, ? extends Object> arg0) {
        Object item;
        Iterator<? extends Object> iter = arg0.iterator();
        while (!((item = iter.next()) instanceof Finished)) {
            if (!(item instanceof Float)) continue;
            for (int ii = this.start; ii < this.end; ii += this.step) {
                if ((double)this.array[ii] != ((Float)item).doubleValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsEvery(Iterable<? extends Object, ? extends Object> arg0) {
        Object item;
        Iterator<? extends Object> iter = arg0.iterator();
        block0: while (!((item = iter.next()) instanceof Finished)) {
            if (item instanceof Float) {
                for (int ii = this.start; ii < this.end; ii += this.step) {
                    if ((double)this.array[ii] == ((Float)item).doubleValue()) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean any(Callable<? extends Boolean> arg0) {
        for (int ii = this.start; ii < this.end; ii += this.step) {
            if (!arg0.$call$((Object)Float.instance(this.array[ii])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object item) {
        for (int ii = this.start; ii < this.end; ii += this.step) {
            if (!(item instanceof Float) || (double)this.array[ii] != ((Float)item).doubleValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <Default> Iterable<? extends Object, ? extends Null> defaultNullElements(@Ignore TypeDescriptor $reified$Default, Default defaultValue) {
        return this;
    }

    @Override
    public Iterable<? extends Float, ? extends Object> getCoalesced() {
        return this;
    }

    @Override
    public boolean getEmpty() {
        return this.end <= this.start;
    }

    @Override
    public long getSize() {
        return Math.max(0, (this.end - this.start + this.step - 1) / this.step);
    }

    @Override
    public Float getFirst() {
        return this.getEmpty() ? null : Float.instance(this.array[this.start]);
    }

    @Override
    public Float getLast() {
        return this.getEmpty() ? null : Float.instance(this.array[this.end - 1]);
    }

    public FloatArrayIterable getRest() {
        return new FloatArrayIterable(this.array, this.start + 1, this.end, this.step);
    }

    @Override
    public Sequential<? extends Float> sequence() {
        return super.sequence();
    }

    @Override
    public Iterator<? extends Float> iterator() {
        if (this.getEmpty()) {
            return emptyIterator_.get_();
        }
        return new Iterator<Float>(){
            private int index;
            {
                this.index = FloatArrayIterable.this.start;
            }

            @Override
            public Object next() {
                if (this.index < FloatArrayIterable.this.end) {
                    Float result = Float.instance(FloatArrayIterable.this.array[this.index]);
                    this.index += FloatArrayIterable.this.step;
                    return result;
                }
                return finished_.get_();
            }
        };
    }

    @Override
    public boolean longerThan(long length) {
        return this.getSize() > length;
    }

    @Override
    public boolean shorterThan(long length) {
        return this.getSize() < length;
    }

    public FloatArrayIterable by(long step) {
        return new FloatArrayIterable(this.array, this.start, this.end, Util.toInt((long)this.step * step));
    }

    public FloatArrayIterable skip(long skip) {
        if (skip <= 0L) {
            return this;
        }
        return new FloatArrayIterable(this.array, Util.toInt((long)this.start + skip * (long)this.step), this.end, this.step);
    }

    public FloatArrayIterable take(long take) {
        if (take < 0L) {
            take = 0L;
        }
        if (take >= this.getSize()) {
            return this;
        }
        return new FloatArrayIterable(this.array, this.start, Util.toInt((long)this.start + take * (long)this.step), this.step);
    }
}

