/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class SerializationProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> clazz;
    private final Object outer;
    private final String name;

    public SerializationProxy(Class<?> clazz, String name) {
        this(null, clazz, name);
    }

    public SerializationProxy(Object outer, Class<?> clazz, String name) {
        this.outer = outer;
        this.clazz = clazz;
        this.name = name;
    }

    Object readResolve() throws ObjectStreamException {
        Method method;
        try {
            method = this.clazz.getDeclaredMethod(this.name, new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not find method " + this.name + " in " + this.clazz, e);
        }
        try {
            method.setAccessible(true);
            return method.invoke(this.outer, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not invoke " + method, e);
        }
    }
}

