/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Byte;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.StaticAnnotation$annotation$;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.model.ClassOrInterface;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassOrInterfaceDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.lang.annotation.Annotation;

@Ceylon(major=8)
@Class(constructors=true)
public final class Types {
    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="java.lang::Class<out T>")
    @TypeParameters(value={@TypeParameter(value="T", satisfies={"ceylon.language::Object"})})
    @NonNull
    public static <T> java.lang.Class<? extends T> classForInstance(@Ignore TypeDescriptor $reifiedT, @Name(value="instance") @NonNull T instance) {
        return instance.getClass();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="java.lang::Class<T>")
    @TypeParameters(value={@TypeParameter(value="T", satisfies={"ceylon.language::Object"})})
    @NonNull
    public static <T> java.lang.Class<T> classForType(@Ignore TypeDescriptor $reifiedT) {
        java.lang.Class<?> result = Metamodel.getJavaClass($reifiedT);
        if (result != null) {
            return result;
        }
        throw new AssertionError("unsupported type: '" + $reifiedT + "' cannot be represented by a java.lang.Class");
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="java.lang::Class<out T>")
    @TypeParameters(value={@TypeParameter(value="T", satisfies={"ceylon.language::Annotation"})})
    @NonNull
    public static <T extends Annotation> java.lang.Class<T> classForAnnotationType(@Ignore TypeDescriptor $reifiedT) {
        if ($reifiedT instanceof TypeDescriptor.Class) {
            TypeDescriptor.Class klass = (TypeDescriptor.Class)$reifiedT;
            if (klass.getTypeArguments().length > 0) {
                throw new RuntimeException("given type has type arguments");
            }
            try {
                java.lang.Class<?> c = klass.getKlass();
                String name = c.getName() + "$annotation$";
                return java.lang.Class.forName(name, true, c.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new AssertionError("unsupported type");
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="java.lang::Class<out ceylon.language::Object>")
    @NonNull
    public static java.lang.Class<? extends Object> classForDeclaration(@Name(value="declaration") @NonNull ClassOrInterfaceDeclaration decl) {
        if (decl instanceof ClassOrInterfaceDeclarationImpl) {
            ClassOrInterfaceDeclarationImpl ci = (ClassOrInterfaceDeclarationImpl)decl;
            return Types.erase(ci.getJavaClass());
        }
        throw new AssertionError("Unsupported declaration type: " + decl);
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="java.lang::Class<out T>")
    @TypeParameters(value={@TypeParameter(value="T", satisfies={"ceylon.language::Object"})})
    @NonNull
    public static <T> java.lang.Class<? extends T> classForModel(@Ignore TypeDescriptor $reifiedT, @Name(value="model") @NonNull ClassOrInterface<? extends T> model) {
        ClassOrInterfaceDeclaration decl = model.getDeclaration();
        if (decl instanceof ClassOrInterfaceDeclarationImpl) {
            ClassOrInterfaceDeclarationImpl ci = (ClassOrInterfaceDeclarationImpl)decl;
            return Types.erase(ci.getJavaClass());
        }
        throw new AssertionError("Unsupported declaration type: " + decl);
    }

    private static <T> java.lang.Class<? extends T> erase(java.lang.Class<? extends T> klass) {
        return TypeDescriptor.klass(klass, new TypeDescriptor[0]).getArrayElementClass();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.language::String")
    @NonNull
    public static String codepoints(@Name(value="array") @NonNull char[] array) {
        return new String(array);
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static char[] charArray(@Name(value="string") @TypeInfo(value="ceylon.language::String") @NonNull String string) {
        return string.toCharArray();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="java.lang::String")
    @NonNull
    public static String nativeString(@Name(value="string") @TypeInfo(value="ceylon.language::String") @NonNull String string) {
        return string;
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static long[] longArray(@Name(value="array") @TypeInfo(value="ceylon.language::Array<ceylon.language::Integer>") @NonNull Array<Integer> array) {
        return (long[])array.toArray();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static double[] doubleArray(@Name(value="array") @TypeInfo(value="ceylon.language::Array<ceylon.language::Float>") @NonNull Array<Float> array) {
        return (double[])array.toArray();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static byte[] byteArray(@Name(value="array") @TypeInfo(value="ceylon.language::Array<ceylon.language::Byte>") @NonNull Array<Byte> array) {
        return (byte[])array.toArray();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static boolean[] booleanArray(@Name(value="array") @TypeInfo(value="ceylon.language::Array<ceylon.language::Boolean>") @NonNull Array<Boolean> array) {
        return (boolean[])array.toArray();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static Object[] objectArray(@Name(value="array") @TypeInfo(value="ceylon.language::Array<ceylon.language::Anything>") @NonNull Array<Object> array) {
        return (Object[])array.toArray();
    }

    @StaticAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public static Array<StackTraceElement> stackTrace(@TypeInfo(value="ceylon.language::Throwable") @Name(value="throwable") @NonNull Throwable throwable) {
        return Array.stackTrace(throwable.getStackTrace());
    }
}

