/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.InvalidArchiveException;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationDeclarationVisitor;
import com.redhat.ceylon.compiler.java.codegen.AnnotationModelVisitor;
import com.redhat.ceylon.compiler.java.codegen.CeylonCompilationUnit;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.CodeGenError;
import com.redhat.ceylon.compiler.java.codegen.CompilerBoxingDeclarationVisitor;
import com.redhat.ceylon.compiler.java.codegen.CompilerBoxingVisitor;
import com.redhat.ceylon.compiler.java.codegen.DeferredVisitor;
import com.redhat.ceylon.compiler.java.codegen.DefiniteAssignmentVisitor;
import com.redhat.ceylon.compiler.java.codegen.EeVisitor;
import com.redhat.ceylon.compiler.java.codegen.InterfaceVisitor;
import com.redhat.ceylon.compiler.java.codegen.JvmMissingNativeVisitor;
import com.redhat.ceylon.compiler.java.codegen.SmallDeclarationVisitor;
import com.redhat.ceylon.compiler.java.codegen.SmallVisitor;
import com.redhat.ceylon.compiler.java.codegen.TypeParameterCaptureVisitor;
import com.redhat.ceylon.compiler.java.codegen.UnsupportedVisitor;
import com.redhat.ceylon.compiler.java.loader.CeylonClassReader;
import com.redhat.ceylon.compiler.java.loader.CeylonModelLoader;
import com.redhat.ceylon.compiler.java.loader.ForcedCaptureVisitor;
import com.redhat.ceylon.compiler.java.loader.ImportScanner;
import com.redhat.ceylon.compiler.java.loader.JCTypeResetter;
import com.redhat.ceylon.compiler.java.loader.MethodOrValueReferenceVisitor;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.CeylonPhasedUnit;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.compiler.java.util.Timer;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UnsupportedError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.parser.LexError;
import com.redhat.ceylon.compiler.typechecker.parser.ParseError;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.UnexpectedError;
import com.redhat.ceylon.compiler.typechecker.util.AssertionVisitor;
import com.redhat.ceylon.compiler.typechecker.util.WarningSuppressionVisitor;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.source.util.TaskEvent;
import com.redhat.ceylon.langtools.source.util.TaskListener;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Symtab;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.comp.Annotate;
import com.redhat.ceylon.langtools.tools.javac.comp.AttrContext;
import com.redhat.ceylon.langtools.tools.javac.comp.Check;
import com.redhat.ceylon.langtools.tools.javac.comp.Enter;
import com.redhat.ceylon.langtools.tools.javac.comp.Env;
import com.redhat.ceylon.langtools.tools.javac.comp.Todo;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.tree.EndPosTable;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Abort;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.SourceLanguage;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.Token;

public class CeylonEnter
extends Enter {
    private CeylonTransformer gen;
    private boolean hasRun = false;
    private PhasedUnits phasedUnits;
    private LanguageCompiler.CompilerDelegate compilerDelegate;
    private Log log;
    private AbstractModelLoader modelLoader;
    private Options options;
    private com.redhat.ceylon.model.loader.Timer timer;
    private CeyloncFileManager fileManager;
    private boolean verbose;
    private Check chk;
    private Types types;
    private Symtab symtab;
    private Todo todo;
    private boolean isBootstrap;
    private Annotate annotate;
    private Set<Module> modulesAddedToClassPath = new HashSet<Module>();
    private Set<ModuleSpec> modulesAddedToAptClassPath = new HashSet<ModuleSpec>();
    private TaskListener taskListener;
    private SourceLanguage sourceLanguage;
    private StatusPrinter sp;
    private boolean hasJavaAndCeylonSources;
    private LanguageCompiler compiler;

    public static CeylonEnter instance(Context context) {
        CeylonEnter instance = (CeylonEnter)context.get(enterKey);
        if (instance == null) {
            instance = new CeylonEnter(context);
            context.put(enterKey, instance);
        }
        return instance;
    }

    protected CeylonEnter(Context context) {
        super(context);
        CeylonClassReader.instance(context);
        try {
            this.gen = CeylonTransformer.getInstance(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.phasedUnits = LanguageCompiler.getPhasedUnitsInstance(context);
        this.compilerDelegate = LanguageCompiler.getCompilerDelegate(context);
        this.log = CeylonLog.instance(context);
        this.modelLoader = CeylonModelLoader.instance(context);
        this.options = Options.instance(context);
        this.timer = Timer.instance(context);
        this.fileManager = (CeyloncFileManager)context.get(JavaFileManager.class);
        this.verbose = this.options.get(Option.VERBOSE) != null;
        this.isBootstrap = this.options.get(Option.BOOTSTRAPCEYLON) != null;
        this.chk = Check.instance(context);
        this.types = Types.instance(context);
        this.symtab = Symtab.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.taskListener = context.get(TaskListener.class);
        this.sourceLanguage = SourceLanguage.instance(context);
        this.compiler = (LanguageCompiler)LanguageCompiler.instance(context);
        this.init(context);
        boolean isProgressPrinted = this.options.get(Option.CEYLONPROGRESS) != null && StatusPrinter.canPrint();
        this.sp = isProgressPrinted && this.taskListener == null ? LanguageCompiler.getStatusPrinterInstance(context) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees) {
        this.timer.startTask("prepareForTypeChecking");
        this.prepareForTypeChecking(trees);
        this.timer.endTask();
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> javaTrees = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> ceylonTrees = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (JCTree.JCCompilationUnit tree : trees) {
            if (tree instanceof CeylonCompilationUnit) {
                ceylonTrees = ceylonTrees.prepend(tree);
                continue;
            }
            javaTrees = javaTrees.prepend(tree);
        }
        this.timer.startTask("Enter on Java trees");
        boolean needsModelReset = this.isBootstrap;
        if (!javaTrees.isEmpty()) {
            this.setupImportedPackagesForJavaTrees(javaTrees);
            this.hasJavaAndCeylonSources = true;
            needsModelReset = true;
        }
        if (!this.compiler.isAddModuleTrees()) {
            this.setupImportedPackagesForJavaTrees(ceylonTrees);
        }
        if (this.isBootstrap || this.hasJavaAndCeylonSources) {
            super.main(trees);
        }
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> packageInfo = this.completeCeylonTrees(trees);
        trees = trees.prependList(packageInfo);
        ceylonTrees = ceylonTrees.prependList(packageInfo);
        if (this.compiler.isHadRunTwiceException()) {
            needsModelReset = true;
        }
        if (needsModelReset) {
            this.resetAndRunEnterAgain(trees);
        } else {
            this.timer.startTask("Enter on Ceylon trees");
            try {
                this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
                super.main(ceylonTrees);
            }
            finally {
                this.sourceLanguage.pop();
            }
            this.timer.endTask();
        }
    }

    private void setupImportedPackagesForJavaTrees(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> javaTrees) {
        ImportScanner visitor = new ImportScanner(this.modelLoader);
        for (JCTree.JCCompilationUnit unit : javaTrees) {
            unit.accept(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAndRunEnterAgain(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees) {
        this.timer.startTask("Resetting all trees for bootstrap");
        this.chk.compiled.clear();
        this.types.reset();
        this.annotate.reset();
        super.reset();
        for (Symbol.ClassSymbol classSymbol : this.symtab.classes.values()) {
            if (!Util.isLoadedFromSource(classSymbol) && (classSymbol.sourcefile == null || classSymbol.sourcefile.getKind() != JavaFileObject.Kind.SOURCE)) continue;
            this.resetClassSymbol(classSymbol);
        }
        JCTypeResetter jcTypeResetter = new JCTypeResetter();
        for (JCTree.JCCompilationUnit tree : trees) {
            tree.accept(jcTypeResetter);
        }
        this.todo.reset();
        this.timer.endTask();
        this.timer.startTask("Enter on Java+Ceylon trees");
        try {
            this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
            super.main(trees);
        }
        finally {
            this.sourceLanguage.pop();
        }
        this.timer.endTask();
    }

    private void resetClassSymbol(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.members_field != null) {
            for (Symbol member : classSymbol.getEnclosedElements()) {
                if (!(member instanceof Symbol.ClassSymbol)) continue;
                this.resetClassSymbol((Symbol.ClassSymbol)member);
            }
        }
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classType.all_interfaces_field = null;
        classType.interfaces_field = null;
        classType.supertype_field = null;
        classType.typarams_field = null;
        if (classType.getTag() == TypeTag.ERROR) {
            classSymbol.type = new Type.ClassType(com.redhat.ceylon.langtools.tools.javac.code.Type.noType, null, null);
            classSymbol.type.tsym = classSymbol;
        }
        classSymbol.members_field = null;
        classSymbol.completer = null;
        classSymbol.kind = 2;
        classSymbol.flags_field = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected com.redhat.ceylon.langtools.tools.javac.code.Type classEnter(JCTree tree, Env<AttrContext> env) {
        if (tree instanceof CeylonCompilationUnit) {
            this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
            try {
                com.redhat.ceylon.langtools.tools.javac.code.Type type = super.classEnter(tree, env);
                return type;
            }
            finally {
                this.sourceLanguage.pop();
            }
        }
        return super.classEnter(tree, env);
    }

    public void prepareForTypeChecking(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees) {
        if (this.hasRun) {
            throw new RuntimeException("Waaaaa, running twice!!!");
        }
        int numParserErrors = this.log.nerrors;
        this.timer.startTask("loadStandardModules");
        this.compilerDelegate.loadStandardModules(this.modelLoader);
        this.timer.endTask();
        this.hasRun = true;
        this.timer.startTask("setupSourceFileObjects");
        this.compilerDelegate.setupSourceFileObjects(trees, this.modelLoader);
        this.timer.endTask();
        this.timer.startTask("verifyModuleDependencyTree");
        this.compilerDelegate.resolveModuleDependencies(this.phasedUnits);
        this.timer.endTask();
        this.timer.startTask("loadPackageDescriptors");
        this.compilerDelegate.loadPackageDescriptors(this.modelLoader);
        this.timer.endTask();
        this.timer.startTask("collectTreeErrors");
        this.collectTreeErrors(false, false);
        this.timer.endTask();
        if (this.options.get(Option.CEYLONCONTINUE) == null && this.log.nerrors - numParserErrors > 0) {
            throw new Abort();
        }
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> completeCeylonTrees(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees) {
        this.timer.startTask("Ceylon type checking");
        this.typeCheck();
        this.timer.startTask("Ceylon code generation");
        com.redhat.ceylon.model.loader.Timer nested = this.timer.nestedTimer();
        if (this.sp != null) {
            this.sp.clearLine();
            this.sp.log("Generating AST");
        }
        int i = 1;
        int size = this.countCeylonFiles(trees);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> packageInfos = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (JCTree.JCCompilationUnit tree : trees) {
            if (!(tree instanceof CeylonCompilationUnit)) continue;
            CeylonCompilationUnit ceylonTree = (CeylonCompilationUnit)tree;
            this.gen.setMap(ceylonTree.lineMap);
            CeylonPhasedUnit phasedUnit = (CeylonPhasedUnit)ceylonTree.phasedUnit;
            if (this.sp != null) {
                this.sp.clearLine();
                this.sp.log("Generating [" + i++ + "/" + size + "] ");
                this.sp.log(phasedUnit.getPathRelativeToSrcDir());
            }
            this.gen.setFileObject(phasedUnit.getFileObject());
            nested.startTask("Ceylon code generation for " + phasedUnit.getUnitFile().getName());
            TaskEvent event = new TaskEvent(TaskEvent.Kind.PARSE, tree);
            if (this.taskListener != null) {
                this.taskListener.started(event);
            }
            ceylonTree.defs = this.gen.transformAfterTypeChecking(ceylonTree.ceylonTree).toList();
            if (this.taskListener != null) {
                this.taskListener.finished(event);
            }
            packageInfos = packageInfos.prependList(this.gen.transformPackageInfo(ceylonTree));
            nested.endTask();
            if (this.isVerbose("ast")) {
                this.log.printRawLines(Log.WriterKind.ERROR, "Model tree for " + tree.getSourceFile());
                this.log.printRawLines(Log.WriterKind.ERROR, ceylonTree.ceylonTree.toString());
            }
            if (!this.isVerbose("code")) continue;
            this.log.printRawLines(Log.WriterKind.ERROR, "Java code generated for " + tree.getSourceFile());
            this.log.printRawLines(Log.WriterKind.ERROR, ceylonTree.toString());
        }
        if (this.isVerbose("code")) {
            for (JCTree.JCCompilationUnit packageInfo : packageInfos) {
                this.log.printRawLines(Log.WriterKind.ERROR, packageInfo.toString());
            }
        }
        if (this.sp != null) {
            this.sp.clearLine();
        }
        this.timer.startTask("Ceylon error generation");
        this.printGeneratorErrors();
        this.timer.endTask();
        if (this.verbose) {
            this.modelLoader.printStats();
        }
        return packageInfos;
    }

    private int countCeylonFiles(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees) {
        int cnt = 0;
        for (JCTree.JCCompilationUnit tree : trees) {
            if (!(tree instanceof CeylonCompilationUnit)) continue;
            ++cnt;
        }
        return cnt;
    }

    private boolean isVerbose(String key) {
        return this.verbose || this.options.get(Option.VERBOSE.text + ":" + key) != null;
    }

    public void addOutputModuleToClassPath(Module module) {
        RepositoryManager repositoryManager = this.fileManager.getOutputRepositoryManager();
        ArtifactResult artifact = null;
        try {
            ArtifactContext ctx = new ArtifactContext(null, module.getNameAsString(), module.getVersion(), ".car", ".jar");
            artifact = repositoryManager.getArtifactResult(ctx);
        }
        catch (InvalidArchiveException e) {
            this.log.warning("ceylon", "Module car " + e.getPath() + " obtained from repository " + e.getRepository() + " has an invalid SHA1 signature:" + " it will be overwritten but if the problem" + " persists you need to remove it and rebuild the module, since it may be corrupted.");
        }
        catch (Exception e) {
            String moduleName = module.getNameAsString();
            if (!module.isDefaultModule()) {
                moduleName = moduleName + "/" + module.getVersion();
            }
            this.log.error("ceylon", "Exception occured while trying to resolve module " + moduleName);
            e.printStackTrace();
        }
        if (artifact == null || JarUtils.isValidJar(artifact.artifact())) {
            this.addModuleToClassPath(module, false, artifact);
        } else {
            this.log.warning("ceylon", "Module car " + artifact.artifact() + " obtained from repository " + artifact.repository() + " could not be read:" + " it will be overwritten but if the problem" + " persists you need to remove it and rebuild the module, since it may be corrupted.");
        }
    }

    public boolean isModuleInClassPath(Module module) {
        return this.modulesAddedToClassPath.contains(module);
    }

    public void addModuleToClassPath(Module module, boolean errorIfMissing, ArtifactResult result) {
        if (this.verbose) {
            this.log.printRawLines(Log.WriterKind.NOTICE, "[Adding module to classpath: " + module.getNameAsString() + "/" + module.getVersion() + "]");
        }
        Collection<File> classPath = this.fileManager.getLocations().getLocation(StandardLocation.CLASS_PATH);
        File artifact = null;
        try {
            artifact = result != null ? result.artifact() : null;
        }
        catch (Exception e) {
            String moduleName = module.getNameAsString();
            if (!module.isDefaultModule()) {
                moduleName = moduleName + "/" + module.getVersion();
            }
            this.log.error("ceylon", "Exception occured while trying to resolve module " + moduleName);
            e.printStackTrace();
        }
        if (this.verbose) {
            if (artifact != null) {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Found module at : " + artifact.getPath() + "]");
            } else {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Could not find module]");
            }
        }
        if (this.modulesAddedToClassPath.add(module)) {
            if (artifact != null && artifact.exists()) {
                ArrayList<File> newClassPath = new ArrayList<File>(classPath);
                newClassPath.add(artifact);
                try {
                    this.fileManager.getLocations().setLocation(StandardLocation.CLASS_PATH, newClassPath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ((LazyModule)module).loadPackageList(result);
            } else if (errorIfMissing) {
                this.log.error("ceylon", "Failed to find module " + module.getNameAsString() + "/" + module.getVersion() + " in repositories");
            }
        } else if (this.verbose) {
            this.log.printRawLines(Log.WriterKind.NOTICE, "[Module already added to classpath]");
        }
    }

    public void addModuleToAptPath(ModuleSpec module, ArtifactResult result) {
        if (this.verbose) {
            this.log.printRawLines(Log.WriterKind.NOTICE, "[Adding APT module to APT classpath: " + module + "]");
        }
        Collection<File> classPath = this.fileManager.getLocations().getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        File artifact = null;
        try {
            artifact = result != null ? result.artifact() : null;
        }
        catch (Exception e) {
            this.log.error("ceylon", "Exception occured while trying to resolve APT module " + module);
            e.printStackTrace();
        }
        if (this.verbose) {
            if (artifact != null) {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Found APT module at : " + artifact.getPath() + "]");
            } else {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Could not find APT module]");
            }
        }
        if (this.modulesAddedToAptClassPath.add(module)) {
            if (artifact != null && artifact.exists()) {
                ArrayList<File> newClassPath = classPath == null ? new ArrayList<File>(1) : new ArrayList<File>(classPath);
                newClassPath.add(artifact);
                try {
                    this.fileManager.getLocations().setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, newClassPath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.log.error("ceylon", "Failed to find APT module " + module + " in repositories");
            }
        } else if (this.verbose) {
            this.log.printRawLines(Log.WriterKind.NOTICE, "[APT Module already added to APT classpath]");
        }
    }

    private void typeCheck() {
        Tree.CompilationUnit compilationUnit;
        List<PhasedUnit> listOfUnits = this.phasedUnits.getPhasedUnits();
        Module jdk = this.modelLoader.getJDKBaseModule();
        Package javaLangPackage = jdk.getPackage("java.lang");
        for (PhasedUnit pu : listOfUnits) {
            pu.getUnit().setJavaLangPackage(javaLangPackage);
        }
        this.compilerDelegate.typeCheck(listOfUnits);
        if (this.sp != null) {
            this.sp.clearLine();
            this.sp.log("Preparation phase");
        }
        int size = listOfUnits.size();
        int i = 1;
        ForcedCaptureVisitor fcv = new ForcedCaptureVisitor();
        for (PhasedUnit pu : listOfUnits) {
            if (this.sp != null) {
                this.progressPreparation(1, i++, size, pu);
            }
            TypecheckerUnit unit = pu.getUnit();
            Tree.CompilationUnit compilationUnit2 = pu.getCompilationUnit();
            compilationUnit2.visit(fcv);
            for (Declaration d : unit.getDeclarations()) {
                if (!(d instanceof TypedDeclaration) || d instanceof Setter || d.isCaptured()) continue;
                compilationUnit2.visit(new MethodOrValueReferenceVisitor((TypedDeclaration)d));
            }
        }
        EeVisitor eeVisitor = this.gen.getEeVisitor();
        UnsupportedVisitor uv = new UnsupportedVisitor(eeVisitor);
        JvmMissingNativeVisitor mnv = new JvmMissingNativeVisitor();
        CompilerBoxingDeclarationVisitor boxingDeclarationVisitor = new CompilerBoxingDeclarationVisitor(this.gen);
        CompilerBoxingVisitor boxingVisitor = new CompilerBoxingVisitor(this.gen);
        SmallDeclarationVisitor smallDeclarationVisitor = new SmallDeclarationVisitor();
        SmallVisitor smallVisitor = new SmallVisitor();
        DeferredVisitor deferredVisitor = new DeferredVisitor();
        AnnotationDeclarationVisitor adv = new AnnotationDeclarationVisitor(this.gen);
        AnnotationModelVisitor amv = new AnnotationModelVisitor(this.gen);
        DefiniteAssignmentVisitor dav = new DefiniteAssignmentVisitor();
        TypeParameterCaptureVisitor tpCaptureVisitor = new TypeParameterCaptureVisitor();
        InterfaceVisitor localInterfaceVisitor = new InterfaceVisitor();
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (this.sp != null) {
                this.progressPreparation(2, i++, size, pu);
            }
            pu.getCompilationUnit().visit(eeVisitor);
            pu.getCompilationUnit().visit(uv);
            pu.getCompilationUnit().visit(adv);
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (this.sp != null) {
                this.progressPreparation(3, i++, size, pu);
            }
            pu.getCompilationUnit().visit(boxingDeclarationVisitor);
            pu.getCompilationUnit().visit(smallDeclarationVisitor);
            pu.getCompilationUnit().visit(amv);
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (this.sp != null) {
                this.progressPreparation(4, i++, size, pu);
            }
            compilationUnit = pu.getCompilationUnit();
            compilationUnit.visit(mnv);
            compilationUnit.visit(boxingVisitor);
            compilationUnit.visit(smallVisitor);
            compilationUnit.visit(deferredVisitor);
            compilationUnit.visit(dav);
            compilationUnit.visit(tpCaptureVisitor);
            compilationUnit.visit(localInterfaceVisitor);
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (this.sp != null) {
                this.progressPreparation(5, i++, size, pu);
            }
            compilationUnit = pu.getCompilationUnit();
            compilationUnit.visit(new WarningSuppressionVisitor<Warning>(Warning.class, pu.getSuppressedWarnings()));
        }
        this.collectTreeErrors(true, true);
    }

    private void progressPreparation(int phase, int i, int size, PhasedUnit pu) {
        this.sp.clearLine();
        this.sp.log("Preparing " + phase + "/5 [" + i++ + "/" + size + "] ");
        this.sp.log(pu.getPathRelativeToSrcDir());
    }

    private void collectTreeErrors(boolean runAssertions, final boolean reportWarnings) {
        List listOfUnits = this.phasedUnits.getPhasedUnits();
        for (PhasedUnit pu : listOfUnits) {
            pu.getCompilationUnit().visit(new JavacAssertionVisitor((CeylonPhasedUnit)pu, runAssertions){

                @Override
                protected void out(UnexpectedError err) {
                    this.setSource();
                    CeylonEnter.this.logError(this.getPosition(err.getTreeNode()), "ceylon", err.getMessage());
                }

                @Override
                protected void out(AnalysisError err) {
                    if (err.isWarning()) {
                        if (reportWarnings) {
                            this.setSource();
                            Node node = this.getIdentifyingNode(err.getTreeNode());
                            CeylonEnter.this.logWarning(this.getPosition(node), "ceylon", err.getMessage());
                        }
                    } else {
                        this.setSource();
                        Node node = this.getIdentifyingNode(err.getTreeNode());
                        CeylonEnter.this.logError(this.getPosition(node), "ceylon", err.getMessage());
                    }
                }

                @Override
                protected void out(Node that, LexError err) {
                    this.setSource();
                    JCDiagnostic.DiagnosticPosition pos = this.getPosition(err.getLine(), err.getCharacterInLine());
                    CeylonEnter.this.logError(pos, "ceylon", err.getMessage());
                }

                @Override
                protected void out(Node that, ParseError err) {
                    this.setSource();
                    JCDiagnostic.DiagnosticPosition pos = this.getPosition(err.getLine(), err.getCharacterInLine());
                    CeylonEnter.this.logError(pos, "ceylon", err.getMessage());
                }

                @Override
                protected void out(UnsupportedError err) {
                    this.setSource();
                    Node node = this.getIdentifyingNode(err.getTreeNode());
                    CeylonEnter.this.logError(this.getPosition(node), "ceylon", err.getMessage());
                }

                @Override
                protected void out(UsageWarning warning) {
                    if (reportWarnings && !warning.isSuppressed()) {
                        this.setSource();
                        Node node = this.getIdentifyingNode(warning.getTreeNode());
                        CeylonEnter.this.logWarning(this.getPosition(node), "ceylon", warning.getMessage());
                    }
                }

                @Override
                protected void out(Node that, String message) {
                    this.setSource();
                    CeylonEnter.this.logError(this.getPosition(that), "ceylon", message);
                }
            });
        }
    }

    private void printGeneratorErrors() {
        List listOfUnits = this.phasedUnits.getPhasedUnits();
        for (PhasedUnit pu : listOfUnits) {
            pu.getCompilationUnit().visit(new JavacAssertionVisitor((CeylonPhasedUnit)pu, false){

                @Override
                protected void out(UnexpectedError err) {
                    if (err instanceof CodeGenError) {
                        this.setSource();
                        CodeGenError error = (CodeGenError)err;
                        String location = this.locationInfo(error);
                        CeylonEnter.this.logError(this.getPosition(err.getTreeNode()), "ceylon.codegen.exception", "compiler bug: " + error.getMessage() + " at " + location);
                    }
                }

                private String locationInfo(CodeGenError error) {
                    if (error.getCause() != null && error.getCause().getStackTrace() != null && error.getCause().getStackTrace().length > 0) {
                        return error.getCause().getStackTrace()[0].toString();
                    }
                    return "unknown";
                }

                @Override
                protected void out(AnalysisError err) {
                }

                @Override
                protected void out(UnsupportedError err) {
                }

                @Override
                protected void out(UsageWarning warn) {
                }

                @Override
                protected void out(Node that, ParseError err) {
                }

                @Override
                protected void out(Node that, LexError err) {
                }

                @Override
                protected void out(Node that, String message) {
                }
            });
        }
    }

    protected void logError(int position, String key, String message) {
        this.logError(this.toDiagnosticPosition(position), key, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logError(JCDiagnostic.DiagnosticPosition position, String key, String message) {
        boolean prev = this.log.multipleErrors;
        this.log.multipleErrors = true;
        try {
            this.log.error(position, key, message);
        }
        finally {
            this.log.multipleErrors = prev;
        }
    }

    protected void logWarning(int position, String key, String message) {
        this.logWarning(this.toDiagnosticPosition(position), key, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logWarning(JCDiagnostic.DiagnosticPosition position, String key, String message) {
        boolean prev = this.log.multipleErrors;
        this.log.multipleErrors = true;
        try {
            this.log.warning(position, key, message);
        }
        finally {
            this.log.multipleErrors = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logStackTrace(String key, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        String tracktrace = sw.toString();
        boolean prev = this.log.multipleErrors;
        this.log.multipleErrors = true;
        try {
            this.log.printLines(Log.WriterKind.ERROR, key, tracktrace);
        }
        finally {
            this.log.multipleErrors = prev;
        }
    }

    protected JCDiagnostic.DiagnosticPosition toDiagnosticPosition(int pos) {
        return pos == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(pos);
    }

    public boolean hasRun() {
        return this.hasRun;
    }

    public boolean isCompilingJavaAndCeylonSources() {
        return this.hasJavaAndCeylonSources;
    }

    private class JavacAssertionVisitor
    extends AssertionVisitor {
        private CeylonPhasedUnit cpu;
        protected final boolean runAssertions;

        JavacAssertionVisitor(CeylonPhasedUnit cpu, boolean runAssertions) {
            this.cpu = cpu;
            this.runAssertions = runAssertions;
            this.includeUsageWarnings(true);
        }

        @Override
        protected void checkType(Tree.Statement that, Type type, Node typedNode) {
            if (this.runAssertions) {
                super.checkType(that, type, typedNode);
            }
        }

        @Override
        protected boolean includeError(Message err, int phase) {
            return err.getBackend() == null || ModelUtil.isForBackend(err.getBackend().asSet(), Backend.Java);
        }

        protected Node getIdentifyingNode(Node node) {
            return TreeUtil.getIdentifyingNode(node);
        }

        protected JCDiagnostic.DiagnosticPosition getPosition(int line, int characterInLine) {
            int pos = this.getPositionAsInt(line, characterInLine);
            return CeylonEnter.this.toDiagnosticPosition(pos);
        }

        protected int getPositionAsInt(int line, int characterInLine) {
            if (line < 1) {
                return -1;
            }
            try {
                return this.cpu.getLineMap().getPosition(line, characterInLine);
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                if (line < 2) {
                    return -1;
                }
                return this.cpu.getLineMap().getPosition(line - 1, 0);
            }
        }

        protected JCDiagnostic.DiagnosticPosition getPosition(Node node) {
            Token token;
            if (node != null && (token = node.getToken()) != null) {
                final int startOffset = node.getStartIndex();
                final int endOffset = node.getStopIndex();
                int startLine = token.getLine();
                int startCol = token.getCharPositionInLine();
                if (startOffset < 0 || endOffset < 0) {
                    return this.getPosition(startLine, startCol);
                }
                return new JCDiagnostic.DiagnosticPosition(){

                    @Override
                    public JCTree getTree() {
                        return null;
                    }

                    @Override
                    public int getStartPosition() {
                        return startOffset;
                    }

                    @Override
                    public int getPreferredPosition() {
                        return startOffset;
                    }

                    @Override
                    public int getEndPosition(EndPosTable endPosTable) {
                        return endOffset;
                    }
                };
            }
            return null;
        }

        protected void setSource() {
            CeylonEnter.this.log.useSource(this.cpu.getFileObject());
        }

        @Override
        protected void initExpectingError(List<Tree.CompilerAnnotation> annotations) {
            if (this.runAssertions) {
                super.initExpectingError(annotations);
            }
        }
    }
}

