/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.mirror;

import com.redhat.ceylon.compiler.java.loader.mirror.JavacField;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacMethod;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacPackage;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacType;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacUtil;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.javax.lang.model.element.Element;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.FieldMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.mirror.PackageMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavacClass
implements ClassMirror {
    public Symbol.ClassSymbol classSymbol;
    private PackageMirror pkg;
    private TypeMirror superclass;
    private List<MethodMirror> methods;
    private List<TypeMirror> interfaces;
    private Map<String, AnnotationMirror> annotations;
    private List<TypeParameterMirror> typeParams;
    private ClassMirror enclosingClass;
    private boolean enclosingClassSet;
    private MethodMirror enclosingMethod;
    private boolean enclosingMethodSet;
    private List<FieldMirror> fields;
    private LinkedList<ClassMirror> innerClasses;
    private String cacheKey;

    public JavacClass(Symbol.ClassSymbol classSymbol) {
        this.classSymbol = classSymbol;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " of " + this.classSymbol;
    }

    @Override
    public boolean isPublic() {
        return (this.classSymbol.flags() & 1L) != 0L;
    }

    @Override
    public boolean isProtected() {
        return (this.classSymbol.flags() & 4L) != 0L;
    }

    @Override
    public boolean isDefaultAccess() {
        return (this.classSymbol.flags() & 7L) == 0L;
    }

    @Override
    public String getQualifiedName() {
        if (this.classSymbol.name.length() == 0) {
            return this.classSymbol.flatname.toString();
        }
        return this.classSymbol.getQualifiedName().toString();
    }

    @Override
    public String getFlatName() {
        return this.classSymbol.flatname.toString();
    }

    @Override
    public PackageMirror getPackage() {
        if (this.pkg == null) {
            this.pkg = new JavacPackage(this.classSymbol.packge());
        }
        return this.pkg;
    }

    @Override
    public boolean isInterface() {
        return this.classSymbol.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return (this.classSymbol.flags() & 0x2000L) != 0L;
    }

    @Override
    public boolean isCeylonToplevelAttribute() {
        return !this.isInnerClass() && this.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Attribute") != null;
    }

    @Override
    public boolean isCeylonToplevelObject() {
        return !this.isInnerClass() && this.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Object") != null;
    }

    @Override
    public boolean isCeylonToplevelMethod() {
        return !this.isInnerClass() && this.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Method") != null;
    }

    @Override
    public AnnotationMirror getAnnotation(String type) {
        if (this.annotations == null) {
            this.annotations = JavacUtil.getAnnotations(this.classSymbol);
        }
        return this.annotations.get(type);
    }

    @Override
    public Set<String> getAnnotationNames() {
        if (this.annotations == null) {
            this.annotations = JavacUtil.getAnnotations(this.classSymbol);
        }
        return this.annotations.keySet();
    }

    @Override
    public boolean isLoadedFromSource() {
        return Util.isLoadedFromSource(this.classSymbol);
    }

    @Override
    public String getName() {
        return ((Name)this.classSymbol.getSimpleName()).toString();
    }

    @Override
    public boolean isAbstract() {
        return (this.classSymbol.flags() & 0x400L) != 0L;
    }

    @Override
    public boolean isStatic() {
        return (this.classSymbol.flags() & 8L) != 0L;
    }

    @Override
    public boolean isFinal() {
        return (this.classSymbol.flags() & 0x10L) != 0L;
    }

    @Override
    public List<MethodMirror> getDirectMethods() {
        if (this.methods == null) {
            LinkedList<JavacMethod> ret = new LinkedList<JavacMethod>();
            for (Symbol sym : this.classSymbol.getEnclosedElements()) {
                if (!(sym instanceof Symbol.MethodSymbol) || (sym.flags() & 2L) != 0L) continue;
                ret.add(new JavacMethod(this, (Symbol.MethodSymbol)sym));
            }
            this.methods = Collections.unmodifiableList(ret);
        }
        return this.methods;
    }

    @Override
    public List<FieldMirror> getDirectFields() {
        if (this.fields == null) {
            LinkedList<JavacField> ret = new LinkedList<JavacField>();
            for (Symbol sym : this.classSymbol.getEnclosedElements()) {
                if (!(sym instanceof Symbol.VarSymbol) || (sym.flags() & 2L) != 0L) continue;
                ret.add(new JavacField((Symbol.VarSymbol)sym));
            }
            this.fields = Collections.unmodifiableList(ret);
        }
        return this.fields;
    }

    @Override
    public TypeMirror getSuperclass() {
        Type supercls;
        if (this.superclass == null && (supercls = this.classSymbol.getSuperclass()) != null && supercls.getTag() != TypeTag.NONE) {
            this.superclass = new JavacType(supercls);
        }
        return this.superclass;
    }

    @Override
    public List<TypeMirror> getInterfaces() {
        if (this.interfaces == null) {
            ArrayList<JavacType> ret = new ArrayList<JavacType>(((com.redhat.ceylon.langtools.tools.javac.util.List)this.classSymbol.getInterfaces()).size());
            for (Type interfce : this.classSymbol.getInterfaces()) {
                ret.add(new JavacType(interfce));
            }
            this.interfaces = Collections.unmodifiableList(ret);
        }
        return this.interfaces;
    }

    @Override
    public List<TypeParameterMirror> getTypeParameters() {
        if (this.typeParams == null) {
            this.typeParams = Collections.unmodifiableList(JavacUtil.getTypeParameters(this.classSymbol));
        }
        return this.typeParams;
    }

    @Override
    public boolean isInnerClass() {
        return this.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Container") != null || this.classSymbol.owner instanceof Symbol.ClassSymbol;
    }

    @Override
    public boolean isLocalClass() {
        return this.getAnnotation("com.redhat.ceylon.compiler.java.metadata.LocalDeclaration") != null || this.classSymbol.owner instanceof Symbol.MethodSymbol;
    }

    @Override
    public List<ClassMirror> getDirectInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = new LinkedList();
            for (Symbol elem : this.classSymbol.getEnclosedElements()) {
                if (!(elem instanceof Symbol.ClassSymbol)) continue;
                this.innerClasses.add(new JavacClass((Symbol.ClassSymbol)elem));
            }
        }
        return this.innerClasses;
    }

    @Override
    public boolean isAnonymous() {
        return this.classSymbol.name.isEmpty();
    }

    @Override
    public boolean isJavaSource() {
        return Util.isJavaSource(this.classSymbol);
    }

    @Override
    public ClassMirror getEnclosingClass() {
        if (!this.enclosingClassSet) {
            Element encl = this.classSymbol.getEnclosingElement();
            if (encl != null && encl instanceof Symbol.ClassSymbol) {
                this.enclosingClass = new JavacClass((Symbol.ClassSymbol)encl);
            }
            this.enclosingClassSet = true;
        }
        return this.enclosingClass;
    }

    @Override
    public MethodMirror getEnclosingMethod() {
        if (!this.enclosingMethodSet) {
            Element encl = this.classSymbol.getEnclosingElement();
            if (encl != null && encl instanceof Symbol.MethodSymbol) {
                Symbol.ClassSymbol enclosingClass = (Symbol.ClassSymbol)((Symbol)encl).getEnclosingElement();
                JavacClass enclosingClassMirror = new JavacClass(enclosingClass);
                this.enclosingMethod = new JavacMethod(enclosingClassMirror, (Symbol.MethodSymbol)encl);
            }
            this.enclosingMethodSet = true;
        }
        return this.enclosingMethod;
    }

    @Override
    public boolean isEnum() {
        try {
            return (this.classSymbol.flags() & 0x4000L) != 0L;
        }
        catch (Symbol.CompletionFailure x) {
            return false;
        }
    }

    @Override
    public String getCacheKey(Module module) {
        if (this.cacheKey == null) {
            String className = this.getQualifiedName();
            this.cacheKey = AbstractModelLoader.getCacheKeyByModule(module, className);
        }
        return this.cacheKey;
    }
}

