/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.mirror;

import com.redhat.ceylon.compiler.java.loader.mirror.JavacType;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacUtil;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.FieldMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import java.util.Map;
import java.util.Set;

public class JavacField
implements FieldMirror {
    private Symbol.VarSymbol fieldSymbol;
    private Map<String, AnnotationMirror> annotations;
    private TypeMirror type;

    public JavacField(Symbol.VarSymbol sym) {
        this.fieldSymbol = sym;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " of " + this.fieldSymbol;
    }

    @Override
    public AnnotationMirror getAnnotation(String type) {
        if (this.annotations == null) {
            this.annotations = JavacUtil.getAnnotations(this.fieldSymbol);
        }
        return this.annotations.get(type);
    }

    @Override
    public Set<String> getAnnotationNames() {
        if (this.annotations == null) {
            this.annotations = JavacUtil.getAnnotations(this.fieldSymbol);
        }
        return this.annotations.keySet();
    }

    @Override
    public String getName() {
        return this.fieldSymbol.name.toString();
    }

    @Override
    public boolean isStatic() {
        return this.fieldSymbol.isStatic();
    }

    @Override
    public boolean isPublic() {
        return (this.fieldSymbol.flags() & 1L) != 0L;
    }

    @Override
    public boolean isProtected() {
        return (this.fieldSymbol.flags() & 4L) != 0L;
    }

    @Override
    public boolean isDefaultAccess() {
        return (this.fieldSymbol.flags() & 7L) == 0L;
    }

    @Override
    public boolean isFinal() {
        return (this.fieldSymbol.flags() & 0x10L) != 0L;
    }

    @Override
    public TypeMirror getType() {
        Type retType;
        if (this.type == null && (retType = this.fieldSymbol.type) != null) {
            this.type = new JavacType(retType);
        }
        return this.type;
    }
}

