/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.mirror;

import com.redhat.ceylon.compiler.java.loader.mirror.JavacType;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacUtil;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacVariable;
import com.redhat.ceylon.javax.lang.model.element.ElementKind;
import com.redhat.ceylon.javax.lang.model.type.TypeKind;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import com.redhat.ceylon.model.loader.mirror.VariableMirror;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavacMethod
implements MethodMirror {
    public Symbol.MethodSymbol methodSymbol;
    private TypeMirror returnType;
    private List<VariableMirror> parameters;
    private Map<String, AnnotationMirror> annotations;
    private List<TypeParameterMirror> typeParams;
    private ClassMirror enclosingClass;

    public JavacMethod(ClassMirror enclosingClass, Symbol.MethodSymbol sym) {
        this.methodSymbol = sym;
        this.enclosingClass = enclosingClass;
    }

    @Override
    public AnnotationMirror getAnnotation(String type) {
        if (this.annotations == null) {
            this.annotations = JavacUtil.getAnnotations(this.methodSymbol);
        }
        return this.annotations.get(type);
    }

    @Override
    public Set<String> getAnnotationNames() {
        if (this.annotations == null) {
            this.annotations = JavacUtil.getAnnotations(this.methodSymbol);
        }
        return this.annotations.keySet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " of " + this.methodSymbol;
    }

    @Override
    public String getName() {
        return this.methodSymbol.name.toString();
    }

    @Override
    public boolean isStatic() {
        return this.methodSymbol.isStatic();
    }

    @Override
    public boolean isPublic() {
        return (this.methodSymbol.flags() & 1L) != 0L;
    }

    @Override
    public boolean isProtected() {
        return (this.methodSymbol.flags() & 4L) != 0L;
    }

    @Override
    public boolean isDefaultAccess() {
        return (this.methodSymbol.flags() & 7L) == 0L;
    }

    @Override
    public boolean isConstructor() {
        return this.methodSymbol.isConstructor();
    }

    @Override
    public boolean isStaticInit() {
        return this.methodSymbol.getKind() == ElementKind.STATIC_INIT;
    }

    @Override
    public boolean isVariadic() {
        return this.methodSymbol.isVarArgs();
    }

    @Override
    public List<VariableMirror> getParameters() {
        if (this.parameters == null) {
            List params = this.methodSymbol.getParameters();
            ArrayList<JavacVariable> ret = new ArrayList<JavacVariable>(((com.redhat.ceylon.langtools.tools.javac.util.List)params).size());
            for (Symbol.VarSymbol parameter : params) {
                ret.add(new JavacVariable(parameter));
            }
            this.parameters = Collections.unmodifiableList(ret);
        }
        return this.parameters;
    }

    @Override
    public boolean isAbstract() {
        return (this.methodSymbol.flags() & 0x400L) != 0L;
    }

    @Override
    public boolean isDefaultMethod() {
        return (this.methodSymbol.flags() & 0x80000000000L) != 0L;
    }

    @Override
    public boolean isFinal() {
        return (this.methodSymbol.flags() & 0x10L) != 0L;
    }

    @Override
    public TypeMirror getReturnType() {
        Type retType;
        if (this.returnType == null && (retType = this.methodSymbol.getReturnType()) != null) {
            this.returnType = new JavacType(retType);
        }
        return this.returnType;
    }

    @Override
    public boolean isDeclaredVoid() {
        Type retType = this.methodSymbol.getReturnType();
        return retType.getKind() == TypeKind.VOID;
    }

    @Override
    public List<TypeParameterMirror> getTypeParameters() {
        if (this.typeParams == null) {
            this.typeParams = Collections.unmodifiableList(JavacUtil.getTypeParameters(this.methodSymbol));
        }
        return this.typeParams;
    }

    @Override
    public boolean isDefault() {
        return this.methodSymbol.getDefaultValue() != null;
    }

    @Override
    public ClassMirror getEnclosingClass() {
        return this.enclosingClass;
    }
}

