/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.mirror;

import com.redhat.ceylon.compiler.java.loader.mirror.JavacClass;
import com.redhat.ceylon.compiler.java.loader.mirror.JavacTypeParameter;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.TypeKind;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavacType
implements TypeMirror {
    public final Type type;
    private List<TypeMirror> typeArguments;
    private boolean componentTypeSet;
    private TypeMirror componentType;
    private boolean upperBoundSet;
    private JavacType upperBound;
    private boolean lowerBoundSet;
    private JavacType lowerBound;
    private JavacClass declaredClass;
    private boolean declaredClassSet;
    private TypeParameterMirror typeParameter;
    private boolean typeParameterSet;
    private JavacType qualifyingType;

    public JavacType(Type type) {
        this.type = type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " of " + this.type;
    }

    @Override
    public String getQualifiedName() {
        return this.type.tsym.getQualifiedName().toString();
    }

    @Override
    public List<TypeMirror> getTypeArguments() {
        if (this.typeArguments == null) {
            ArrayList<JavacType> args = new ArrayList<JavacType>(this.type.getTypeArguments().size());
            for (Type typeArg : this.type.getTypeArguments()) {
                args.add(new JavacType(typeArg));
            }
            this.typeArguments = Collections.unmodifiableList(args);
        }
        return this.typeArguments;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.valueOf(this.type.getKind().name());
    }

    @Override
    public TypeMirror getComponentType() {
        if (!this.componentTypeSet && this.type instanceof Type.ArrayType) {
            Type compType = ((Type.ArrayType)this.type).getComponentType();
            if (compType != null) {
                this.componentType = new JavacType(compType);
            }
            this.componentTypeSet = true;
        }
        return this.componentType;
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public TypeMirror getUpperBound() {
        if (!this.upperBoundSet) {
            Type bound;
            if (this.type instanceof Type.WildcardType) {
                Type bound2 = ((Type.WildcardType)this.type).getExtendsBound();
                if (bound2 != null) {
                    this.upperBound = new JavacType(bound2);
                }
            } else if (this.type instanceof Type.TypeVar && (bound = ((Type.TypeVar)this.type).getUpperBound()) != null) {
                this.upperBound = new JavacType(bound);
            }
            this.upperBoundSet = true;
        }
        return this.upperBound;
    }

    @Override
    public TypeMirror getLowerBound() {
        if (!this.lowerBoundSet && this.type instanceof Type.WildcardType) {
            Type bound = ((Type.WildcardType)this.type).getSuperBound();
            if (bound != null) {
                this.lowerBound = new JavacType(bound);
            }
            this.lowerBoundSet = true;
        }
        return this.lowerBound;
    }

    @Override
    public boolean isRaw() {
        return this.type.isRaw();
    }

    @Override
    public ClassMirror getDeclaredClass() {
        if (!this.declaredClassSet) {
            if (this.type.tsym instanceof Symbol.ClassSymbol) {
                this.declaredClass = new JavacClass((Symbol.ClassSymbol)this.type.tsym);
            }
            this.declaredClassSet = true;
        }
        return this.declaredClass;
    }

    @Override
    public TypeParameterMirror getTypeParameter() {
        if (this.getKind() != TypeKind.TYPEVAR) {
            return null;
        }
        if (!this.typeParameterSet) {
            this.typeParameter = new JavacTypeParameter((Symbol.TypeVariableSymbol)this.type.tsym);
            this.typeParameterSet = true;
        }
        return this.typeParameter;
    }

    @Override
    public TypeMirror getQualifyingType() {
        Type enclosingType;
        if (this.qualifyingType == null && (enclosingType = this.type.getEnclosingType()) != null && enclosingType instanceof Type.ClassType) {
            this.qualifyingType = new JavacType(enclosingType);
        }
        return this.qualifyingType;
    }
}

