/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel;

import ceylon.language.meta.declaration.AliasDeclaration;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.Declaration;
import ceylon.language.meta.declaration.FunctionDeclaration;
import ceylon.language.meta.declaration.GenericDeclaration;
import ceylon.language.meta.declaration.Module;
import ceylon.language.meta.declaration.Package;
import ceylon.language.meta.declaration.TypeParameter;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.modules_;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;

class DeclarationParser {
    private int i = 0;
    private String ref;

    DeclarationParser() {
    }

    private RuntimeException parseError(String msg) {
        throw Metamodel.newModelError(msg + " at index " + this.i + ": " + this.ref);
    }

    private RuntimeException unexpectedToken() {
        return this.parseError("Unexpected token");
    }

    private boolean atEnd() {
        return this.i == this.ref.length();
    }

    private boolean at(char token) {
        if (!this.atEnd() && this.ref.charAt(this.i) == token) {
            ++this.i;
            return true;
        }
        return false;
    }

    public Declaration ref(String ref) {
        this.i = 0;
        this.ref = ref;
        String version2 = this.version();
        Declaration module = this.module(version2);
        return module;
    }

    private String version() {
        if (!this.at(':')) {
            return null;
        }
        char sentinal = this.ref.charAt(this.i);
        ++this.i;
        int start = this.i;
        while (this.i < this.ref.length()) {
            if (this.ref.charAt(this.i) == sentinal) {
                ++this.i;
                return this.ref.substring(start, this.i - 1);
            }
            ++this.i;
        }
        throw this.parseError("Unterminated version");
    }

    private Declaration module(String version2) {
        String moduleName = this.moduleName();
        if (moduleName == null || moduleName.isEmpty()) {
            throw this.parseError("Missing module name");
        }
        Module module = this.makeModule(moduleName, version2);
        if (this.atEnd()) {
            return module;
        }
        return this.package_(module);
    }

    private String moduleName() {
        return this.dottedIdent();
    }

    private boolean atIdent() {
        char ch;
        int start = this.i;
        while (this.i < this.ref.length() && (Character.isLetter(ch = this.ref.charAt(this.i)) || Character.isDigit(ch) || ch == '_')) {
            ++this.i;
        }
        return this.i > start;
    }

    private String ident() {
        int start = this.i;
        if (this.atIdent()) {
            return this.ref.substring(start, this.i);
        }
        return null;
    }

    private String dottedIdent() {
        int start = this.i;
        while (this.atIdent() && !this.atEnd() && this.at('.')) {
        }
        return this.ref.substring(start, this.i);
    }

    private Declaration package_(Module module) {
        String packageName;
        if (!this.at(':')) {
            throw this.parseError("Expecting a colon at start of package");
        }
        boolean expectColon = false;
        if (this.at(':')) {
            packageName = module.getName();
        } else if (this.at('.')) {
            packageName = this.packageName();
            expectColon = true;
        } else {
            String p = this.packageName();
            packageName = p.isEmpty() ? module.getName() : module.getName() + '.' + p;
            expectColon = true;
        }
        Package package_2 = this.makePackage(module, packageName);
        if (this.atEnd()) {
            return package_2;
        }
        if (expectColon && !this.at(':')) {
            throw this.parseError("Expecting a colon at end of package");
        }
        return this.declaration(package_2);
    }

    private String packageName() {
        return this.dottedIdent();
    }

    private Declaration declaration(Declaration packageOrType) {
        Declaration result = this.type(packageOrType);
        if (result == null) {
            result = this.function(packageOrType);
        }
        if (result == null) {
            result = this.value(packageOrType);
        }
        if (result == null) {
            result = this.constructor(packageOrType);
        }
        if (result == null) {
            throw this.parseError("Expected type or function or value");
        }
        return result;
    }

    private Declaration function(Declaration packageOrType) {
        if (!this.at('F')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            Declaration result = this.makeFunction(packageOrType, fn);
            if (this.at('.')) {
                result = this.typeParameter(result);
            }
            if (!this.atEnd()) {
                throw this.unexpectedToken();
            }
            return result;
        }
        throw this.unexpectedToken();
    }

    private Declaration value(Declaration packageOrType) {
        if (!this.at('V')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            return this.makeValue(packageOrType, fn);
        }
        throw this.unexpectedToken();
    }

    private Declaration constructor(Declaration packageOrType) {
        if (!this.at('c')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            return this.makeConstructor(packageOrType, fn);
        }
        throw this.unexpectedToken();
    }

    private Declaration type(Declaration packageOrType) {
        GenericDeclaration result = this.class_(packageOrType);
        if (result == null) {
            result = this.interface_(packageOrType);
        }
        if (result == null) {
            result = this.alias(packageOrType);
        }
        if (result != null && this.at('.')) {
            return this.tpOrMember((Declaration)((Object)result));
        }
        return result;
    }

    private Declaration tpOrMember(Declaration type) {
        Declaration result = this.typeParameter(type);
        if (result == null) {
            result = this.declaration(type);
        }
        return result;
    }

    private ClassOrInterfaceDeclaration class_(Declaration packageOrType) {
        if (!this.at('C')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            return this.makeClassOrInterface(packageOrType, fn);
        }
        throw this.unexpectedToken();
    }

    private ClassOrInterfaceDeclaration interface_(Declaration packageOrType) {
        if (!this.at('I')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            return this.makeClassOrInterface(packageOrType, fn);
        }
        throw this.unexpectedToken();
    }

    private AliasDeclaration alias(Declaration packageOrType) {
        if (!this.at('A')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            return this.makeAlias(packageOrType, fn);
        }
        throw this.unexpectedToken();
    }

    private TypeParameter typeParameter(Declaration packageOrType) {
        if (!this.at('P')) {
            return null;
        }
        String fn = this.ident();
        if (fn != null) {
            return this.makeTypeParameter(packageOrType, fn);
        }
        throw this.unexpectedToken();
    }

    private RuntimeException metamodelError(String msg) {
        return Metamodel.newModelError(msg);
    }

    private RuntimeException metamodelNotFound(String msg) {
        return Metamodel.newModelError(msg);
    }

    protected Module makeModule(String moduleName, String version2) {
        if (version2 == null) {
            throw this.metamodelError("Runtime versions not yet supported");
        }
        Module module = modules_.get_().find(moduleName, version2);
        if (module == null) {
            throw this.metamodelNotFound("Could not find module: " + moduleName + ", version: " + version2);
        }
        return module;
    }

    protected Package makePackage(Module module, String packageName) {
        Package package_2 = module.findPackage(packageName);
        if (package_2 == null) {
            throw this.metamodelNotFound("Could not find package: " + packageName + " of module: " + module.getName() + ", version: " + module.getVersion());
        }
        return package_2;
    }

    protected ClassOrInterfaceDeclaration makeClassOrInterface(Declaration packageOrType, String typeName) {
        ClassOrInterfaceDeclaration result;
        if (packageOrType instanceof Package) {
            result = (ClassOrInterfaceDeclaration)((Package)packageOrType).getMember(ClassOrInterfaceDeclaration.$TypeDescriptor$, typeName);
        } else if (packageOrType instanceof ClassOrInterfaceDeclaration) {
            result = (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)packageOrType).getMemberDeclaration(ClassOrInterfaceDeclaration.$TypeDescriptor$, typeName);
        } else {
            throw this.metamodelError("Unexpected container " + packageOrType.getClass() + " for type " + typeName);
        }
        if (result == null) {
            throw this.metamodelNotFound("Could not find type: " + typeName + " in " + packageOrType.getName());
        }
        return result;
    }

    protected AliasDeclaration makeAlias(Declaration packageOrType, String aliasName) {
        AliasDeclaration result;
        if (packageOrType instanceof Package) {
            result = ((Package)packageOrType).getAlias(aliasName);
        } else if (packageOrType instanceof ClassOrInterfaceDeclaration) {
            result = (AliasDeclaration)((ClassOrInterfaceDeclaration)packageOrType).getMemberDeclaration(AliasDeclaration.$TypeDescriptor$, aliasName);
        } else {
            throw this.metamodelError("Unexpected container " + packageOrType.getClass() + " for alias " + aliasName);
        }
        if (result == null) {
            throw this.metamodelNotFound("Could not find alias: " + aliasName + " in " + packageOrType.getName());
        }
        return result;
    }

    protected TypeParameter makeTypeParameter(Declaration packageOrType, String typeParameter) {
        TypeParameter result;
        if (packageOrType instanceof ClassOrInterfaceDeclaration) {
            result = ((ClassOrInterfaceDeclaration)packageOrType).getTypeParameterDeclaration(typeParameter);
        } else if (packageOrType instanceof FunctionDeclaration) {
            result = ((FunctionDeclaration)packageOrType).getTypeParameterDeclaration(typeParameter);
        } else if (packageOrType instanceof AliasDeclaration) {
            result = ((AliasDeclaration)packageOrType).getTypeParameterDeclaration(typeParameter);
        } else {
            throw this.metamodelError("Unexpected container " + packageOrType.getClass() + " for type parameter " + typeParameter);
        }
        if (result == null) {
            throw this.metamodelNotFound("Could not find alias: " + typeParameter + " in " + packageOrType.getName());
        }
        return result;
    }

    protected FunctionDeclaration makeFunction(Declaration packageOrType, String fn) {
        FunctionDeclaration result;
        if (packageOrType instanceof Package) {
            result = ((Package)packageOrType).getFunction(fn);
        } else if (packageOrType instanceof ClassOrInterfaceDeclaration) {
            result = (FunctionDeclaration)((ClassOrInterfaceDeclaration)packageOrType).getMemberDeclaration(FunctionDeclaration.$TypeDescriptor$, fn);
        } else {
            throw this.metamodelError("Unexpected container " + packageOrType.getClass() + " for function " + fn);
        }
        if (result == null) {
            throw this.metamodelNotFound("Could not find function: " + fn + " in " + packageOrType.getName());
        }
        return result;
    }

    protected ValueDeclaration makeValue(Declaration packageOrType, String val) {
        ValueDeclaration result;
        if (packageOrType instanceof Package) {
            result = ((Package)packageOrType).getValue(val);
        } else if (packageOrType instanceof ClassOrInterfaceDeclaration) {
            result = (ValueDeclaration)((ClassOrInterfaceDeclaration)packageOrType).getMemberDeclaration(ValueDeclaration.$TypeDescriptor$, val);
        } else {
            throw this.metamodelError("Unexpected container " + packageOrType.getClass() + " for value " + val);
        }
        if (result == null) {
            throw this.metamodelNotFound("Could not find value: " + val + " in " + packageOrType.getName());
        }
        return result;
    }

    protected Declaration makeConstructor(Declaration packageOrType, String val) {
        if (!(packageOrType instanceof ClassDeclaration)) {
            throw this.metamodelError("Unexpected container " + packageOrType.getClass() + " for value " + val);
        }
        Declaration result = (Declaration)((ClassDeclaration)packageOrType).getConstructorDeclaration(val);
        if (result == null) {
            throw this.metamodelNotFound("Could not find value: " + val + " in " + packageOrType.getName());
        }
        return result;
    }
}

