/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel.decl;

import ceylon.language.Anything;
import ceylon.language.Empty;
import ceylon.language.Sequential;
import ceylon.language.empty_;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionDeclaration;
import ceylon.language.meta.declaration.NestableDeclaration;
import ceylon.language.meta.declaration.OpenClassType;
import ceylon.language.meta.declaration.OpenInterfaceType;
import ceylon.language.meta.declaration.OpenType;
import ceylon.language.meta.declaration.TypeParameter;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.ClassOrInterface;
import ceylon.language.meta.model.Member;
import ceylon.language.meta.model.Type;
import ceylon.language.meta.model.TypeApplicationException;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.ObjectArrayIterable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Sequenced;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.AnnotationBearing;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Predicates;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.FunctionDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.NestableDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ValueDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberClassImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberInterfaceImpl;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Ceylon(major=8)
@Class
public abstract class ClassOrInterfaceDeclarationImpl
extends NestableDeclarationImpl
implements ClassOrInterfaceDeclaration,
AnnotationBearing {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ClassOrInterfaceDeclarationImpl.class, new TypeDescriptor[0]);
    @Ignore
    private static final TypeDescriptor $FunctionTypeDescriptor = TypeDescriptor.klass(FunctionDeclaration.class, Anything.$TypeDescriptor$, Empty.$TypeDescriptor$);
    @Ignore
    private static final TypeDescriptor $AttributeTypeDescriptor = TypeDescriptor.klass(ValueDeclaration.class, Anything.$TypeDescriptor$);
    @Ignore
    private static final TypeDescriptor $ClassOrInterfaceTypeDescriptor = TypeDescriptor.klass(ClassOrInterfaceDeclaration.class, Anything.$TypeDescriptor$);
    private volatile boolean initialised = false;
    private OpenClassType superclass;
    private Sequential<OpenInterfaceType> interfaces;
    private Sequential<? extends TypeParameter> typeParameters;
    private List<NestableDeclaration> declaredDeclarations;
    private List<NestableDeclaration> declarations;
    private Sequential<? extends OpenType> caseTypes;

    public ClassOrInterfaceDeclarationImpl(com.redhat.ceylon.model.typechecker.model.ClassOrInterface declaration) {
        super(declaration);
    }

    protected void init() {
        com.redhat.ceylon.model.typechecker.model.ClassOrInterface declaration = (com.redhat.ceylon.model.typechecker.model.ClassOrInterface)this.declaration;
        com.redhat.ceylon.model.typechecker.model.Type superType = declaration.getExtendedType();
        if (superType != null) {
            this.superclass = (OpenClassType)Metamodel.getMetamodel(superType);
        }
        List<com.redhat.ceylon.model.typechecker.model.Type> satisfiedTypes = declaration.getSatisfiedTypes();
        OpenInterfaceType[] interfaces = new OpenInterfaceType[satisfiedTypes.size()];
        int i = 0;
        for (com.redhat.ceylon.model.typechecker.model.Type type : satisfiedTypes) {
            interfaces[i++] = (OpenInterfaceType)Metamodel.getMetamodel(type);
        }
        this.interfaces = Util.sequentialWrapper(OpenInterfaceType.$TypeDescriptor$, interfaces);
        this.caseTypes = declaration.getCaseTypes() != null ? Metamodel.getMetamodelSequential(declaration.getCaseTypes()) : empty_.get_();
        this.typeParameters = Metamodel.getTypeParameters(declaration);
        List<Declaration> memberModelDeclarations = declaration.getMembers();
        this.declaredDeclarations = new LinkedList<NestableDeclaration>();
        for (Declaration memberModelDeclaration : memberModelDeclarations) {
            ClassOrInterfaceDeclarationImpl.addDeclarationTo(memberModelDeclaration, this.declaredDeclarations);
        }
        Collection<Declaration> collection = this.collectMembers(declaration);
        this.declarations = new LinkedList<NestableDeclaration>();
        for (Declaration memberModelDeclaration : collection) {
            ClassOrInterfaceDeclarationImpl.addDeclarationTo(memberModelDeclaration, this.declarations);
        }
    }

    protected static void addDeclarationTo(Declaration memberModelDeclaration, List<NestableDeclaration> declaredDeclarations) {
        Setter setter;
        if (ClassOrInterfaceDeclarationImpl.isSupportedType(memberModelDeclaration)) {
            declaredDeclarations.add((NestableDeclaration)Metamodel.getOrCreateMetamodel(memberModelDeclaration));
        }
        if (memberModelDeclaration instanceof Value && (setter = ((Value)memberModelDeclaration).getSetter()) != null) {
            declaredDeclarations.add((NestableDeclaration)Metamodel.getOrCreateMetamodel(setter));
        }
    }

    private static boolean isSupportedType(Declaration memberModelDeclaration) {
        return memberModelDeclaration instanceof Value || memberModelDeclaration instanceof Function && !((Function)memberModelDeclaration).isAbstraction() || memberModelDeclaration instanceof TypeAlias || memberModelDeclaration instanceof Interface || memberModelDeclaration instanceof com.redhat.ceylon.model.typechecker.model.Class && !((com.redhat.ceylon.model.typechecker.model.Class)memberModelDeclaration).isAbstraction();
    }

    private Collection<Declaration> collectMembers(TypeDeclaration base) {
        HashMap<String, Declaration> byName = new HashMap<String, Declaration>();
        this.collectMembers(base, byName);
        return byName.values();
    }

    private void collectMembers(TypeDeclaration base, Map<String, Declaration> byName) {
        for (Declaration decl : base.getMembers()) {
            Declaration otherDeclaration;
            if (!decl.isShared() || !ModelUtil.isResolvable(decl) || (otherDeclaration = byName.get(decl.getName())) != null && !decl.refines(otherDeclaration)) continue;
            byName.put(decl.getName(), decl);
        }
        com.redhat.ceylon.model.typechecker.model.Type et = base.getExtendedType();
        if (et != null) {
            this.collectMembers(et.getDeclaration(), byName);
        }
        for (com.redhat.ceylon.model.typechecker.model.Type st : base.getSatisfiedTypes()) {
            if (st == null) continue;
            this.collectMembers(st.getDeclaration(), byName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkInit() {
        if (!this.initialised) {
            Object object = Metamodel.getLock();
            synchronized (object) {
                if (!this.initialised) {
                    this.init();
                    this.initialised = true;
                }
            }
        }
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Kind>")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Kind", satisfies={"ceylon.language.meta.declaration::NestableDeclaration"})})
    public <Kind extends NestableDeclaration> Sequential<? extends Kind> memberDeclarations(@Ignore TypeDescriptor $reifiedKind) {
        Predicates.Predicate<Declaration> predicate = Predicates.isDeclarationOfKind($reifiedKind);
        return this.filteredMembers($reifiedKind, predicate);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Kind>")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Kind", satisfies={"ceylon.language.meta.declaration::NestableDeclaration"})})
    public <Kind extends NestableDeclaration> Sequential<? extends Kind> declaredMemberDeclarations(@Ignore TypeDescriptor $reifiedKind) {
        Predicates.Predicate<Declaration> predicate = Predicates.isDeclarationOfKind($reifiedKind);
        return this.filteredDeclaredMembers($reifiedKind, predicate);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Kind>")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Kind", satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}), @com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Annotation", satisfies={"ceylon.language::Annotation"})})
    public <Kind extends NestableDeclaration, Annotation extends Annotation> Sequential<? extends Kind> annotatedMemberDeclarations(@Ignore TypeDescriptor $reifiedKind, @Ignore TypeDescriptor $reifiedAnnotation) {
        Predicates.Predicate predicate = Predicates.and(Predicates.isDeclarationOfKind($reifiedKind), Predicates.isDeclarationAnnotatedWith($reifiedAnnotation));
        return this.filteredMembers($reifiedKind, predicate);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Kind>")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Kind", satisfies={"ceylon.language.meta.declaration::NestableDeclaration"}), @com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Annotation", satisfies={"ceylon.language::Annotation"})})
    public <Kind extends NestableDeclaration, Annotation extends Annotation> Sequential<? extends Kind> annotatedDeclaredMemberDeclarations(@Ignore TypeDescriptor $reifiedKind, @Ignore TypeDescriptor $reifiedAnnotation) {
        Predicates.Predicate predicate = Predicates.and(Predicates.isDeclarationOfKind($reifiedKind), Predicates.isDeclarationAnnotatedWith($reifiedAnnotation));
        return this.filteredDeclaredMembers($reifiedKind, predicate);
    }

    private <Kind> Sequential<? extends Kind> filteredMembers(@Ignore TypeDescriptor $reifiedKind, Predicates.Predicate predicate) {
        if (predicate == Predicates.false_()) {
            return empty_.get_();
        }
        this.checkInit();
        ArrayList<NestableDeclaration> members = new ArrayList<NestableDeclaration>(this.declarations.size());
        for (NestableDeclaration decl : this.declarations) {
            Declaration declaration2 = ((NestableDeclarationImpl)decl).declaration;
            if (declaration2.isNativeHeader() || !predicate.accept(declaration2)) continue;
            members.add(decl);
        }
        Object[] array = members.toArray(new Object[0]);
        ObjectArrayIterable iterable = new ObjectArrayIterable($reifiedKind, array);
        return iterable.sequence();
    }

    private <Kind> Sequential<? extends Kind> filteredDeclaredMembers(@Ignore TypeDescriptor $reifiedKind, Predicates.Predicate predicate) {
        if (predicate == Predicates.false_()) {
            return empty_.get_();
        }
        this.checkInit();
        ArrayList<NestableDeclaration> members = new ArrayList<NestableDeclaration>(this.declarations.size());
        for (NestableDeclaration decl : this.declaredDeclarations) {
            Declaration declaration2 = ((NestableDeclarationImpl)decl).declaration;
            if (declaration2.isNativeHeader() || !predicate.accept(declaration2)) continue;
            members.add(decl);
        }
        Object[] array = members.toArray(new Object[0]);
        ObjectArrayIterable iterable = new ObjectArrayIterable($reifiedKind, array);
        return iterable.sequence();
    }

    private <Kind> Kind filteredMember(@Ignore TypeDescriptor $reifiedKind, Predicates.Predicate predicate) {
        if (predicate == Predicates.false_()) {
            return null;
        }
        this.checkInit();
        for (NestableDeclaration decl : this.declarations) {
            Declaration declaration2 = ((NestableDeclarationImpl)decl).declaration;
            if (declaration2.isNativeHeader() || !predicate.accept(declaration2)) continue;
            return (Kind)decl;
        }
        return null;
    }

    private <Kind> Kind filteredDeclaredMember(@Ignore TypeDescriptor $reifiedKind, Predicates.Predicate predicate) {
        if (predicate == Predicates.false_()) {
            return null;
        }
        this.checkInit();
        for (NestableDeclaration decl : this.declaredDeclarations) {
            Declaration declaration2 = ((NestableDeclarationImpl)decl).declaration;
            if (declaration2.isNativeHeader() || !predicate.accept(declaration2)) continue;
            return (Kind)decl;
        }
        return null;
    }

    @Override
    @TypeInfo(value="Kind")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Kind", satisfies={"ceylon.language.meta.declaration::NestableDeclaration"})})
    public <Kind extends NestableDeclaration> Kind getMemberDeclaration(@Ignore TypeDescriptor $reifiedKind, @Name(value="name") String name) {
        Predicates.Predicate predicate = Predicates.and(Predicates.isDeclarationNamed(name), Predicates.isDeclarationOfKind($reifiedKind));
        return (Kind)((NestableDeclaration)this.filteredMember($reifiedKind, predicate));
    }

    @Override
    @TypeInfo(value="Kind")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Kind", satisfies={"ceylon.language.meta.declaration::NestableDeclaration"})})
    public <Kind extends NestableDeclaration> Kind getDeclaredMemberDeclaration(@Ignore TypeDescriptor $reifiedKind, @Name(value="name") String name) {
        Predicates.Predicate predicate = Predicates.and(Predicates.isDeclarationNamed(name), Predicates.isDeclarationOfKind($reifiedKind));
        return (Kind)((NestableDeclaration)this.filteredDeclaredMember($reifiedKind, predicate));
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::OpenInterfaceType>")
    public Sequential<? extends OpenInterfaceType> getSatisfiedTypes() {
        this.checkInit();
        return this.interfaces;
    }

    @Override
    @TypeInfo(value="ceylon.language.meta.declaration::OpenClassType|ceylon.language::Null")
    public OpenClassType getExtendedType() {
        this.checkInit();
        return this.superclass;
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::OpenType>")
    public Sequential<? extends OpenType> getCaseTypes() {
        this.checkInit();
        return this.caseTypes;
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::TypeParameter>")
    public Sequential<? extends TypeParameter> getTypeParameterDeclarations() {
        this.checkInit();
        return this.typeParameters;
    }

    @Override
    public boolean getIsAlias() {
        return ((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)this.declaration).isAlias();
    }

    @Override
    public OpenType getOpenType() {
        return Metamodel.getMetamodel(((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)this.declaration).getType());
    }

    @Override
    @TypeInfo(value="ceylon.language.meta.declaration::TypeParameter|ceylon.language::Null")
    public TypeParameter getTypeParameterDeclaration(@Name(value="name") String name) {
        return Metamodel.findDeclarationByName(this.getTypeParameterDeclarations(), name);
    }

    @Ignore
    public <Type> ClassOrInterface<Type> apply(@Ignore TypeDescriptor $reifiedType) {
        return this.apply($reifiedType, empty_.get_());
    }

    @TypeInfo(value="ceylon.language.meta.model::ClassOrInterface<Type>")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Type")})
    public <Type> ClassOrInterface<Type> apply(@Ignore TypeDescriptor $reifiedType, @Name(value="typeArguments") @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.model::Type<ceylon.language::Anything>>") @Sequenced Sequential<? extends Type<?>> typeArguments) {
        if (!this.getToplevel()) {
            throw new TypeApplicationException("Cannot apply a member declaration with no container type: use memberApply");
        }
        List<com.redhat.ceylon.model.typechecker.model.Type> producedTypes = Metamodel.getProducedTypes(typeArguments);
        Metamodel.checkTypeArguments(null, this.declaration, producedTypes);
        Reference appliedType = this.declaration.appliedReference(null, producedTypes);
        Metamodel.checkReifiedTypeArgument("apply", "ClassOrInterface<$1>", Variance.OUT, appliedType.getType(), $reifiedType);
        return (ClassOrInterface)Metamodel.getAppliedMetamodel(appliedType.getType());
    }

    @Override
    @Ignore
    public <Container, Type> Object memberApply(TypeDescriptor $reifiedContainer, TypeDescriptor $reifiedType, Type<? extends Object> containerType) {
        return this.memberApply($reifiedContainer, $reifiedType, containerType, empty_.get_());
    }

    @TypeInfo(value="ceylon.language.meta.model::Member<Container,ceylon.language.meta.model::ClassOrInterface<Type>>&ceylon.language.meta.model::ClassOrInterface<Type>")
    @TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Container"), @com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Type")})
    public <Container, Type> Object memberApply(@Ignore TypeDescriptor $reifiedContainer, @Ignore TypeDescriptor $reifiedType, @Name(value="containerType") Type<? extends Object> containerType, @Name(value="typeArguments") @Sequenced Sequential<? extends Type<?>> typeArguments) {
        if (this.getToplevel()) {
            throw new TypeApplicationException("Cannot apply a toplevel declaration to a container type: use apply");
        }
        Member member = this.getAppliedClassOrInterface(null, null, typeArguments, containerType);
        TypeDescriptor actualReifiedContainer = member instanceof MemberClassImpl ? ((MemberClassImpl)member).$reifiedContainer : ((MemberInterfaceImpl)member).$reifiedContainer;
        com.redhat.ceylon.model.typechecker.model.Type actualType = Metamodel.getModel((Type)((Object)member));
        Metamodel.checkReifiedTypeArgument("memberApply", "Member<$1,ClassOrInterface<$2>>&ClassOrInterface<$2>", Variance.IN, Metamodel.getProducedType(actualReifiedContainer), $reifiedContainer, Variance.OUT, actualType, $reifiedType);
        return member;
    }

    public <Container, Kind extends ClassOrInterface<? extends Object>> Member<Container, Kind> getAppliedClassOrInterface(@Ignore TypeDescriptor $reifiedContainer, @Ignore TypeDescriptor $reifiedKind, Sequential<? extends Type<?>> types, Type<? extends Object> container) {
        List<com.redhat.ceylon.model.typechecker.model.Type> producedTypes = Metamodel.getProducedTypes(types);
        com.redhat.ceylon.model.typechecker.model.Type qualifyingType = Metamodel.getModel(container);
        if (this.getStatic()) {
            producedTypes.addAll(0, qualifyingType.getTypeArgumentList());
        }
        Metamodel.checkQualifyingType(qualifyingType, this.declaration);
        Metamodel.checkTypeArguments(qualifyingType, this.declaration, producedTypes);
        com.redhat.ceylon.model.typechecker.model.Type memberQualifyingType = qualifyingType.getSupertype((TypeDeclaration)this.declaration.getContainer());
        Reference producedReference = this.declaration.appliedReference(memberQualifyingType, producedTypes);
        com.redhat.ceylon.model.typechecker.model.Type appliedType = producedReference.getType();
        return (Member)((Object)Metamodel.getAppliedMetamodel(appliedType));
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    public FunctionDeclarationImpl findMethod(String name) {
        Object decl = this.findDeclaration(null, name);
        return decl instanceof FunctionDeclarationImpl ? (FunctionDeclarationImpl)decl : null;
    }

    public FunctionDeclarationImpl findDeclaredMethod(String name) {
        Object decl = this.findDeclaredDeclaration(null, name);
        return decl instanceof FunctionDeclarationImpl ? (FunctionDeclarationImpl)decl : null;
    }

    public ValueDeclarationImpl findValue(String name) {
        Object decl = this.findDeclaration(null, name);
        return decl instanceof ValueDeclarationImpl ? (ValueDeclarationImpl)decl : null;
    }

    public ValueDeclarationImpl findDeclaredValue(String name) {
        Object decl = this.findDeclaredDeclaration(null, name);
        return decl instanceof ValueDeclarationImpl ? (ValueDeclarationImpl)decl : null;
    }

    public ClassOrInterfaceDeclarationImpl findType(String name) {
        Object decl = this.findDeclaration(null, name);
        return decl instanceof ClassOrInterfaceDeclarationImpl ? (ClassOrInterfaceDeclarationImpl)decl : null;
    }

    public ClassOrInterfaceDeclarationImpl findDeclaredType(String name) {
        Object decl = this.findDeclaredDeclaration(null, name);
        return decl instanceof ClassOrInterfaceDeclarationImpl ? (ClassOrInterfaceDeclarationImpl)decl : null;
    }

    public <T extends NestableDeclarationImpl> T findDeclaration(@Ignore TypeDescriptor $reifiedT, String name) {
        this.checkInit();
        return this.findDeclaration($reifiedT, name, this.declarations);
    }

    public <T extends NestableDeclarationImpl> T findDeclaredDeclaration(@Ignore TypeDescriptor $reifiedT, String name) {
        this.checkInit();
        return this.findDeclaration($reifiedT, name, this.declaredDeclarations);
    }

    <T extends NestableDeclarationImpl> T findDeclaration(@Ignore TypeDescriptor $reifiedT, String name, List<NestableDeclaration> declarations) {
        for (NestableDeclaration decl : declarations) {
            if (decl instanceof ClassDeclaration && ((ClassDeclaration)decl).getAnonymous() || !name.equals(decl.getName())) continue;
            return (T)((NestableDeclarationImpl)decl);
        }
        return null;
    }

    @Override
    @Ignore
    public Annotation[] $getJavaAnnotations$() {
        return Metamodel.getJavaClass(this.declaration).getAnnotations();
    }

    @Override
    @Ignore
    public boolean $isAnnotated$(java.lang.Class<? extends Annotation> annotationType) {
        java.lang.Class<?> element = Metamodel.getJavaClass(this.declaration);
        return element != null ? element.isAnnotationPresent(annotationType) : false;
    }

    @Override
    public <AnnotationType extends Annotation> boolean annotated(TypeDescriptor reifed$AnnotationType) {
        return Metamodel.isAnnotated(reifed$AnnotationType, this);
    }

    public java.lang.Class<?> getJavaClass() {
        return Metamodel.getJavaClass(this.declaration);
    }
}

