/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel.meta;

import ceylon.language.Array;
import ceylon.language.Basic;
import ceylon.language.Entry;
import ceylon.language.Identifiable;
import ceylon.language.Iterable;
import ceylon.language.Map;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.empty_;
import ceylon.language.meta.declaration.FunctionDeclaration;
import ceylon.language.meta.declaration.TypeParameter;
import ceylon.language.meta.model.Type;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Sequenced;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.DefaultValueProvider;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.MethodHandleUtil;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.FunctionDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

@Ceylon(major=8)
@Class
@TypeParameters(value={@com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Type", variance=Variance.OUT), @com.redhat.ceylon.compiler.java.metadata.TypeParameter(value="Arguments", variance=Variance.IN, satisfies={"ceylon.language::Sequential<ceylon.language::Anything>"})})
public class FunctionImpl<Type, Arguments extends Sequential<? extends java.lang.Object>>
implements ceylon.language.meta.model.Function<Type, Arguments>,
ReifiedType,
DefaultValueProvider {
    @Ignore
    private final TypeDescriptor $reifiedType;
    @Ignore
    private final TypeDescriptor $reifiedArguments;
    private Type<? extends Type> type;
    protected final FunctionDeclarationImpl declaration;
    private MethodHandle method;
    private MethodHandle[] dispatch;
    private int firstDefaulted = -1;
    private int variadicIndex = -1;
    private Map<? extends TypeParameter, ? extends Type<?>> typeArguments;
    private Map<? extends TypeParameter, ? extends Sequence<? extends java.lang.Object>> typeArgumentWithVariances;
    private java.lang.Object instance;
    private Type<?> container;
    private List<com.redhat.ceylon.model.typechecker.model.Type> parameterProducedTypes;
    private Sequential<? extends Type<? extends java.lang.Object>> parameterTypes;
    private Reference appliedFunction;

    public FunctionImpl(@Ignore TypeDescriptor $reifiedType, @Ignore TypeDescriptor $reifiedArguments, Reference appliedFunction, FunctionDeclarationImpl function, Type<?> container, java.lang.Object instance) {
        this.$reifiedType = $reifiedType;
        this.$reifiedArguments = $reifiedArguments;
        this.container = container;
        this.instance = instance;
        this.appliedFunction = appliedFunction;
        Functional decl = (Functional)((java.lang.Object)function.declaration);
        List<Parameter> parameters = decl.getFirstParameterList().getParameters();
        this.firstDefaulted = Metamodel.getFirstDefaultedParameter(parameters);
        this.variadicIndex = Metamodel.getVariadicParameter(parameters);
        Method[] defaultedMethods = null;
        if (this.firstDefaulted != -1) {
            this.dispatch = new MethodHandle[parameters.size() + 1 - this.firstDefaulted];
            defaultedMethods = new Method[this.dispatch.length];
        }
        this.type = Metamodel.getAppliedMetamodel(Metamodel.getFunctionReturnType(appliedFunction));
        this.declaration = function;
        this.typeArguments = Metamodel.getTypeArguments(this.declaration, appliedFunction);
        this.typeArgumentWithVariances = Metamodel.getTypeArgumentWithVariances(this.declaration, appliedFunction);
        this.parameterProducedTypes = Metamodel.getParameterProducedTypes(parameters, appliedFunction);
        this.parameterTypes = Metamodel.getAppliedMetamodelSequential(this.parameterProducedTypes);
        java.lang.Class<?> javaClass = Metamodel.getJavaClass(function.declaration);
        Method found = null;
        String name = Metamodel.getJavaMethodName((Functional)((java.lang.Object)function.declaration));
        if (javaClass == Object.class || javaClass == Basic.class || javaClass == Identifiable.class) {
            if ("equals".equals(name)) {
                try {
                    found = java.lang.Object.class.getDeclaredMethod("equals", java.lang.Object.class);
                }
                catch (NoSuchMethodException e) {
                    throw Metamodel.newModelError("Missing equals method in ceylon.language::Object");
                }
                catch (SecurityException e) {
                    throw Metamodel.newModelError("Security exception getting equals method in ceylon.language::Object");
                }
            }
            throw Metamodel.newModelError("Object/Basic/Identifiable member not supported: " + decl.getName());
        }
        if (javaClass == ceylon.language.Throwable.class) {
            if ("printStackTrace".equals(name)) {
                try {
                    found = Throwable.class.getDeclaredMethod("printStackTrace", new java.lang.Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw Metamodel.newModelError("Missing printStackTrace method in ceylon.language::Throwable");
                }
                catch (SecurityException e) {
                    throw Metamodel.newModelError("Security exception getting printStackTrace method in ceylon.language::Throwable");
                }
            }
            if ("addSuppressed".equals(name)) {
                try {
                    found = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    throw Metamodel.newModelError("Missing addSuppressed method in ceylon.language::Throwable");
                }
                catch (SecurityException e) {
                    throw Metamodel.newModelError("Security exception getting addSuppressed method in ceylon.language::Throwable");
                }
            }
        } else {
            found = Metamodel.getJavaMethod((Function)function.declaration);
            int reifiedTypeParameterCount = MethodHandleUtil.isReifiedTypeSupported(found, false) ? found.getTypeParameters().length : 0;
            boolean isArray = MethodHandleUtil.isJavaArray(javaClass);
            for (Method method : javaClass.getDeclaredMethods()) {
                if (!method.getName().equals(name) || method.isBridge() || method.isSynthetic() || isArray && Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(Ignore.class) || this.firstDefaulted == -1) continue;
                int params = method.getParameterTypes().length - reifiedTypeParameterCount;
                defaultedMethods[params - this.firstDefaulted] = method;
            }
        }
        if (found != null) {
            boolean variadic = found.isVarArgs();
            this.method = this.reflectionToMethodHandle(found, javaClass, instance, appliedFunction, this.parameterProducedTypes, variadic, false);
            if (defaultedMethods != null && !variadic) {
                for (int i = 0; i < defaultedMethods.length - 1; ++i) {
                    if (defaultedMethods[i] == null) {
                        throw Metamodel.newModelError("Missing defaulted method " + found.getName() + " with " + (i + this.firstDefaulted) + " parameters in " + found.getDeclaringClass());
                    }
                    this.dispatch[i] = this.reflectionToMethodHandle(defaultedMethods[i], javaClass, instance, appliedFunction, this.parameterProducedTypes, variadic, false);
                }
                this.dispatch[i] = this.method;
            } else if (variadic) {
                this.dispatch[0] = this.reflectionToMethodHandle(found, javaClass, instance, appliedFunction, this.parameterProducedTypes, variadic, true);
                this.dispatch[1] = this.method;
            }
        }
    }

    private MethodHandle reflectionToMethodHandle(Method foundMethod, java.lang.Class<?> javaClass, java.lang.Object instance, Reference appliedFunction, List<com.redhat.ceylon.model.typechecker.model.Type> parameterProducedTypes, boolean variadic, boolean bindVariadicParameterToEmptyArray) {
        MethodHandle method = null;
        int skipParameters = 0;
        Function functionModel = (Function)appliedFunction.getDeclaration();
        java.lang.Class<?>[] parameterTypes = foundMethod.getParameterTypes();
        java.lang.Class<?> returnType = foundMethod.getReturnType();
        int mods = foundMethod.getModifiers();
        boolean isJavaArray = MethodHandleUtil.isJavaArray(javaClass);
        int typeParametersCount = foundMethod.getTypeParameters().length;
        try {
            if (isJavaArray) {
                if (foundMethod.getName().equals("get")) {
                    method = MethodHandleUtil.getJavaArrayGetterMethodHandle(javaClass);
                } else if (foundMethod.getName().equals("set")) {
                    method = MethodHandleUtil.getJavaArraySetterMethodHandle(javaClass);
                } else if (foundMethod.getName().equals("copyTo")) {
                    foundMethod = MethodHandleUtil.getJavaArrayCopyToMethod(javaClass, foundMethod);
                } else if (foundMethod.getName().equals("from")) {
                    foundMethod = MethodHandleUtil.getJavaArrayFromMethod(javaClass, foundMethod);
                }
            }
            if (method == null) {
                foundMethod.setAccessible(true);
                method = MethodHandles.lookup().unreflect(foundMethod);
            }
        }
        catch (IllegalAccessException e) {
            throw Metamodel.newModelError("Problem getting a MH for constructor for: " + javaClass, e);
        }
        List<com.redhat.ceylon.model.typechecker.model.TypeParameter> reifiedTypeParameters = functionModel.getTypeParameters();
        if (functionModel.isStatic()) {
            reifiedTypeParameters = new ArrayList<com.redhat.ceylon.model.typechecker.model.TypeParameter>();
            reifiedTypeParameters.addAll(((ClassOrInterface)functionModel.getContainer()).getTypeParameters());
            reifiedTypeParameters.addAll(functionModel.getTypeParameters());
        } else {
            reifiedTypeParameters = functionModel.getTypeParameters();
        }
        method = MethodHandleUtil.boxReturnValue(method, returnType, appliedFunction.getType());
        if (instance != null && (isJavaArray || !Modifier.isStatic(mods))) {
            method = method.bindTo(instance);
        }
        method = method.asType(MethodType.methodType(java.lang.Object.class, parameterTypes));
        if (typeParametersCount != 0 && MethodHandleUtil.isReifiedTypeSupported(foundMethod, false)) {
            ArrayList<com.redhat.ceylon.model.typechecker.model.Type> typeArguments = new ArrayList<com.redhat.ceylon.model.typechecker.model.Type>();
            java.util.Map<com.redhat.ceylon.model.typechecker.model.TypeParameter, com.redhat.ceylon.model.typechecker.model.Type> typeArgumentMap = appliedFunction.getTypeArguments();
            for (com.redhat.ceylon.model.typechecker.model.TypeParameter tp : reifiedTypeParameters) {
                typeArguments.add(typeArgumentMap.get(tp));
            }
            method = MethodHandleUtil.insertReifiedTypeArguments(method, 0, typeArguments);
            skipParameters += typeParametersCount;
        }
        method = MethodHandleUtil.unboxArguments(method, skipParameters, 0, parameterTypes, parameterProducedTypes, variadic, bindVariadicParameterToEmptyArray);
        return method;
    }

    @Override
    public FunctionDeclaration getDeclaration() {
        return this.declaration;
    }

    @TypeInfo(value="ceylon.language::Map<ceylon.language.meta.declaration::TypeParameter,ceylon.language.meta.model::Type<ceylon.language::Anything>>")
    public Map<? extends TypeParameter, ? extends Type<?>> getTypeArguments() {
        return this.typeArguments;
    }

    public Sequential<? extends Type<?>> getTypeArgumentList() {
        return Metamodel.getTypeArgumentList(this);
    }

    @Override
    @TypeInfo(value="ceylon.language::Map<ceylon.language.meta.declaration::TypeParameter,[ceylon.language.meta.model::Type<ceylon.language::Anything>,ceylon.language.meta.declaration::Variance]>")
    public Map<? extends TypeParameter, ? extends Sequence<? extends java.lang.Object>> getTypeArgumentWithVariances() {
        return this.typeArgumentWithVariances;
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<[ceylon.language.meta.model::Type<ceylon.language::Anything>,ceylon.language.meta.declaration::Variance]>")
    public Sequential<? extends Sequence<? extends java.lang.Object>> getTypeArgumentWithVarianceList() {
        return Metamodel.getTypeArgumentWithVarianceList(this);
    }

    private void checkMethod() {
        if (this.method == null) {
            throw Metamodel.newModelError("No method found for: " + this.declaration.getName());
        }
    }

    @Override
    @Ignore
    public Type $call$() {
        this.checkMethod();
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.method.invokeExact();
            }
            return (Type)this.dispatch[0].invokeExact();
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    @Ignore
    public Type $call$(java.lang.Object arg0) {
        this.checkMethod();
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.method.invokeExact(arg0);
            }
            return (Type)this.dispatch[1 - this.firstDefaulted].invokeExact(arg0);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    @Ignore
    public Type $call$(java.lang.Object arg0, java.lang.Object arg1) {
        this.checkMethod();
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.method.invokeExact(arg0, arg1);
            }
            return (Type)this.dispatch[2 - this.firstDefaulted].invokeExact(arg0, arg1);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    @Ignore
    public Type $call$(java.lang.Object arg0, java.lang.Object arg1, java.lang.Object arg2) {
        this.checkMethod();
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.method.invokeExact(arg0, arg1, arg2);
            }
            return (Type)this.dispatch[3 - this.firstDefaulted].invokeExact(arg0, arg1, arg2);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    @Ignore
    public Type $call$(java.lang.Object ... args) {
        this.checkMethod();
        try {
            if (this.firstDefaulted == -1) {
                return (Type)this.method.invokeWithArguments(args);
            }
            return (Type)this.dispatch[args.length - this.firstDefaulted].invokeWithArguments(args);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    @Ignore
    public short $getVariadicParameterIndex$() {
        return (short)this.variadicIndex;
    }

    @Override
    @TypeInfo(value="ceylon.language.meta.model::Type<Type>")
    public Type<? extends Type> getType() {
        return this.type;
    }

    @Override
    @Ignore
    public Type $callvariadic$() {
        return this.$call$();
    }

    @Override
    @Ignore
    public Type $callvariadic$(Sequential<?> varargs) {
        return this.$call$((java.lang.Object)varargs);
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object arg0, Sequential<?> varargs) {
        return this.$call$(arg0, (java.lang.Object)varargs);
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object arg0, java.lang.Object arg1, Sequential<?> varargs) {
        return this.$call$(arg0, arg1, (java.lang.Object)varargs);
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object arg0, java.lang.Object arg1, java.lang.Object arg2, Sequential<?> varargs) {
        return this.$call$(arg0, arg1, arg2, varargs);
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object ... argsAndVarargs) {
        return this.$call$(argsAndVarargs);
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object arg0) {
        return this.$call$(arg0, (java.lang.Object)empty_.get_());
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object arg0, java.lang.Object arg1) {
        return this.$call$(arg0, arg1, (java.lang.Object)empty_.get_());
    }

    @Override
    @Ignore
    public Type $callvariadic$(java.lang.Object arg0, java.lang.Object arg1, java.lang.Object arg2) {
        return this.$call$(arg0, arg1, arg2, empty_.get_());
    }

    @Override
    @Ignore
    public Type apply() {
        return this.apply((Sequential<?>)empty_.get_());
    }

    @Override
    public Type apply(@Name(value="arguments") @Sequenced @TypeInfo(value="ceylon.language::Sequential<ceylon.language::Anything>") Sequential<?> arguments) {
        return (Type)Metamodel.apply(this, arguments, this.parameterProducedTypes, this.firstDefaulted, this.variadicIndex);
    }

    @Override
    public Type namedApply(@Name(value="arguments") @TypeInfo(value="ceylon.language::Iterable<ceylon.language::Entry<ceylon.language::String,ceylon.language::Anything>,ceylon.language::Null>") Iterable<? extends Entry<? extends ceylon.language.String, ? extends java.lang.Object>, ? extends java.lang.Object> arguments) {
        return (Type)Metamodel.namedApply(this, this, (Functional)((java.lang.Object)this.declaration.declaration), arguments, this.parameterProducedTypes);
    }

    @Override
    public java.lang.Object getDefaultParameterValue(Parameter parameter, Array<java.lang.Object> values, int collectedValueCount) {
        java.lang.Class<?> javaClass = Metamodel.getJavaClass(this.declaration.declaration);
        String name = this.declaration.getName() + "$" + parameter.getName();
        Method found = null;
        for (Method m : javaClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            found = m;
            break;
        }
        if (found == null) {
            throw Metamodel.newModelError("Default argument method for " + parameter.getName() + " not found");
        }
        int parameterCount = found.getParameterTypes().length;
        if (MethodHandleUtil.isReifiedTypeSupported(found, false)) {
            parameterCount -= found.getTypeParameters().length;
        }
        if (parameterCount != collectedValueCount) {
            throw Metamodel.newModelError("Default argument method for " + parameter.getName() + " requires wrong number of parameters: " + parameterCount + " should be " + collectedValueCount);
        }
        MethodHandle methodHandle = this.reflectionToMethodHandle(found, javaClass, this.instance, this.appliedFunction, this.parameterProducedTypes, false, false);
        java.lang.Object[] arguments = new java.lang.Object[collectedValueCount];
        System.arraycopy(values.toArray(), 0, arguments, 0, collectedValueCount);
        try {
            return methodHandle.invokeWithArguments(arguments);
        }
        catch (Throwable e) {
            Util.rethrow(e);
            return null;
        }
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.model::Type<ceylon.language::Anything>>")
    public Sequential<? extends Type<? extends java.lang.Object>> getParameterTypes() {
        return this.parameterTypes;
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 37 * result + this.getDeclaration().hashCode();
        result = 37 * result + this.getTypeArguments().hashCode();
        return result;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FunctionImpl)) {
            return false;
        }
        FunctionImpl other = (FunctionImpl)obj;
        return this.getDeclaration().equals(other.getDeclaration()) && Util.eq(this.instance, other.instance) && this.getTypeArguments().equals(other.getTypeArguments());
    }

    @Override
    @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>|ceylon.language::Null")
    public Type<?> getContainer() {
        return this.container;
    }

    public String toString() {
        return Metamodel.toTypeString(this);
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(FunctionImpl.class, this.$reifiedType, this.$reifiedArguments);
    }
}

