/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.model;

import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.LoaderJULLogger;
import com.redhat.ceylon.model.loader.ModelResolutionException;
import com.redhat.ceylon.model.loader.impl.reflect.CachedTOCJars;
import com.redhat.ceylon.model.loader.impl.reflect.ReflectionModelLoader;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionClass;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionUtils;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.runtime.CeylonModuleClassLoader;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuntimeModelLoader
extends ReflectionModelLoader {
    public static final int MAX_JBOSS_MODULES_WAITS = 4;
    public static final int JBOSS_MODULES_TIMEOUT = 5000;
    private Map<Module, ClassLoader> classLoaders = new HashMap<Module, ClassLoader>();
    private Map<String, Module> moduleCache = new HashMap<String, Module>();
    private CachedTOCJars jars = new CachedTOCJars();
    private ClassLoader defaultClassLoader;
    private Map<String, Module> lazyLoadedModulesByPackage = new HashMap<String, Module>();
    private Boolean staticMetamodelCache;

    public RuntimeModelLoader(ModuleManager moduleManager, Modules modules) {
        super(moduleManager, modules, new LoaderJULLogger());
    }

    @Override
    public void loadStandardModules() {
        this.jdkProvider = new JdkProvider();
        Module languageModule = this.findOrCreateModule("ceylon.language", null);
        this.addModuleToClassPath(languageModule, null);
        LazyPackage languagePackage = this.findOrCreatePackage(languageModule, "ceylon.language");
        this.typeFactory.setPackage(languagePackage);
        for (String jdkModule : JDKUtils.getJDKModuleNames()) {
            this.findOrCreateModule(jdkModule, JDKUtils.jdk.version);
        }
        for (String jdkOracleModule : JDKUtils.getOracleJDKModuleNames()) {
            this.findOrCreateModule(jdkOracleModule, JDKUtils.jdk.version);
        }
    }

    @Override
    protected List<String> getPackageList(Module module, String packageName) {
        return this.jars.getPackageList(module, packageName);
    }

    @Override
    protected boolean packageExists(Module module, String packageName) {
        return this.jars.packageExists(module, packageName);
    }

    public byte[] getContents(String path) {
        return this.jars.getContents(path);
    }

    public URI getContentUri(String path) {
        return this.jars.getContentUri(path);
    }

    public byte[] getContents(Module module, String path) {
        return this.jars.getContents(module, path);
    }

    public URI getContentUri(Module module, String path) {
        return this.jars.getContentUri(module, path);
    }

    public void setDefaultClassLoader(ClassLoader cl) {
        this.defaultClassLoader = cl;
    }

    @Override
    protected Class<?> loadClass(Module module, String name) {
        ClassLoader classLoader = this.classLoaders.get(module);
        if (classLoader == null) {
            if (JDKUtils.isJDKModule(module.getNameAsString()) || JDKUtils.isOracleJDKModule(module.getNameAsString())) {
                try {
                    return ClassLoader.getSystemClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            try {
                if (this.defaultClassLoader != null) {
                    return this.defaultClassLoader.loadClass(name);
                }
                if (this.isDynamicMetamodel()) {
                    return this.getClass().getClassLoader().loadClass(name);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError x) {
                return null;
            }
            return null;
        }
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError x) {
            return null;
        }
    }

    @Override
    public void addModuleToClassPath(final Module module, ArtifactResult artifact) {
        String cacheKey = this.cacheKeyByModule(module.getNameAsString(), module.getVersion());
        this.moduleCache.put(cacheKey, module);
        if (artifact == null) {
            return;
        }
        this.jars.addJar(artifact, module);
        if (module instanceof LazyModule) {
            ((LazyModule)module).setPackagePathsProvider(new LazyModule.PackagePathsProvider(){

                @Override
                public Set<String> getPackagePaths() {
                    return RuntimeModelLoader.this.jars.getPackagePaths(module);
                }
            });
        }
    }

    public void addModuleClassLoader(Module module, ClassLoader classLoader) {
        this.classLoaders.put(module, classLoader);
    }

    @Override
    public Module findModuleForClassMirror(ClassMirror classMirror) {
        Class<?> klass = ((ReflectionClass)classMirror).klass;
        Module ret = this.findModuleForClass(klass);
        if (ret == null) {
            throw new ModelResolutionException("Could not find module for class " + klass);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module findModuleForClass(Class<?> klass) {
        ClassLoader cl = klass.getClassLoader();
        if (cl instanceof CeylonModuleClassLoader) {
            String version2;
            CeylonModuleClassLoader classLoader = (CeylonModuleClassLoader)((Object)cl);
            String name = classLoader.getModuleName();
            String cacheKey = this.cacheKeyByModule(name, version2 = classLoader.getModuleVersion());
            Module ret = this.moduleCache.get(cacheKey);
            if (ret == null) {
                Object lock;
                classLoader.registerInMetaModel();
                Object object = lock = this.getLock();
                synchronized (object) {
                    int tries = 4;
                    while (!this.classLoaders.containsValue(cl)) {
                        try {
                            lock.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new ModelResolutionException(e);
                        }
                        if (tries-- >= 0) continue;
                        throw new ModelResolutionException("Failed to find registered classloader for " + klass);
                    }
                    ret = this.moduleCache.get(cacheKey);
                }
            }
            return ret;
        }
        String pkgName = ReflectionUtils.getPackageName(klass);
        String jdkModuleName = JDKUtils.getJDKModuleNameForPackage(pkgName);
        if (jdkModuleName != null) {
            return this.findModule(jdkModuleName, JDKUtils.jdk.version);
        }
        if (this.isDynamicMetamodel()) {
            return this.lazyLoadModuleForPackage(pkgName);
        }
        return this.lookupModuleByPackageName(pkgName);
    }

    private Module lazyLoadModuleForPackage(String pkgName) {
        Module module;
        if (this.lazyLoadedModulesByPackage.containsKey(pkgName)) {
            return this.lazyLoadedModulesByPackage.get(pkgName);
        }
        if (pkgName.isEmpty()) {
            module = this.modules.getDefaultModule();
        } else {
            Module loadByModule = this.modules.getDefaultModule();
            ClassMirror moduleClass = this.findModuleClass(loadByModule, pkgName);
            if (moduleClass != null) {
                String name = this.getAnnotationStringValue(moduleClass, "com.redhat.ceylon.compiler.java.metadata.Module", "name");
                String version2 = this.getAnnotationStringValue(moduleClass, "com.redhat.ceylon.compiler.java.metadata.Module", "version");
                module = this.findOrCreateModule(name, version2);
                this.loadCompiledModule(module);
                module.addImport(new ModuleImport(null, this.modules.getDefaultModule(), false, false));
            } else {
                int lastDot = pkgName.lastIndexOf(46);
                String parentPackage = lastDot == -1 ? "" : pkgName.substring(0, lastDot);
                module = this.lazyLoadModuleForPackage(parentPackage);
            }
        }
        this.lazyLoadedModulesByPackage.put(pkgName, module);
        return module;
    }

    @Override
    protected String cacheKeyByModule(Module module, String name) {
        if (module == null) {
            throw new NullPointerException("No module found for " + name);
        }
        return super.cacheKeyByModule(module, name);
    }

    private String cacheKeyByModule(String name, String version2) {
        if (name.equals("default")) {
            return name + "/";
        }
        return name + "/" + version2;
    }

    public Unit getUnit() {
        return this.typeFactory;
    }

    @Override
    protected UnknownType.ErrorReporter makeModelErrorReporter(Module module, String message) {
        return this.makeModelErrorReporter(message);
    }

    @Override
    protected UnknownType.ErrorReporter makeModelErrorReporter(final String message) {
        return new UnknownType.ErrorReporter(message){

            @Override
            public void reportError() {
                throw new ModelResolutionException(message);
            }
        };
    }

    @Override
    protected void setAnnotationConstructor(LazyFunction method, MethodMirror meth) {
    }

    @Override
    protected void makeInteropAnnotationConstructorInvocation(AnnotationProxyMethod ctor, AnnotationProxyClass klass, List<Parameter> ctorParams) {
    }

    @Override
    public void lazyLoadModule(Module module) {
        if (this.isDynamicMetamodel() && this.loadCompiledModule(module)) {
            String pkgName = module.getNameAsString();
            ClassMirror moduleClass = this.findModuleClass(module, pkgName);
            Class<?> klass = ((ReflectionClass)moduleClass).klass;
            String path = klass.getProtectionDomain().getCodeSource().getLocation().getPath();
            Unit u = new Unit();
            u.setFilename(path);
            u.setFullPath(path);
            module.setUnit(u);
        }
    }

    @Override
    public boolean isDynamicMetamodel() {
        if (this.staticMetamodelCache == null) {
            this.staticMetamodelCache = JvmBackendUtil.isStaticMetamodel(this.getClass());
        }
        return !this.getModuleManager().isManualMetamodelSetup() && this.staticMetamodelCache == false;
    }
}

