/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.model;

import ceylon.language.Annotation;
import ceylon.language.Anything;
import ceylon.language.AssertionError;
import ceylon.language.Basic;
import ceylon.language.ConstrainedAnnotation;
import ceylon.language.Empty;
import ceylon.language.Identifiable;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.Range;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.empty_;
import ceylon.language.null_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.BooleanArray;
import com.redhat.ceylon.compiler.java.language.ByteArray;
import com.redhat.ceylon.compiler.java.language.CharArray;
import com.redhat.ceylon.compiler.java.language.DoubleArray;
import com.redhat.ceylon.compiler.java.language.FloatArray;
import com.redhat.ceylon.compiler.java.language.IntArray;
import com.redhat.ceylon.compiler.java.language.LongArray;
import com.redhat.ceylon.compiler.java.language.ObjectArray;
import com.redhat.ceylon.compiler.java.language.ShortArray;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModuleManager;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.model.FunctionOrValueInterface;
import com.redhat.ceylon.model.loader.model.LocalDeclarationContainer;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class TypeDescriptor
implements Serializable {
    private static final long serialVersionUID = -7025975752915564091L;
    public static final TypeDescriptor NothingType = new Nothing();
    private static final Variance[] NO_VARIANCE = new Variance[0];

    public abstract Type toType(RuntimeModuleManager var1);

    public abstract java.lang.Class<?> getArrayElementClass();

    public abstract boolean containsNull();

    public abstract boolean isNull();

    public abstract boolean isObject();

    public abstract boolean equals(java.lang.Object var1);

    public abstract int hashCode();

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.stringTo(b);
        return b.toString();
    }

    protected abstract void stringTo(StringBuilder var1);

    static int unorderedHashCode(TypeDescriptor[] array) {
        int hash = 0;
        for (int i = 0; i < array.length; ++i) {
            hash ^= array[i].hashCode();
        }
        return hash;
    }

    public static TypeDescriptor member(TypeDescriptor container, TypeDescriptor member) {
        return new Member(container, member);
    }

    public static TypeDescriptor klass(java.lang.Class<?> klass, TypeDescriptor ... typeArguments) {
        return TypeDescriptor.klass(klass, NO_VARIANCE, typeArguments);
    }

    public static TypeDescriptor klass(java.lang.Class<?> klass, Variance[] useSiteVariance, TypeDescriptor ... typeArguments) {
        Tuple tuple = TypeDescriptor.unwrapTupleType(klass, useSiteVariance, typeArguments, false);
        if (tuple != null) {
            return tuple;
        }
        return new Class(klass, useSiteVariance, typeArguments);
    }

    private static Tuple unwrapTupleType(java.lang.Class<?> klass, Variance[] useSiteVariance, TypeDescriptor[] typeArguments, boolean allOptional) {
        int firstDefaulted;
        boolean atLeastOne;
        boolean variadic;
        LinkedList<TypeDescriptor> elementTypes;
        block17: {
            block18: {
                block19: {
                    if (klass != ceylon.language.Tuple.class || useSiteVariance != null && useSiteVariance != NO_VARIANCE) {
                        return null;
                    }
                    if (typeArguments.length != 3) {
                        return null;
                    }
                    elementTypes = new LinkedList<TypeDescriptor>();
                    variadic = false;
                    atLeastOne = false;
                    firstDefaulted = allOptional ? 0 : -1;
                    while (true) {
                        TypeDescriptor first = typeArguments[1];
                        TypeDescriptor rest = typeArguments[2];
                        elementTypes.add(first);
                        if (rest.equals(Empty.$TypeDescriptor$)) break block17;
                        if (rest instanceof Tuple) {
                            Tuple restTuple = (Tuple)rest;
                            return TypeDescriptor.combineTuples(elementTypes, firstDefaulted, restTuple);
                        }
                        if (rest instanceof Class) {
                            Class restClass = (Class)rest;
                            if (restClass.getKlass() == ceylon.language.Tuple.class) {
                                typeArguments = restClass.getTypeArguments();
                                continue;
                            }
                            if (restClass.getKlass() == Sequence.class) {
                                if (restClass.getTypeArguments().length != 1) {
                                    return null;
                                }
                                elementTypes.add(restClass.getTypeArguments()[0]);
                                atLeastOne = true;
                                variadic = true;
                                break block17;
                            }
                            if (restClass.getKlass() == Sequential.class) {
                                if (restClass.getTypeArguments().length != 1) {
                                    return null;
                                }
                                elementTypes.add(restClass.getTypeArguments()[0]);
                                variadic = true;
                                break block17;
                            }
                            return null;
                        }
                        if (!(rest instanceof Union)) break block18;
                        Union restUnion = (Union)rest;
                        if (restUnion.members.length != 2) {
                            return null;
                        }
                        TypeDescriptor alternative = null;
                        if (restUnion.members[0] == Empty.$TypeDescriptor$) {
                            alternative = restUnion.members[1];
                        } else if (restUnion.members[1] == Empty.$TypeDescriptor$) {
                            alternative = restUnion.members[0];
                        }
                        if (alternative == null) {
                            return null;
                        }
                        if (firstDefaulted == -1) {
                            firstDefaulted = elementTypes.size();
                        }
                        if (alternative instanceof Tuple) {
                            Tuple restTuple = (Tuple)alternative;
                            return TypeDescriptor.combineTuples(elementTypes, firstDefaulted, restTuple);
                        }
                        if (!(alternative instanceof Class)) break block19;
                        if (((Class)alternative).getKlass() != ceylon.language.Tuple.class) break;
                        typeArguments = ((Class)alternative).getTypeArguments();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return new Tuple(variadic, atLeastOne, firstDefaulted, elementTypes.toArray(new TypeDescriptor[elementTypes.size()]));
    }

    private static Tuple combineTuples(List<TypeDescriptor> elementTypes, int firstDefaulted, Tuple restTuple) {
        TypeDescriptor[] newElements = new TypeDescriptor[elementTypes.size() + restTuple.elements.length];
        newElements = elementTypes.toArray(newElements);
        System.arraycopy(restTuple.elements, 0, newElements, elementTypes.size(), restTuple.elements.length);
        if (firstDefaulted == -1 && (firstDefaulted = restTuple.firstDefaulted) != -1) {
            firstDefaulted += elementTypes.size();
        }
        return new Tuple(restTuple.variadic, restTuple.atLeastOne, firstDefaulted, newElements);
    }

    private static Tuple combineTuples(TypeDescriptor[] elementTypes, int firstDefaulted, Tuple restTuple) {
        TypeDescriptor[] newElements = new TypeDescriptor[elementTypes.length + restTuple.elements.length];
        System.arraycopy(elementTypes, 0, newElements, 0, elementTypes.length);
        System.arraycopy(restTuple.elements, 0, newElements, elementTypes.length, restTuple.elements.length);
        if (firstDefaulted == -1 && (firstDefaulted = restTuple.firstDefaulted) != -1) {
            firstDefaulted += elementTypes.length;
        }
        return new Tuple(restTuple.variadic, restTuple.atLeastOne, firstDefaulted, newElements);
    }

    public static TypeDescriptor tuple(boolean variadic, boolean atLeastOne, int firstDefaulted, TypeDescriptor ... elements) {
        return new Tuple(variadic, atLeastOne, firstDefaulted, elements);
    }

    public static TypeDescriptor tupleWithRest(TypeDescriptor rest, TypeDescriptor restElement, int firstDefaulted, TypeDescriptor ... elements) {
        if (rest == Empty.$TypeDescriptor$) {
            return TypeDescriptor.tuple(false, false, firstDefaulted, elements);
        }
        if (rest instanceof Tuple) {
            return TypeDescriptor.combineTuples(elements, firstDefaulted, (Tuple)rest);
        }
        if (rest instanceof Class) {
            Class restClass = (Class)rest;
            if (restClass.klass == Sequence.class || restClass.klass == Sequential.class || restClass.klass == Range.class) {
                TypeDescriptor[] newElements = new TypeDescriptor[elements.length + 1];
                System.arraycopy(elements, 0, newElements, 0, elements.length);
                newElements[newElements.length - 1] = restClass.getSequenceElement();
                return TypeDescriptor.tuple(true, restClass.klass == Sequence.class, firstDefaulted, newElements);
            }
            Tuple restTuple = TypeDescriptor.unwrapTupleType(restClass.klass, restClass.useSiteVariance, restClass.typeArguments, false);
            if (restTuple != null) {
                return TypeDescriptor.combineTuples(elements, firstDefaulted, restTuple);
            }
            return TypeDescriptor.makeDegenerateTuple(elements, firstDefaulted, restTuple, restElement);
        }
        return TypeDescriptor.makeDegenerateTuple(elements, firstDefaulted, rest, restElement);
    }

    private static TypeDescriptor makeDegenerateTuple(TypeDescriptor[] elements, int firstDefaulted, TypeDescriptor rest, TypeDescriptor restElementType) {
        for (int i = elements.length - 1; i >= 0; --i) {
            TypeDescriptor first = elements[i];
            restElementType = TypeDescriptor.union(restElementType, first);
            rest = new Class(ceylon.language.Tuple.class, NO_VARIANCE, new TypeDescriptor[]{restElementType, first, rest});
            if (firstDefaulted == -1 || firstDefaulted > i) continue;
            rest = TypeDescriptor.union(Empty.$TypeDescriptor$, rest);
        }
        return rest;
    }

    public static TypeDescriptor functionOrValue(String name, TypeDescriptor ... typeArguments) {
        return new FunctionOrValue(name, typeArguments);
    }

    public static TypeDescriptor functionOrValue(java.lang.Class<?> klass, TypeDescriptor ... typeArguments) {
        return new FunctionOrValue(klass, typeArguments);
    }

    public static TypeDescriptor union(TypeDescriptor ... members) {
        if (members == null || members.length == 0) {
            throw new AssertionError("members can't be null or empty");
        }
        TypeDescriptor single = TypeDescriptor.getSingleTypeDescriptorIfUnique(members = TypeDescriptor.flattenUnionOrIntersection(members, true));
        if (single != null) {
            return single;
        }
        if ((members = TypeDescriptor.removeDuplicates(members)).length == 2) {
            Class klass;
            Tuple tuple;
            TypeDescriptor alternative = null;
            if (members[0].equals(Empty.$TypeDescriptor$)) {
                alternative = members[1];
            } else if (members[1].equals(Empty.$TypeDescriptor$)) {
                alternative = members[0];
            }
            if (alternative instanceof Tuple) {
                Tuple tuple2 = (Tuple)alternative;
                return new Tuple(tuple2.variadic, tuple2.atLeastOne, 0, tuple2.elements);
            }
            if (alternative instanceof Class && (tuple = TypeDescriptor.unwrapTupleType((klass = (Class)alternative).getKlass(), klass.useSiteVariance, klass.getTypeArguments(), true)) != null) {
                return tuple;
            }
        }
        return new Union(members);
    }

    public static TypeDescriptor intersection(TypeDescriptor ... members) {
        if (members == null || members.length == 0) {
            throw new AssertionError("members can't be null or empty");
        }
        TypeDescriptor single = TypeDescriptor.getSingleTypeDescriptorIfUnique(members = TypeDescriptor.flattenUnionOrIntersection(members, false));
        if (single != null) {
            return single;
        }
        members = TypeDescriptor.removeDuplicates(members);
        return new Intersection(members);
    }

    private static TypeDescriptor[] flattenUnionOrIntersection(TypeDescriptor[] members, boolean union) {
        TypeDescriptor[] iterating = members;
        for (int ii = 0; ii < iterating.length; ++ii) {
            TypeDescriptor td = iterating[ii];
            if ((!(td instanceof Union) || !union) && (!(td instanceof Intersection) || union)) continue;
            TypeDescriptor[] extra = ((Composite)td).members;
            TypeDescriptor[] n = new TypeDescriptor[iterating.length - 1 + extra.length];
            System.arraycopy(iterating, 0, n, 0, ii);
            System.arraycopy(extra, 0, n, ii, extra.length);
            if (ii + 1 < iterating.length) {
                System.arraycopy(iterating, ii + 1, n, ii + extra.length, iterating.length - ii - 1);
            }
            iterating = n;
        }
        return iterating;
    }

    private static TypeDescriptor[] removeDuplicates(TypeDescriptor[] members) {
        int duplicates = 0;
        int nothing = 0;
        for (int i = 0; i < members.length; ++i) {
            TypeDescriptor ref = members[i];
            for (int j = i + 1; j < members.length; ++j) {
                if (!ref.equals(members[j])) continue;
                ++duplicates;
                break;
            }
            if (ref != NothingType) continue;
            nothing = 1;
        }
        if (duplicates > 0 || nothing > 0) {
            TypeDescriptor[] unique = new TypeDescriptor[members.length - duplicates - nothing];
            int u = 0;
            block2: for (int i = 0; i < members.length; ++i) {
                TypeDescriptor ref = members[i];
                for (int j = i + 1; j < members.length; ++j) {
                    if (!ref.equals(members[j])) continue;
                    ++duplicates;
                    continue block2;
                }
                if (ref == NothingType) continue;
                unique[u++] = ref;
            }
            return unique;
        }
        return members;
    }

    private static TypeDescriptor getSingleTypeDescriptorIfUnique(TypeDescriptor[] members) {
        if (members.length == 1) {
            return members[0];
        }
        TypeDescriptor first = members[0];
        for (int i = 1; i < members.length; ++i) {
            if (members[i].equals(first)) continue;
            return null;
        }
        return first;
    }

    public boolean is(TypeDescriptor instanceType) {
        return this == instanceType || Metamodel.getProducedType(instanceType).isSubtypeOf(Metamodel.getProducedType(this));
    }

    public static class Intersection
    extends Composite {
        private static final long serialVersionUID = -6146724688533043308L;

        public Intersection(TypeDescriptor[] members) {
            super(members);
        }

        @Override
        public boolean is(TypeDescriptor instanceType) {
            for (TypeDescriptor member : this.members) {
                if (member.is(instanceType)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Intersection)) {
                return false;
            }
            return super.equals((Intersection)obj);
        }

        @Override
        public int hashCode() {
            int ret = 17;
            ret = 37 * ret + "intersection".hashCode();
            ret = 37 * ret + Intersection.unorderedHashCode(this.members);
            return ret;
        }

        @Override
        public char getSep() {
            return '&';
        }

        @Override
        public Type toType(RuntimeModuleManager moduleManager) {
            Unit unit = moduleManager.getModelLoader().getUnit();
            ArrayList<Type> satisfiedTypes = new ArrayList<Type>(this.members.length);
            for (TypeDescriptor member : this.members) {
                satisfiedTypes.add(Metamodel.getProducedType(member));
            }
            return ModelUtil.canonicalIntersection(satisfiedTypes, unit);
        }

        public Type toSimpleType(RuntimeModuleManager moduleManager) {
            Unit unit = moduleManager.getModelLoader().getUnit();
            ArrayList<Type> satisfiedTypes = new ArrayList<Type>(this.members.length);
            for (TypeDescriptor member : this.members) {
                ModelUtil.addToIntersection(satisfiedTypes, Metamodel.getProducedType(member), unit);
            }
            return ModelUtil.canonicalIntersection(satisfiedTypes, unit);
        }

        @Override
        public java.lang.Class<?> getArrayElementClass() {
            java.lang.Class<?> result = null;
            for (TypeDescriptor td : this.members) {
                if (td instanceof Nothing) {
                    return java.lang.Object.class;
                }
                if (td.isNull()) {
                    return java.lang.Object.class;
                }
                if (td.isObject()) continue;
                java.lang.Class<?> c = td.getArrayElementClass();
                if (result == null) {
                    result = c;
                    continue;
                }
                if (result.isAssignableFrom(c)) {
                    result = c;
                    continue;
                }
                if (c.isAssignableFrom(result) || result == c) continue;
                return java.lang.Object.class;
            }
            return result == null ? java.lang.Object.class : result;
        }

        @Override
        public boolean containsNull() {
            for (TypeDescriptor td : this.members) {
                if (td.containsNull()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isNull() {
            for (TypeDescriptor td : this.members) {
                if (td.isNull()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isObject() {
            for (TypeDescriptor td : this.members) {
                if (td.isObject()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Union
    extends Composite {
        private static final long serialVersionUID = -7420930358788416571L;

        public Union(TypeDescriptor[] members) {
            super(members);
        }

        @Override
        public boolean is(TypeDescriptor instanceType) {
            if (instanceType instanceof Union) {
                for (TypeDescriptor instanceMember : ((Union)instanceType).members) {
                    if (this.is(instanceMember)) continue;
                    return false;
                }
                return true;
            }
            for (TypeDescriptor member : this.members) {
                if (!member.is(instanceType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Union)) {
                return false;
            }
            return super.equals((Union)obj);
        }

        @Override
        public int hashCode() {
            int ret = 17;
            ret = 37 * ret + "union".hashCode();
            ret = 37 * ret + Union.unorderedHashCode(this.members);
            return ret;
        }

        @Override
        public char getSep() {
            return '|';
        }

        @Override
        public Type toType(RuntimeModuleManager moduleManager) {
            Unit unit = moduleManager.getModelLoader().getUnit();
            ArrayList<Type> caseTypes = new ArrayList<Type>(this.members.length);
            for (TypeDescriptor member : this.members) {
                caseTypes.add(Metamodel.getProducedType(member));
            }
            return ModelUtil.union(caseTypes, unit);
        }

        public Type toSimpleType(RuntimeModuleManager moduleManager) {
            ArrayList<Type> caseTypes = new ArrayList<Type>(this.members.length);
            for (TypeDescriptor member : this.members) {
                ModelUtil.addToUnion(caseTypes, Metamodel.getProducedType(member));
            }
            return ModelUtil.union(caseTypes, moduleManager.getModelLoader().getUnit());
        }

        @Override
        public java.lang.Class<?> getArrayElementClass() {
            java.lang.Class<?> result = null;
            for (TypeDescriptor td : this.members) {
                if (td.isObject()) {
                    return java.lang.Object.class;
                }
                if (td.isNull() || td instanceof Nothing) continue;
                java.lang.Class<?> c = td.getArrayElementClass();
                if (result == null) {
                    result = c;
                    continue;
                }
                if (result.isAssignableFrom(c)) continue;
                if (c.isAssignableFrom(result)) {
                    result = c;
                    continue;
                }
                if (result == c) continue;
                return java.lang.Object.class;
            }
            return result == null ? java.lang.Object.class : result;
        }

        @Override
        public boolean containsNull() {
            for (TypeDescriptor td : this.members) {
                if (!td.containsNull()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isNull() {
            for (TypeDescriptor td : this.members) {
                if (td.isNull()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isObject() {
            for (TypeDescriptor td : this.members) {
                if (!td.isObject()) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Composite
    extends TypeDescriptor {
        private static final long serialVersionUID = -5468389615462158394L;
        protected final TypeDescriptor[] members;

        public Composite(TypeDescriptor[] members) {
            this.members = members;
        }

        public TypeDescriptor[] getMembers() {
            return this.members;
        }

        protected boolean equals(Composite other) {
            return Composite.allContained(this.members, other.members) && Composite.allContained(other.members, this.members);
        }

        private static boolean allContained(TypeDescriptor[] a, TypeDescriptor[] b) {
            block0: for (int i = 0; i < a.length; ++i) {
                TypeDescriptor ref = a[i];
                for (int j = 0; j < b.length; ++j) {
                    if (ref.equals(b[j])) continue block0;
                }
                return false;
            }
            return true;
        }

        protected abstract char getSep();

        @Override
        protected final void stringTo(StringBuilder sb) {
            char sep = this.getSep();
            if (this.members.length > 0) {
                for (int i = 0; i < this.members.length; ++i) {
                    TypeDescriptor member;
                    if (i > 0) {
                        sb.append(sep);
                    }
                    if ((member = this.members[i]) instanceof Composite) {
                        sb.append('<');
                    }
                    member.stringTo(sb);
                    if (!(member instanceof Composite)) continue;
                    sb.append('>');
                }
            }
        }
    }

    public static class Nothing
    extends TypeDescriptor {
        private static final long serialVersionUID = -2762984778119395164L;

        @Override
        public boolean is(TypeDescriptor instanceType) {
            return false;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            int ret = 17;
            ret = 37 * ret + "nothing".hashCode();
            return ret;
        }

        @Override
        public Type toType(RuntimeModuleManager moduleManager) {
            return new NothingType(moduleManager.getModelLoader().getUnit()).getType();
        }

        @Override
        public void stringTo(StringBuilder sb) {
            sb.append("ceylon.language.Nothing");
        }

        @Override
        public java.lang.Class<?> getArrayElementClass() {
            return java.lang.Object.class;
        }

        @Override
        public boolean containsNull() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }
    }

    public static class Member
    extends TypeDescriptor {
        private static final long serialVersionUID = 1139040165187154453L;
        private TypeDescriptor container;
        private TypeDescriptor member;

        public Member(TypeDescriptor container, TypeDescriptor member) {
            this.member = member;
            this.container = container;
        }

        public TypeDescriptor getContainer() {
            return this.container;
        }

        public TypeDescriptor getMember() {
            return this.member;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Member)) {
                return false;
            }
            Member other = (Member)obj;
            return this.container.equals(other.container) && this.member.equals(other.member);
        }

        @Override
        public int hashCode() {
            int ret = 17;
            ret = 37 * ret + "member".hashCode();
            ret = 37 * ret + this.container.hashCode();
            ret = 37 * ret + this.member.hashCode();
            return ret;
        }

        @Override
        public void stringTo(StringBuilder sb) {
            this.container.stringTo(sb);
            sb.append(".");
            this.member.stringTo(sb);
        }

        @Override
        public Type toType(RuntimeModuleManager moduleManager) {
            Type qualifyingType = Metamodel.getProducedType(this.container);
            return ((QualifiableTypeDescriptor)((java.lang.Object)this.member)).toProducedType(qualifyingType, moduleManager);
        }

        @Override
        public java.lang.Class<?> getArrayElementClass() {
            return this.member.getArrayElementClass();
        }

        @Override
        public boolean containsNull() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }
    }

    public static class FunctionOrValue
    extends Generic
    implements QualifiableTypeDescriptor {
        private static final long serialVersionUID = 1916449991722960781L;
        private final String name;
        private final java.lang.Class<?> klass;
        private final boolean local;
        private int memoizedHash;

        public FunctionOrValue(String name, TypeDescriptor[] typeArguments) {
            super(NO_VARIANCE, typeArguments);
            this.klass = null;
            this.name = name;
            this.local = name.isEmpty() ? false : Character.isDigit(name.charAt(0));
        }

        public FunctionOrValue(java.lang.Class<?> klass, TypeDescriptor[] typeArguments) {
            super(NO_VARIANCE, typeArguments);
            this.klass = klass;
            this.name = null;
            this.local = false;
        }

        @Override
        public Type toType(RuntimeModuleManager moduleManager) {
            String typeName = this.klass.getName();
            Module module = moduleManager.findModuleForClass(this.klass);
            TypedDeclaration declaration = (TypedDeclaration)moduleManager.getModelLoader().getDeclaration(module, typeName, ModelLoader.DeclarationType.TYPE);
            return this.makeProducedType(null, declaration, moduleManager);
        }

        @Override
        public Type toProducedType(Type qualifyingType, RuntimeModuleManager moduleManager) {
            Declaration qualifyingDeclaration = qualifyingType.getDeclaration();
            if (qualifyingDeclaration instanceof FunctionOrValueInterface) {
                qualifyingDeclaration = ((FunctionOrValueInterface)qualifyingDeclaration).getUnderlyingDeclaration();
            }
            TypedDeclaration declaration = this.local ? (TypedDeclaration)((LocalDeclarationContainer)((java.lang.Object)qualifyingDeclaration)).getLocalDeclaration(this.name) : (TypedDeclaration)qualifyingDeclaration.getDirectMember(this.name, null, false);
            return this.makeProducedType(qualifyingType, declaration, moduleManager);
        }

        private Type makeProducedType(Type qualifyingType, TypedDeclaration declaration, RuntimeModuleManager moduleManager) {
            ArrayList<Type> typeArgs = new ArrayList<Type>(this.typeArguments.length);
            for (TypeDescriptor typeArg : this.typeArguments) {
                typeArgs.add(Metamodel.getProducedType(typeArg));
            }
            return new FunctionOrValueInterface(declaration).appliedType(qualifyingType, typeArgs);
        }

        @Override
        public java.lang.Class<?> getArrayElementClass() {
            throw new AssertionError("Should never be called");
        }

        @Override
        public boolean containsNull() {
            throw new AssertionError("Should never be called");
        }

        @Override
        public boolean isNull() {
            throw new AssertionError("Should never be called");
        }

        @Override
        public boolean isObject() {
            throw new AssertionError("Should never be called");
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof FunctionOrValue)) {
                return false;
            }
            FunctionOrValue other = (FunctionOrValue)obj;
            if (this.name != null ? !this.name.equals(other.name) : this.klass != other.klass) {
                return false;
            }
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHash == 0) {
                this.memoizedHash = 17;
                this.memoizedHash = 37 * this.memoizedHash + "functionorvalue".hashCode();
                this.memoizedHash = 37 * this.memoizedHash + Arrays.hashCode(this.typeArguments);
                this.memoizedHash = 37 * this.memoizedHash + (this.klass != null ? this.klass.hashCode() : 0);
                this.memoizedHash = 37 * this.memoizedHash + (this.name != null ? this.name.hashCode() : 0);
            }
            return this.memoizedHash;
        }

        @Override
        public void stringTo(StringBuilder b) {
            if (this.klass != null) {
                b.append(this.klass.getName());
            } else {
                b.append(this.name);
            }
            super.stringTo(b);
        }
    }

    public static class Tuple
    extends Class {
        private static final long serialVersionUID = 6816227953528929741L;
        private final TypeDescriptor[] elements;
        private final boolean variadic;
        private final boolean atLeastOne;
        private final int firstDefaulted;
        private TypeDescriptor elementUnion;
        private TypeDescriptor rest;
        private int memoizedHash;

        public Tuple(boolean variadic, boolean atLeastOne, int firstDefaulted, TypeDescriptor[] elements) {
            super(ceylon.language.Tuple.class, NO_VARIANCE, null);
            if (elements.length < (variadic ? 2 : 1)) {
                throw new AssertionError("Not enough elements in a tuple (logic error): please report bug");
            }
            this.elements = elements;
            this.variadic = variadic;
            this.atLeastOne = atLeastOne;
            this.firstDefaulted = firstDefaulted;
        }

        @Override
        public TypeDescriptor[] getTypeArguments() {
            return new TypeDescriptor[]{this.getSequenceElement(), this.getTupleFirstElement(), this.getTupleRest()};
        }

        @Override
        public int getNumTypeArguments() {
            return 3;
        }

        @Override
        public TypeDescriptor getTypeArgument(int index) {
            switch (index) {
                case 0: {
                    return this.getSequenceElement();
                }
                case 1: {
                    return this.getTupleFirstElement();
                }
                case 2: {
                    return this.getTupleRest();
                }
            }
            throw new RuntimeException();
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)obj;
            if (this.klass != other.klass) {
                return false;
            }
            return Arrays.equals(this.elements, other.elements) && this.variadic == other.variadic && this.atLeastOne == other.atLeastOne && this.firstDefaulted == other.firstDefaulted;
        }

        @Override
        public int hashCode() {
            if (this.memoizedHash == 0) {
                this.memoizedHash = 17;
                this.memoizedHash = 37 * this.memoizedHash + "tuple".hashCode();
                this.memoizedHash = 37 * this.memoizedHash + Arrays.hashCode(this.elements);
                this.memoizedHash = 37 * this.memoizedHash + (this.variadic ? 1 : 0);
                this.memoizedHash = 37 * this.memoizedHash + (this.atLeastOne ? 1 : 0);
                this.memoizedHash = 37 * this.memoizedHash + this.firstDefaulted;
            }
            return this.memoizedHash;
        }

        @Override
        public boolean is(TypeDescriptor instanceType) {
            if (this.firstDefaulted == 0 && (instanceType == empty_.$TypeDescriptor$ || instanceType == Empty.$TypeDescriptor$)) {
                return true;
            }
            return super.is(instanceType);
        }

        @Override
        protected void stringTo(StringBuilder b) {
            b.append("[");
            int lastNonVariadic = this.variadic ? this.elements.length - 2 : this.elements.length - 1;
            for (int i = 0; i < this.elements.length; ++i) {
                if (i > 0) {
                    b.append(",");
                }
                this.elements[i].stringTo(b);
                if (i <= lastNonVariadic) {
                    if (this.firstDefaulted < 0 || i < this.firstDefaulted) continue;
                    b.append("=");
                    continue;
                }
                b.append(this.atLeastOne ? "+" : "*");
            }
            b.append("]");
        }

        @Override
        public Type toProducedType(Type qualifyingType, RuntimeModuleManager moduleManager) {
            String typeName = this.klass.getName();
            Module module = moduleManager.findModuleForClass(this.klass);
            TypeDeclaration decl = (TypeDeclaration)moduleManager.getModelLoader().getDeclaration(module, typeName, ModelLoader.DeclarationType.TYPE);
            ArrayList<Type> elemTypes = new ArrayList<Type>(this.elements.length);
            for (TypeDescriptor element : this.elements) {
                elemTypes.add(Metamodel.getProducedType(element));
            }
            return decl.getUnit().getTupleType(elemTypes, this.variadic, this.atLeastOne, this.firstDefaulted);
        }

        @Override
        public TypeDescriptor getSequenceElement() {
            if (this.elementUnion == null) {
                this.elementUnion = Tuple.union(this.elements);
            }
            return this.elementUnion;
        }

        @Override
        public TypeDescriptor getTupleFirstElement() {
            return this.elements[0];
        }

        @Override
        public TypeDescriptor getTupleRest() {
            if (this.rest == null) {
                if (this.variadic) {
                    if (this.elements.length == 1) {
                        throw new AssertionError("Variadic tuple of length 1: that's a bug please report it");
                    }
                    this.rest = this.elements.length == 2 ? (this.atLeastOne ? TypeDescriptor.klass(Sequence.class, this.elements[1]) : TypeDescriptor.klass(Sequential.class, this.elements[1])) : this.makeTupleRest();
                } else {
                    this.rest = this.elements.length == 1 ? Empty.$TypeDescriptor$ : this.makeTupleRest();
                }
            }
            return this.rest;
        }

        private TypeDescriptor makeTupleRest() {
            TypeDescriptor[] newElements = new TypeDescriptor[this.elements.length - 1];
            System.arraycopy(this.elements, 1, newElements, 0, newElements.length);
            int firstDefaulted = this.firstDefaulted;
            if (firstDefaulted >= 1) {
                --firstDefaulted;
            }
            return new Tuple(this.variadic, this.atLeastOne, firstDefaulted, newElements);
        }
    }

    public static class Class
    extends Generic
    implements QualifiableTypeDescriptor {
        private static final long serialVersionUID = -490491495105002855L;
        private int memoizedHash;
        protected final java.lang.Class<?> klass;

        public Class(java.lang.Class<?> klass, Variance[] useSiteVariance, TypeDescriptor[] typeArguments) {
            super(useSiteVariance, typeArguments);
            this.klass = klass;
        }

        public java.lang.Class<?> getKlass() {
            return this.klass;
        }

        @Override
        public boolean is(TypeDescriptor instanceType) {
            if (this.klass == Anything.class || this.klass == Object.class) {
                return true;
            }
            if (this.klass == Null.class || this.klass == null_.class) {
                return false;
            }
            if (instanceType instanceof Class) {
                java.lang.Class<?> instanceKlass = ((Class)instanceType).klass;
                if (this.klass == Basic.class) {
                    return Util.isBasic(instanceKlass);
                }
                if (this.klass == Identifiable.class) {
                    return Util.isIdentifiable(instanceKlass);
                }
                java.lang.Class realKlass = this.klass == ceylon.language.Exception.class ? Exception.class : (this.klass == ceylon.language.Throwable.class ? Throwable.class : (this.klass == Annotation.class || this.klass == ConstrainedAnnotation.class ? java.lang.annotation.Annotation.class : this.klass));
                boolean isSubclass = realKlass.isAssignableFrom(instanceKlass);
                if (!isSubclass) {
                    return false;
                }
                if (!this.isGeneric()) {
                    return true;
                }
            } else {
                if (instanceType instanceof Union) {
                    for (TypeDescriptor member : ((Union)instanceType).members) {
                        if (this.is(member)) continue;
                        return false;
                    }
                    return true;
                }
                if (instanceType instanceof Intersection) {
                    for (TypeDescriptor member : ((Intersection)instanceType).members) {
                        if (!this.is(member)) continue;
                        return true;
                    }
                    return false;
                }
            }
            return super.is(instanceType);
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Class)) {
                return false;
            }
            Class other = (Class)obj;
            if (this.klass != other.klass) {
                return false;
            }
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            if (this.memoizedHash == 0) {
                this.memoizedHash = 17;
                this.memoizedHash = 37 * this.memoizedHash + "class".hashCode();
                this.memoizedHash = 37 * this.memoizedHash + Arrays.hashCode(this.typeArguments);
                this.memoizedHash = 37 * this.memoizedHash + Arrays.hashCode((java.lang.Object[])this.useSiteVariance);
                this.memoizedHash = 37 * this.memoizedHash + this.klass.hashCode();
            }
            return this.memoizedHash;
        }

        @Override
        protected void stringTo(StringBuilder sb) {
            String className = this.klass.getName();
            sb.append(className);
            if (this.typeArguments.length != 0) {
                super.stringTo(sb);
            }
        }

        @Override
        public Type toType(RuntimeModuleManager moduleManager) {
            return this.toProducedType(null, moduleManager);
        }

        @Override
        public Type toProducedType(Type qualifyingType, RuntimeModuleManager moduleManager) {
            String typeName = this.klass.getName();
            Module module = moduleManager.findModuleForClass(this.klass);
            TypeDeclaration decl = (TypeDeclaration)moduleManager.getModelLoader().getDeclaration(module, typeName, ModelLoader.DeclarationType.TYPE);
            ArrayList<Type> typeArgs = new ArrayList<Type>(this.typeArguments.length);
            for (TypeDescriptor typeArg : this.typeArguments) {
                typeArgs.add(Metamodel.getProducedType(typeArg));
            }
            if (Modifier.isStatic(this.klass.getModifiers())) {
                typeArgs.addAll(0, qualifyingType.getTypeArgumentList());
            }
            Type type = decl.appliedType(qualifyingType, typeArgs);
            type = this.applyUseSiteVariance(decl, type);
            return type;
        }

        @Override
        public java.lang.Class<?> getArrayElementClass() {
            if (this.isNull() || this.isObject()) {
                return java.lang.Object.class;
            }
            if (this.klass == ceylon.language.Throwable.class) {
                return Throwable.class;
            }
            if (this.klass == ceylon.language.Exception.class) {
                return Exception.class;
            }
            if (this.klass == Annotation.class || this.klass == ConstrainedAnnotation.class) {
                return java.lang.annotation.Annotation.class;
            }
            if (this.klass == ObjectArray.class) {
                return java.lang.Object[].class;
            }
            if (this.klass == BooleanArray.class) {
                return boolean[].class;
            }
            if (this.klass == LongArray.class) {
                return long[].class;
            }
            if (this.klass == IntArray.class) {
                return int[].class;
            }
            if (this.klass == ShortArray.class) {
                return short[].class;
            }
            if (this.klass == ByteArray.class) {
                return byte[].class;
            }
            if (this.klass == DoubleArray.class) {
                return double[].class;
            }
            if (this.klass == FloatArray.class) {
                return float[].class;
            }
            if (this.klass == CharArray.class) {
                return char[].class;
            }
            return this.klass;
        }

        @Override
        public boolean containsNull() {
            return this.klass == Null.class || this.klass == null_.class || this.klass == Anything.class;
        }

        @Override
        public boolean isNull() {
            return this.klass == Null.class || this.klass == null_.class;
        }

        @Override
        public boolean isObject() {
            return this.klass == Anything.class || this.klass == Object.class || this.klass == Identifiable.class || this.klass == Basic.class;
        }

        public TypeDescriptor getSequenceElement() {
            if (this.klass == ceylon.language.Tuple.class || this.klass == Sequence.class || this.klass == Sequential.class || this.klass == Range.class) {
                return this.typeArguments[0];
            }
            if (this.klass == Empty.class) {
                return NothingType;
            }
            return null;
        }

        public TypeDescriptor getTupleFirstElement() {
            return this.typeArguments[1];
        }

        public TypeDescriptor getTupleRest() {
            return this.typeArguments[2];
        }
    }

    public static abstract class Generic
    extends TypeDescriptor {
        private static final long serialVersionUID = 3624907451428501623L;
        protected final TypeDescriptor[] typeArguments;
        protected final Variance[] useSiteVariance;

        public Generic(Variance[] useSiteVariance, TypeDescriptor[] typeArguments) {
            this.typeArguments = typeArguments;
            if (useSiteVariance != NO_VARIANCE && useSiteVariance.length != typeArguments.length) {
                throw new IllegalArgumentException("Undefined variance");
            }
            this.useSiteVariance = useSiteVariance;
        }

        public TypeDescriptor[] getTypeArguments() {
            return this.typeArguments;
        }

        public int getNumTypeArguments() {
            return this.typeArguments.length;
        }

        public TypeDescriptor getTypeArgument(int index) {
            return this.typeArguments[index];
        }

        public boolean isGeneric() {
            return this.getNumTypeArguments() > 0;
        }

        protected boolean equals(Generic other) {
            return Arrays.equals(this.typeArguments, other.typeArguments) && Arrays.equals((java.lang.Object[])this.useSiteVariance, (java.lang.Object[])other.useSiteVariance);
        }

        @Override
        protected void stringTo(StringBuilder b) {
            if (this.typeArguments.length > 0) {
                b.append("<");
                for (int i = 0; i < this.typeArguments.length; ++i) {
                    if (i > 0) {
                        b.append(",");
                    }
                    if (this.useSiteVariance != NO_VARIANCE) {
                        b.append(this.useSiteVariance[i].getPretty()).append(' ');
                    }
                    this.typeArguments[i].stringTo(b);
                }
                b.append(">");
            }
        }

        protected Type applyUseSiteVariance(TypeDeclaration decl, Type type) {
            if (this.useSiteVariance.length != 0 && decl instanceof com.redhat.ceylon.model.typechecker.model.Generic) {
                List<TypeParameter> typeParameters = decl.getTypeParameters();
                int i = 0;
                for (TypeParameter typeParameter : typeParameters) {
                    if (i >= this.useSiteVariance.length) break;
                    switch (this.useSiteVariance[i]) {
                        case IN: {
                            type.setVariance(typeParameter, SiteVariance.IN);
                            break;
                        }
                        case OUT: {
                            type.setVariance(typeParameter, SiteVariance.OUT);
                            break;
                        }
                    }
                    ++i;
                }
            }
            return type;
        }
    }

    public static interface QualifiableTypeDescriptor {
        public Type toProducedType(Type var1, RuntimeModuleManager var2);
    }
}

