/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools;

import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import java.util.LinkedList;
import java.util.List;

public class Options {
    private String workingDirectory;
    private String systemRepository;
    private List<String> userRepositories = new LinkedList<String>();
    private boolean offline;
    private boolean verbose;
    private String verboseCategory;
    private boolean noDefaultRepositories;
    private String run;
    private String overrides;
    private boolean downgradeDist;
    private int timeout;

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getSystemRepository() {
        return this.systemRepository;
    }

    public void setSystemRepository(String systemRepository) {
        this.systemRepository = systemRepository;
    }

    public List<String> getUserRepositories() {
        return this.userRepositories;
    }

    public void setUserRepositories(List<String> userRepositories) {
        this.userRepositories = userRepositories;
    }

    public void addUserRepository(String userRepository) {
        this.userRepositories.add(userRepository);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (verbose) {
            if (this.verboseCategory == null) {
                this.verboseCategory = "all";
            }
        } else {
            this.verboseCategory = null;
        }
    }

    public String getVerboseCategory() {
        return this.verboseCategory;
    }

    public void setVerboseCategory(String verboseCategory) {
        if (verboseCategory == null) {
            this.verbose = false;
        } else {
            this.verbose = true;
            if (verboseCategory.isEmpty()) {
                verboseCategory = "all";
            }
        }
        this.verboseCategory = verboseCategory;
    }

    public boolean isVerbose(String category) {
        String categories = this.getVerboseCategory();
        if (categories == null) {
            return false;
        }
        for (String cat : categories.split(",")) {
            if (cat.equals(category)) {
                return true;
            }
            if (!cat.equals("all")) continue;
            return true;
        }
        return false;
    }

    public boolean isNoDefaultRepositories() {
        return this.noDefaultRepositories;
    }

    public void setNoDefaultRepositories(boolean noDefaultRepositories) {
        this.noDefaultRepositories = noDefaultRepositories;
    }

    public String getRun() {
        return this.run;
    }

    public void setRun(String run) {
        this.run = run;
    }

    public String getOverrides() {
        return this.overrides;
    }

    public void setOverrides(String overrides) {
        this.overrides = overrides;
    }

    public boolean isDowngradeDist() {
        return this.downgradeDist;
    }

    public void setDowngradeDist(boolean downgradeDist) {
        this.downgradeDist = downgradeDist;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void mapOptions(CeylonConfig config) {
        this.setTimeout((int)DefaultToolOptions.getDefaultTimeout(config));
        this.setOffline(DefaultToolOptions.getDefaultOffline(config));
        this.setOverrides(DefaultToolOptions.getDefaultOverrides(config));
        this.setRun(DefaultToolOptions.getRunToolRun(config, null));
        this.setDowngradeDist(!DefaultToolOptions.getLinkWithCurrentDistribution(config));
    }

    public static Options fromConfig() {
        return Options.fromConfig(CeylonConfig.get());
    }

    public static Options fromConfig(CeylonConfig config) {
        Options options = new Options();
        options.mapOptions(config);
        return options;
    }
}

