/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.loader.UnknownTypeCollector;
import com.redhat.ceylon.compiler.java.loader.model.CompilerModuleManager;
import com.redhat.ceylon.compiler.java.loader.model.LazyModuleSourceMapper;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.compiler.java.tools.StatusPrinterProgressListener;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleValidator;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.util.List;

public final class CeyloncCompilerDelegate
implements LanguageCompiler.CompilerDelegate {
    private final Context context;
    private CompilerModuleManager moduleManager;
    private LazyModuleSourceMapper moduleSourceMapper;

    public CeyloncCompilerDelegate(Context context) {
        this.context = context;
    }

    @Override
    public CompilerModuleManager getModuleManager() {
        if (this.moduleManager == null) {
            com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = LanguageCompiler.getCeylonContextInstance(this.context);
            this.moduleManager = new CompilerModuleManager(ceylonContext, this.context);
        }
        return this.moduleManager;
    }

    @Override
    public ModuleSourceMapper getModuleSourceMapper() {
        if (this.moduleSourceMapper == null) {
            com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = LanguageCompiler.getCeylonContextInstance(this.context);
            Options options = Options.instance(this.context);
            boolean verbose = options.isSet(Option.VERBOSE);
            CeylonLog log = (CeylonLog)CeylonLog.instance(this.context);
            this.moduleSourceMapper = new LazyModuleSourceMapper(ceylonContext, this.getModuleManager(), this.getStatusPrinter(), verbose, log);
        }
        return this.moduleSourceMapper;
    }

    @Override
    public PhasedUnit getExternalSourcePhasedUnit(VirtualFile srcDir, VirtualFile file) {
        return null;
    }

    @Override
    public void typeCheck(List<PhasedUnit> listOfUnits) {
        StatusPrinter sp = this.getStatusPrinter();
        int size = listOfUnits.size();
        int i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 1, i++, size, pu);
            }
            pu.validateTree();
            pu.scanDeclarations();
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 2, i++, size, pu);
            }
            pu.scanTypeDeclarations();
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 3, i++, size, pu);
            }
            pu.validateRefinement();
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 4, i++, size, pu);
            }
            pu.analyseTypes();
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 5, i++, size, pu);
            }
            pu.analyseFlow();
        }
        i = 1;
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 6, i++, size, pu);
            }
            pu.analyseUsage();
        }
        i = 1;
        UnknownTypeCollector utc = new UnknownTypeCollector();
        for (PhasedUnit pu : listOfUnits) {
            if (sp != null) {
                this.progress(sp, 7, i++, size, pu);
            }
            pu.getCompilationUnit().visit(utc);
        }
    }

    private StatusPrinter getStatusPrinter() {
        boolean isProgressPrinted;
        Options options = Options.instance(this.context);
        boolean bl = isProgressPrinted = options.get(Option.CEYLONPROGRESS) != null && StatusPrinter.canPrint();
        if (isProgressPrinted) {
            return LanguageCompiler.getStatusPrinterInstance(this.context);
        }
        return null;
    }

    private void progress(StatusPrinter sp, int phase, int i, int size, PhasedUnit pu) {
        sp.clearLine();
        sp.log("Typechecking " + phase + "/7 [" + i + "/" + size + "] ");
        sp.log(pu.getPathRelativeToSrcDir());
    }

    @Override
    public void visitModules(PhasedUnits phasedUnits) {
        phasedUnits.visitModules();
    }

    @Override
    public void loadPackageDescriptors(AbstractModelLoader modelLoader) {
        modelLoader.loadPackageDescriptors();
    }

    @Override
    public void resolveModuleDependencies(PhasedUnits phasedUnits) {
        StatusPrinter sp = this.getStatusPrinter();
        com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = LanguageCompiler.getCeylonContextInstance(this.context);
        ModuleValidator validator = new ModuleValidator(ceylonContext, phasedUnits);
        if (sp != null) {
            validator.setListener(new StatusPrinterProgressListener(validator, sp));
            sp.clearLine();
            sp.log("Starting resolving");
        }
        validator.verifyModuleDependencyTree();
        if (sp != null) {
            sp.clearLine();
            sp.log("Done resolving");
        }
    }

    @Override
    public void setupSourceFileObjects(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees, AbstractModelLoader modelLoader) {
        modelLoader.setupSourceFileObjects(trees);
    }

    @Override
    public void loadStandardModules(AbstractModelLoader modelLoader) {
        com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = LanguageCompiler.getCeylonContextInstance(this.context);
        Module languageModule = ceylonContext.getModules().getLanguageModule();
        if (languageModule.getVersion() == null) {
            languageModule.setVersion("1.3.3");
        }
        modelLoader.loadStandardModules();
    }
}

