/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.CachingRepositoryManager;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.Repositories;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.java.codegen.CeylonFileObject;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.CompilerConfig;
import com.redhat.ceylon.compiler.java.tools.JarOutputRepositoryManager;
import com.redhat.ceylon.compiler.java.tools.JavacLogger;
import com.redhat.ceylon.javax.tools.FileObject;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardJavaFileManager;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.tools.javac.api.MultiTaskListener;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.file.RegularFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.RelativePath;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

public class CeyloncFileManager
extends JavacFileManager
implements StandardJavaFileManager {
    private Module currentModule;
    private JarOutputRepositoryManager jarRepository;
    private Context context;
    private Options options;
    private RepositoryManager repoManager;
    private RepositoryManager outputRepoManager;
    private Logger cmrLogger;

    public CeyloncFileManager(Context context, boolean register, Charset charset) {
        super(context, register, charset);
        this.options = Options.instance(context);
    }

    private Logger getLogger() {
        if (this.cmrLogger == null) {
            this.cmrLogger = new JavacLogger(this.options, Log.instance(this.context));
        }
        return this.cmrLogger;
    }

    private JarOutputRepositoryManager getJarRepository() {
        if (this.jarRepository == null) {
            this.jarRepository = new JarOutputRepositoryManager(CeylonLog.instance(this.context), this.options, this, MultiTaskListener.instance(this.context));
        }
        return this.jarRepository;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        super.setContext(context);
    }

    @Override
    public JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension) || name.endsWith(".ceylon")) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    public static void preRegister(Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make(Context context) {
                return new CeyloncFileManager(context, true, null);
            }
        });
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        Iterable<? extends JavaFileObject> theCollection = super.getJavaFileObjectsFromFiles(files);
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (JavaFileObject javaFileObject : theCollection) {
            if (javaFileObject.getName().endsWith(".ceylon")) {
                result.add(new CeylonFileObject(javaFileObject));
                continue;
            }
            result.add(javaFileObject);
        }
        return result;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ListBuffer<JavaFileObject> buf = new ListBuffer<JavaFileObject>();
        for (JavaFileObject f : result) {
            if (f.getName().endsWith(".ceylon")) {
                buf.add(new CeylonFileObject(f));
                continue;
            }
            buf.add(f);
        }
        return buf.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CeylonFileObject) {
            CeylonFileObject fo = (CeylonFileObject)file;
            return super.inferBinaryName(location, fo.getFile());
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    protected JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile fileName, FileObject sibling) throws IOException {
        if (sibling instanceof CeylonFileObject) {
            sibling = ((CeylonFileObject)sibling).getFile();
        }
        if (location == StandardLocation.CLASS_OUTPUT) {
            File siblingFile = null;
            if (sibling != null && sibling instanceof RegularFileObject) {
                siblingFile = ((RegularFileObject)sibling).getUnderlyingFile();
            }
            return this.getJarRepository().getFileObject(this.getOutputRepositoryManager(), this.currentModule, fileName.getPath(), siblingFile);
        }
        return super.getFileForOutput(location, fileName, sibling);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        CeyloncFileManager.nullCheck(location);
        CeyloncFileManager.nullCheck(className);
        CeyloncFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        JavaFileObject file = this.getFileForInput(location, CeyloncFileManager.forClass(className, kind));
        if (file != null && file.getName().endsWith(".ceylon")) {
            return new CeylonFileObject(file);
        }
        return file;
    }

    static RelativePath.RelativeFile forClass(CharSequence className, JavaFileObject.Kind kind) {
        String extension = kind == JavaFileObject.Kind.SOURCE ? ".ceylon" : kind.extension;
        return new RelativePath.RelativeFile(className.toString().replace('.', '/') + extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        super.flush();
        try {
            this.getJarRepository().flush();
        }
        finally {
            this.clearOutputRepositoryManager();
        }
    }

    private void clearOutputRepositoryManager() {
        if (this.outputRepoManager instanceof CachingRepositoryManager) {
            File tmpDir = ((CachingRepositoryManager)this.outputRepoManager).getCacheFolder();
            FileUtil.delete(tmpDir);
            this.outputRepoManager = null;
        }
    }

    public void setModule(Module module) {
        this.currentModule = module;
    }

    public RepositoryManager getRepositoryManager() {
        if (this.repoManager != null) {
            return this.repoManager;
        }
        LinkedList<String> userRepos = new LinkedList<String>();
        if (this.options.getMulti(Option.CEYLONREPO) != null) {
            userRepos.addAll(this.options.getMulti(Option.CEYLONREPO));
        }
        String systemRepo = this.getSystemRepoOption();
        String cacheRepo = this.getCacheRepoOption();
        String outRepo = this.getOutputRepoOption();
        String overrides = this.options.get(Option.CEYLONOVERRIDES);
        boolean upgradeDist = !this.options.getBoolean(Option.CEYLONDOWNGRADEDIST.text);
        this.repoManager = CeylonUtils.repoManager().config(CompilerConfig.instance(this.context)).cwd(this.getCurrentWorkingDir()).upgradeDist(upgradeDist).overrides(overrides).systemRepo(systemRepo).cacheRepo(cacheRepo).noDefaultRepos(this.getNoDefaultRepos()).userRepos(userRepos).outRepo(outRepo).offline(this.getOfflineOption()).timeout(this.getTimeoutOption()).logger(this.getLogger()).buildManager();
        return this.repoManager;
    }

    public RepositoryManager getOutputRepositoryManager() {
        if (this.outputRepoManager != null) {
            return this.outputRepoManager;
        }
        String outRepo = this.getOutputRepoOption();
        String user = this.options.get(Option.CEYLONUSER);
        String password = this.options.get(Option.CEYLONPASS);
        this.outputRepoManager = CeylonUtils.repoManager().config(CompilerConfig.instance(this.context)).cwd(this.getCurrentWorkingDir()).outRepo(outRepo).logger(this.getLogger()).user(user).password(password).timeout(this.getTimeoutOption()).buildOutputManager();
        return this.outputRepoManager;
    }

    protected String getCurrentWorkingDir() {
        return this.options.get(Option.CEYLONCWD);
    }

    private String getSystemRepoOption() {
        return this.options.get(Option.CEYLONSYSTEMREPO);
    }

    private String getCacheRepoOption() {
        return this.options.get(Option.CEYLONCACHEREPO);
    }

    private boolean getNoDefaultRepos() {
        return this.options.get(Option.CEYLONNODEFREPOS) != null;
    }

    private String getOutputRepoOption() {
        return this.options.get(Option.D);
    }

    private boolean getOfflineOption() {
        return this.options.get(Option.CEYLONOFFLINE) != null;
    }

    private int getTimeoutOption() {
        String to = this.options.get(Option.CEYLONTIMEOUT);
        if (to != null) {
            return Integer.parseInt(to);
        }
        return -1;
    }

    @Override
    protected File getClassOutDir() {
        File outDir = super.getClassOutDir();
        if (outDir == null) {
            String dir = Repositories.withConfig(CompilerConfig.instance(this.context)).getOutputRepository().getUrl();
            try {
                super.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(new File(dir)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return outDir;
    }

    @Override
    protected boolean isValidDirectory(String s) {
        return true;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        CeyloncFileManager.nullCheck(a);
        CeyloncFileManager.nullCheck(b);
        return a.equals(b);
    }

    public void setAptRound(boolean b) {
        this.getJarRepository().setAptRound(b);
    }
}

