/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.OsgiUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.jar.Manifest;

public class JarEntryManifestFileObject
implements JavaFileObject {
    private File jarTempFolder;
    private String fileName;
    private Module module;
    private String osgiProvidedBundles;
    private ByteArrayOutputStream baos;
    private JdkProvider jdkProvider;

    public JarEntryManifestFileObject(File jarTempFolder, String fileName, Module module, String osgiProvidedBundles, JdkProvider jdkProvider) {
        this.jarTempFolder = jarTempFolder;
        this.fileName = fileName;
        this.module = module;
        this.osgiProvidedBundles = osgiProvidedBundles;
        this.jdkProvider = jdkProvider;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.baos = new ByteArrayOutputStream();
        return new FilterOutputStream(this.baos){

            @Override
            public void close() throws IOException {
                super.write(10);
                super.close();
            }
        };
    }

    public Manifest writeManifest(Logger log) throws IOException {
        if (this.baos != null) {
            return this.writeManifestJarEntry(this.readManifest(this.baos), log);
        }
        return null;
    }

    private Manifest writeManifestJarEntry(Manifest originalManifest, Logger log) throws IOException {
        Manifest manifest = this.module.isDefaultModule() ? new OsgiUtil.DefaultModuleManifest().build() : new OsgiUtil.OsgiManifest(this.module, this.jdkProvider, this.osgiProvidedBundles, originalManifest, log).build();
        return manifest;
    }

    private Manifest readManifest(ByteArrayOutputStream baos) throws IOException {
        return new Manifest(new ByteArrayInputStream(baos.toByteArray()));
    }

    public int hashCode() {
        int ret = 17;
        ret = 37 * ret + this.jarTempFolder.hashCode();
        ret = 37 * ret + this.fileName.hashCode();
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JarEntryManifestFileObject) {
            JarEntryManifestFileObject r = (JarEntryManifestFileObject)obj;
            return this.jarTempFolder.equals(r.jarTempFolder) && this.fileName.equals(r.fileName);
        }
        return false;
    }

    public String toString() {
        return this.jarTempFolder + ":" + this.fileName;
    }

    @Override
    public URI toUri() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return null;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return null;
    }

    @Override
    public Writer openWriter() throws IOException {
        return null;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return null;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }
}

