/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import com.redhat.ceylon.langtools.classfile.AccessFlags;
import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.Attributes;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.ClassWriter;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.Field;
import com.redhat.ceylon.langtools.classfile.Method;
import com.redhat.ceylon.langtools.classfile.ModuleMainClass_attribute;
import com.redhat.ceylon.langtools.classfile.ModulePackages_attribute;
import com.redhat.ceylon.langtools.classfile.Module_attribute;
import com.redhat.ceylon.langtools.tools.javac.jvm.ClassFile;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Java9Util {
    private static final String METAINF_JBOSSMODULES = "META-INF/jbossmodules/";
    private static final String MODULE_XML = "module.xml";

    private static String sanitiseName(String name) {
        return name.replace('-', '_');
    }

    public static void writeModuleDescriptor(File outputFolder, Java9ModuleDescriptor module) {
        ClassWriter classWriter = new ClassWriter();
        ClassFile classFile = Java9Util.generateModuleDescriptor(module);
        try (FileOutputStream os = new FileOutputStream(new File(outputFolder, "module-info.class"));){
            classWriter.write(classFile, os);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void writeModuleDescriptor(ZipOutputStream zos, Java9ModuleDescriptor module) {
        ClassWriter classWriter = new ClassWriter();
        ClassFile classFile = Java9Util.generateModuleDescriptor(module);
        try {
            zos.putNextEntry(new ZipEntry("module-info.class"));
            classWriter.write(classFile, zos);
            zos.flush();
            zos.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static ClassFile generateModuleDescriptor(Java9ModuleDescriptor module) {
        ConstantPool.CPInfo[] pool = new ConstantPool.CPInfo[8 + module.imports.size() * 2 + module.getPackagesSize() * 2 + (module.main != null ? 3 : 0)];
        ConstantPool constantPool = new ConstantPool(pool);
        int cp = 1;
        pool[cp++] = new ConstantPool.CONSTANT_Utf8_info("module-info");
        pool[cp++] = new ConstantPool.CONSTANT_Class_info(constantPool, 1);
        pool[cp++] = new ConstantPool.CONSTANT_Utf8_info("Module");
        pool[cp++] = new ConstantPool.CONSTANT_Utf8_info("ModulePackages");
        pool[cp++] = new ConstantPool.CONSTANT_Utf8_info(module.version);
        pool[cp++] = new ConstantPool.CONSTANT_Utf8_info(module.name);
        pool[cp++] = new ConstantPool.CONSTANT_Module_info(constantPool, 6);
        if (module.main != null) {
            pool[cp++] = new ConstantPool.CONSTANT_Utf8_info("ModuleMainClass");
            pool[cp++] = new ConstantPool.CONSTANT_Utf8_info(module.main.replace('.', '/'));
            pool[cp++] = new ConstantPool.CONSTANT_Class_info(constantPool, 9);
        }
        int i = 0;
        Module_attribute.RequiresEntry[] requires = new Module_attribute.RequiresEntry[module.imports.size()];
        for (Java9ModuleImport imp : module.imports) {
            pool[cp] = new ConstantPool.CONSTANT_Utf8_info(imp.name);
            pool[cp + 1] = new ConstantPool.CONSTANT_Module_info(constantPool, cp);
            int flag = 0;
            if (imp.exported) {
                flag |= 0x20;
            }
            requires[i] = new Module_attribute.RequiresEntry(cp + 1, flag, 0);
            ++i;
            cp += 2;
        }
        Module_attribute.ExportsEntry[] exports = new Module_attribute.ExportsEntry[module.exportedPackages.size()];
        i = 0;
        int[] modulePackages = new int[module.exportedPackages.size() + module.concealedPackages.size()];
        int m = 0;
        for (String pkg : module.exportedPackages) {
            pool[cp] = new ConstantPool.CONSTANT_Utf8_info(pkg.replace('.', '/'));
            pool[cp + 1] = new ConstantPool.CONSTANT_Package_info(constantPool, cp);
            exports[i++] = new Module_attribute.ExportsEntry(cp + 1, 0, new int[0]);
            modulePackages[m++] = cp + 1;
            cp += 2;
        }
        for (String pkg : module.concealedPackages) {
            pool[cp] = new ConstantPool.CONSTANT_Utf8_info(pkg.replace('.', '/'));
            pool[cp + 1] = new ConstantPool.CONSTANT_Package_info(constantPool, cp);
            modulePackages[m++] = cp + 1;
            cp += 2;
        }
        Attribute[] attributesArray = new Attribute[2 + (module.main != null ? 1 : 0)];
        attributesArray[0] = new Module_attribute(3, 7, 0, 5, requires, exports, new Module_attribute.OpensEntry[0], new int[0], new Module_attribute.ProvidesEntry[0]);
        attributesArray[1] = new ModulePackages_attribute(4, modulePackages);
        if (module.main != null) {
            attributesArray[2] = new ModuleMainClass_attribute(8, 10);
        }
        Attributes attributes = new Attributes(constantPool, attributesArray);
        return new ClassFile(-889275714, ClassFile.Version.V53.minor, ClassFile.Version.V53.major, constantPool, new AccessFlags(32768), 2, 0, new int[0], new Field[0], new Method[0], attributes);
    }

    public static void main(String[] args) throws IOException {
        System.err.println("Add Java9 Module info for " + args[0]);
        String jarName = args[0];
        File jarFile = new File(jarName);
        ZipFile zipFile = new ZipFile(jarFile);
        File outFile = File.createTempFile(jarName, ".jar");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        HashSet<String> packages = new HashSet<String>();
        ModuleInfo info = null;
        String moduleName = null;
        String version2 = null;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.equals("module-info.class")) {
                System.err.println(" Already has a module info!");
                zipFile.close();
                zos.close();
                outFile.delete();
                return;
            }
            if (name.endsWith(".class")) {
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash != -1) {
                    String pkg = name.substring(0, lastSlash).replace('/', '.');
                    packages.add(pkg);
                }
            } else if (name.startsWith(METAINF_JBOSSMODULES) && name.endsWith(MODULE_XML)) {
                String path = name.substring(METAINF_JBOSSMODULES.length());
                int p = (path = path.substring(0, path.length() - MODULE_XML.length() - 1)).lastIndexOf(47);
                if (p > 0) {
                    moduleName = path.substring(0, p).replace('/', '.');
                    version2 = path.substring(p + 1);
                }
                try (InputStream is = zipFile.getInputStream(entry);){
                    info = XmlDependencyResolver.INSTANCE.resolveFromInputStream(is, null, null, null);
                    System.err.println(" Found module descriptor at " + name);
                }
            }
            zos.putNextEntry(entry);
            if (!entry.isDirectory()) {
                IOUtils.copyStream(zipFile.getInputStream(entry), zos, true, false);
            }
            zos.closeEntry();
        }
        zipFile.close();
        if (info != null && moduleName != null && version2 != null) {
            Java9Util.writeModuleDescriptor(zos, new Java9ModuleDescriptor(moduleName, version2, info, packages));
        }
        zos.flush();
        zos.close();
        jarFile.delete();
        Files.copy(outFile.toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        outFile.delete();
    }

    static class Java9ModuleImport {
        final String name;
        final boolean exported;

        Java9ModuleImport(String name, boolean exported) {
            this.name = Java9Util.sanitiseName(name);
            this.exported = exported;
        }
    }

    static class Java9ModuleDescriptor {
        final String name;
        final String version;
        final String main;
        final Set<String> exportedPackages = new HashSet<String>();
        final Set<String> concealedPackages = new HashSet<String>();
        final List<Java9ModuleImport> imports = new LinkedList<Java9ModuleImport>();

        Java9ModuleDescriptor(Module module) {
            this.name = Java9Util.sanitiseName(module.getNameAsString());
            this.version = module.getVersion();
            for (Package pkg : module.getPackages()) {
                if (this.isShared(pkg)) {
                    this.exportedPackages.add(pkg.getNameAsString());
                    continue;
                }
                this.concealedPackages.add(pkg.getNameAsString());
            }
            HashSet<String> importedModules = new HashSet<String>();
            for (ModuleImport imp : module.getImports()) {
                String dependency;
                if (imp.isOptional() || !importedModules.add(dependency = JDKUtils.getJava9ModuleName(imp.getModule().getNameAsString(), imp.getModule().getVersion())) || this.skipModuleImport(dependency)) continue;
                this.imports.add(new Java9ModuleImport(dependency, imp.isExport()));
            }
            this.addImplicitImports();
            this.main = this.getMain(module.getNameAsString());
        }

        public Java9ModuleDescriptor(String name, String version2, ModuleInfo info, Set<String> packages) {
            this.name = Java9Util.sanitiseName(name);
            this.version = version2;
            this.exportedPackages.addAll(packages);
            HashSet<String> importedModules = new HashSet<String>();
            for (ModuleDependencyInfo imp : info.getDependencies()) {
                String dependency;
                if (imp.isOptional() || !importedModules.add(dependency = JDKUtils.getJava9ModuleName(imp.getName(), imp.getVersion())) || this.skipModuleImport(dependency)) continue;
                this.imports.add(new Java9ModuleImport(dependency, imp.isExport()));
            }
            this.addImplicitImports();
            this.main = this.getMain(name);
        }

        private boolean skipModuleImport(String dependency) {
            if (this.name.equals("com.redhat.ceylon.model") && dependency.equals("ceylon.language")) {
                return true;
            }
            return this.name.equals("org.slf4j.api") && dependency.equals("org.slf4j.simple");
        }

        private String getMain(String module) {
            if (module.equals("com.redhat.ceylon.java.main")) {
                return "com.redhat.ceylon.compiler.java.runtime.Main2";
            }
            return null;
        }

        private boolean isShared(Package pkg) {
            String name;
            if (pkg.getModule().isLanguageModule() && ((name = pkg.getNameAsString()).equals("com.redhat.ceylon.compiler.java.runtime.metamodel") || name.equals("com.redhat.ceylon.compiler.java.runtime") || name.equals("com.redhat.ceylon.compiler.java.metadata") || name.equals("com.redhat.ceylon.compiler.java"))) {
                return true;
            }
            return pkg.isShared();
        }

        private void addImplicitImports() {
            for (Java9ModuleImport imp : this.imports) {
                if (!imp.name.equals("java.base")) continue;
                return;
            }
            this.imports.add(new Java9ModuleImport("java.base", true));
        }

        int getPackagesSize() {
            return this.exportedPackages.size() + this.concealedPackages.size();
        }
    }
}

