/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MavenPomUtil {
    public static void writeMavenManifest2(File outputFolder, Module module, JdkProvider jdkProvider) {
        String artifactId;
        String groupId;
        if (module.getGroupId() != null) {
            groupId = module.getGroupId();
            artifactId = MavenPomUtil.artifactId(module);
        } else {
            String moduleName = module.getNameAsString();
            String[] mavenCoordinates = ModuleUtil.getMavenCoordinates(moduleName);
            groupId = mavenCoordinates[0];
            artifactId = mavenCoordinates[1];
        }
        String path = MavenPomUtil.mavenPath(groupId, artifactId);
        File destinationPath = new File(outputFolder, path);
        FileUtil.mkdirs(destinationPath);
        MavenPomUtil.writePomXml(destinationPath, groupId, artifactId, module, jdkProvider);
        MavenPomUtil.writePomProperties(destinationPath, groupId, artifactId, module.getVersion());
    }

    private static void writePomXml(File outputFolder, String groupId, String artifactId, Module module, JdkProvider jdkProvider) {
        try (FileOutputStream os = new FileOutputStream(new File(outputFolder, "pom.xml"));){
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));
            out.writeStartDocument();
            out.writeCharacters("\n");
            out.writeStartElement("project");
            out.writeAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
            out.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            out.writeAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
            out.writeCharacters("\n  ");
            out.writeStartElement("modelVersion");
            out.writeCharacters("4.0.0");
            out.writeEndElement();
            out.writeCharacters("\n  ");
            out.writeStartElement("groupId");
            out.writeCharacters(groupId);
            out.writeEndElement();
            out.writeCharacters("\n  ");
            out.writeStartElement("artifactId");
            out.writeCharacters(artifactId);
            out.writeEndElement();
            out.writeCharacters("\n  ");
            out.writeStartElement("version");
            out.writeCharacters(module.getVersion());
            out.writeEndElement();
            out.writeCharacters("\n  ");
            out.writeStartElement("name");
            out.writeCharacters(module.getNameAsString());
            out.writeEndElement();
            List<ModuleImport> imports = module.getImports();
            if (!imports.isEmpty()) {
                out.writeCharacters("\n  ");
                out.writeStartElement("dependencies");
                for (ModuleImport dep : imports) {
                    String depClassifier;
                    String depArtifactId;
                    String depGroupId;
                    Module moduleDependency;
                    String dependencyName;
                    if (!ModelUtil.isForBackend(dep.getNativeBackends(), Backend.Java) || (dependencyName = (moduleDependency = dep.getModule()).getNameAsString()).equals("ceylon.language") || jdkProvider.isJDKModule(dependencyName)) continue;
                    if (moduleDependency.getGroupId() != null) {
                        depGroupId = moduleDependency.getGroupId();
                        depArtifactId = MavenPomUtil.artifactId(moduleDependency);
                        depClassifier = moduleDependency.getClassifier();
                    } else {
                        String[] mavenCoordinates = ModuleUtil.getMavenCoordinates(dependencyName);
                        depGroupId = mavenCoordinates[0];
                        depArtifactId = mavenCoordinates[1];
                        depClassifier = mavenCoordinates[2];
                    }
                    out.writeCharacters("\n    ");
                    out.writeStartElement("dependency");
                    out.writeCharacters("\n      ");
                    out.writeStartElement("groupId");
                    out.writeCharacters(depGroupId);
                    out.writeEndElement();
                    out.writeCharacters("\n      ");
                    out.writeStartElement("artifactId");
                    out.writeCharacters(depArtifactId);
                    out.writeEndElement();
                    if (depClassifier != null) {
                        out.writeCharacters("\n      ");
                        out.writeStartElement("classifier");
                        out.writeCharacters(depClassifier);
                        out.writeEndElement();
                    }
                    out.writeCharacters("\n      ");
                    out.writeStartElement("version");
                    out.writeCharacters(moduleDependency.getVersion());
                    out.writeEndElement();
                    if (dep.isOptional()) {
                        out.writeCharacters("\n      ");
                        out.writeStartElement("optional");
                        out.writeCharacters("true");
                        out.writeEndElement();
                    }
                    out.writeCharacters("\n    ");
                    out.writeEndElement();
                }
                out.writeCharacters("\n  ");
                out.writeEndElement();
            }
            out.writeCharacters("\n");
            out.writeEndElement();
            out.writeEndDocument();
            out.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private static String artifactId(Module moduleDependency) {
        return moduleDependency.getArtifactId() != null ? moduleDependency.getArtifactId() : moduleDependency.getNameAsString();
    }

    private static void writePomProperties(File outputFolder, String groupId, String artifactId, String version2) {
        try (FileOutputStream os = new FileOutputStream(new File(outputFolder, "pom.properties"));){
            Properties properties = new Properties();
            properties.put("version", version2);
            properties.put("groupId", groupId);
            properties.put("artifactId", artifactId);
            properties.store(os, "Generated by Ceylon");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isMavenDescriptor(String entryFullName, Module module) {
        String artifactId;
        String moduleName = module.getNameAsString();
        String[] mavenCoordinates = ModuleUtil.getMavenCoordinates(moduleName);
        String groupId = mavenCoordinates[0];
        String path = MavenPomUtil.mavenPath(groupId, artifactId = mavenCoordinates[1]);
        return entryFullName.equals(path + "pom.xml") || entryFullName.equals(path + "pom.properties");
    }

    private static String mavenPath(String groupId, String artifactId) {
        return "META-INF/maven/" + groupId + "/" + artifactId + "/";
    }
}

