/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MetaInfServices {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseMetaInfServices(InputStream is) throws UnsupportedEncodingException, IOException {
        HashSet<String> impls = new HashSet<String>(1);
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String line = inputStream.readLine();
            while (line != null) {
                int index = line.indexOf(35);
                if (index != -1) {
                    line = line.substring(0, index);
                }
                if (!line.isEmpty()) {
                    impls.add(line);
                }
                line = inputStream.readLine();
            }
        }
        return impls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<String>> parseAllServices(File carFile) throws IOException, UnsupportedEncodingException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try (JarFile jarFile = new JarFile(carFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("META-INF/services/") || entry.isDirectory()) continue;
                String serviceBinaryName = entry.getName().substring("META-INF/services/".length());
                result.put(serviceBinaryName, MetaInfServices.parseMetaInfServices(jarFile.getInputStream(entry)));
            }
        }
        return result;
    }

    public static void writeAllServices(File outputFolder, Map<String, Set<String>> previousServices) {
        for (Map.Entry<String, Set<String>> serviceEntry : previousServices.entrySet()) {
            String serviceInterface = serviceEntry.getKey();
            Set<String> serviceClasses = serviceEntry.getValue();
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputFolder, "META-INF/services/" + serviceInterface)), "UTF-8");
                Throwable throwable = null;
                try {
                    for (String impl2 : serviceClasses) {
                        ((Writer)writer).append(impl2).append('\n');
                    }
                    ((Writer)writer).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

