/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.tools.StatusPrinterArtifactCallback;
import com.redhat.ceylon.model.cmr.ArtifactResult;

public class StatusPrinterAptProgressListener {
    StatusPrinter sp;

    public StatusPrinterAptProgressListener(StatusPrinter sp) {
        this.sp = sp;
    }

    protected long getNumberOfModulesResolved() {
        return 0L;
    }

    public void retrievingModuleArtifact(ModuleSpec module, ArtifactContext artifactContext) {
        long done;
        long total = done = this.getNumberOfModulesResolved();
        this.sp.clearLine();
        this.sp.log("[" + total + "]: ");
        int moduleSize = this.sp.remainingForPercentage(0.4);
        int versionSize = this.sp.remainingForPercentage(0.1);
        this.sp.log(module.getName(), moduleSize);
        this.sp.log("/");
        this.sp.log(module.getVersion(), versionSize);
        this.sp.captureLine();
        artifactContext.setCallback(new StatusPrinterArtifactCallback(this.sp));
    }

    public void retrievingModuleArtifactFailed(ModuleSpec module, ArtifactContext artifactContext) {
        this.sp.logCapturedLine();
        this.sp.log(" FAIL");
    }

    public void retrievingModuleArtifactSuccess(ModuleSpec module, ArtifactResult artifact) {
        this.sp.logCapturedLine();
        this.sp.log(" OK");
    }
}

