/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ArtifactCallback;
import com.redhat.ceylon.common.StatusPrinter;
import java.io.File;

final class StatusPrinterArtifactCallback
implements ArtifactCallback {
    private StatusPrinter sp;
    private long size;
    private long read;
    private int previousPercentage;

    StatusPrinterArtifactCallback(StatusPrinter sp) {
        this.sp = sp;
    }

    @Override
    public void start(String nodeFullPath, long size, String contentStore) {
        this.size = size;
        this.read = 0L;
        this.previousPercentage = 0;
        this.sp.logCapturedLine();
        int fitOn = Math.max(0, this.sp.getRemaining() - 6);
        this.sp.log(" from " + contentStore + " (" + size / 1024L + "kb)", fitOn);
        this.sp.captureLine();
    }

    @Override
    public void read(byte[] bytes, int length) {
        this.read += (long)length;
        if (this.size != -1L) {
            int percentage = (int)Math.floor((double)this.read / (double)this.size * 100.0);
            if (this.previousPercentage != percentage) {
                this.sp.logCapturedLine();
                this.sp.logRight(" " + percentage + "% ");
                this.previousPercentage = percentage;
            }
        } else {
            this.sp.logRight(" " + this.read / 1024L + "kb ");
        }
    }

    @Override
    public void done(File localFile) {
    }

    @Override
    public void error(File localFile, Throwable err) {
    }
}

