/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.codegen.CeylonCompilationUnit;
import com.redhat.ceylon.compiler.java.tools.CeylonTaskListener;
import com.redhat.ceylon.langtools.source.tree.CompilationUnitTree;
import com.redhat.ceylon.langtools.source.util.TaskEvent;

public class StatusPrinterTaskListener
implements CeylonTaskListener {
    private StatusPrinter sp;

    public StatusPrinterTaskListener(StatusPrinter sp) {
        this.sp = sp;
    }

    @Override
    public void started(TaskEvent e) {
        CompilationUnitTree compilationUnit = e.getCompilationUnit();
        String path = e.getSourceFile().toUri().toString();
        this.sp.clearLine();
        switch (e.getKind()) {
            case ANALYZE: {
                this.sp.log("Javac [typecheck]: " + path);
                break;
            }
            case ENTER: {
                this.sp.log("Javac [enter]: " + path);
                break;
            }
            case GENERATE: {
                this.sp.log("Javac [generate]: " + path);
                break;
            }
            case PARSE: {
                if (compilationUnit instanceof CeylonCompilationUnit) break;
                this.sp.log("Javac [parse]: " + path);
                break;
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
    }

    @Override
    public void moduleCompiled(String name, String version2) {
        this.sp.clearLine();
    }
}

