/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.util;

import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class Util {
    public static String quote(String name) {
        return JVMModuleUtil.quote(name);
    }

    public static String quoteIfJavaKeyword(String name) {
        return JVMModuleUtil.quoteIfJavaKeyword(name);
    }

    public static String[] quoteJavaKeywords(String[] name) {
        return JVMModuleUtil.quoteJavaKeywords(name);
    }

    public static String quoteJavaKeywords(String qualifiedName) {
        return JVMModuleUtil.quoteJavaKeywords(qualifiedName);
    }

    public static String strip(String str) {
        return Naming.stripLeadingDollar(str);
    }

    public static String capitalize(String str) {
        return Naming.capitalize(str);
    }

    public static String getModuleArchiveName(Module module) {
        return Util.getArchiveName(module, "car");
    }

    public static String getSourceArchiveName(Module module) {
        return Util.getArchiveName(module, "src");
    }

    public static String getArchiveName(Module module, String extension) {
        String moduleName = module.getNameAsString();
        moduleName = module.isDefaultModule() ? "default" : moduleName + "-" + module.getVersion();
        return moduleName + "." + extension;
    }

    public static File getModulePath(File outputDir, Module module) {
        String modulePath;
        String moduleName = module.getNameAsString();
        if (module.isDefaultModule()) {
            modulePath = "default";
        } else {
            modulePath = moduleName.replace('.', File.separatorChar);
            modulePath = modulePath + File.separatorChar + module.getVersion();
        }
        return new File(outputDir, modulePath);
    }

    public static String getName(List<String> parts) {
        return JvmBackendUtil.getName(parts);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        outputStream.flush();
    }

    public static boolean isUnboxedVoid(Declaration decl) {
        return decl instanceof Function && ((Function)decl).isDeclaredVoid();
    }

    public static boolean isJavaSource(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.classfile != null) {
            return classSymbol.classfile.getKind() == JavaFileObject.Kind.SOURCE && classSymbol.classfile.getName().endsWith(".java");
        }
        if (classSymbol.sourcefile != null) {
            return classSymbol.sourcefile.getKind() == JavaFileObject.Kind.SOURCE && classSymbol.sourcefile.getName().endsWith(".java");
        }
        return false;
    }

    public static boolean isLoadedFromSource(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.classfile != null) {
            return classSymbol.classfile.getKind() != JavaFileObject.Kind.CLASS;
        }
        if (classSymbol.sourcefile != null) {
            return classSymbol.sourcefile.getKind() != JavaFileObject.Kind.CLASS;
        }
        return false;
    }
}

