/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.AttributeGenerator;
import com.redhat.ceylon.compiler.js.FunctionHelper;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.SequenceGenerator;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BmeGenerator {
    static void generateBme(Tree.BaseMemberExpression bme, GenerateJsVisitor gen) {
        boolean forInvoke = bme.getDirectlyInvoked();
        Declaration decl = bme.getDeclaration();
        if (decl != null) {
            String name = decl.getName();
            Package pkg = decl.getUnit().getPackage();
            if (pkg.isLanguagePackage() && ("true".equals(name) || "false".equals(name) || "null".equals(name))) {
                gen.out(name, new String[0]);
                return;
            }
            if (ModelUtil.isConstructor(decl)) {
                Constructor cd = TypeUtils.getConstructor(decl);
                Declaration cdc = (Declaration)((Object)cd.getContainer());
                if (!gen.qualify(bme, cd)) {
                    gen.out(gen.getNames().name(cdc), gen.getNames().constructorSeparator(decl));
                }
                if (decl instanceof Value) {
                    gen.out(gen.getNames().name(decl), new String[0]);
                } else {
                    gen.out(gen.getNames().name(cd), new String[0]);
                }
                if (!forInvoke && decl instanceof Value) {
                    gen.out("()", new String[0]);
                }
                return;
            }
        }
        String exp = gen.memberAccess(bme, null);
        if (decl == null && gen.isInDynamicBlock()) {
            if ("undefined".equals(exp)) {
                gen.out(exp, new String[0]);
            } else {
                gen.out("(typeof ", exp, "==='undefined'||", exp, "===null?");
                gen.generateThrow(null, "Undefined or null reference: " + exp, bme);
                gen.out(":", exp, ")");
            }
        } else {
            String who;
            boolean isCallable = !forInvoke && (decl instanceof Functional || bme.getUnit().getCallableDeclaration().equals(bme.getTypeModel().getDeclaration()));
            boolean hasTparms = BmeGenerator.hasTypeParameters(bme);
            if (isCallable && (decl.isParameter() || decl.isToplevel() && !hasTparms)) {
                gen.out(exp, new String[0]);
                return;
            }
            String string = who = isCallable && decl.isMember() ? gen.getMember(bme, null) : null;
            if (who == null || who.isEmpty()) {
                ClassOrInterface cont = ModelUtil.getContainingClassOrInterface(bme.getScope());
                String string2 = who = cont == null ? "0" : gen.getNames().self(cont);
            }
            if (isCallable && (who != null || hasTparms)) {
                if (hasTparms) {
                    BmeGenerator.printGenericMethodReference(gen, bme, who, exp);
                } else {
                    gen.out(gen.getClAlias(), "jsc$3(", who, ",", exp, ")");
                }
            } else {
                gen.out(exp, new String[0]);
            }
        }
    }

    static boolean hasTypeParameters(Tree.StaticMemberOrTypeExpression expr) {
        return expr.getTypeArguments() != null && expr.getTypeArguments().getTypeModels() != null && !expr.getTypeArguments().getTypeModels().isEmpty();
    }

    static Map<TypeParameter, Type> createTypeArguments(Tree.StaticMemberOrTypeExpression expr) {
        List<Type> typeModels;
        List<TypeParameter> tparams = null;
        Declaration declaration = expr.getDeclaration();
        if (declaration instanceof Generic) {
            tparams = declaration.getTypeParameters();
        } else if (declaration instanceof TypedDeclaration && ((TypedDeclaration)declaration).getType() != null && ((TypedDeclaration)declaration).getType().isTypeConstructor()) {
            tparams = ((TypedDeclaration)declaration).getType().getDeclaration().getTypeParameters();
        } else {
            expr.addUnexpectedError("Getting type parameters from unidentified declaration type " + declaration, Backend.JavaScript);
            return null;
        }
        HashMap<TypeParameter, Type> targs = new HashMap<TypeParameter, Type>();
        Tree.TypeArguments typeArguments = expr.getTypeArguments();
        if (typeArguments != null && (typeModels = typeArguments.getTypeModels()) != null) {
            Iterator<Type> iter = typeModels.iterator();
            for (TypeParameter tp : tparams) {
                Type pt = iter.hasNext() ? iter.next() : tp.getDefaultTypeArgument();
                targs.put(tp, pt);
            }
        }
        return targs;
    }

    static void printGenericMethodReference(GenerateJsVisitor gen, Tree.StaticMemberOrTypeExpression expr, String who, String member) {
        gen.out(gen.getClAlias(), "jsc$3(", who, ",", member, ",");
        TypeUtils.printTypeArguments(expr, BmeGenerator.createTypeArguments(expr), gen, false, expr.getTypeModel().getVarianceOverrides());
        gen.out(")", new String[0]);
    }

    static void generateMemberAccess(Tree.StaticMemberOrTypeExpression expr, GenerateJsVisitor.GenerateCallback callback, String lhs, GenerateJsVisitor gen) {
        Declaration decl = expr.getDeclaration();
        boolean paren = false;
        String plainName = null;
        if (decl == null && gen.isInDynamicBlock()) {
            plainName = expr.getIdentifier().getText();
        } else if (TypeUtils.isNativeJs(decl)) {
            plainName = decl.getName();
        }
        if (plainName != null) {
            if (lhs != null && lhs.length() > 0) {
                gen.out(lhs, ".");
            }
            gen.out(plainName, "=");
        } else {
            boolean protoCall;
            boolean bl = protoCall = gen.opts.isOptimize() && gen.getSuperMemberScope(expr) != null;
            if (!(!gen.accessDirectly(decl) || protoCall && AttributeGenerator.defineAsProperty(decl))) {
                gen.out(gen.memberAccessBase(expr, decl, true, lhs), "=");
            } else {
                gen.out(gen.memberAccessBase(expr, decl, true, lhs), protoCall ? ".call(this," : "(");
                paren = true;
            }
        }
        callback.generateValue();
        if (paren) {
            gen.out(")", new String[0]);
        }
    }

    static void generateMemberAccess(Tree.StaticMemberOrTypeExpression expr, final String strValue, String lhs, final GenerateJsVisitor gen) {
        BmeGenerator.generateMemberAccess(expr, new GenerateJsVisitor.GenerateCallback(){

            @Override
            public void generateValue() {
                gen.out(strValue, new String[0]);
            }
        }, lhs, gen);
    }

    static void generateQte(Tree.QualifiedTypeExpression that, GenerateJsVisitor gen) {
        boolean dyncall;
        Tree.Primary prim = that.getPrimary();
        Declaration d = that.getDeclaration();
        boolean bl = dyncall = gen.isInDynamicBlock() && d == null;
        if (that.getMemberOperator() instanceof Tree.SpreadOp) {
            SequenceGenerator.generateSpread(that, gen);
        } else if (that.getDirectlyInvoked() && !(that.getMemberOperator() instanceof Tree.SafeMemberOp) && !(prim instanceof Tree.BaseTypeExpression) || dyncall) {
            boolean isQte = prim instanceof Tree.QualifiedTypeExpression;
            if (dyncall && that.getDirectlyInvoked() && !isQte) {
                gen.out("new ", new String[0]);
            }
            if (prim instanceof Tree.BaseMemberExpression) {
                BmeGenerator.generateBme((Tree.BaseMemberExpression)prim, gen);
            } else if (isQte) {
                BmeGenerator.generateQte((Tree.QualifiedTypeExpression)prim, gen);
            } else {
                prim.visit(gen);
            }
            if (dyncall) {
                gen.out(".", that.getIdentifier().getText());
            } else if (ModelUtil.isConstructor(d)) {
                gen.out(gen.getNames().constructorSeparator(d), gen.getNames().name(d));
            } else {
                gen.out(".", gen.getNames().name(d));
            }
        } else {
            boolean parens;
            boolean bl2 = parens = that.getDirectlyInvoked() && prim instanceof Tree.BaseTypeExpression;
            if (parens) {
                gen.out("(", new String[0]);
            }
            FunctionHelper.generateCallable(that, gen.getNames().name(d), gen);
            if (parens) {
                gen.out(")", new String[0]);
            }
        }
    }

    static void generateBte(Tree.BaseTypeExpression that, GenerateJsVisitor gen, boolean forceReference) {
        Declaration d = that.getDeclaration();
        if (d == null && gen.isInDynamicBlock()) {
            String id = that.getIdentifier().getText();
            gen.out("(typeof ", id, "==='undefined'?");
            gen.generateThrow(null, "Undefined type " + id, that);
            gen.out(":", id, ")");
        } else {
            int i;
            boolean wrap = false;
            String pname = null;
            List<Parameter> params = null;
            if ((forceReference || !that.getDirectlyInvoked()) && d instanceof TypeDeclaration && d.isParameterized()) {
                wrap = true;
                pname = gen.getNames().createTempVariable();
                gen.out("function(", new String[0]);
                if (d instanceof Class) {
                    params = ((Class)d).getParameterList().getParameters();
                } else if (d instanceof Constructor) {
                    params = ((Constructor)d).getFirstParameterList().getParameters();
                }
                for (i = 0; i < params.size(); ++i) {
                    if (i > 0) {
                        gen.out(",", new String[0]);
                    }
                    gen.out(pname, "$", Integer.toString(i));
                }
                gen.out("){return ", new String[0]);
            }
            if (d instanceof Constructor) {
                if (gen.getNames().name(d).equals(gen.getNames().name((TypeDeclaration)d.getContainer()))) {
                    gen.qualify(that, (TypeDeclaration)d.getContainer());
                } else {
                    gen.qualify(that, d);
                }
            } else {
                if (d instanceof Class && d.isDynamic()) {
                    gen.out("new ", new String[0]);
                }
                gen.qualify(that, d);
            }
            gen.out(gen.getNames().name(d), new String[0]);
            if (wrap) {
                gen.out("(", new String[0]);
                for (i = 0; i < params.size(); ++i) {
                    gen.out(pname, "$", Integer.toString(i), ",");
                }
                List<Type> targs = that.getTypeArguments() == null ? null : that.getTypeArguments().getTypeModels();
                TypeUtils.printTypeArguments(that, TypeUtils.matchTypeParametersWithArguments(d.getTypeParameters(), targs), gen, false, null);
                gen.out(");}", new String[0]);
            }
        }
    }

    static void generateStaticReference(Node n, Declaration d, GenerateJsVisitor gen) {
        Declaration orig = d instanceof TypedDeclaration ? ((TypedDeclaration)d).getOriginalDeclaration() : d;
        ClassOrInterface coi = (ClassOrInterface)(orig == null ? d : orig).getContainer();
        gen.qualify(n, coi);
        gen.out(gen.getNames().name(coi), ".$st$.", gen.getNames().name(d));
        if (d instanceof Value && ((Value)d).getType().getDeclaration().isAnonymous()) {
            gen.out("()", new String[0]);
        }
    }
}

