/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.Constructors;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.SerializationHelper;
import com.redhat.ceylon.compiler.js.Singletons;
import com.redhat.ceylon.compiler.js.TypeGenerator;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import java.util.ArrayList;
import java.util.List;

public class ClassGenerator {
    static void classDefinition(Tree.ClassDefinition that, GenerateJsVisitor gen, GenerateJsVisitor.InitDeferrer initDeferrer) {
        ArrayList<Tree.Constructor> constructors;
        boolean hasEnumerated;
        List<Tree.Statement> stmts;
        if (TypeGenerator.errVisitor.hasErrors(that)) {
            return;
        }
        Class d = that.getDeclarationModel();
        if (d.isClassOrInterfaceMember() && ((ClassOrInterface)d.getContainer()).isDynamic()) {
            return;
        }
        Class natd = (Class)ModelUtil.getNativeDeclaration((Declaration)d, Backend.JavaScript);
        boolean headerWithoutBackend = NativeUtil.isHeaderWithoutBackend(that, Backend.JavaScript);
        if (natd != null && (headerWithoutBackend || NativeUtil.isNativeHeader(that))) {
            gen.saveNativeHeader(that);
            return;
        }
        if (!NativeUtil.isForBackend(that, Backend.JavaScript) && !headerWithoutBackend) {
            return;
        }
        Tree.ParameterList plist = that.getParameterList();
        if (NativeUtil.isForBackend(d, Backend.JavaScript)) {
            Tree.Declaration nh = gen.getNativeHeader(d);
            if (nh == null && NativeUtil.hasNativeMembers(d)) {
                nh = that;
            }
            stmts = NativeUtil.mergeStatements(that.getClassBody(), nh, Backend.JavaScript);
        } else {
            stmts = that.getClassBody().getStatements();
        }
        Tree.Constructor defconstr = null;
        boolean hasConstructors = d.hasConstructors() || natd != null && natd.hasConstructors();
        boolean bl = hasEnumerated = d.hasEnumerated() || natd != null && natd.hasEnumerated();
        if (hasConstructors) {
            constructors = new ArrayList<Tree.Constructor>(3);
            for (Tree.Statement st : stmts) {
                if (!(st instanceof Tree.Constructor)) continue;
                Tree.Constructor constr = (Tree.Constructor)st;
                constructors.add(constr);
                if (constr.getDeclarationModel().getName() != null) continue;
                defconstr = constr;
            }
        } else {
            constructors = null;
        }
        gen.comment(that);
        boolean isAbstractNative = d.isNativeHeader() && natd != null;
        String typeName = gen.getNames().name(d);
        if (TypeUtils.isNativeExternal(d)) {
            boolean bye = false;
            if (hasConstructors && defconstr == null) {
                gen.out("function ", typeName);
                gen.out("(){", new String[0]);
                gen.generateThrow("Exception", d.getQualifiedNameString() + " has no default constructor.", that);
                gen.out(";}", new String[0]);
                gen.endLine();
            }
            if (gen.stitchNative(d, that)) {
                if (d.isShared()) {
                    gen.share(d);
                }
                TypeGenerator.initializeType(that, gen, initDeferrer);
                bye = true;
            }
            if (hasConstructors) {
                for (Tree.Constructor cnstr : constructors) {
                    Constructors.classConstructor(cnstr, that, constructors, gen);
                }
            }
            if (bye) {
                return;
            }
        }
        gen.out("function ", typeName);
        if (hasConstructors || hasEnumerated) {
            if (defconstr == null) {
                gen.out("(){", new String[0]);
                gen.generateThrow("Exception", d.getQualifiedNameString() + " has no default constructor.", that);
                gen.out(";}", new String[0]);
                gen.endLine();
                gen.out("function ", typeName);
            }
            gen.out("$$c", new String[0]);
        }
        if (isAbstractNative) {
            if (plist != null) {
                for (Parameter p : d.getParameterList().getParameters()) {
                    gen.getNames().forceName(natd.getParameter(p.getName()).getModel(), gen.getNames().name(p));
                }
            }
            for (Declaration hd : d.getMembers()) {
                if (hd.isShared()) continue;
                gen.getNames().forceName(natd.getMember(hd.getName(), null, false), gen.getNames().name(hd));
            }
        }
        boolean withTargs = TypeGenerator.generateParameters(that.getTypeParameterList(), plist, d, gen);
        gen.beginBlock();
        if (!hasConstructors) {
            gen.out("$init$", typeName, "();");
            gen.endLine();
            gen.declareSelf(d);
            gen.referenceOuter(d);
        }
        String me = gen.getNames().self(d);
        if (withTargs) {
            gen.out(gen.getClAlias(), "set_type_args(", me, ",$$targs$$);");
            gen.endLine();
        }
        ClassGenerator.addFunctionTypeArguments(d, me, gen);
        List<Tree.Parameter> defparams = null;
        if (plist != null) {
            defparams = gen.initParameters(plist, d, null);
        }
        ClassGenerator.callSupertypes(that, d, typeName, gen);
        if (!gen.opts.isOptimize() && plist != null) {
            for (Tree.Parameter p : plist.getParameters()) {
                if (p.getParameterModel().isHidden()) continue;
                gen.generateAttributeForParameter(that, d, p.getParameterModel());
            }
        }
        if (!hasConstructors) {
            if (TypeUtils.isNativeExternal(d)) {
                gen.stitchConstructorHelper(that, "_cons_before");
            }
            gen.visitStatements(stmts);
            if (TypeUtils.isNativeExternal(d)) {
                gen.stitchConstructorHelper(that, "_cons_after");
            }
            gen.out("return ", me, ";");
        }
        gen.endBlockNewLine();
        if (defconstr != null) {
            ClassOrInterface coi;
            String _this = "undefined";
            if (!d.isToplevel() && (coi = ModelUtil.getContainingClassOrInterface(d.getContainer())) != null) {
                _this = d.isClassOrInterfaceMember() ? "this" : gen.getNames().self(coi);
            }
            gen.out("function ", typeName, "(){return ", typeName, gen.getNames().constructorSeparator(defconstr.getDeclarationModel()), gen.getNames().name(defconstr.getDeclarationModel()), ".apply(", _this, ",arguments);}");
            gen.endLine();
        }
        if (hasConstructors) {
            for (Tree.Constructor cnstr : constructors) {
                Constructors.classConstructor(cnstr, that, constructors, gen);
            }
        }
        if (hasEnumerated) {
            for (Tree.Statement st : stmts) {
                if (!(st instanceof Tree.Enumerated)) continue;
                Singletons.valueConstructor(that, (Tree.Enumerated)st, gen);
            }
        }
        if (defparams != null) {
            for (Tree.Parameter p : defparams) {
                Tree.SpecifierOrInitializerExpression expr = gen.getDefaultExpression(p);
                if (expr == null) continue;
                gen.out(typeName, ".$defs$", p.getParameterModel().getName(), "=function(", me);
                for (Parameter otherP : d.getParameterList().getParameters()) {
                    if (otherP.equals(p.getParameterModel())) continue;
                    gen.out(",", gen.getNames().name(otherP));
                }
                gen.out("){return ", new String[0]);
                gen.generateParameterExpression(p, expr, d);
                gen.out("};", new String[0]);
            }
        }
        gen.out(typeName, ".$crtmm$=");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)d, that.getAnnotationList(), gen);
        gen.endLine(true);
        if (!isAbstractNative) {
            gen.share(d);
        }
        TypeGenerator.initializeType(that, gen, initDeferrer);
        if (d.isSerializable()) {
            SerializationHelper.addDeserializer(that, d, gen);
        }
    }

    public static void addFunctionTypeArguments(Class d, String objname, GenerateJsVisitor gen) {
        if (!d.isToplevel() && d.getContainer() instanceof Function && !((Function)d.getContainer()).getTypeParameters().isEmpty()) {
            gen.out(gen.getClAlias(), "set_type_args(", objname, ",", gen.getNames().typeArgsParamName((Function)d.getContainer()), ")");
            gen.endLine(true);
        }
    }

    public static void callSupertypes(Tree.ClassDefinition that, Class d, String typeName, GenerateJsVisitor gen) {
        ArrayList<Declaration> superDecs = new ArrayList<Declaration>(3);
        if (!gen.opts.isOptimize()) {
            that.getClassBody().visit(new GenerateJsVisitor.SuperVisitor(superDecs));
        }
        Tree.ExtendedType extendedType = that.getExtendedType();
        Tree.SatisfiedTypes sats = that.getSatisfiedTypes();
        TypeGenerator.callSupertypes(sats == null ? null : TypeUtils.getTypes(sats.getTypes()), extendedType == null ? null : extendedType.getType(), d, that, superDecs, extendedType == null ? null : extendedType.getInvocationExpression(), extendedType == null ? null : ((Class)d.getExtendedType().getDeclaration()).getParameterList(), gen);
    }
}

