/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.ClosureHelper;
import com.redhat.ceylon.compiler.js.ConditionGenerator;
import com.redhat.ceylon.compiler.js.Destructurer;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.RetainedVars;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ComprehensionGenerator {
    private final GenerateJsVisitor gen;
    private final JsIdentifierNames names;
    private final RetainedVars retainedVars = new RetainedVars();
    private final String finished;
    private final Set<Declaration> directAccess;

    ComprehensionGenerator(GenerateJsVisitor gen, JsIdentifierNames names, Set<Declaration> directDeclarations) {
        this.gen = gen;
        this.finished = String.format("%sfinished()", gen.getClAlias());
        this.names = names;
        this.directAccess = directDeclarations;
    }

    private void expressionClause(Tree.ExpressionComprehensionClause startClause, int initialIfClauses, String tail, Tree.Comprehension that) {
        String exhaustionVarName = this.names.createTempVariable();
        this.gen.out("var ", exhaustionVarName, "=false");
        this.gen.endLine(true);
        this.gen.out("return function()", new String[0]);
        this.gen.beginBlock();
        this.gen.out("if(", exhaustionVarName, ") return ", this.finished);
        this.gen.endLine(true);
        this.gen.out(exhaustionVarName, "=true");
        this.gen.endLine(true);
        this.gen.out("return ", new String[0]);
        Tree.Expression _expr = startClause.getExpression();
        if (!this.gen.isNaturalLiteral(_expr.getTerm())) {
            _expr.visit(this.gen);
        }
        this.gen.endBlockNewLine(true);
        for (int i = 0; i < initialIfClauses; ++i) {
            this.gen.endBlock();
        }
        this.gen.endLine();
        this.gen.out(tail, new String[0]);
        this.gen.endBlock();
        this.gen.out(",", new String[0]);
        TypeUtils.printTypeArguments(that, TypeUtils.wrapAsIterableArguments(that.getTypeModel()), this.gen, false, null);
        this.gen.out(")", new String[0]);
    }

    private Tree.Expression gatherLoopsAndVariables(Tree.ForComprehensionClause forClause, Tree.Comprehension that, List<ComprehensionLoopInfo> loops) {
        Tree.Expression expression = null;
        while (forClause != null) {
            ComprehensionLoopInfo loop = new ComprehensionLoopInfo(that, forClause.getForIterator());
            Tree.ComprehensionClause clause = forClause.getComprehensionClause();
            while (clause != null && !(clause instanceof Tree.ForComprehensionClause)) {
                if (clause instanceof Tree.IfComprehensionClause) {
                    Tree.IfComprehensionClause ifClause = (Tree.IfComprehensionClause)clause;
                    loop.conditions.add(ifClause.getConditionList());
                    loop.conditionVars.add(this.gen.conds.gatherVariables(ifClause.getConditionList(), true, false));
                    clause = ifClause.getComprehensionClause();
                    continue;
                }
                if (clause instanceof Tree.ExpressionComprehensionClause) {
                    expression = ((Tree.ExpressionComprehensionClause)clause).getExpression();
                    clause = null;
                    continue;
                }
                that.addError("No support for comprehension clause of type " + clause.getClass().getName(), Backend.JavaScript);
                return expression;
            }
            loops.add(loop);
            forClause = (Tree.ForComprehensionClause)clause;
        }
        return expression;
    }

    void generateComprehension(Tree.Comprehension that) {
        int i;
        this.gen.out(this.gen.getClAlias(), "for$(function()");
        this.gen.beginBlock();
        if (this.gen.opts.isComment()) {
            this.gen.out("//Comprehension", new String[0]);
            this.gen.location(that);
            this.gen.endLine();
        }
        ArrayList<ComprehensionLoopInfo> loops = new ArrayList<ComprehensionLoopInfo>();
        Tree.Expression expression = null;
        Tree.ComprehensionClause startClause = that.getInitialComprehensionClause();
        String tail = null;
        int initialIfClauses = 0;
        while (!(startClause instanceof Tree.ForComprehensionClause)) {
            if (startClause instanceof Tree.IfComprehensionClause) {
                Tree.IfComprehensionClause ifClause = (Tree.IfComprehensionClause)startClause;
                this.gen.conds.specialConditions(this.gen.conds.gatherVariables(ifClause.getConditionList(), true, false), ifClause.getConditionList(), "if", false);
                ++initialIfClauses;
                this.gen.beginBlock();
                startClause = ifClause.getComprehensionClause();
                if (startClause instanceof Tree.IfComprehensionClause) continue;
                tail = "return function(){return " + this.finished + ";}";
                continue;
            }
            if (startClause instanceof Tree.ExpressionComprehensionClause) {
                this.expressionClause((Tree.ExpressionComprehensionClause)startClause, initialIfClauses, tail, that);
                return;
            }
            that.addError("No support for comprehension clause of type " + startClause.getClass().getName(), Backend.JavaScript);
            return;
        }
        expression = this.gatherLoopsAndVariables((Tree.ForComprehensionClause)startClause, that, loops);
        for (int loopIndex = 0; loopIndex < loops.size(); ++loopIndex) {
            int i2;
            String capname;
            boolean isLastLoop;
            ComprehensionLoopInfo loop = (ComprehensionLoopInfo)loops.get(loopIndex);
            this.gen.out("var ", loop.itVarName, "=");
            if (loopIndex == 0) {
                loop.forIterator.getSpecifierExpression().visit(this.gen);
                this.gen.out(".iterator()", new String[0]);
            } else {
                this.gen.out(this.gen.getClAlias(), "emptyIterator()");
            }
            this.gen.out(",", loop.valueVarName, "=", this.finished);
            if (loop.pattern != null) {
                HashSet<Declaration> decs = new HashSet<Declaration>();
                new Destructurer(loop.pattern, null, decs, "", true, false);
                for (Declaration d : decs) {
                    this.gen.out(",", this.names.name(d));
                }
            }
            this.gen.endLine(true);
            boolean bl = isLastLoop = loopIndex == loops.size() - 1;
            if (isLastLoop && loop.conditions.isEmpty() && loop.pattern == null) {
                this.gen.out("var n", loop.valueVarName, "=function(){return ", loop.valueVarName, "=", loop.itVarName, ".next();}");
                this.gen.endLine();
                continue;
            }
            this.gen.out("var n", loop.valueVarName, "=function()");
            this.gen.beginBlock();
            String elemVarName = loop.valueVarName;
            this.gen.out(loop.conditions.isEmpty() ? "if" : "while", "((", elemVarName, "=", loop.itVarName, ".next())!==", this.finished, ")");
            this.gen.beginBlock();
            if (loop.pattern != null) {
                new Destructurer(loop.pattern, this.gen, this.directAccess, elemVarName, true, false);
                this.gen.endLine(true);
            }
            if (loop.valDecl != null && loop.valDecl.isJsCaptured()) {
                capname = this.names.createTempVariable();
                this.gen.out("var ", capname, "=", loop.valueVarName, ";");
                this.names.forceName(loop.valDecl, capname);
            } else {
                capname = null;
            }
            for (i2 = 0; i2 < loop.conditions.size(); ++i2) {
                this.gen.conds.specialConditions(loop.conditionVars.get(i2), loop.conditions.get(i2), "if", false);
                this.gen.beginBlock();
            }
            if (!isLastLoop) {
                ComprehensionLoopInfo nextLoop = (ComprehensionLoopInfo)loops.get(loopIndex + 1);
                this.gen.out(nextLoop.itVarName, "=");
                nextLoop.forIterator.getSpecifierExpression().visit(this.gen);
                this.gen.out(".iterator()", new String[0]);
                this.gen.endLine(true);
            }
            this.gen.out("return ", elemVarName, ";");
            for (i2 = 0; i2 <= loop.conditions.size(); ++i2) {
                this.gen.endBlockNewLine();
            }
            this.retainedVars.emitRetainedVars(this.gen);
            if (loop.pattern != null) {
                this.gen.out("return undefined;", new String[0]);
            } else {
                this.gen.out("return ", this.finished, ";");
            }
            if (capname != null) {
                this.names.forceName(loop.valDecl, null);
            }
            this.gen.endBlockNewLine();
        }
        this.gen.out("return function()", new String[0]);
        this.gen.beginBlock();
        for (int i3 = 1; i3 < loops.size(); ++i3) {
            this.gen.out("do", new String[0]);
            this.gen.beginBlock();
        }
        ComprehensionLoopInfo lastLoop = (ComprehensionLoopInfo)loops.get(loops.size() - 1);
        this.gen.out("if(n", lastLoop.valueVarName, "()!==", lastLoop.pattern == null ? this.finished : "undefined", ")");
        this.gen.beginBlock();
        String tv = this.names.createTempVariable();
        String tempVarName = this.names.createTempVariable();
        this.names.forceName(lastLoop.valDecl, tv);
        this.gen.out("var ", tv, "=", lastLoop.valueVarName, ",");
        if (lastLoop.pattern != null) {
            HashSet<Declaration> decs = new HashSet<Declaration>();
            new Destructurer(lastLoop.pattern, null, decs, "", true, false);
            for (Declaration d : decs) {
                String newDeconstructedVarName = this.names.createTempVariable();
                this.gen.out(newDeconstructedVarName, "=", this.names.name(d), ",");
                this.names.forceName(d, newDeconstructedVarName);
            }
        }
        ArrayList<ConditionGenerator.VarHolder> captureds = null;
        if (expression.getTypeModel() != null && TypeUtils.isCallable(expression.getTypeModel())) {
            captureds = new ArrayList<ConditionGenerator.VarHolder>(loops.size() * 2);
            for (ComprehensionLoopInfo cli : loops) {
                captureds.addAll(cli.containedVars(expression));
            }
        }
        this.gen.out(tempVarName, "=");
        if (captureds != null && !captureds.isEmpty()) {
            this.gen.out("function(", new String[0]);
            boolean first = true;
            for (ConditionGenerator.VarHolder vh : captureds) {
                if (!first) {
                    this.gen.out(",", new String[0]);
                }
                this.gen.out(vh.name, new String[0]);
                first = false;
            }
            this.gen.out("){return ", new String[0]);
        }
        expression.visit(this.gen);
        if (captureds != null && !captureds.isEmpty()) {
            this.gen.out(";}(", new String[0]);
            boolean first = true;
            for (ConditionGenerator.VarHolder vh : captureds) {
                if (!first) {
                    this.gen.out(",", new String[0]);
                }
                this.gen.out(vh.name, new String[0]);
                first = false;
            }
            this.gen.out(")", new String[0]);
        }
        this.gen.endLine(true);
        this.retainedVars.emitRetainedVars(this.gen);
        this.gen.out("return ", tempVarName, ";");
        this.gen.endBlockNewLine();
        for (i = loops.size() - 2; i >= 0; --i) {
            this.gen.endBlock();
            this.gen.out("while(n", ((ComprehensionLoopInfo)loops.get((int)i)).valueVarName, "()!==", ((ComprehensionLoopInfo)loops.get((int)i)).pattern == null ? this.finished : "undefined", ")");
            this.gen.endLine(true);
        }
        this.gen.out("return ", this.finished, ";");
        this.gen.endBlockNewLine();
        if (tail != null) {
            for (i = 0; i < initialIfClauses; ++i) {
                this.gen.endBlock();
            }
            this.gen.endLine();
            this.gen.out(tail, new String[0]);
        }
        this.gen.endBlock();
        this.gen.out(",", new String[0]);
        TypeUtils.printTypeArguments(that, TypeUtils.wrapAsIterableArguments(that.getTypeModel()), this.gen, false, null);
        this.gen.out(")", new String[0]);
    }

    private class ComprehensionLoopInfo {
        public final Tree.ForIterator forIterator;
        public final List<Tree.ConditionList> conditions = new ArrayList<Tree.ConditionList>();
        public final List<List<ConditionGenerator.VarHolder>> conditionVars = new ArrayList<List<ConditionGenerator.VarHolder>>();
        public final String itVarName;
        public final String valueVarName;
        public final Declaration valDecl;
        public final Tree.Pattern pattern;
        private Set<ConditionGenerator.VarHolder> treeVars;

        public ComprehensionLoopInfo(Tree.Comprehension that, Tree.ForIterator forIterator) {
            this.forIterator = forIterator;
            this.itVarName = ComprehensionGenerator.this.names.createTempVariable();
            Tree.Variable valueVar = null;
            if (forIterator instanceof Tree.ValueIterator) {
                valueVar = ((Tree.ValueIterator)forIterator).getVariable();
                this.pattern = null;
                this.valDecl = valueVar.getDeclarationModel();
                this.valueVarName = ComprehensionGenerator.this.names.name(this.valDecl);
                ComprehensionGenerator.this.directAccess.add(this.valDecl);
            } else if (forIterator instanceof Tree.PatternIterator) {
                this.pattern = ((Tree.PatternIterator)forIterator).getPattern();
                valueVar = null;
                this.valDecl = null;
                this.valueVarName = ComprehensionGenerator.this.names.createTempVariable();
            } else {
                that.addError("No support yet for iterators of type " + forIterator.getClass().getName(), Backend.JavaScript);
                this.valueVarName = null;
                this.valDecl = null;
                this.pattern = null;
                return;
            }
        }

        public Set<ConditionGenerator.VarHolder> containedVars(Tree.Expression that) {
            Set<Declaration> expdecs = ClosureHelper.declarationsInExpression(that);
            this.treeVars = new HashSet<ConditionGenerator.VarHolder>(expdecs.size());
            for (List<ConditionGenerator.VarHolder> lvh : this.conditionVars) {
                for (ConditionGenerator.VarHolder vh : lvh) {
                    if (vh.var != null && expdecs.contains(vh.var)) {
                        this.treeVars.add(vh);
                    }
                    if (vh.captured == null) continue;
                    for (Value cap : vh.captured) {
                        if (!expdecs.contains(cap)) continue;
                        this.treeVars.add(vh);
                    }
                }
            }
            return this.treeVars;
        }
    }
}

