/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.JsWriter;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class Destructurer
extends Visitor {
    private final GenerateJsVisitor gen;
    private final JsWriter jsw;
    private final JsIdentifierNames names;
    private final String expvar;
    private final Set<Declaration> directAccess;
    private boolean first;
    private final boolean forAssert;
    private final Set<Tree.Variable> added = new HashSet<Tree.Variable>();
    private final Set<Value> attribs = new HashSet<Value>();
    private final Set<Value> caps = new HashSet<Value>();
    private final Map<Tree.Variable, Integer> spread = new IdentityHashMap<Tree.Variable, Integer>();

    public Destructurer(Tree.Pattern that, GenerateJsVisitor gen, Set<Declaration> directAccess, String expvar, boolean first, boolean forAssert) {
        this.gen = gen;
        this.jsw = gen == null ? null : gen.out;
        this.names = gen == null ? null : gen.getNames();
        this.directAccess = directAccess;
        this.expvar = expvar;
        this.first = first;
        this.forAssert = forAssert;
        that.visit(this);
        if (this.jsw != null && !this.attribs.isEmpty()) {
            for (Value attr : this.attribs) {
                this.jsw.write(";", this.names.self((TypeDeclaration)attr.getContainer()), ".", this.names.name(attr), "=", this.names.name(attr));
            }
        }
    }

    @Override
    public void visit(Tree.TuplePattern that) {
        int idx = 0;
        for (Tree.Pattern p : that.getPatterns()) {
            if (p instanceof Tree.VariablePattern) {
                boolean useRest;
                int minLength;
                boolean isVariadic = ((Tree.VariablePattern)p).getVariable().getType() instanceof Tree.SequencedType;
                int n = minLength = isVariadic ? p.getUnit().getTupleMinimumLength(((Tree.VariablePattern)p).getVariable().getDeclarationModel().getType()) : 0;
                if (minLength > 0) {
                    this.spread.put(((Tree.VariablePattern)p).getVariable(), minLength);
                }
                p.visit(this);
                if (this.jsw == null) continue;
                boolean bl = useRest = isVariadic && idx == 1;
                if (isVariadic) {
                    this.jsw.write(useRest ? ".rest" : ".skip(", new String[0]);
                } else {
                    this.jsw.write(".$_get(", new String[0]);
                }
                if (!useRest) {
                    this.jsw.write(Integer.toString(idx++), ")");
                }
                if (!isVariadic) continue;
                if (minLength > 0) {
                    this.jsw.write(")", new String[0]);
                    continue;
                }
                if (useRest) continue;
                this.jsw.write(".sequence()", new String[0]);
                continue;
            }
            this.added.addAll(new Destructurer(p, this.gen, this.directAccess, this.expvar + ".$_get(" + idx++ + ")", this.first && idx == 0, this.forAssert).getVariables());
        }
    }

    @Override
    public void visit(Tree.KeyValuePattern that) {
        if (that.getKey() instanceof Tree.VariablePattern) {
            that.getKey().visit(this);
            if (this.jsw != null) {
                this.jsw.write(".key", new String[0]);
            }
        } else {
            this.added.addAll(new Destructurer(that.getKey(), this.gen, this.directAccess, this.expvar + ".key", this.first, this.forAssert).getVariables());
            this.first = false;
        }
        if (that.getValue() instanceof Tree.VariablePattern) {
            that.getValue().visit(this);
            if (this.jsw != null) {
                this.jsw.write(".item", new String[0]);
            }
        } else {
            this.added.addAll(new Destructurer(that.getValue(), this.gen, this.directAccess, this.expvar + ".item", false, this.forAssert).getVariables());
        }
    }

    @Override
    public void visit(Tree.VariablePattern that) {
        Tree.Variable v = that.getVariable();
        Value d = v.getDeclarationModel();
        if (this.directAccess != null) {
            this.directAccess.add(d);
        }
        if (d.isClassOrInterfaceMember()) {
            this.attribs.add(d);
        }
        if (d.isJsCaptured()) {
            this.caps.add(d);
        }
        this.added.add(v);
        if (this.first) {
            this.first = false;
        } else if (this.jsw != null) {
            this.jsw.write(",", new String[0]);
        }
        if (this.jsw != null) {
            int minLength;
            this.jsw.write(this.names.name(d), "=");
            int n = minLength = this.spread.containsKey(v) ? this.spread.get(v) : 0;
            if (minLength > 0) {
                this.jsw.write(this.gen.getClAlias(), "$cksprdstr$(", Integer.toString(minLength), ",'", v.getDeclarationModel().getType().asString(), "','", v.getIdentifier().getText(), "','", v.getLocation(), "','", v.getUnit().getFilename(), "',");
            }
            this.jsw.write(this.expvar, new String[0]);
        }
    }

    public Set<Value> getDeclarations() {
        HashSet<Value> decs = new HashSet<Value>(this.added.size());
        for (Tree.Variable v : this.added) {
            decs.add(v.getDeclarationModel());
        }
        return decs;
    }

    public Set<Tree.Variable> getVariables() {
        return this.added;
    }

    public Set<Value> getCapturedValues() {
        return this.caps;
    }
}

