/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocVisitor
extends Visitor {
    private List<String> docs = new ArrayList<String>();
    private Map<String, Integer> locs = new HashMap<String, Integer>();

    private boolean retrieveDocs(List<Annotation> annotations, String location) {
        boolean rval = false;
        for (Annotation ann : annotations) {
            int idx;
            if (!"doc".equals(ann.getName()) || ann.getPositionalArguments().isEmpty()) continue;
            String doc = ann.getPositionalArguments().get(0);
            if (doc.charAt(0) == '\"' && doc.charAt(doc.length() - 1) == '\"') {
                doc = doc.substring(1, doc.length() - 1);
            }
            if ((idx = this.docs.indexOf(doc)) < 0) {
                idx = this.docs.size();
                this.docs.add(doc);
            }
            this.locs.put(location, idx);
            rval = true;
        }
        return rval;
    }

    @Override
    public void visit(Tree.MemberOrTypeExpression that) {
        String loc = that.getLocation();
        if (that.getDeclaration() != null && loc != null) {
            if (that instanceof Tree.QualifiedMemberOrTypeExpression) {
                Tree.QualifiedMemberOrTypeExpression qme = (Tree.QualifiedMemberOrTypeExpression)that;
                loc = qme.getIdentifier().getLocation();
            }
            this.retrieveDocs(that.getDeclaration().getAnnotations(), loc);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        Type t = that.getDeclarationModel().getType();
        if (t != null && t.getDeclaration() != null) {
            this.retrieveDocs(t.getDeclaration().getAnnotations(), that.getType().getLocation());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        if (that instanceof Tree.MethodDeclaration) {
            Tree.MethodDeclaration md = (Tree.MethodDeclaration)that;
            if (md.getSpecifierExpression() != null) {
                md.getSpecifierExpression().visit(this);
            }
        } else {
            Type t = that.getDeclarationModel().getType();
            if (t != null && t.getDeclaration() != null) {
                this.retrieveDocs(t.getDeclaration().getAnnotations(), that.getType().getLocation());
            }
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.SimpleType that) {
        TypeDeclaration d = that.getDeclarationModel();
        if (d != null) {
            this.retrieveDocs(d.getAnnotations(), that.getLocation());
        }
        super.visit(that);
    }

    public List<String> getDocs() {
        return this.docs;
    }

    public Map<String, Integer> getLocations() {
        return this.locs;
    }
}

