/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.Destructurer;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.Set;

public class ForGenerator {
    final GenerateJsVisitor gen;
    private final Set<Declaration> directAccess;
    private final String iterVar;
    private String enteredVar;

    ForGenerator(GenerateJsVisitor generator, Set<Declaration> directAccess) {
        this.gen = generator;
        this.directAccess = directAccess;
        this.iterVar = this.gen.getNames().createTempVariable();
    }

    void generate(Tree.ForStatement that) {
        if (this.gen.opts.isComment() && !this.gen.opts.isMinify()) {
            this.gen.out("//'for' statement at ", that.getUnit().getFilename(), " (", that.getLocation(), ")");
            if (that.getExits()) {
                this.gen.out("//EXITS!", new String[0]);
            }
            this.gen.endLine();
        }
        Tree.ForIterator foriter = that.getForClause().getForIterator();
        boolean hasElse = that.getElseClause() != null && !that.getElseClause().getBlock().getStatements().isEmpty();
        HashSet<Value> caps = new HashSet<Value>();
        String itemVar = this.generateForLoop(foriter, hasElse, caps);
        this.gen.encloseBlockInFunction(that.getForClause().getBlock(), false, caps);
        this.gen.endBlockNewLine();
        if (this.enteredVar != null) {
            this.gen.out("if(!", this.enteredVar, ")");
            this.gen.generateThrow(this.gen.getClAlias() + "AssertionError", "nonempty Iterable with initial 'finished' element", that);
            this.gen.out(";", new String[0]);
        }
        if (hasElse) {
            this.gen.out("if(", this.gen.getClAlias(), "finished()", "===", itemVar, ")");
            this.gen.encloseBlockInFunction(that.getElseClause().getBlock(), true, null);
        }
    }

    private String generateForLoop(Tree.ForIterator that, boolean hasElse, Set<Value> capturedValues) {
        String itemVar;
        Tree.SpecifierExpression iterable = that.getSpecifierExpression();
        boolean captured = false;
        if (that instanceof Tree.ValueIterator) {
            Value val = ((Tree.ValueIterator)that).getVariable().getDeclarationModel();
            captured = val.isJsCaptured();
            if (captured) {
                itemVar = this.gen.getNames().createTempVariable();
                capturedValues.add(val);
            } else {
                itemVar = this.gen.getNames().name(val);
            }
        } else {
            itemVar = this.gen.getNames().createTempVariable();
        }
        boolean isNative = this.iterateNative(iterable.getExpression().getTerm(), itemVar);
        if (!isNative) {
            boolean checkEntered = that.getUnit().isNonemptyIterableType(iterable.getExpression().getTerm().getTypeModel());
            if (hasElse || !this.optimize(iterable, itemVar)) {
                this.gen.out("var ", itemVar);
                if (checkEntered) {
                    this.enteredVar = this.gen.getNames().createTempVariable();
                    this.gen.out(",", this.enteredVar);
                }
                this.gen.out(";for(var ", this.iterVar, "=");
                iterable.visit(this.gen);
                this.gen.out(".iterator();(", itemVar, "=", this.iterVar, ".next())!==", this.gen.getClAlias(), "finished();)");
            }
            this.gen.beginBlock();
            if (this.enteredVar != null) {
                this.gen.out(this.enteredVar, "=true;");
            }
        }
        if (that instanceof Tree.ValueIterator) {
            if (captured) {
                this.gen.out("var ", this.gen.getNames().name(((Tree.ValueIterator)that).getVariable().getDeclarationModel()), "=", itemVar, ";");
            }
            this.directAccess.add(((Tree.ValueIterator)that).getVariable().getDeclarationModel());
        } else if (that instanceof Tree.PatternIterator) {
            this.gen.out("var ", new String[0]);
            Destructurer d = new Destructurer(((Tree.PatternIterator)that).getPattern(), this.gen, this.directAccess, itemVar, true, false);
            if (d.getCapturedValues() != null) {
                capturedValues.addAll(d.getCapturedValues());
            }
            this.gen.endLine(true);
        }
        return itemVar;
    }

    boolean optimize(Tree.SpecifierExpression iterable, String itemVar) {
        Tree.Term term = iterable.getExpression().getTerm();
        if (term instanceof Tree.RangeOp) {
            return this.optimizeRange((Tree.RangeOp)term, itemVar);
        }
        if (term instanceof Tree.SegmentOp) {
            return this.optimizeSegment((Tree.SegmentOp)term, itemVar);
        }
        return false;
    }

    boolean iterateNative(Tree.Term term, String itemVar) {
        if (!this.gen.isInDynamicBlock() || term.getTypeModel() != null && !term.getTypeModel().isUnknown()) {
            return false;
        }
        String termVar = this.gen.getNames().createTempVariable();
        this.gen.out("var ", termVar, "=");
        term.visit(this.gen);
        this.gen.out(";for(var ", this.iterVar, "=0;", this.iterVar, "<", termVar, ".length;", this.iterVar, "++){var ", itemVar, "=", termVar, "[", this.iterVar, "];");
        return true;
    }

    boolean optimizeRange(Tree.RangeOp range, String itemVar) {
        Tree.Term left = range.getLeftTerm();
        Tree.Term right = range.getRightTerm();
        if (left instanceof Tree.NaturalLiteral && right instanceof Tree.NaturalLiteral) {
            try {
                long una = this.gen.parseNaturalLiteral((Tree.NaturalLiteral)left, false);
                long dos = this.gen.parseNaturalLiteral((Tree.NaturalLiteral)right, false);
                this.optimizeNaturals(una, dos, itemVar);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        this.gen.out("var ", itemVar, "=");
        left.visit(this.gen);
        this.gen.out(",", this.iterVar, "=");
        right.visit(this.gen);
        String cmpvar = this.gen.getNames().createTempVariable();
        String nxtvar = this.gen.getNames().createTempVariable();
        String cfvar = this.gen.getNames().createTempVariable();
        this.gen.out(",", cmpvar, "=", itemVar, ".compare(", this.iterVar, "),", nxtvar, "=", cmpvar, "===", this.gen.getClAlias(), "smaller()?'successor':'predecessor';for(var ", cfvar, "=", this.gen.getClAlias(), "eorl$(", cmpvar, ");", cfvar, "(", this.iterVar, ",", itemVar, ");");
        this.gen.out(itemVar, "=", itemVar, "[", nxtvar, "])");
        return true;
    }

    boolean optimizeSegment(Tree.SegmentOp that, String itemVar) {
        Tree.Term left = that.getLeftTerm();
        Tree.Term right = that.getRightTerm();
        boolean leftNat = left instanceof Tree.NaturalLiteral;
        boolean rightNat = right instanceof Tree.NaturalLiteral;
        if (leftNat && rightNat) {
            try {
                long una = this.gen.parseNaturalLiteral((Tree.NaturalLiteral)left, false);
                long dos = this.gen.parseNaturalLiteral((Tree.NaturalLiteral)right, false);
                this.optimizeNaturals(una, una + dos - 1L, itemVar);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        String limvar = rightNat ? Long.toString(this.gen.parseNaturalLiteral((Tree.NaturalLiteral)right, false)) : this.gen.getNames().createTempVariable();
        this.gen.out("var ", itemVar, "=");
        left.visit(this.gen);
        if (!rightNat) {
            this.gen.out(",", limvar, "=");
            right.visit(this.gen);
        }
        this.gen.out(";", new String[0]);
        String tmpvar = this.gen.getNames().createTempVariable();
        this.gen.out("for(var ", tmpvar, "=0;", tmpvar, "<", limvar, ";", tmpvar, "++,(", itemVar, "=", itemVar, ".successor))");
        return true;
    }

    void optimizeNaturals(long from, long to, String itemVar) {
        boolean menor = from < to;
        this.gen.out("for(var ", itemVar, "=", Long.toString(from), ";", itemVar, menor ? "<=" : ">=", Long.toString(to), ";", itemVar, menor ? "++" : "--", ")");
    }
}

