/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.BmeGenerator;
import com.redhat.ceylon.compiler.js.Destructurer;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.TypeGenerator;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FunctionHelper {
    static void multiStmtFunction(final List<Tree.ParameterList> paramLists, final Tree.Block block, final Scope scope, final boolean initSelf, final GenerateJsVisitor gen) {
        FunctionHelper.generateParameterLists(block, paramLists, scope, new ParameterListCallback(){

            @Override
            public void completeFunction() {
                gen.beginBlock();
                if (paramLists.size() == 1 && scope != null && initSelf) {
                    gen.initSelf(block);
                }
                if (scope instanceof Function) {
                    FunctionHelper.addParentMethodTypeParameters((Function)scope, gen);
                }
                gen.initParameters((Tree.ParameterList)paramLists.get(paramLists.size() - 1), scope instanceof TypeDeclaration ? (TypeDeclaration)scope : null, null);
                gen.visitStatements(block.getStatements());
                gen.endBlock();
            }
        }, true, gen);
    }

    static void singleExprFunction(final List<Tree.ParameterList> paramLists, final Tree.Expression expr, final Scope scope, final boolean initSelf, boolean emitFunctionKeyword, final GenerateJsVisitor gen) {
        FunctionHelper.generateParameterLists(expr, paramLists, scope, new ParameterListCallback(){

            @Override
            public void completeFunction() {
                gen.out("{", new String[0]);
                if (paramLists.size() == 1 && scope != null && initSelf) {
                    gen.initSelf(expr);
                }
                if (scope instanceof Function) {
                    FunctionHelper.addParentMethodTypeParameters((Function)scope, gen);
                }
                gen.initParameters((Tree.ParameterList)paramLists.get(paramLists.size() - 1), null, scope instanceof Function ? (Function)scope : null);
                gen.out("return ", new String[0]);
                if (!gen.isNaturalLiteral(expr.getTerm())) {
                    gen.visitSingleExpression(expr);
                }
                gen.out("}", new String[0]);
            }
        }, emitFunctionKeyword, gen);
    }

    static void generateParameterLists(Node context, List<Tree.ParameterList> plist, Scope scope, ParameterListCallback callback, boolean emitFunctionKeyword, GenerateJsVisitor gen) {
        if (plist.size() == 1) {
            if (emitFunctionKeyword) {
                gen.out("function", new String[0]);
            }
            Tree.ParameterList paramList = plist.get(0);
            paramList.visit(gen);
            callback.completeFunction();
        } else {
            ArrayList<MplData> metas = new ArrayList<MplData>(plist.size());
            Function m = scope instanceof Function ? (Function)scope : null;
            for (Tree.ParameterList paramList : plist) {
                MplData mpl = new MplData();
                metas.add(mpl);
                mpl.n = context;
                if (metas.size() == 1) {
                    if (emitFunctionKeyword) {
                        gen.out("function", new String[0]);
                    }
                } else {
                    mpl.name = gen.getNames().createTempVariable();
                    mpl.params = paramList;
                    gen.out("var ", mpl.name, "=function");
                }
                paramList.visit(gen);
                if (metas.size() == 1) {
                    gen.beginBlock();
                    gen.initSelf(context);
                    Scope parent = scope == null ? null : scope.getContainer();
                    gen.initParameters(paramList, parent instanceof TypeDeclaration ? (TypeDeclaration)parent : null, m);
                    continue;
                }
                gen.out("{", new String[0]);
            }
            callback.completeFunction();
            FunctionHelper.closeMPL(metas, m.getType(), gen);
            gen.endBlock();
        }
    }

    static void attributeArgument(Tree.AttributeArgument that, GenerateJsVisitor gen) {
        gen.out("(function()", new String[0]);
        gen.beginBlock();
        if (gen.opts.isVerbose() && that.getParameter() != null) {
            gen.out("//AttributeArgument ", that.getParameter().getName());
            gen.location(that);
            gen.endLine();
        }
        Tree.Block block = that.getBlock();
        Tree.SpecifierExpression specExpr = that.getSpecifierExpression();
        if (specExpr != null) {
            gen.out("return ", new String[0]);
            if (!gen.isNaturalLiteral(specExpr.getExpression().getTerm())) {
                gen.visitSingleExpression(specExpr.getExpression());
            }
        } else if (block != null) {
            gen.visitStatements(block.getStatements());
        }
        gen.endBlock();
        gen.out("())", new String[0]);
    }

    static void objectArgument(final Tree.ObjectArgument that, final GenerateJsVisitor gen) {
        final Class c = (Class)that.getDeclarationModel().getTypeDeclaration();
        gen.out("(function()", new String[0]);
        gen.beginBlock();
        gen.out("//ObjectArgument ", that.getIdentifier().getText());
        gen.location(that);
        gen.endLine();
        gen.out("function ", gen.getNames().name(c), "()");
        gen.beginBlock();
        gen.instantiateSelf(c);
        gen.referenceOuter(c);
        Tree.ExtendedType xt = that.getExtendedType();
        final Tree.ClassBody body = that.getClassBody();
        Tree.SatisfiedTypes sts = that.getSatisfiedTypes();
        ArrayList<Declaration> superDecs = new ArrayList<Declaration>(3);
        if (!gen.opts.isOptimize()) {
            new GenerateJsVisitor.SuperVisitor(superDecs).visit(that.getClassBody());
        }
        TypeGenerator.callSupertypes(sts == null ? null : TypeUtils.getTypes(sts.getTypes()), xt == null ? null : xt.getType(), c, that, superDecs, xt == null ? null : xt.getInvocationExpression(), xt == null ? null : c.getParameterList(), gen);
        body.visit(gen);
        gen.out("return ", gen.getNames().self(c), ";");
        gen.endBlock(false, true);
        gen.out(gen.getNames().name(c), ".$crtmm$=");
        TypeUtils.encodeForRuntime(that, c, gen);
        gen.endLine(true);
        TypeGenerator.typeInitialization(xt, sts, c, new GenerateJsVisitor.PrototypeInitCallback(){

            @Override
            public void addToPrototypeCallback() {
                gen.addToPrototype(that, c, body.getStatements());
            }
        }, gen, null, null);
        gen.out("return ", gen.getNames().name(c), "(new ", gen.getNames().name(c), ".$$);");
        gen.endBlock();
        gen.out("())", new String[0]);
    }

    static void methodArgument(Tree.MethodArgument that, GenerateJsVisitor gen) {
        gen.out("(", new String[0]);
        if (that.getBlock() == null) {
            FunctionHelper.singleExprFunction(that.getParameterLists(), that.getSpecifierExpression().getExpression(), that.getScope(), false, true, gen);
        } else {
            FunctionHelper.multiStmtFunction(that.getParameterLists(), that.getBlock(), that.getScope(), false, gen);
        }
        gen.out(")", new String[0]);
    }

    static void functionArgument(Tree.FunctionArgument that, GenerateJsVisitor gen) {
        gen.out("(", new String[0]);
        if (that.getBlock() == null) {
            FunctionHelper.singleExprFunction(that.getParameterLists(), that.getExpression(), that.getScope(), false, true, gen);
        } else {
            FunctionHelper.multiStmtFunction(that.getParameterLists(), that.getBlock(), that.getScope(), false, gen);
        }
        gen.out(")", new String[0]);
    }

    static void methodDeclaration(TypeDeclaration outer, Tree.MethodDeclaration that, GenerateJsVisitor gen, boolean verboseStitcher) {
        Function m = that.getDeclarationModel();
        if (that.getSpecifierExpression() != null) {
            if (outer == null) {
                if (gen.opts.isOptimize() && m.isMember()) {
                    return;
                }
                gen.comment(that);
                gen.initDefaultedParameters(that.getParameterLists().get(0), that);
                if ((!gen.opts.isOptimize() || !m.isClassOrInterfaceMember()) && TypeUtils.isNativeExternal(m) && gen.stitchNative(m, that)) {
                    if (verboseStitcher) {
                        gen.spitOut("Stitching in native method " + m.getQualifiedNameString() + ", ignoring Ceylon declaration");
                    }
                    if (m.isShared()) {
                        gen.share(m);
                    }
                    return;
                }
                gen.out(m.isToplevel() ? "function " : "var ", new String[0]);
            } else {
                gen.comment(that);
                gen.initDefaultedParameters(that.getParameterLists().get(0), that);
                if (m.isStatic()) {
                    gen.out(gen.getNames().name(outer), ".$st$.");
                } else {
                    gen.out(gen.getNames().self(outer), ".");
                }
            }
            gen.out(gen.getNames().name(m), new String[0]);
            if (!m.isToplevel()) {
                gen.out("=", new String[0]);
            }
            if (TypeUtils.isNativeExternal(m) && gen.stitchNative(m, that)) {
                if (verboseStitcher) {
                    gen.spitOut("Stitching in native method " + m.getQualifiedNameString() + ", ignoring Ceylon declaration");
                }
                if (m.isShared()) {
                    gen.share(m);
                }
                return;
            }
            FunctionHelper.singleExprFunction(that.getParameterLists(), that.getSpecifierExpression().getExpression(), m, true, !m.isToplevel(), gen);
            gen.endLine(true);
            if (outer != null) {
                if (m.isStatic()) {
                    gen.out(gen.getNames().name(outer), ".$st$.");
                } else {
                    gen.out(gen.getNames().self(outer), ".");
                }
            }
            gen.out(gen.getNames().name(m), ".$crtmm$=");
            TypeUtils.encodeMethodForRuntime(that, gen);
            gen.endLine(true);
            gen.share(m);
        } else if (outer == null && m == that.getScope()) {
            if (m.getContainer() instanceof Class && m.isClassOrInterfaceMember()) {
                String name = gen.getNames().name(((Class)m.getContainer()).getParameter(m.getName()));
                if (name != null) {
                    gen.out(gen.getNames().self((Class)m.getContainer()), ".", gen.getNames().name(m), "=", name);
                    gen.endLine(true);
                }
            } else if (m.getContainer() instanceof Function) {
                String name = gen.getNames().name(((Function)m.getContainer()).getParameter(m.getName()));
                gen.getNames().forceName(m, name);
            }
            gen.initDefaultedParameters(that.getParameterLists().get(0), that);
            if ((!gen.opts.isOptimize() || !m.isClassOrInterfaceMember()) && TypeUtils.isNativeExternal(m) && gen.stitchNative(m, that)) {
                if (verboseStitcher) {
                    gen.spitOut("Stitching in native method " + m.getQualifiedNameString() + ", ignoring Ceylon declaration");
                }
                if (m.isShared()) {
                    gen.share(m);
                }
            }
        } else if (m == that.getScope() && m.getContainer() instanceof TypeDeclaration && m.isMember() && (m.isFormal() || TypeUtils.isNativeExternal(m))) {
            gen.out(gen.getNames().self((TypeDeclaration)m.getContainer()), ".", gen.getNames().name(m), "=");
            if (m.isFormal()) {
                gen.out("{$fml:1,$crtmm$:", new String[0]);
                TypeUtils.encodeForRuntime(that, m, gen);
                gen.out("};", new String[0]);
            } else if (TypeUtils.isNativeExternal(m) && gen.stitchNative(m, that)) {
                if (verboseStitcher) {
                    gen.spitOut("Stitching in native method " + m.getQualifiedNameString() + ", ignoring Ceylon declaration");
                }
                if (m.isShared()) {
                    gen.share(m);
                }
            }
        }
    }

    static void methodDefinition(Tree.MethodDefinition that, GenerateJsVisitor gen, boolean needsName, boolean verboseStitcher) {
        Function d = that.getDeclarationModel();
        if (TypeUtils.isNativeExternal(d) && gen.stitchNative(d, that)) {
            if (verboseStitcher) {
                gen.spitOut("Stitching in native method " + d.getQualifiedNameString() + ", ignoring Ceylon definition");
            }
            if (d.isShared()) {
                gen.share(d);
            }
            return;
        }
        if (that.getParameterLists().size() == 1) {
            if (needsName) {
                gen.out("function ", gen.getNames().name(d));
            } else {
                gen.out("function", new String[0]);
            }
            Tree.ParameterList paramList = that.getParameterLists().get(0);
            paramList.visit(gen);
            gen.pushImports(that.getBlock());
            gen.beginBlock();
            if (d.getContainer() instanceof TypeDeclaration) {
                gen.initSelf(that);
            }
            FunctionHelper.addParentMethodTypeParameters(d, gen);
            gen.initParameters(paramList, null, d);
            gen.visitStatements(that.getBlock().getStatements());
            gen.endBlock();
            gen.popImports(that.getBlock());
        } else {
            ArrayList<MplData> metas = new ArrayList<MplData>(that.getParameterLists().size());
            for (Tree.ParameterList paramList : that.getParameterLists()) {
                MplData mpl = new MplData();
                mpl.n = that;
                metas.add(mpl);
                if (metas.size() == 1) {
                    if (needsName) {
                        gen.out("function ", gen.getNames().name(d));
                    } else {
                        gen.out("function", new String[0]);
                    }
                } else {
                    mpl.name = gen.getNames().createTempVariable();
                    mpl.params = paramList;
                    gen.out("var ", mpl.name, "=function");
                }
                paramList.visit(gen);
                gen.beginBlock();
                if (metas.size() == 1 && d.getContainer() instanceof TypeDeclaration) {
                    gen.initSelf(that);
                }
                gen.initParameters(paramList, null, d);
            }
            gen.visitStatements(that.getBlock().getStatements());
            FunctionHelper.closeMPL(metas, d.getType(), gen);
            gen.endBlock();
        }
        if (!gen.share(d)) {
            gen.out(";", new String[0]);
        }
    }

    static void generateLet(Tree.LetExpression that, Set<Declaration> directs, GenerateJsVisitor gen) {
        gen.out("function(){var ", new String[0]);
        boolean first = true;
        HashSet<Value> decs2 = new HashSet<Value>();
        for (Tree.Statement st : that.getLetClause().getVariables()) {
            if (!first) {
                gen.out(",", new String[0]);
            }
            if (st instanceof Tree.Variable) {
                Tree.Variable var = (Tree.Variable)st;
                gen.out(gen.getNames().name(var.getDeclarationModel()), "=");
                var.getSpecifierExpression().getExpression().visit(gen);
                directs.add(var.getDeclarationModel());
                decs2.add(var.getDeclarationModel());
            } else if (st instanceof Tree.Destructure) {
                String expvar = gen.getNames().createTempVariable();
                gen.out(expvar, "=");
                ((Tree.Destructure)st).getSpecifierExpression().visit(gen);
                decs2.addAll(new Destructurer(((Tree.Destructure)st).getPattern(), gen, directs, expvar, false, false).getDeclarations());
            }
            first = false;
        }
        gen.out(";return ", new String[0]);
        gen.visitSingleExpression(that.getLetClause().getExpression());
        gen.out("}()", new String[0]);
        directs.removeAll(decs2);
    }

    private static void closeMPL(List<MplData> mpl, Type rt, GenerateJsVisitor gen) {
        for (int i = mpl.size() - 1; i > 0; --i) {
            MplData pl = mpl.get(i);
            gen.endBlock(true, true);
            pl.outputMetamodelAndReturn(gen, rt);
            if (i <= 1) continue;
            rt = ModelUtil.appliedType((TypeDeclaration)pl.n.getUnit().getCallableDeclaration(), rt, pl.tupleFromParameterList());
        }
    }

    private static boolean copyMissingTypeParameters(Function child, Function parent, int idx, boolean firstOne, GenerateJsVisitor gen) {
        List<TypeParameter> ctp = child.getTypeParameters();
        List<TypeParameter> ptp = parent.getTypeParameters();
        String tpaname = gen.getNames().typeArgsParamName(child) + ".";
        TypeParameter dad = ptp.get(idx);
        TypeParameter kid = ctp.get(idx);
        if (!dad.getName().equals(kid.getName())) {
            String pname = tpaname + dad.getName() + "$" + child.getName();
            if (firstOne) {
                String cname = tpaname + kid.getName() + "$" + child.getName();
                gen.out("if(", cname, "===undefined)", cname, "=", pname);
            } else {
                gen.out("||", pname);
            }
            return true;
        }
        return false;
    }

    static void addParentMethodTypeParameters(Function m, GenerateJsVisitor gen) {
        List<TypeParameter> tps = m.getTypeParameters();
        if (m.isActual() && tps != null && !tps.isEmpty()) {
            Function sm = (Function)m.getRefinedDeclaration();
            for (int i = 0; i < tps.size(); ++i) {
                boolean end = false;
                end |= FunctionHelper.copyMissingTypeParameters(m, sm, i, true, gen);
                if (m.isClassOrInterfaceMember()) {
                    Declaration d;
                    HashSet<Declaration> decs = new HashSet<Declaration>();
                    decs.add(sm);
                    decs.add(m);
                    ClassOrInterface cont = ModelUtil.getContainingClassOrInterface(m);
                    for (TypeDeclaration typeDeclaration : cont.getSupertypeDeclarations()) {
                        d = typeDeclaration.getDirectMember(m.getName(), null, false);
                        if (!(d instanceof Function) || decs.contains(d)) continue;
                        decs.add(d);
                        end |= FunctionHelper.copyMissingTypeParameters(m, (Function)d, i, false, gen);
                    }
                    for (Type type : ((TypeDeclaration)cont).getSatisfiedTypes()) {
                        d = type.getDeclaration().getDirectMember(m.getName(), null, false);
                        if (!(d instanceof Function) || decs.contains(d)) continue;
                        decs.add(d);
                        end |= FunctionHelper.copyMissingTypeParameters(m, (Function)d, i, false, gen);
                    }
                }
                if (!end) continue;
                gen.endLine(true);
            }
        }
    }

    static void generateCallable(Tree.QualifiedMemberOrTypeExpression that, String name, GenerateJsVisitor gen) {
        Declaration d = that.getDeclaration();
        if (that.getPrimary() instanceof Tree.BaseTypeExpression) {
            if (name == null) {
                name = gen.memberAccess(that, "");
            }
            if (ModelUtil.isConstructor(d)) {
                Constructor cd = TypeUtils.getConstructor(d);
                boolean hasTargs = BmeGenerator.hasTypeParameters((Tree.BaseTypeExpression)that.getPrimary());
                if (hasTargs) {
                    if (that.getDirectlyInvoked()) {
                        gen.out(gen.qualifiedPath(that, cd), gen.getNames().constructorSeparator(cd), gen.getNames().name(cd));
                    } else {
                        BmeGenerator.printGenericMethodReference(gen, (Tree.BaseTypeExpression)that.getPrimary(), "0", gen.qualifiedPath(that, cd) + gen.getNames().constructorSeparator(cd) + gen.getNames().name(cd));
                    }
                } else {
                    gen.qualify(that, cd);
                    gen.out(gen.getNames().name(cd), new String[0]);
                    if (cd.isValueConstructor()) {
                        gen.out("()", new String[0]);
                    }
                }
            } else if (d.isStatic()) {
                BmeGenerator.generateStaticReference(that, d, gen);
            } else {
                gen.out("function(x){return ", new String[0]);
                if (BmeGenerator.hasTypeParameters(that)) {
                    BmeGenerator.printGenericMethodReference(gen, that, "x", "x." + name);
                } else {
                    gen.out(gen.getClAlias(), "jsc$3(x,x.", name, ")");
                }
                gen.out(";}", new String[0]);
            }
            return;
        }
        if (d.isToplevel() && d instanceof Function) {
            gen.out(gen.getNames().name(d), new String[0]);
            return;
        }
        String primaryVar = gen.createRetainedTempVar();
        gen.out("(", primaryVar, "=");
        that.getPrimary().visit(gen);
        if (!that.getStaticMethodReferencePrimary() || ModelUtil.isConstructor(that.getDeclaration())) {
            String member;
            gen.out(",", new String[0]);
            String string = member = name == null ? gen.memberAccess(that, primaryVar) : primaryVar + "." + name;
            if (that.getDeclaration() instanceof Function && !((Function)that.getDeclaration()).getTypeParameters().isEmpty()) {
                BmeGenerator.printGenericMethodReference(gen, that, primaryVar, member);
            } else if (that.getUnit().isOptionalType(that.getPrimary().getTypeModel())) {
                gen.out(gen.getClAlias(), "jsc$3(", primaryVar, ",", gen.getClAlias(), "nn$(", primaryVar, ")?", member, ":null)");
            } else {
                gen.out(gen.getClAlias(), "jsc$3(", primaryVar, ",", member, ")");
            }
        }
        gen.out(")", new String[0]);
    }

    private static class MplData {
        String name;
        Node n;
        Tree.ParameterList params;

        private MplData() {
        }

        void outputMetamodelAndReturn(GenerateJsVisitor gen, Type t) {
            gen.out(this.name, ".$crtmm$=function(){return{", "ps", ":");
            TypeUtils.encodeParameterListForRuntime(true, this.n, this.params.getModel(), gen);
            if (t != null) {
                gen.out(",", "$t", ":");
                TypeUtils.typeNameOrList(this.n, t, gen, false);
            }
            gen.out("};};return ", gen.getClAlias(), "jsc$3(0,", this.name, ");");
        }

        Type tupleFromParameterList() {
            if (this.params.getParameters().isEmpty()) {
                return this.n.getUnit().getEmptyType();
            }
            ArrayList<Type> types = new ArrayList<Type>(this.params.getParameters().size());
            int firstDefaulted = -1;
            int count = 0;
            for (Tree.Parameter p : this.params.getParameters()) {
                types.add(p.getParameterModel().getType());
                if (p.getParameterModel().isDefaulted()) {
                    firstDefaulted = count;
                }
                ++count;
            }
            return this.n.getUnit().getTupleType(types, this.params.getParameters().get(this.params.getParameters().size() - 1).getParameterModel().isSequenced(), this.params.getParameters().get(this.params.getParameters().size() - 1).getParameterModel().isAtLeastOne(), firstDefaulted);
        }
    }

    static interface ParameterListCallback {
        public void completeFunction();
    }
}

