/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.BmeGenerator;
import com.redhat.ceylon.compiler.js.FunctionHelper;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.SequenceGenerator;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.RetainedVars;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvocationGenerator {
    private final GenerateJsVisitor gen;
    private final JsIdentifierNames names;
    private final RetainedVars retainedVars;

    InvocationGenerator(GenerateJsVisitor owner, JsIdentifierNames names, RetainedVars rv) {
        this.gen = owner;
        this.names = names;
        this.retainedVars = rv;
    }

    public void generateInvocation(Tree.InvocationExpression that) {
        if (that.getNamedArgumentList() != null) {
            this.namedInvocation(that);
        } else {
            this.positionalInvocation(that);
        }
    }

    private Map<TypeParameter, Type> getTypeArguments(Tree.Primary p) {
        if (p instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression smote = (Tree.StaticMemberOrTypeExpression)p;
            Declaration d = smote.getDeclaration();
            boolean hasTargs = d != null && d.getContainer() instanceof Generic && ((Generic)((Object)d.getContainer())).isParameterized();
            boolean hasParentTargs = TypeUtils.isStaticWithGenericContainer(d);
            if (hasTargs && ModelUtil.isConstructor(d)) {
                return smote.getTarget().getTypeArguments();
            }
            if (hasParentTargs) {
                if (smote.getTypeArguments() != null && !smote.getTypeArguments().getTypeModels().isEmpty()) {
                    HashMap<TypeParameter, Type> targs = new HashMap<TypeParameter, Type>();
                    targs.putAll(smote.getTarget().getTypeArguments());
                    targs.putAll(smote.getTarget().getQualifyingType().getTypeArguments());
                    return targs;
                }
                return smote.getTarget().getQualifyingType().getTypeArguments();
            }
            if (d instanceof Functional) {
                Map<TypeParameter, Type> targs = TypeUtils.matchTypeParametersWithArguments(d.getTypeParameters(), smote.getTypeArguments() == null ? null : smote.getTypeArguments().getTypeModels());
                if (targs == null) {
                    this.gen.out("/*TARGS != TPARAMS!!!!*/", new String[0]);
                }
                return targs;
            }
        } else if (p instanceof Tree.ExtendedTypeExpression) {
            Tree.ExtendedTypeExpression ete = (Tree.ExtendedTypeExpression)p;
            return ete.getTarget().getTypeArguments();
        }
        return null;
    }

    private void namedInvocation(Tree.InvocationExpression that) {
        Tree.Primary typeArgSource = that.getPrimary();
        Tree.NamedArgumentList argList = that.getNamedArgumentList();
        if (this.gen.isInDynamicBlock() && typeArgSource instanceof Tree.MemberOrTypeExpression && ((Tree.MemberOrTypeExpression)typeArgSource).getDeclaration() == null) {
            String fname = this.names.createTempVariable();
            this.gen.out("(", fname, "=");
            if (typeArgSource instanceof Tree.QualifiedTypeExpression) {
                BmeGenerator.generateQte((Tree.QualifiedTypeExpression)typeArgSource, this.gen);
            } else {
                typeArgSource.visit(this.gen);
            }
            this.gen.out(",", fname, ".$$===undefined?new ", fname, "(");
            this.nativeObject(argList);
            this.gen.out("):", fname, "(");
            this.nativeObject(argList);
            this.gen.out("))", new String[0]);
        } else {
            Tree.MemberOrTypeExpression mte;
            this.gen.out("(", new String[0]);
            Map<String, String> argVarNames = this.defineNamedArguments(typeArgSource, argList);
            if (typeArgSource instanceof Tree.BaseMemberExpression) {
                BmeGenerator.generateBme((Tree.BaseMemberExpression)typeArgSource, this.gen);
            } else if (typeArgSource instanceof Tree.QualifiedTypeExpression) {
                BmeGenerator.generateQte((Tree.QualifiedTypeExpression)typeArgSource, this.gen);
            } else {
                typeArgSource.visit(this.gen);
            }
            if (typeArgSource instanceof Tree.MemberOrTypeExpression && (mte = (Tree.MemberOrTypeExpression)typeArgSource).getDeclaration() instanceof Functional) {
                Functional f = (Functional)((Object)mte.getDeclaration());
                Map<TypeParameter, Type> targs = this.getTypeArguments(typeArgSource);
                this.applyNamedArguments(argList, f, argVarNames, this.gen.getSuperMemberScope(mte) != null, targs);
            }
            this.gen.out(")", new String[0]);
        }
    }

    private void positionalInvocation(Tree.InvocationExpression that) {
        boolean hasSpread;
        Tree.Primary typeArgSource = that.getPrimary();
        Tree.PositionalArgumentList argList = that.getPositionalArgumentList();
        Map<TypeParameter, Type> targs = this.getTypeArguments(typeArgSource);
        if (this.gen.isInDynamicBlock() && typeArgSource instanceof Tree.BaseTypeExpression && ((Tree.BaseTypeExpression)typeArgSource).getDeclaration() == null) {
            this.gen.out("(", new String[0]);
            List<String> argnames = this.generatePositionalArguments(typeArgSource, argList, argList.getPositionalArguments(), false, true);
            if (!argnames.isEmpty()) {
                this.gen.out(",", new String[0]);
            }
            String fname = this.names.createTempVariable();
            this.gen.out(fname, "=");
            typeArgSource.visit(this.gen);
            String theargs = "";
            if (!argnames.isEmpty()) {
                theargs = argnames.toString().substring(1);
                theargs = theargs.substring(0, theargs.length() - 1);
            }
            this.gen.out(",", fname, ".$$===undefined?new ", fname, "(", theargs, "):", fname, "(", theargs, "))");
            return;
        }
        Tree.PositionalArgument lastArg = argList.getPositionalArguments().isEmpty() ? null : argList.getPositionalArguments().get(argList.getPositionalArguments().size() - 1);
        boolean bl = hasSpread = lastArg instanceof Tree.SpreadArgument && that.getUnit().isUnknownArgumentsCallable(that.getPrimary().getTypeModel()) && !typeArgSource.getTypeModel().isUnknown();
        if (hasSpread) {
            this.gen.out(this.gen.getClAlias(), "spread$2(");
        }
        if (typeArgSource instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression _bme = (Tree.BaseMemberExpression)typeArgSource;
            if (this.gen.isInDynamicBlock()) {
                Tree.PositionalArgument printArg;
                if (_bme.getDeclaration() == null || _bme.getDeclaration().isDynamic() || _bme.getDeclaration() instanceof TypedDeclaration && ((TypedDeclaration)_bme.getDeclaration()).isDynamicallyTyped()) {
                    if (lastArg instanceof Tree.SpreadArgument && (lastArg.getTypeModel() == null || lastArg.getTypeModel().isUnknown())) {
                        BmeGenerator.generateBme(_bme, this.gen);
                        this.gen.out(".apply(0,", new String[0]);
                        if (argList.getPositionalArguments().size() == 1) {
                            this.generatePositionalArguments(typeArgSource, argList, argList.getPositionalArguments(), false, true);
                        } else {
                            this.gen.out("[", new String[0]);
                            ArrayList<Tree.PositionalArgument> subargs = new ArrayList<Tree.PositionalArgument>(argList.getPositionalArguments().size());
                            subargs.addAll(argList.getPositionalArguments());
                            subargs.remove(subargs.size() - 1);
                            this.generatePositionalArguments(typeArgSource, argList, subargs, false, true);
                            this.gen.out("].concat(", new String[0]);
                            lastArg.visit(this.gen);
                            this.gen.out(")", new String[0]);
                        }
                        this.gen.out(")", new String[0]);
                        return;
                    }
                } else if ("ceylon.language::print".equals(_bme.getDeclaration().getQualifiedNameString()) && ModelUtil.isTypeUnknown((printArg = that.getPositionalArgumentList().getPositionalArguments().get(0)).getTypeModel())) {
                    this.gen.out(this.gen.getClAlias(), "pndo$(");
                    printArg.visit(this.gen);
                    this.gen.out(")", new String[0]);
                    return;
                }
            }
            BmeGenerator.generateBme(_bme, this.gen);
        } else if (typeArgSource instanceof Tree.QualifiedTypeExpression) {
            BmeGenerator.generateQte((Tree.QualifiedTypeExpression)typeArgSource, this.gen);
        } else {
            typeArgSource.visit(this.gen);
        }
        if (this.gen.opts.isOptimize() && this.gen.getSuperMemberScope(typeArgSource) != null) {
            this.gen.out(".call(", this.names.self(ModelUtil.getContainingClassOrInterface(typeArgSource.getScope())));
            if (!argList.getPositionalArguments().isEmpty()) {
                this.gen.out(",", new String[0]);
            }
        } else if (hasSpread) {
            this.gen.out(",", new String[0]);
        } else {
            this.gen.out("(", new String[0]);
        }
        boolean fillInParams = !argList.getPositionalArguments().isEmpty();
        for (Tree.PositionalArgument arg : argList.getPositionalArguments()) {
            fillInParams &= arg.getParameter() == null;
        }
        if (fillInParams) {
            Type callable;
            Interface cd = that.getUnit().getCallableDeclaration();
            Type ed = that.getUnit().getEmptyType();
            Class td = that.getUnit().getTupleDeclaration();
            Type type = callable = typeArgSource.getTypeModel() == null ? null : typeArgSource.getTypeModel().getSupertype(cd);
            if (callable != null) {
                boolean isSequenced;
                Type callableArgs = callable.getTypeArgumentList().get(1);
                boolean isUnion = false;
                if (callableArgs.isUnion()) {
                    if (callableArgs.getCaseTypes().size() == 2) {
                        callableArgs = callableArgs.minus(ed);
                    }
                    isUnion = callableArgs.isUnion();
                }
                boolean bl2 = isSequenced = !isUnion && !td.equals(callableArgs.getDeclaration());
                Type argtype = isUnion ? callableArgs : (callableArgs.isTypeParameter() || callableArgs.isEmpty() ? callableArgs : (callableArgs.isSequence() || callableArgs.isSequential() ? callableArgs.getTypeArgumentList().get(0) : callableArgs.getTypeArgumentList().get(isSequenced ? 0 : 1)));
                Parameter p = null;
                int c = 0;
                for (Tree.PositionalArgument arg : argList.getPositionalArguments()) {
                    if (p == null) {
                        p = new Parameter();
                        p.setName("arg" + c);
                        p.setDeclaration(typeArgSource.getTypeModel().getDeclaration());
                        Value v = new Value();
                        Scope scope = that.getPositionalArgumentList().getScope();
                        v.setContainer(scope);
                        v.setScope(scope);
                        v.setType(argtype);
                        p.setModel(v);
                        if (callableArgs == null || isSequenced) {
                            p.setSequenced(true);
                        } else if (!isSequenced) {
                            Type next;
                            Type type2 = next = isUnion ? null : callableArgs.getTypeArgumentList().get(2);
                            if (next != null && next.getSupertype(td) == null) {
                                if (next.isUnion()) {
                                    callableArgs = next.minus(ed);
                                    isSequenced = !td.equals(callableArgs.getDeclaration());
                                    argtype = callableArgs.getTypeArgumentList().get(isSequenced ? 0 : 1);
                                } else {
                                    argtype = next;
                                    callableArgs = null;
                                }
                            } else {
                                callableArgs = next;
                                argtype = callableArgs == null ? null : callableArgs.getTypeArgumentList().get(1);
                            }
                        }
                    }
                    arg.setParameter(p);
                    ++c;
                    if (p.isSequenced()) continue;
                    p = null;
                }
            }
        }
        this.generatePositionalArguments(typeArgSource, argList, argList.getPositionalArguments(), false, false);
        if (targs != null && !targs.isEmpty() && typeArgSource instanceof Tree.MemberOrTypeExpression && ((Tree.MemberOrTypeExpression)typeArgSource).getDeclaration() instanceof Functional) {
            if (argList.getPositionalArguments().size() > 0) {
                this.gen.out(",", new String[0]);
            }
            Functional bmed = (Functional)((Object)((Tree.MemberOrTypeExpression)typeArgSource).getDeclaration());
            int argsSize = argList.getPositionalArguments().size();
            int paramArgDiff = bmed.getFirstParameterList().getParameters().size() - argsSize;
            if (paramArgDiff > 0) {
                Tree.PositionalArgument parg;
                Tree.PositionalArgument positionalArgument = parg = argsSize > 0 ? argList.getPositionalArguments().get(argsSize - 1) : null;
                if (parg instanceof Tree.Comprehension || parg instanceof Tree.SpreadArgument) {
                    --paramArgDiff;
                }
                for (int i = 0; i < paramArgDiff; ++i) {
                    this.gen.out("undefined,", new String[0]);
                }
            }
            if (targs != null && !targs.isEmpty()) {
                TypeUtils.printTypeArguments(typeArgSource, targs, this.gen, false, null);
            }
        }
        this.gen.out(")", new String[0]);
    }

    Map<String, String> defineNamedArguments(Tree.Primary primary, Tree.NamedArgumentList argList) {
        HashMap<String, String> argVarNames = new HashMap<String, String>();
        for (Tree.NamedArgument arg : argList.getNamedArguments()) {
            Parameter p = arg.getParameter();
            String paramName = p == null && this.gen.isInDynamicBlock() ? arg.getIdentifier().getText() : arg.getParameter().getName();
            String varName = this.names.createTempVariable();
            argVarNames.put(paramName, varName);
            this.retainedVars.add(varName);
            this.gen.out(varName, "=");
            if (arg instanceof Tree.MethodArgument) {
                Tree.MethodArgument marg = (Tree.MethodArgument)arg;
                this.gen.out(this.gen.getClAlias(), "jsc$2(");
                FunctionHelper.methodArgument(marg, this.gen);
                this.gen.out(",", new String[0]);
                TypeUtils.encodeParameterListForRuntime(true, arg, marg.getParameterLists().get(0).getModel(), this.gen);
                this.gen.out(",", new String[0]);
                Type margType = marg.getDeclarationModel().getType().getFullType();
                TypeUtils.printTypeArguments(arg, margType.getTypeArguments(), this.gen, false, margType.getVarianceOverrides());
                this.gen.boxUnboxEnd(4);
            } else {
                arg.visit(this.gen);
            }
            this.gen.out(",", new String[0]);
        }
        Tree.SequencedArgument sarg = argList.getSequencedArgument();
        if (sarg != null) {
            String paramName = sarg.getParameter().getName();
            String varName = this.names.createTempVariable();
            argVarNames.put(paramName, varName);
            this.retainedVars.add(varName);
            this.gen.out(varName, "=");
            this.generatePositionalArguments(primary, argList, sarg.getPositionalArguments(), true, false);
            this.gen.out(",", new String[0]);
        }
        return argVarNames;
    }

    void applyNamedArguments(Tree.NamedArgumentList argList, Functional func, Map<String, String> argVarNames, boolean superAccess, Map<TypeParameter, Type> targs) {
        ParameterList plist = func.getFirstParameterList();
        boolean first = true;
        if (superAccess) {
            this.gen.out(".call(this", new String[0]);
            if (!plist.getParameters().isEmpty()) {
                this.gen.out(",", new String[0]);
            }
        } else {
            this.gen.out("(", new String[0]);
        }
        for (Parameter p : plist.getParameters()) {
            String vname;
            if (!first) {
                this.gen.out(",", new String[0]);
            }
            if ((vname = argVarNames.get(p.getName())) == null) {
                if (p.isDefaulted()) {
                    this.gen.out("undefined", new String[0]);
                } else {
                    this.gen.out(this.gen.getClAlias(), "empty()");
                }
            } else {
                this.gen.out(vname, new String[0]);
            }
            first = false;
        }
        if (targs != null && !targs.isEmpty()) {
            if (!first) {
                this.gen.out(",", new String[0]);
            }
            TypeUtils.printTypeArguments(argList, targs, this.gen, false, null);
        }
        this.gen.out(")", new String[0]);
    }

    List<String> generatePositionalArguments(Tree.Primary primary, Tree.ArgumentList that, List<Tree.PositionalArgument> args, boolean forceSequenced, boolean generateVars) {
        if (args.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> argvars = new ArrayList<String>(args.size());
        boolean first = true;
        boolean opened = false;
        Type sequencedType = null;
        for (Tree.PositionalArgument arg : args) {
            Tree.Expression expr;
            Parameter pd = arg.getParameter();
            if (arg instanceof Tree.ListedArgument) {
                boolean dyncheck;
                if (!first) {
                    this.gen.out(",", new String[0]);
                }
                expr = ((Tree.ListedArgument)arg).getExpression();
                Type exprType = expr.getTypeModel();
                boolean bl = dyncheck = this.gen.isInDynamicBlock() && pd != null && !ModelUtil.isTypeUnknown(pd.getType()) && exprType.containsUnknowns();
                if (forceSequenced || pd != null && pd.isSequenced()) {
                    Type elemtype;
                    if (dyncheck) {
                        exprType = pd.getType();
                    }
                    if (pd == null || pd.getType().getTypeArgumentList().isEmpty()) {
                        elemtype = exprType;
                    } else {
                        elemtype = pd.getType().getTypeArgumentList().get(0);
                        if (!elemtype.isTypeParameter()) {
                            elemtype = exprType;
                        }
                    }
                    sequencedType = sequencedType == null ? elemtype : ModelUtil.unionType(elemtype, sequencedType, that.getUnit());
                    if (!opened) {
                        if (generateVars) {
                            String argvar = this.names.createTempVariable();
                            argvars.add(argvar);
                            this.gen.out(argvar, "=");
                        }
                        if (exprType.isSequential() || pd != null && pd.isSequenced()) {
                            this.gen.out(this.gen.getClAlias(), "$arr$sa$([");
                        } else {
                            int argpos;
                            ArrayList<Tree.PositionalArgument> seqargs = new ArrayList<Tree.PositionalArgument>(args.size() - argpos + 1);
                            for (argpos = args.indexOf(arg); argpos < args.size(); ++argpos) {
                                seqargs.add(args.get(argpos));
                            }
                            Tree.PositionalArgument lastArg = (Tree.PositionalArgument)seqargs.get(seqargs.size() - 1);
                            if (sequencedType.isTypeParameter()) {
                                sequencedType = that.getUnit().getIterableType(sequencedType);
                            }
                            SequenceGenerator.lazyEnumeration(seqargs, primary, sequencedType, lastArg instanceof Tree.SpreadArgument || lastArg instanceof Tree.Comprehension, this.gen);
                            return argvars;
                        }
                    }
                    opened = true;
                } else if (generateVars) {
                    String argvar = this.names.createTempVariable();
                    argvars.add(argvar);
                    this.gen.out(argvar, "=");
                }
                int boxType = pd == null ? 0 : this.gen.boxUnboxStart(expr.getTerm(), pd.getModel());
                Map<TypeParameter, Type> targs = null;
                if (dyncheck) {
                    if (primary instanceof Tree.MemberOrTypeExpression) {
                        targs = ((Tree.MemberOrTypeExpression)primary).getTarget().getTypeArguments();
                    }
                    TypeUtils.generateDynamicCheck(expr, pd.getType(), this.gen, false, targs);
                } else {
                    arg.visit(this.gen);
                }
                if (boxType == 4) {
                    Tree.Term argTerm;
                    this.gen.out(",", new String[0]);
                    this.describeMethodParameters(expr.getTerm());
                    this.gen.out(",", new String[0]);
                    targs = arg.getTypeModel().getTypeArguments();
                    if (arg instanceof Tree.ListedArgument && (argTerm = ((Tree.ListedArgument)arg).getExpression().getTerm()) instanceof Tree.MemberOrTypeExpression) {
                        targs = ((Tree.MemberOrTypeExpression)argTerm).getTarget().getTypeArguments();
                    }
                    TypeUtils.printTypeArguments(arg, targs, this.gen, false, arg.getTypeModel().getVarianceOverrides());
                }
                this.gen.boxUnboxEnd(boxType);
            } else if (arg instanceof Tree.SpreadArgument || arg instanceof Tree.Comprehension) {
                boolean isSpreadArg = arg instanceof Tree.SpreadArgument;
                expr = isSpreadArg ? ((Tree.SpreadArgument)arg).getExpression() : null;
                boolean chained = false;
                if (opened) {
                    SequenceGenerator.closeSequenceWithReifiedType(that, TypeUtils.wrapAsIterableArguments(sequencedType), this.gen, false);
                    this.gen.out(".chain(", new String[0]);
                    sequencedType = null;
                    chained = true;
                } else if (!first) {
                    this.gen.out(",", new String[0]);
                }
                if (isSpreadArg) {
                    this.generateSpreadArgument(primary, (Tree.SpreadArgument)arg, expr, pd);
                } else {
                    arg.visit(this.gen);
                    if (pd != null && pd.getType().isSequential() && !arg.getTypeModel().isSequential() && !arg.getTypeModel().isUnknown()) {
                        this.gen.out(".sequence()", new String[0]);
                    }
                }
                if (opened) {
                    Map<TypeParameter, SiteVariance> _vo;
                    Map<TypeParameter, Type> _targs;
                    this.gen.out(",", new String[0]);
                    if (expr == null) {
                        _targs = TypeUtils.wrapAsIterableArguments(arg.getTypeModel());
                        _vo = null;
                    } else {
                        Type spreadType = TypeUtils.findSupertype(that.getUnit().getSequentialDeclaration(), expr.getTypeModel());
                        if (spreadType == null) {
                            spreadType = TypeUtils.findSupertype(that.getUnit().getIterableDeclaration(), expr.getTypeModel());
                        }
                        _targs = spreadType.getTypeArguments();
                        _vo = spreadType.getVarianceOverrides();
                    }
                    if (chained) {
                        Type[] _tlist = new Type[2];
                        for (TypeParameter tp : _targs.keySet()) {
                            if ("Element".equals(tp.getName())) {
                                _tlist[0] = _targs.get(tp);
                                continue;
                            }
                            if (!"Absent".equals(tp.getName())) continue;
                            _tlist[1] = _targs.get(tp);
                        }
                        if (_tlist[1] == null) {
                            _tlist[1] = that.getUnit().getNothingType();
                        }
                        Function cdec = (Function)that.getUnit().getIterableDeclaration().getMember("chain", null, false);
                        _targs = TypeUtils.matchTypeParametersWithArguments(cdec.getTypeParameters(), Arrays.asList(_tlist));
                    }
                    TypeUtils.printTypeArguments(that, _targs, this.gen, false, _vo);
                    this.gen.out(")", new String[0]);
                    if (chained) {
                        this.gen.out(".sequence()", new String[0]);
                    }
                }
                if (arg instanceof Tree.Comprehension) break;
            }
            first = false;
        }
        if (sequencedType != null) {
            Map<TypeParameter, Type> seqtargs = forceSequenced && args.size() > 0 ? that.getUnit().getNonemptyIterableType(sequencedType).getTypeArguments() : TypeUtils.wrapAsIterableArguments(sequencedType);
            SequenceGenerator.closeSequenceWithReifiedType(primary, seqtargs, this.gen, false);
        }
        return argvars;
    }

    private void generateSpreadArgument(Tree.Primary primary, Tree.SpreadArgument arg, Tree.Expression expr, Parameter pd) {
        FunctionOrValue td = pd == null ? null : pd.getModel();
        int boxType = this.gen.boxUnboxStart(expr.getTerm(), td);
        if (boxType == 4) {
            arg.visit(this.gen);
            this.gen.out(",", new String[0]);
            this.describeMethodParameters(expr.getTerm());
            this.gen.out(",", new String[0]);
            TypeUtils.printTypeArguments(arg, arg.getTypeModel().getTypeArguments(), this.gen, false, arg.getTypeModel().getVarianceOverrides());
        } else if (pd == null) {
            Declaration primDec;
            Declaration declaration = primDec = primary instanceof Tree.MemberOrTypeExpression ? ((Tree.MemberOrTypeExpression)primary).getDeclaration() : null;
            if (this.gen.isInDynamicBlock() && primary instanceof Tree.MemberOrTypeExpression && (primDec == null || primDec.isDynamic() || primDec instanceof TypedDeclaration && ((TypedDeclaration)primDec).isDynamicallyTyped()) && arg.getTypeModel() != null && arg.getTypeModel().getDeclaration().inherits(arg.getUnit().getTupleDeclaration())) {
                Type tupleType = arg.getTypeModel();
                Type targ = tupleType.getTypeArgumentList().get(2);
                arg.visit(this.gen);
                this.gen.out(".$_get(0)", new String[0]);
                int i = 1;
                while (!targ.isSubtypeOf(arg.getUnit().getEmptyType())) {
                    this.gen.out(",", new String[0]);
                    arg.visit(this.gen);
                    this.gen.out(".$_get(" + i++ + ")", new String[0]);
                    targ = targ.getTypeArgumentList().get(2);
                }
            } else {
                arg.visit(this.gen);
            }
        } else if (pd.isSequenced()) {
            arg.visit(this.gen);
            if (!arg.getUnit().isSequentialType(arg.getTypeModel())) {
                this.gen.out(".sequence()", new String[0]);
            }
        } else if (!arg.getTypeModel().isEmpty()) {
            List<Parameter> moreParams;
            String get1;
            String specialSpreadVar = this.gen.getNames().createTempVariable();
            this.gen.out("(", specialSpreadVar, "=");
            arg.visit(this.gen);
            boolean unknownSpread = arg.getTypeModel().isUnknown();
            String get0 = unknownSpread ? "[" : ".$_get(";
            String string = get1 = unknownSpread ? "]" : ")";
            if (!unknownSpread && !arg.getUnit().isSequentialType(arg.getTypeModel())) {
                this.gen.out(".sequence()", new String[0]);
            }
            this.gen.out(",", new String[0]);
            if (pd.isDefaulted()) {
                this.gen.out(this.gen.getClAlias(), "nn$(", specialSpreadVar, get0, "0", get1, ")?", specialSpreadVar, get0, "0", get1, ":undefined)");
            } else {
                this.gen.out(specialSpreadVar, get0, "0", get1, ")");
            }
            Declaration pdd = pd.getDeclaration();
            boolean found = false;
            if (pdd instanceof Function) {
                moreParams = ((Function)pdd).getFirstParameterList().getParameters();
            } else if (pdd instanceof Class) {
                moreParams = ((Class)pdd).getParameterList().getParameters();
            } else {
                List<Parameter> cparms = TypeUtils.convertTupleToParameters(primary.getTypeModel().getTypeArgumentList().get(1));
                cparms.remove(0);
                moreParams = cparms;
                found = true;
            }
            if (moreParams != null) {
                int c = 1;
                for (Parameter restp : moreParams) {
                    if (found) {
                        String cs = Integer.toString(c++);
                        if (restp.isDefaulted()) {
                            this.gen.out(",", this.gen.getClAlias(), "nn$(", specialSpreadVar, get0, cs, get1, ")?", specialSpreadVar, get0, cs, get1, ":undefined");
                            continue;
                        }
                        if (restp.isSequenced()) {
                            if (c == 2) {
                                this.gen.out(",", specialSpreadVar, ".rest");
                                continue;
                            }
                            this.gen.out(",", specialSpreadVar, ".sublistFrom(", cs, ")");
                            continue;
                        }
                        this.gen.out(",", specialSpreadVar, get0, cs, get1);
                        continue;
                    }
                    found = restp.equals(pd);
                }
            }
        }
        this.gen.boxUnboxEnd(boxType);
    }

    void nativeObject(Tree.NamedArgumentList argList) {
        List<Tree.NamedArgument> nargs = argList.getNamedArguments();
        if (argList.getSequencedArgument() == null) {
            String tmpobjvar;
            ArrayList<Tree.NamedArgument> getters = null;
            for (Tree.NamedArgument arg : nargs) {
                if (!(arg instanceof Tree.AttributeArgument)) continue;
                if (getters == null) {
                    getters = new ArrayList<Tree.NamedArgument>(nargs.size());
                }
                getters.add(arg);
            }
            String string = tmpobjvar = getters == null ? null : this.gen.createRetainedTempVar();
            if (getters != null) {
                this.gen.out("(", tmpobjvar, "=");
            }
            this.gen.out("{", new String[0]);
            boolean first = true;
            for (Tree.NamedArgument arg : nargs) {
                if (arg instanceof Tree.AttributeArgument) continue;
                if (first) {
                    first = false;
                } else {
                    this.gen.out(",", new String[0]);
                }
                String string2 = arg.getIdentifier().getText();
                if (JsIdentifierNames.isTrueReservedWord(string2)) {
                    this.gen.out("\"", string2, "\"");
                } else {
                    this.gen.out(string2, new String[0]);
                }
                this.gen.out(":", new String[0]);
                arg.visit(this.gen);
            }
            this.gen.out("}", new String[0]);
            if (getters != null) {
                for (Tree.NamedArgument arg : getters) {
                    if (first) {
                        first = false;
                    } else {
                        this.gen.out(",", new String[0]);
                    }
                    this.gen.out("Object.defineProperty(", tmpobjvar, ",'");
                    if (!(arg instanceof Tree.AttributeArgument)) continue;
                    String string3 = arg.getIdentifier().getText();
                    if (JsIdentifierNames.isTrueReservedWord(string3)) {
                        this.gen.out("\"", string3, "\"");
                    } else {
                        this.gen.out(string3, new String[0]);
                    }
                    this.gen.out("',{get:function(){ return ", new String[0]);
                    this.gen.visitSingleExpression(((Tree.AttributeArgument)arg).getSpecifierExpression().getExpression());
                    this.gen.out("},configurable:true,enumerable:true})", new String[0]);
                }
                this.gen.out(",", tmpobjvar, ")");
            }
        } else {
            boolean isSpread;
            String arr = null;
            boolean isComp = false;
            boolean bl = isSpread = argList.getSequencedArgument() != null && !argList.getSequencedArgument().getPositionalArguments().isEmpty() && argList.getSequencedArgument().getPositionalArguments().get(argList.getSequencedArgument().getPositionalArguments().size() - 1) instanceof Tree.SpreadArgument;
            if (nargs.size() > 0) {
                this.gen.out("function()", new String[0]);
                this.gen.beginBlock();
                arr = this.names.createTempVariable();
                this.gen.out("var ", arr, "=");
            } else {
                boolean bl2 = isComp = argList.getSequencedArgument().getPositionalArguments().size() == 1 && argList.getSequencedArgument().getPositionalArguments().get(0) instanceof Tree.Comprehension;
            }
            if (isComp) {
                this.gen.out(this.gen.getClAlias(), "nfor$(");
            } else if (isSpread) {
                this.gen.out(this.gen.getClAlias(), "tpl$([");
            } else {
                this.gen.out("[", new String[0]);
            }
            boolean first = true;
            for (Tree.PositionalArgument positionalArgument : argList.getSequencedArgument().getPositionalArguments()) {
                if (positionalArgument instanceof Tree.SpreadArgument) {
                    this.gen.out("],", new String[0]);
                    positionalArgument.visit(this.gen);
                    this.gen.out(").nativeArray()", new String[0]);
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    this.gen.out(",", new String[0]);
                }
                positionalArgument.visit(this.gen);
            }
            if (isComp) {
                this.gen.out(")", new String[0]);
            } else if (!isSpread) {
                this.gen.out("]", new String[0]);
            }
            if (nargs.size() > 0) {
                this.gen.endLine(true);
                for (Tree.NamedArgument namedArgument : nargs) {
                    this.gen.out(arr, ".", namedArgument.getIdentifier().getText(), "=");
                    namedArgument.visit(this.gen);
                    this.gen.endLine(true);
                }
                this.gen.out("return ", arr, ";");
                this.gen.endBlock();
                this.gen.out("()", new String[0]);
            }
        }
    }

    void describeMethodParameters(Tree.Term term) {
        ParameterList plist = null;
        if (term instanceof Tree.FunctionArgument) {
            plist = ((Tree.FunctionArgument)term).getDeclarationModel().getFirstParameterList();
        } else if (term instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mote = (Tree.MemberOrTypeExpression)term;
            if (mote.getStaticMethodReference()) {
                plist = new ParameterList();
                Parameter param = new Parameter();
                plist.getParameters().add(param);
                Value pm = new Value();
                pm.setType(mote.getTarget().getQualifyingType());
                param.setModel(pm);
                param.setName("_0");
            } else if (mote.getDeclaration() instanceof Function) {
                plist = ((Function)((Tree.MemberOrTypeExpression)term).getDeclaration()).getFirstParameterList();
            }
        } else {
            if (term instanceof Tree.InvocationExpression) {
                TypeUtils.encodeCallableArgumentsAsParameterListForRuntime(term, term.getTypeModel(), this.gen);
                return;
            }
            this.gen.out("/*WARNING4 Callable EXPR of type ", term.getClass().getName(), "*/");
        }
        if (plist == null) {
            this.gen.out("[]", new String[0]);
        } else {
            TypeUtils.encodeParameterListForRuntime(true, term, plist, this.gen);
        }
    }
}

