/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetamodelHelper {
    static void generateOpenType(Tree.MetaLiteral that, Declaration d, GenerateJsVisitor gen, boolean compilingLanguageModule) {
        boolean isConstructor;
        Module m = d.getUnit().getPackage().getModule();
        boolean bl = isConstructor = ModelUtil.isConstructor(d) || that instanceof Tree.NewLiteral;
        if (!(d instanceof TypeParameter)) {
            if (compilingLanguageModule) {
                gen.out("$init$", new String[0]);
            } else {
                gen.out(gen.getClAlias(), new String[0]);
            }
        }
        if (d instanceof Interface) {
            gen.out("OpenInterface$jsint", new String[0]);
        } else if (isConstructor) {
            if (TypeUtils.getConstructor(d).isValueConstructor()) {
                gen.out("OpenValueConstructor$jsint", new String[0]);
            } else {
                gen.out("OpenCallableConstructor$jsint", new String[0]);
            }
        } else if (d instanceof Class) {
            gen.out("openClass$jsint", new String[0]);
        } else if (d instanceof Function) {
            gen.out("OpenFunction$jsint", new String[0]);
        } else if (d instanceof Value) {
            gen.out("OpenValue$jsint", new String[0]);
        } else if (d instanceof IntersectionType) {
            gen.out("OpenIntersection", new String[0]);
        } else if (d instanceof UnionType) {
            gen.out("OpenUnion", new String[0]);
        } else {
            if (d instanceof TypeParameter) {
                MetamodelHelper.generateOpenType(that, ((TypeParameter)d).getDeclaration(), gen, compilingLanguageModule);
                gen.out(".getTypeParameterDeclaration('", d.getName(), "')");
                return;
            }
            if (d instanceof NothingType) {
                gen.out("NothingType", new String[0]);
            } else if (d instanceof TypeAlias) {
                gen.out("OpenAlias$jsint(", new String[0]);
                if (compilingLanguageModule) {
                    gen.out(")(", new String[0]);
                }
                if (d.isMember()) {
                    ArrayList<Declaration> parents = new ArrayList<Declaration>(2);
                    Declaration pd = (Declaration)((Object)d.getContainer());
                    while (pd != null) {
                        parents.add(0, pd);
                        pd = pd.isMember() ? (Declaration)((Object)pd.getContainer()) : null;
                    }
                    for (Declaration _d : parents) {
                        gen.out(gen.getNames().name(_d), ".$$.prototype.");
                    }
                }
                gen.out(gen.getNames().name(d), ")");
                return;
            }
        }
        if (compilingLanguageModule) {
            gen.out("()", new String[0]);
        }
        gen.out("(", gen.getClAlias());
        String pkgname = d.getUnit().getPackage().getNameAsString();
        if (Objects.equals(that.getUnit().getPackage().getModule(), d.getUnit().getPackage().getModule())) {
            gen.out("lmp$(ex$,'", new String[0]);
        } else {
            gen.out("fmp$('", m.getNameAsString(), "','", m.getVersion(), "','");
        }
        gen.out("ceylon.language".equals(pkgname) ? "$" : pkgname, "'),");
        if (d.isMember() || isConstructor) {
            if (isConstructor) {
                String constrName;
                Class actualClass;
                if (d instanceof Class) {
                    actualClass = (Class)d;
                    constrName = "$c$";
                } else {
                    actualClass = (Class)d.getContainer();
                    constrName = d instanceof Constructor && ((Constructor)d).isValueConstructor() ? gen.getNames().name(actualClass.getDirectMember(d.getName(), null, false)) : gen.getNames().name(d);
                }
                if (gen.isImported(that.getUnit().getPackage(), actualClass)) {
                    gen.out(gen.getNames().moduleAlias(actualClass.getUnit().getPackage().getModule()), ".");
                }
                if (actualClass.isMember()) {
                    MetamodelHelper.outputPathToDeclaration(that, actualClass, gen);
                }
                gen.out(gen.getNames().name(actualClass), gen.getNames().constructorSeparator(d), constrName, ")");
                return;
            }
            MetamodelHelper.outputPathToDeclaration(that, d, gen);
        }
        if (d instanceof Value || d.isParameter()) {
            if (!d.isMember()) {
                gen.qualify(that, d);
            }
            if (d.isStatic() && d instanceof Value && ((Value)d).getType().getDeclaration().isAnonymous()) {
                gen.out(gen.getNames().name(d), ")");
            } else {
                gen.out(gen.getNames().getter(d, true), ")");
            }
        } else {
            if (d.isAnonymous()) {
                String oname = gen.getNames().objectName(d);
                if (d.isToplevel()) {
                    gen.qualify(that, d);
                }
                gen.out("$init$", oname);
                if (!d.isToplevel()) {
                    gen.out("()", new String[0]);
                }
            } else {
                if (!d.isMember()) {
                    gen.qualify(that, d);
                }
                gen.out(gen.getNames().name(d), new String[0]);
            }
            gen.out(")", new String[0]);
        }
    }

    static void generateClosedTypeLiteral(Tree.TypeLiteral that, GenerateJsVisitor gen) {
        boolean isConstructor;
        Type ltype = that.getType().getTypeModel().resolveAliases();
        TypeDeclaration td = ltype.getDeclaration();
        Map<TypeParameter, Type> targs = ltype.getTypeArguments();
        boolean bl = isConstructor = that instanceof Tree.NewLiteral || ModelUtil.isConstructor(td);
        if (ltype.isClass()) {
            if (td.isClassOrInterfaceMember()) {
                gen.out(gen.getClAlias(), "$init$AppliedMemberClass$jsint()(");
            } else {
                gen.out(gen.getClAlias(), "$init$AppliedClass$jsint()(");
            }
            if (that.getUnit().isTupleType(ltype)) {
                gen.qualify(that, td);
                gen.out(gen.getNames().name(td), new String[0]);
            } else if (ltype.isNullValue()) {
                gen.out(gen.getClAlias(), "$init$$_null()");
            } else {
                TypeUtils.outputQualifiedTypename(null, gen.isImported(gen.getCurrentPackage(), td), ltype, gen, false);
            }
            gen.out(",", new String[0]);
            TypeUtils.printTypeArguments(that, that.getTypeModel().getTypeArguments(), gen, false, that.getTypeModel().getVarianceOverrides());
            if (targs != null && !targs.isEmpty()) {
                gen.out(",undefined,", new String[0]);
                TypeUtils.printTypeArguments(that, targs, gen, false, ltype.getVarianceOverrides());
            }
            gen.out(")", new String[0]);
        } else if (isConstructor) {
            MetamodelHelper.constructorLiteral(ltype, TypeUtils.getConstructor(td), that, gen);
        } else if (ltype.isInterface()) {
            if (td.isToplevel()) {
                gen.out(gen.getClAlias(), "$init$AppliedInterface$jsint()(");
            } else {
                gen.out(gen.getClAlias(), "$init$AppliedMemberInterface$jsint()(");
            }
            TypeUtils.outputQualifiedTypename(null, gen.isImported(gen.getCurrentPackage(), td), ltype, gen, false);
            gen.out(",", new String[0]);
            TypeUtils.printTypeArguments(that, that.getTypeModel().getTypeArguments(), gen, false, that.getTypeModel().getVarianceOverrides());
            if (targs != null && !targs.isEmpty()) {
                gen.out(",undefined,", new String[0]);
                TypeUtils.printTypeArguments(that, targs, gen, false, ltype.getVarianceOverrides());
            }
            gen.out(")", new String[0]);
        } else if (ltype.isNothing()) {
            gen.out(gen.getClAlias(), "nothingType$meta$model()");
        } else if (that instanceof Tree.AliasLiteral) {
            gen.out("/*TODO: applied alias*/", new String[0]);
        } else if (that instanceof Tree.TypeParameterLiteral) {
            gen.out("/*TODO: applied type parameter*/", new String[0]);
        } else {
            gen.out(gen.getClAlias(), "typeLiteral$meta({Type$typeLiteral:");
            TypeUtils.typeNameOrList(that, ltype, gen, false);
            gen.out("})", new String[0]);
        }
    }

    private static void constructorLiteral(Type ltype, Constructor cd, Tree.MetaLiteral meta, GenerateJsVisitor gen) {
        Class _pc = (Class)cd.getContainer();
        if (_pc.isClassOrInterfaceMember()) {
            gen.out(gen.getClAlias(), "$init$AppliedMemberClass", cd.isValueConstructor() ? "Value" : "Callable", "Constructor$jsint()(");
        } else {
            gen.out(gen.getClAlias(), "$init$Applied", cd.isValueConstructor() ? "Value" : "Callable", "Constructor$jsint()(");
        }
        TypeUtils.outputQualifiedTypename(null, gen.isImported(gen.getCurrentPackage(), _pc), _pc.getType(), gen, false);
        if (cd.isValueConstructor()) {
            gen.out(gen.getNames().constructorSeparator(cd), gen.getNames().name(meta.getDeclaration()), ",");
        } else {
            gen.out(gen.getNames().constructorSeparator(cd), gen.getNames().name(cd), ",");
        }
        Type mtype = meta.getTypeModel().resolveAliases();
        TypeUtils.printTypeArguments(meta, mtype.getTypeArguments(), gen, false, mtype.getVarianceOverrides());
        if (ltype != null && ltype.getTypeArguments() != null && !ltype.getTypeArguments().isEmpty()) {
            gen.out(",undefined,", new String[0]);
            TypeUtils.printTypeArguments(meta, ltype.getTypeArguments(), gen, false, ltype.getVarianceOverrides());
        }
        gen.out(")", new String[0]);
    }

    static void generateMemberLiteral(Tree.MemberLiteral that, GenerateJsVisitor gen) {
        Class anonClass;
        Reference ref = that.getTarget();
        Type ltype = that.getType() == null ? null : that.getType().getTypeModel().resolveAliases();
        Declaration d = ref.getDeclaration();
        Class clazz = anonClass = d.isMember() && d.getContainer() instanceof Class && ((Class)d.getContainer()).isAnonymous() ? (Class)d.getContainer() : null;
        if (that instanceof Tree.FunctionLiteral || d instanceof Function) {
            if (ModelUtil.isConstructor(d)) {
                MetamodelHelper.constructorLiteral(ref.getType(), TypeUtils.getConstructor(d), that, gen);
                return;
            }
            gen.out(gen.getClAlias(), d.isMember() ? "AppliedMethod$jsint(" : "AppliedFunction$jsint(");
            if (anonClass != null) {
                gen.qualify(that, anonClass);
                gen.out(gen.getNames().objectName(anonClass), ".");
            } else if (ltype == null) {
                gen.qualify(that, d);
            } else {
                if (ltype.isUnion() || ltype.isIntersection()) {
                    if (d.getContainer() instanceof TypeDeclaration) {
                        ltype = ((TypeDeclaration)d.getContainer()).getType();
                    } else if (d.getContainer() instanceof TypedDeclaration) {
                        ltype = ((TypedDeclaration)((Object)d.getContainer())).getType();
                    }
                }
                if (ltype.getDeclaration().isMember()) {
                    MetamodelHelper.outputPathToDeclaration(that, ltype.getDeclaration(), gen);
                } else {
                    gen.qualify(that, ltype.getDeclaration());
                }
                gen.out(gen.getNames().name(ltype.getDeclaration()), new String[0]);
                gen.out(d.isStatic() ? ".$st$." : ".$$.prototype.", new String[0]);
            }
            if (d instanceof Value) {
                gen.out(gen.getNames().getter(d, true), ",");
            } else {
                gen.out(gen.getNames().name(d), ",");
            }
            if (d.isMember()) {
                if (that.getTypeArgumentList() != null) {
                    List<Type> typeModels = that.getTypeArgumentList().getTypeModels();
                    if (typeModels != null) {
                        gen.out("[", new String[0]);
                        boolean first = true;
                        for (Type targ : typeModels) {
                            if (first) {
                                first = false;
                            } else {
                                gen.out(",", new String[0]);
                            }
                            gen.out(gen.getClAlias(), "typeLiteral$meta({Type$typeLiteral:");
                            TypeUtils.typeNameOrList(that, targ, gen, false);
                            gen.out("})", new String[0]);
                        }
                        gen.out("]", new String[0]);
                        gen.out(",", new String[0]);
                    } else {
                        gen.out("undefined,", new String[0]);
                    }
                } else {
                    gen.out("undefined,", new String[0]);
                }
                TypeUtils.printTypeArguments(that, that.getTypeModel().getTypeArguments(), gen, false, that.getTypeModel().getVarianceOverrides());
            } else {
                TypeUtils.printTypeArguments(that, that.getTypeModel().getTypeArguments(), gen, false, that.getTypeModel().getVarianceOverrides());
                if (ref.getTypeArguments() != null && !ref.getTypeArguments().isEmpty()) {
                    gen.out(",undefined,", new String[0]);
                    TypeUtils.printTypeArguments(that, ref.getTypeArguments(), gen, false, ref.getType().getVarianceOverrides());
                }
            }
            gen.out(")", new String[0]);
        } else if (that instanceof Tree.ValueLiteral || d instanceof Value) {
            if (ModelUtil.isConstructor(d)) {
                MetamodelHelper.constructorLiteral(ref.getType(), TypeUtils.getConstructor(d), that, gen);
                return;
            }
            Value vd = (Value)d;
            if (vd.isMember()) {
                gen.out(gen.getClAlias(), "$init$AppliedAttribute$meta$model()('");
                gen.out(d.getName(), "',");
            } else {
                gen.out(gen.getClAlias(), "$init$AppliedValue$jsint()(undefined,");
            }
            if (anonClass != null) {
                gen.qualify(that, anonClass);
                gen.out(gen.getNames().objectName(anonClass), ".");
            } else if (ltype == null) {
                gen.qualify(that, d);
            } else {
                gen.qualify(that, ltype.getDeclaration());
                gen.out(gen.getNames().name(ltype.getDeclaration()), new String[0]);
                gen.out(d.isStatic() ? ".$st$." : ".$$.prototype.", new String[0]);
            }
            gen.out(gen.getNames().getter(vd, true), ",");
            TypeUtils.printTypeArguments(that, that.getTypeModel().getTypeArguments(), gen, false, that.getTypeModel().getVarianceOverrides());
            gen.out(")", new String[0]);
        } else {
            gen.out(gen.getClAlias(), "/*TODO:closed member literal*/typeLiteral$meta({Type$typeLiteral:");
            gen.out("{t:", new String[0]);
            if (ltype == null) {
                gen.qualify(that, d);
            } else {
                gen.qualify(that, ltype.getDeclaration());
                gen.out(gen.getNames().name(ltype.getDeclaration()), new String[0]);
                gen.out(d.isStatic() ? ".$st$." : ".$$.prototype.", new String[0]);
            }
            gen.out(gen.getNames().name(d), new String[0]);
            if (ltype != null && ltype.getTypeArguments() != null && !ltype.getTypeArguments().isEmpty()) {
                gen.out(",a:", new String[0]);
                TypeUtils.printTypeArguments(that, ltype.getTypeArguments(), gen, false, ltype.getVarianceOverrides());
            }
            gen.out("}})", new String[0]);
        }
    }

    static void findModule(Module m, GenerateJsVisitor gen) {
        gen.out(gen.getClAlias(), "findModuleOrThrow$('", m.getNameAsString(), "','", m.getVersion(), "')");
    }

    static void outputPathToDeclaration(Node that, Declaration d, GenerateJsVisitor gen) {
        Declaration parent = ModelUtil.getContainingDeclaration(d);
        if (!gen.opts.isOptimize() && parent instanceof TypeDeclaration && ModelUtil.contains((Scope)((Object)parent), that.getScope())) {
            gen.out(gen.getNames().self((TypeDeclaration)parent), ".");
        } else {
            Declaration _md = d;
            ArrayList<Declaration> parents = new ArrayList<Declaration>(3);
            while (_md.isMember()) {
                _md = ModelUtil.getContainingDeclaration(_md);
                parents.add(0, _md);
            }
            boolean first = true;
            boolean imported = false;
            boolean parentIsObject = false;
            for (Declaration _d : parents) {
                if (first) {
                    imported = gen.qualify(that, _d);
                    first = false;
                } else if (parentIsObject) {
                    gen.out(".", new String[0]);
                    parentIsObject = false;
                } else {
                    gen.out(_d.isStatic() ? ".$st$." : ".$$.prototype.", new String[0]);
                }
                if (_d.isAnonymous()) {
                    String oname = gen.getNames().objectName(_d);
                    if (_d.isToplevel()) {
                        gen.out(oname, new String[0]);
                        parentIsObject = true;
                    } else {
                        gen.out("$init$", oname, "()");
                    }
                } else {
                    if (!imported) {
                        gen.out("$init$", new String[0]);
                    }
                    gen.out(gen.getNames().name(_d), imported ? "" : "()");
                }
                imported = true;
            }
            if (!parents.isEmpty()) {
                if (parentIsObject) {
                    gen.out(".", new String[0]);
                } else {
                    gen.out(d.isStatic() ? ".$st$." : ".$$.prototype.", new String[0]);
                }
            }
        }
    }
}

