/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TryCatchGenerator {
    private final GenerateJsVisitor gen;
    private final Set<Declaration> directAccess;

    TryCatchGenerator(GenerateJsVisitor generator, Set<Declaration> da) {
        this.gen = generator;
        this.directAccess = da;
    }

    void generate(Tree.TryCatchStatement that) {
        List<Tree.Resource> resources;
        List<Tree.Resource> list = resources = that.getTryClause().getResourceList() == null ? null : that.getTryClause().getResourceList().getResources();
        if (resources != null && resources.isEmpty()) {
            resources = null;
        }
        ArrayList<Res> resourceVars = null;
        String tvar = null;
        if (resources != null && !resources.isEmpty()) {
            resourceVars = new ArrayList<Res>(resources.size());
            this.gen.out("var ", new String[0]);
            for (Tree.Resource res : resources) {
                if (!resourceVars.isEmpty()) {
                    this.gen.out(",", new String[0]);
                }
                Res r = new Res(res);
                this.gen.out(r.var, "=null");
                resourceVars.add(r);
            }
            tvar = this.gen.getNames().createTempVariable();
            this.gen.out(",", tvar, "=null");
            this.gen.endLine(true);
        }
        this.gen.out("try", new String[0]);
        HashSet<Value> caps = null;
        if (resources != null) {
            this.gen.out("{", new String[0]);
            for (Res resourceVar : resourceVars) {
                if (resourceVar.destroy) {
                    this.gen.out(resourceVar.var, "=");
                    resourceVar.r.visit(this.gen);
                } else {
                    this.gen.out(tvar, "=");
                    resourceVar.r.visit(this.gen);
                    this.gen.out(";", tvar, ".obtain();", resourceVar.var, "=", tvar);
                }
                this.gen.endLine(true);
                if (resourceVar.captured == null) continue;
                if (caps == null) {
                    caps = new HashSet<Value>(resourceVars.size());
                }
                caps.add(resourceVar.captured);
            }
        }
        this.gen.encloseBlockInFunction(that.getTryClause().getBlock(), true, caps);
        if (resources != null) {
            Collections.reverse(resourceVars);
            for (Res r : resourceVars) {
                this.gen.out(tvar, "=", r.var, ";", r.var, "=null;", tvar);
                if (r.destroy) {
                    this.gen.out(".destroy(null);", new String[0]);
                } else {
                    this.gen.out(".release(null);", new String[0]);
                }
                this.gen.endLine();
            }
            this.gen.out("}", new String[0]);
        }
        if (!that.getCatchClauses().isEmpty() || resources != null) {
            String catchVarName = this.gen.getNames().createTempVariable();
            this.gen.out("catch(", catchVarName, ")");
            this.gen.beginBlock();
            this.gen.out("if(", new String[0]);
            this.gen.generateIsOfType(that, catchVarName, that.getUnit().getThrowableType(), catchVarName, true, false);
            this.gen.out(")", catchVarName, "=", this.gen.getClAlias(), "NatErr(", catchVarName, ")");
            this.gen.endLine(true);
            if (resources != null) {
                for (Res r : resourceVars) {
                    this.gen.out("try{if(", r.var, "!==null)", r.var, r.destroy ? ".destroy(" : ".release(", catchVarName, ");}catch(", r.var, "e$){", catchVarName, ".addSuppressed(", r.var, "e$);}");
                    this.gen.endLine();
                }
            }
            boolean firstCatch = true;
            for (Tree.CatchClause catchClause : that.getCatchClauses()) {
                Tree.Variable variable = catchClause.getCatchVariable().getVariable();
                if (!firstCatch) {
                    this.gen.out("else ", new String[0]);
                }
                firstCatch = false;
                this.gen.out("if(", new String[0]);
                this.gen.generateIsOfType(variable, catchVarName, variable.getType().getTypeModel(), null, false, false);
                this.gen.out(")", new String[0]);
                if (catchClause.getBlock().getStatements().isEmpty()) {
                    this.gen.out("{}", new String[0]);
                    continue;
                }
                this.gen.beginBlock();
                this.directAccess.add(variable.getDeclarationModel());
                this.gen.getNames().forceName(variable.getDeclarationModel(), catchVarName);
                this.gen.visitStatements(catchClause.getBlock().getStatements());
                this.gen.endBlock();
            }
            if (!that.getCatchClauses().isEmpty()) {
                this.gen.out("else{throw ", catchVarName, "}");
            }
            this.gen.endBlockNewLine();
        }
        if (that.getFinallyClause() != null) {
            this.gen.out("finally", new String[0]);
            this.gen.encloseBlockInFunction(that.getFinallyClause().getBlock(), true, caps);
        }
    }

    private class Res {
        final boolean destroy;
        final String var;
        final Tree.Resource r;
        final Value captured;

        Res(Tree.Resource r) {
            this.r = r;
            if (r.getVariable() != null) {
                this.destroy = r.getVariable().getType().getTypeModel().isSubtypeOf(r.getUnit().getDestroyableType());
                this.var = TryCatchGenerator.this.gen.getNames().name(r.getVariable().getDeclarationModel());
                this.captured = r.getVariable().getDeclarationModel().isJsCaptured() ? r.getVariable().getDeclarationModel() : null;
                TryCatchGenerator.this.directAccess.add(r.getVariable().getDeclarationModel());
            } else {
                this.destroy = r.getExpression().getTypeModel().isSubtypeOf(r.getUnit().getDestroyableType());
                this.var = TryCatchGenerator.this.gen.getNames().createTempVariable();
                this.captured = null;
            }
        }
    }
}

