/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.AttributeGenerator;
import com.redhat.ceylon.compiler.js.ErrorVisitor;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.util.TypeComparator;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class TypeGenerator {
    static final ErrorVisitor errVisitor = new ErrorVisitor();

    static void initializeType(final Node type, final GenerateJsVisitor gen, GenerateJsVisitor.InitDeferrer initDeferrer) {
        Node objectDef;
        List<Tree.Statement> stmts;
        ClassOrInterface decl;
        Tree.ExtendedType extendedType = null;
        Tree.SatisfiedTypes satisfiedTypes = null;
        Value objDecl = null;
        if (type instanceof Tree.ClassDefinition) {
            Tree.ClassDefinition classDef = (Tree.ClassDefinition)type;
            extendedType = classDef.getExtendedType();
            satisfiedTypes = classDef.getSatisfiedTypes();
            decl = classDef.getDeclarationModel();
            Tree.Declaration nh = gen.getNativeHeader(decl);
            if (nh == null && NativeUtil.hasNativeMembers(decl)) {
                nh = classDef;
            }
            stmts = NativeUtil.mergeStatements(classDef.getClassBody(), nh, Backend.JavaScript);
        } else if (type instanceof Tree.InterfaceDefinition) {
            satisfiedTypes = ((Tree.InterfaceDefinition)type).getSatisfiedTypes();
            decl = ((Tree.InterfaceDefinition)type).getDeclarationModel();
            Tree.InterfaceDefinition idef = (Tree.InterfaceDefinition)type;
            Tree.Declaration nh = gen.getNativeHeader(decl);
            if (nh == null && NativeUtil.hasNativeMembers(decl)) {
                nh = idef;
            }
            stmts = NativeUtil.mergeStatements(idef.getInterfaceBody(), nh, Backend.JavaScript);
        } else if (type instanceof Tree.ObjectDefinition) {
            objectDef = (Tree.ObjectDefinition)type;
            extendedType = ((Tree.ObjectDefinition)objectDef).getExtendedType();
            satisfiedTypes = ((Tree.ObjectDefinition)objectDef).getSatisfiedTypes();
            decl = (ClassOrInterface)((Tree.ObjectDefinition)objectDef).getDeclarationModel().getTypeDeclaration();
            objDecl = ((Tree.ObjectDefinition)objectDef).getDeclarationModel();
            Node nh = gen.getNativeHeader(decl);
            if (nh == null && NativeUtil.hasNativeMembers(decl)) {
                nh = objectDef;
            }
            stmts = NativeUtil.mergeStatements(((Tree.ObjectDefinition)objectDef).getClassBody(), nh, Backend.JavaScript);
        } else if (type instanceof Tree.ObjectExpression) {
            objectDef = (Tree.ObjectExpression)type;
            extendedType = ((Tree.ObjectExpression)objectDef).getExtendedType();
            satisfiedTypes = ((Tree.ObjectExpression)objectDef).getSatisfiedTypes();
            decl = ((Tree.ObjectExpression)objectDef).getAnonymousClass();
            stmts = ((Tree.ObjectExpression)objectDef).getClassBody().getStatements();
        } else if (type instanceof Tree.Enumerated) {
            Tree.Enumerated vc = (Tree.Enumerated)type;
            stmts = vc.getBlock().getStatements();
            decl = (ClassOrInterface)vc.getDeclarationModel().getTypeDeclaration().getContainer();
        } else {
            stmts = null;
            decl = null;
        }
        GenerateJsVisitor.PrototypeInitCallback callback = new GenerateJsVisitor.PrototypeInitCallback(){

            @Override
            public void addToPrototypeCallback() {
                if (decl != null) {
                    gen.addToPrototype(type, decl, stmts);
                }
            }
        };
        TypeGenerator.typeInitialization(extendedType, satisfiedTypes, decl, callback, gen, objDecl, initDeferrer);
    }

    static void typeInitialization(Tree.ExtendedType extendedType, Tree.SatisfiedTypes satisfiedTypes, ClassOrInterface d, GenerateJsVisitor.PrototypeInitCallback callback, GenerateJsVisitor gen, Value objectDeclaration, GenerateJsVisitor.InitDeferrer initDeferrer) {
        String initname;
        boolean isInterface = d instanceof Interface;
        String initFuncName = isInterface ? "initTypeProtoI" : "initTypeProto";
        String typename = gen.getNames().name(d);
        if (d.isAnonymous()) {
            String _initname = gen.getNames().objectName(d);
            initname = d.isToplevel() ? "$init$" + _initname.substring(0, _initname.length() - 2) : "$init$" + _initname;
        } else {
            initname = "$init$" + typename;
        }
        gen.out("function ", initname, "()");
        gen.beginBlock();
        gen.out("if(", typename, ".$$===undefined)");
        gen.beginBlock();
        boolean genIniter = true;
        if (TypeUtils.isNativeExternal(d)) {
            boolean bl = genIniter = !gen.stitchInitializer(d);
        }
        if (genIniter) {
            ArrayList<Tree.StaticType> supers;
            gen.out(gen.getClAlias(), initFuncName, "(", typename, ",'", d.getQualifiedNameString(), "'");
            ArrayList<Tree.StaticType> arrayList = supers = satisfiedTypes == null ? Collections.emptyList() : new ArrayList<Tree.StaticType>(satisfiedTypes.getTypes().size() + 1);
            if (extendedType != null) {
                if (satisfiedTypes == null) {
                    String fname = TypeGenerator.typeFunctionName(extendedType.getType(), d, gen);
                    gen.out(",", fname);
                } else {
                    supers.add(extendedType.getType());
                }
            } else if (!isInterface) {
                gen.out(",", gen.getClAlias(), "Basic");
            }
            if (satisfiedTypes != null) {
                supers.addAll(satisfiedTypes.getTypes());
                Collections.sort(supers, new StaticTypeComparator());
                for (Tree.StaticType satType : supers) {
                    String fname = TypeGenerator.typeFunctionName(satType, d, gen);
                    gen.out(",", fname);
                }
            }
            gen.out(");", new String[0]);
        }
        if (d.isMember()) {
            StringBuilder containers = new StringBuilder();
            Scope _d2 = d;
            while (_d2 instanceof ClassOrInterface) {
                if (containers.length() > 0) {
                    containers.insert(0, '.');
                }
                containers.insert(0, gen.getNames().name((Declaration)((Object)_d2)));
                _d2 = _d2.getContainer();
            }
            gen.endLine();
            gen.out(containers.toString(), "=", typename, ";");
        }
        if (gen.opts.isOptimize()) {
            gen.endLine();
            callback.addToPrototypeCallback();
        }
        gen.endBlockNewLine();
        gen.out("return ", typename, ";");
        gen.endBlockNewLine();
        if (d.isStatic()) {
            gen.out(gen.getNames().name(ModelUtil.getContainingClassOrInterface(d.getContainer())), ".$st$.", initname, "=", initname, ";");
        } else if (gen.outerSelf(d)) {
            gen.out(".", initname, "=", initname, ";");
        }
        if (initDeferrer != null) {
            initDeferrer.deferred.add(initname + "();");
        } else {
            gen.out(initname, "();");
        }
    }

    static String typeFunctionName(Tree.StaticType type, ClassOrInterface coi, GenerateJsVisitor gen) {
        String tfn;
        boolean removeAlias;
        TypeDeclaration d = type.getTypeModel().getDeclaration();
        boolean bl = removeAlias = d == null || !d.isClassOrInterfaceMember() || d instanceof Interface;
        if (removeAlias && d.isAlias() || d instanceof Constructor) {
            Type extendedType = d.getExtendedType();
            d = extendedType == null ? null : extendedType.getDeclaration();
        }
        Declaration cont = ModelUtil.getContainingDeclaration(d);
        boolean inProto = gen.opts.isOptimize() && cont instanceof TypeDeclaration;
        boolean imported = gen.isImported(type.getUnit().getPackage(), d);
        String dname = gen.getNames().name(d);
        if (d.isAlias()) {
            TypeDeclaration d2 = d;
            while (d2.isAlias()) {
                d2 = d2.getExtendedType().getDeclaration();
            }
            dname = gen.getNames().name(d2);
        }
        String initName = "$init$" + dname + "()";
        if (!imported && !d.isClassOrInterfaceMember()) {
            return initName;
        }
        if (inProto && coi.isMember() && !d.isAlias() && (coi.getContainer() == cont || ModelUtil.contains(d, coi))) {
            return initName;
        }
        if (coi != null && coi.isAnonymous() && cont instanceof Scope && ModelUtil.contains((Scope)((Object)cont), coi)) {
            tfn = gen.qualifiedPath(type, cont, inProto);
        } else {
            if (inProto && d.isClassOrInterfaceMember()) {
                return TypeGenerator.pathToType(type, d, gen);
            }
            tfn = gen.qualifiedPath(type, d, inProto);
        }
        tfn = gen.memberAccessBase(type, d, false, tfn);
        if (removeAlias && !imported) {
            int idx = tfn.lastIndexOf(46);
            tfn = idx > 0 ? tfn.substring(0, idx + 1) + initName : initName;
        }
        return tfn;
    }

    static String pathToType(Node that, TypeDeclaration d, GenerateJsVisitor gen) {
        ArrayList<TypeDeclaration> parents = new ArrayList<TypeDeclaration>(3);
        TypeDeclaration path = d;
        parents.add(path);
        while (path.isClassOrInterfaceMember()) {
            path = ModelUtil.getContainingClassOrInterface(path.getContainer());
            parents.add(0, path);
        }
        StringBuilder sb = new StringBuilder();
        String qp = gen.qualifiedPath(that, (Declaration)parents.get(0), gen.opts.isOptimize() && ModelUtil.getContainingDeclaration(d) instanceof TypeDeclaration);
        if (qp != null && !qp.isEmpty()) {
            sb.append(qp);
        }
        boolean first = true;
        for (TypeDeclaration td : parents) {
            if (first) {
                first = false;
            } else if (td.isStatic()) {
                sb.append(".$st$");
            } else {
                sb.append(".$$.prototype");
            }
            if (sb.length() > 0) {
                sb.append('.');
            }
            if (!td.isAlias()) {
                sb.append("$init$");
            }
            sb.append(gen.getNames().name(td));
            if (td.isAlias()) continue;
            sb.append("()");
        }
        return sb.toString();
    }

    static void interfaceDefinition(Tree.InterfaceDefinition that, GenerateJsVisitor gen, GenerateJsVisitor.InitDeferrer initDeferrer) {
        List<Tree.Statement> stmts;
        if (errVisitor.hasErrors(that)) {
            return;
        }
        Interface d = that.getDeclarationModel();
        if (d.isClassOrInterfaceMember() && ((ClassOrInterface)d.getContainer()).isDynamic()) {
            return;
        }
        Interface natd = (Interface)ModelUtil.getNativeDeclaration((Declaration)d, Backend.JavaScript);
        boolean headerWithoutBackend = NativeUtil.isHeaderWithoutBackend(that, Backend.JavaScript);
        if (natd != null && (headerWithoutBackend || NativeUtil.isNativeHeader(that))) {
            gen.saveNativeHeader(that);
            return;
        }
        if (!NativeUtil.isForBackend(that, Backend.JavaScript) && !headerWithoutBackend) {
            return;
        }
        gen.comment(that);
        gen.out("function ", gen.getNames().name(d));
        boolean withTargs = TypeGenerator.generateParameters(that.getTypeParameterList(), null, d, gen);
        gen.beginBlock();
        ArrayList<Declaration> superDecs = new ArrayList<Declaration>(3);
        if (!gen.opts.isOptimize()) {
            new GenerateJsVisitor.SuperVisitor(superDecs).visit(that.getInterfaceBody());
        }
        Tree.SatisfiedTypes sats = that.getSatisfiedTypes();
        if (withTargs) {
            gen.out(gen.getClAlias(), "set_type_args(", gen.getNames().self(d), ",$$targs$$,", gen.getNames().name(d), ")");
            gen.endLine(true);
        }
        TypeGenerator.callSupertypes(sats == null ? null : TypeUtils.getTypes(sats.getTypes()), null, d, that, superDecs, null, null, gen);
        if (!d.isToplevel() && d.getContainer() instanceof Function && !((Function)d.getContainer()).getTypeParameters().isEmpty()) {
            gen.out(gen.getClAlias(), "set_type_args(", gen.getNames().self(d), ",", gen.getNames().typeArgsParamName((Function)d.getContainer()), ",", gen.getNames().name(d), ")");
            gen.endLine(true);
        }
        if (NativeUtil.isForBackend(d, Backend.JavaScript)) {
            Tree.Declaration nh = gen.getNativeHeader(d);
            if (nh == null && NativeUtil.hasNativeMembers(d)) {
                nh = that;
            }
            stmts = NativeUtil.mergeStatements(that.getInterfaceBody(), nh, Backend.JavaScript);
        } else {
            stmts = that.getInterfaceBody().getStatements();
        }
        gen.visitStatements(stmts);
        gen.endBlockNewLine();
        if (d.isDynamic()) {
            List<Declaration> members = d.getMembers();
            gen.out(gen.getNames().name(d), ".dynmem$=[");
            if (members.isEmpty()) {
                gen.out("];", new String[0]);
            } else {
                gen.out("'", new String[0]);
                boolean first = true;
                for (Declaration m : members) {
                    if (first) {
                        first = false;
                    } else {
                        gen.out("','", new String[0]);
                    }
                    gen.out(gen.getNames().name(m), new String[0]);
                }
                gen.out("'];", new String[0]);
            }
        }
        gen.out(gen.getNames().name(d), ".$crtmm$=");
        TypeUtils.encodeForRuntime((Node)that, (Declaration)d, that.getAnnotationList(), gen);
        gen.endLine(true);
        gen.share(d);
        TypeGenerator.initializeType(that, gen, initDeferrer);
    }

    static boolean generateParameters(Tree.TypeParameterList tparms, Tree.ParameterList plist, TypeDeclaration d, GenerateJsVisitor gen) {
        boolean withTargs;
        gen.out("(", new String[0]);
        boolean bl = withTargs = tparms != null && !tparms.getTypeParameterDeclarations().isEmpty() || TypeUtils.isStaticWithGenericContainer(d);
        if (plist != null) {
            for (Tree.Parameter p : plist.getParameters()) {
                p.visit(gen);
                gen.out(",", new String[0]);
            }
        }
        if (withTargs) {
            gen.out("$$targs$$,", new String[0]);
        }
        gen.out(gen.getNames().self(d), ")");
        return withTargs;
    }

    static void callSuperclass(Tree.SimpleType extendedType, Tree.InvocationExpression invocation, Class d, ParameterList plist, Node that, boolean pseudoAbstractConstructor, List<Declaration> superDecs, GenerateJsVisitor gen) {
        TypeDeclaration typeDecl = extendedType.getDeclarationModel();
        if (invocation != null) {
            List<TypeParameter> typeParams;
            String qpath;
            Tree.PositionalArgumentList argList = invocation.getPositionalArgumentList();
            if (typeDecl instanceof Constructor) {
                String path = gen.qualifiedPath(that, (TypeDeclaration)typeDecl.getContainer(), false);
                qpath = path.isEmpty() ? gen.getNames().name((TypeDeclaration)typeDecl.getContainer()) : path + "." + gen.getNames().name((TypeDeclaration)typeDecl.getContainer());
            } else if (typeDecl.isStatic()) {
                Declaration _cont = ModelUtil.getContainingDeclaration(typeDecl);
                String qp = gen.qualifiedPath(that, _cont, false);
                qpath = qp + (qp.isEmpty() ? "" : ".") + gen.getNames().name(_cont);
            } else {
                qpath = gen.qualifiedPath(that, typeDecl, false);
            }
            if (pseudoAbstractConstructor) {
                if (typeDecl instanceof Constructor) {
                    gen.out(gen.memberAccessBase(extendedType, typeDecl, false, qpath), "$$a(");
                } else {
                    gen.out(gen.memberAccessBase(extendedType, typeDecl, false, qpath), gen.getNames().constructorSeparator(typeDecl), "$c$$$a(");
                }
            } else {
                gen.out(gen.memberAccessBase(extendedType, typeDecl, false, qpath), gen.opts.isOptimize() && gen.getSuperMemberScope(extendedType) != null ? ".call(this," : "(");
            }
            gen.getInvoker().generatePositionalArguments(invocation.getPrimary(), argList, argList.getPositionalArguments(), false, false);
            if (argList.getPositionalArguments().size() > 0) {
                gen.out(",", new String[0]);
            }
            if (plist != null && plist.getParameters().size() > argList.getPositionalArguments().size()) {
                for (int i = argList.getPositionalArguments().size(); i < plist.getParameters().size(); ++i) {
                    Parameter p = plist.getParameters().get(i);
                    if (p.isSequenced()) {
                        gen.out(gen.getClAlias(), "empty(),");
                        continue;
                    }
                    gen.out("undefined,", new String[0]);
                }
            }
            if (typeDecl instanceof Constructor) {
                typeParams = ((Class)typeDecl.getContainer()).getTypeParameters();
                if (typeParams != null && !typeParams.isEmpty()) {
                    typeParams = null;
                    if (ModelUtil.contains(d, typeDecl)) {
                        gen.out("$$targs$$,", new String[0]);
                    } else {
                        TypeUtils.printTypeArguments(that, extendedType.getTypeModel().getQualifyingType().getTypeArguments(), gen, false, null);
                        gen.out(",", new String[0]);
                    }
                }
            } else {
                typeParams = typeDecl.getTypeParameters();
            }
            if (typeParams != null && !typeParams.isEmpty()) {
                List<Type> typeArgs = null;
                if (extendedType.getTypeArgumentList() != null) {
                    typeArgs = extendedType.getTypeArgumentList().getTypeModels();
                }
                TypeUtils.printTypeArguments(that, TypeUtils.matchTypeParametersWithArguments(typeParams, typeArgs), gen, false, null);
                gen.out(",", new String[0]);
            }
            gen.out(gen.getNames().self(d), ")");
            gen.endLine(true);
        }
        TypeGenerator.copySuperMembers(typeDecl, superDecs, d, gen);
    }

    static void callSupertypes(List<Type> sats, Tree.SimpleType supertype, ClassOrInterface d, Node that, List<Declaration> superDecs, Tree.InvocationExpression invoke, ParameterList plist, GenerateJsVisitor gen) {
        if (sats != null) {
            ArrayList<Type> supers = new ArrayList<Type>(sats.size() + 1);
            supers.addAll(sats);
            if (supertype != null) {
                supers.add(supertype.getTypeModel());
            }
            Collections.sort(supers, new TypeComparator());
            HashSet<String> myTypeArgs = new HashSet<String>();
            for (TypeParameter tp : d.getTypeParameters()) {
                myTypeArgs.add(tp.getName());
            }
            for (Type st : supers) {
                if (supertype != null && st == supertype.getTypeModel()) {
                    TypeGenerator.callSuperclass(supertype, invoke, (Class)d, plist, that, false, superDecs, gen);
                    continue;
                }
                TypeDeclaration typeDecl = st.getDeclaration();
                ClassOrInterface _anoncont = d.isAnonymous() && ModelUtil.contains(ModelUtil.getContainingClassOrInterface(d.getContainer()), typeDecl) ? ModelUtil.getContainingClassOrInterface(d) : null;
                if (_anoncont == null) {
                    if (typeDecl.isStatic()) {
                        Declaration _cont = ModelUtil.getContainingDeclaration(typeDecl);
                        String qp = gen.qualifiedPath(that, _cont, false);
                        gen.out(qp, qp.isEmpty() ? "" : ".", gen.getNames().name(_cont), ".$st$.");
                    } else {
                        gen.qualify(that, typeDecl);
                    }
                    gen.out(gen.getNames().name(typeDecl), "(");
                } else {
                    gen.qualify(that, _anoncont);
                    gen.out(gen.getNames().name(typeDecl), ".call(", gen.getNames().self(ModelUtil.getContainingClassOrInterface(d.getContainer())), ",");
                }
                if (typeDecl.isParameterized()) {
                    TypeUtils.printTypeArguments(that, st.getTypeArguments(), gen, d.isToplevel(), null);
                    gen.out(",", new String[0]);
                }
                gen.out(gen.getNames().self(d), ")");
                gen.endLine(true);
                TypeGenerator.copySuperMembers(typeDecl, superDecs, d, gen);
            }
        } else if (supertype != null) {
            TypeGenerator.callSuperclass(supertype, invoke, (Class)d, plist, that, false, superDecs, gen);
        }
    }

    private static void copySuperMembers(TypeDeclaration typeDecl, List<Declaration> decs, ClassOrInterface d, GenerateJsVisitor gen) {
        if (!gen.opts.isOptimize() && decs != null) {
            for (Declaration dec : decs) {
                if (!typeDecl.isMember(dec)) continue;
                String suffix = gen.getNames().scopeSuffix(dec.getContainer());
                if (dec instanceof Value && ((Value)dec).isTransient()) {
                    TypeGenerator.superGetterRef(dec, d, suffix, gen);
                    if (!((Value)dec).isVariable()) continue;
                    TypeGenerator.superSetterRef(dec, d, suffix, gen);
                    continue;
                }
                gen.out(gen.getNames().self(d), ".", gen.getNames().name(dec), suffix, "=", gen.getNames().self(d), ".", gen.getNames().name(dec));
                gen.endLine(true);
            }
        }
    }

    private static void superGetterRef(Declaration d, ClassOrInterface sub, String parentSuffix, GenerateJsVisitor gen) {
        if (AttributeGenerator.defineAsProperty(d)) {
            gen.out(gen.getClAlias(), "copySuperAttr(", gen.getNames().self(sub), ",'", gen.getNames().name(d), "','", parentSuffix, "')");
        } else {
            gen.out(gen.getNames().self(sub), ".", gen.getNames().getter(d, false), parentSuffix, "=", gen.getNames().self(sub), ".", gen.getNames().getter(d, false));
        }
        gen.endLine(true);
    }

    private static void superSetterRef(Declaration d, ClassOrInterface sub, String parentSuffix, GenerateJsVisitor gen) {
        if (!AttributeGenerator.defineAsProperty(d)) {
            gen.out(gen.getNames().self(sub), ".", gen.getNames().setter(d), parentSuffix, "=", gen.getNames().self(sub), ".", gen.getNames().setter(d));
            gen.endLine(true);
        }
    }

    public static class StaticTypeComparator
    implements Comparator<Tree.StaticType> {
        @Override
        public int compare(Tree.StaticType o1, Tree.StaticType o2) {
            Declaration dd2;
            Declaration d2;
            Type t1 = o1.getTypeModel();
            Type t2 = o2.getTypeModel();
            if (ModelUtil.isTypeUnknown(t1)) {
                return ModelUtil.isTypeUnknown(t2) ? 0 : -1;
            }
            if (ModelUtil.isTypeUnknown(t2)) {
                return ModelUtil.isTypeUnknown(t1) ? 0 : -1;
            }
            if (t1.isSubtypeOf(t2)) {
                return 1;
            }
            if (t2.isSubtypeOf(t1)) {
                return -1;
            }
            for (Declaration d : t1.getDeclaration().getMembers()) {
                if (!(d instanceof TypedDeclaration) && !(d instanceof ClassOrInterface) || (d2 = t2.getDeclaration().getMember(d.getName(), null, false)) == null || !((dd2 = ModelUtil.getContainingDeclaration(d2)) instanceof TypeDeclaration) || !t1.getDeclaration().inherits((TypeDeclaration)dd2)) continue;
                return 1;
            }
            for (Declaration d : t2.getDeclaration().getMembers()) {
                if (!(d instanceof TypedDeclaration) && !(d instanceof ClassOrInterface) || (d2 = t1.getDeclaration().getMember(d.getName(), null, false)) == null || !((dd2 = ModelUtil.getContainingDeclaration(d2)) instanceof TypeDeclaration) || !t2.getDeclaration().inherits((TypeDeclaration)dd2)) continue;
                return -1;
            }
            return 0;
        }
    }
}

