/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.SequenceGenerator;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;

public class ValueVisitor
extends Visitor {
    private final TypedDeclaration declaration;
    private boolean inCapturingScope = false;
    private int sameScope;

    public ValueVisitor(TypedDeclaration declaration) {
        this.declaration = declaration;
    }

    private boolean enterCapturingScope() {
        boolean cs = this.inCapturingScope;
        this.inCapturingScope = true;
        return cs;
    }

    private void exitCapturingScope(boolean cs) {
        this.inCapturingScope = cs;
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        this.visitReference(that);
    }

    private void visitReference(Tree.Primary that) {
        if (this.inCapturingScope) {
            this.capture(that);
        }
    }

    private void capture(Tree.Primary that) {
        TypedDeclaration d;
        if (that instanceof Tree.MemberOrTypeExpression && (d = (TypedDeclaration)((Tree.MemberOrTypeExpression)that).getDeclaration()) == this.declaration) {
            if (d.isParameter()) {
                if (!d.getContainer().equals(that.getScope()) || this.sameScope > 0) {
                    ((FunctionOrValue)d).setJsCaptured(true);
                }
            } else if (d instanceof Value && !ModelUtil.isConstructor(d) && !d.isToplevel()) {
                ((Value)d).setJsCaptured(true);
            }
        }
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        super.visit(that);
        if (this.isSelfReference(that.getPrimary())) {
            this.visitReference(that);
        } else {
            this.capture(that);
        }
    }

    private boolean isSelfReference(Tree.Primary that) {
        return that instanceof Tree.This || that instanceof Tree.Outer;
    }

    @Override
    public void visit(Tree.Declaration that) {
        Declaration dm = that.getDeclarationModel();
        if (dm == this.declaration.getContainer() || dm == this.declaration || dm instanceof Setter && ((Setter)dm).getGetter() == this.declaration) {
            this.inCapturingScope = false;
        }
        super.visit(that);
    }

    private void captureContainer(Declaration d) {
        if (d == null || d.isAnonymous()) {
            return;
        }
        Declaration cd = ModelUtil.getContainingDeclaration(d);
        if (cd != null && !cd.isAnonymous() && !cd.isJsCaptured() && cd instanceof FunctionOrValue) {
            ((FunctionOrValue)cd).setJsCaptured(true);
        }
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that.getClassBody());
        this.captureContainer(that.getDeclarationModel());
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        boolean cs = this.enterCapturingScope();
        super.visit(that);
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.LazySpecifierExpression that) {
        if (that.getExpression() == null) {
            return;
        }
        boolean cs = this.enterCapturingScope();
        ++this.sameScope;
        that.getExpression().visit(this);
        --this.sameScope;
        this.exitCapturingScope(cs);
    }

    @Override
    public void visit(Tree.Parameter that) {
        if (that.getParameterModel().getDeclaration() instanceof Class) {
            that.getParameterModel().getModel().setJsCaptured(true);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.SequenceEnumeration that) {
        boolean cs = this.enterCapturingScope();
        if (that.getSequencedArgument() != null && !SequenceGenerator.allLiterals(that.getSequencedArgument().getPositionalArguments())) {
            for (Tree.PositionalArgument arg : that.getSequencedArgument().getPositionalArguments()) {
                if (arg instanceof Tree.ListedArgument) {
                    ((Tree.ListedArgument)arg).getExpression().visit(this);
                    continue;
                }
                if (arg instanceof Tree.SpreadArgument) {
                    ((Tree.SpreadArgument)arg).getExpression().visit(this);
                    continue;
                }
                if (!(arg instanceof Tree.Comprehension)) continue;
                arg.visit(this);
            }
        }
        this.exitCapturingScope(cs);
    }
}

