/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.loader;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.impl.AbstractRepository;
import com.redhat.ceylon.cmr.resolver.javascript.JavaScriptResolver;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.compiler.js.CeylonRunJsException;
import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.js.loader.JsModuleManagerFactory;
import com.redhat.ceylon.compiler.js.loader.JsonModule;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsModuleSourceMapper
extends ModuleSourceMapper {
    private boolean clLoaded;
    private String encoding;

    public JsModuleSourceMapper(Context context, ModuleManager moduleManager, String encoding) {
        super(context, moduleManager);
        this.encoding = encoding;
    }

    protected void loadModuleFromMap(ArtifactResult artifact, Module module, LinkedList<Module> dependencyTree, List<PhasedUnits> phasedUnitsOfDependencies, boolean forCompiledModule, Map<String, Object> model) {
        List deps = (List)model.get("$mod-deps");
        if (deps != null) {
            for (Object dep : deps) {
                String s;
                boolean optional = false;
                boolean export = false;
                if (dep instanceof Map) {
                    Map depmap = (Map)dep;
                    s = (String)depmap.get("path");
                    optional = depmap.containsKey("opt");
                    export = depmap.containsKey("exp");
                } else {
                    s = (String)dep;
                }
                int p = s.indexOf(47);
                String depuri = null;
                String depv = null;
                if (p > 0) {
                    depuri = s.substring(0, p);
                    depv = s.substring(p + 1);
                    if (depv.isEmpty()) {
                        depv = null;
                    }
                    if ("ceylon.language".equals(depuri)) {
                        if ("1.1.0".equals(depv)) {
                            depv = "1.2.0";
                        } else if ("1.2.1".equals(depv)) {
                            depv = "1.3.3";
                        } else if ("1.2.2".equals(depv)) {
                            depv = "1.3.3";
                        } else if ("1.3.0".equals(depv)) {
                            depv = "1.3.3";
                        } else if ("1.3.1".equals(depv)) {
                            depv = "1.3.3";
                        } else if ("1.3.2".equals(depv)) {
                            depv = "1.3.3";
                        }
                    }
                } else {
                    depuri = s;
                }
                String depnamespace = ModuleUtil.getNamespaceFromUri(depuri);
                String depname = ModuleUtil.getModuleNameFromUri(depuri);
                JsonModule mod = (JsonModule)this.getModuleManager().getOrCreateModule(ModuleManager.splitModuleName(depname), depv);
                Backends backends = mod.getNativeBackends();
                ModuleImport imp = new ModuleImport(depnamespace, (Module)mod, optional, export, backends);
                module.addImport(imp);
            }
            model.remove("$mod-deps");
            this.overrideModuleImports(module, artifact);
        }
        ((JsonModule)module).setModel(model);
        ((JsonModule)module).loadDeclarations();
    }

    public static Map<String, Object> loadJsonModel(File jsFile) {
        try {
            Map<String, Object> model = JavaScriptResolver.readJsonModel(jsFile);
            if (model == null) {
                throw new CompilerErrorException("Can't find metamodel definition in " + jsFile.getAbsolutePath());
            }
            if (!model.containsKey("$mod-bin")) {
                throw new CeylonRunJsException("The JavaScript module " + jsFile + " is not compatible with the current version of ceylon-js");
            }
            return model;
        }
        catch (IOException ex) {
            throw new CompilerErrorException("Error loading model from " + jsFile);
        }
    }

    @Override
    public void resolveModule(ArtifactResult artifact, Module module, ModuleImport moduleImport, LinkedList<Module> dependencyTree, List<PhasedUnits> phasedUnitsOfDependencies, boolean forCompiledModule) {
        File js;
        if (!this.clLoaded) {
            this.clLoaded = true;
            if (!"ceylon.language".equals(artifact.name()) || !artifact.artifact().getName().endsWith("-model.js")) {
                if (JsModuleManagerFactory.isVerbose()) {
                    System.out.println("Loading JS language module before any other modules");
                }
                ArtifactContext ac = new ArtifactContext(null, "ceylon.language", module.getLanguageModule().getVersion(), "-model.js");
                ac.setIgnoreDependencies(true);
                ac.setThrowErrorIfMissing(true);
                ArtifactResult lmar = this.getContext().getRepositoryManager().getArtifactResult(ac);
                this.resolveModule(lmar, module.getLanguageModule(), null, dependencyTree, phasedUnitsOfDependencies, forCompiledModule);
            }
        }
        if ((js = artifact.artifact()).getName().endsWith(".js") && !js.getName().endsWith("-model.js")) {
            ArtifactContext ac = new ArtifactContext(artifact.namespace(), artifact.name(), artifact.version(), "-model.js");
            ac.setIgnoreDependencies(true);
            ac.setThrowErrorIfMissing(true);
            ArtifactResult lmar = this.getContext().getRepositoryManager().getArtifactResult(ac);
            js = lmar.artifact();
        }
        if (module instanceof JsonModule) {
            if (((JsonModule)module).getModel() != null) {
                return;
            }
            if (js.exists() && js.isFile() && js.canRead() && js.getName().endsWith("-model.js")) {
                Map<String, Object> model;
                if (JsModuleManagerFactory.isVerbose()) {
                    System.out.println("Loading model from " + js);
                }
                if ((model = JsModuleSourceMapper.loadJsonModel(js)) == null) {
                    if (JsModuleManagerFactory.isVerbose()) {
                        System.out.println("Model not found in " + js);
                    }
                } else {
                    this.loadModuleFromMap(artifact, module, dependencyTree, phasedUnitsOfDependencies, forCompiledModule, model);
                    return;
                }
            }
            if ("npm".equals(artifact.namespace())) {
                try {
                    File root = ((AbstractRepository)artifact.repository()).getRoot().getContent(File.class);
                    String npmPath = artifact.artifact().getAbsolutePath().replace(File.separator, "/");
                    ((JsonModule)module).setNpmPath(npmPath.substring(root.getAbsolutePath().length() + 1));
                    module.setJsMajor(10);
                    module.setJsMinor(0);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
        super.resolveModule(artifact, module, moduleImport, dependencyTree, phasedUnitsOfDependencies, forCompiledModule);
    }

    @Override
    protected PhasedUnits createPhasedUnits() {
        PhasedUnits units = super.createPhasedUnits();
        String fileEncoding = this.encoding;
        if (fileEncoding == null) {
            fileEncoding = CeylonConfig.get("defaults.encoding");
        }
        if (fileEncoding != null) {
            units.setEncoding(fileEncoding);
        }
        return units;
    }
}

