/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.compiler.js.BlockWithCaptureVisitor;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Scope;
import java.util.IdentityHashMap;

public class ContinueBreakVisitor
extends Visitor {
    private boolean breaks;
    private boolean continues;
    private boolean returns;
    private final Scope scope;
    private final JsIdentifierNames names;
    private String bname;
    private String cname;
    private String rname;
    private int level;
    private boolean ignore;
    private int loops;
    private final IdentityHashMap<Tree.Directive, Boolean> dirs = new IdentityHashMap();

    public ContinueBreakVisitor(Tree.Block n, JsIdentifierNames names) {
        this.scope = n.getScope();
        this.names = names;
        n.visit(this);
    }

    @Override
    public void visit(Tree.Block that) {
        ++this.level;
        if (this.level > 1) {
            this.ignore = new BlockWithCaptureVisitor(that).hasCapture();
        }
        super.visit(that);
        this.ignore = false;
        --this.level;
    }

    @Override
    public void visit(Tree.Break n) {
        if (this.ignore || this.loops > 0) {
            return;
        }
        if (this.bname == null) {
            this.bname = this.names.createTempVariable();
        }
        this.breaks = true;
        this.dirs.put(n, true);
        super.visit(n);
    }

    @Override
    public void visit(Tree.Continue n) {
        if (this.ignore || this.loops > 0) {
            return;
        }
        if (this.cname == null) {
            this.cname = this.names.createTempVariable();
        }
        this.continues = true;
        this.dirs.put(n, true);
        super.visit(n);
    }

    @Override
    public void visit(Tree.Return n) {
        if (this.ignore) {
            return;
        }
        this.returns = true;
        super.visit(n);
    }

    @Override
    public void visit(Tree.ForStatement that) {
        if (this.ignore) {
            return;
        }
        ++this.loops;
        super.visit(that);
        --this.loops;
    }

    @Override
    public void visit(Tree.WhileStatement that) {
        if (this.ignore) {
            return;
        }
        ++this.loops;
        super.visit(that);
        --this.loops;
    }

    public boolean belongs(Tree.Directive dir) {
        return this.dirs.containsKey(dir);
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isContinues() {
        return this.continues;
    }

    public boolean isReturns() {
        return this.returns;
    }

    public boolean isBreaks() {
        return this.breaks;
    }

    public String getContinueName() {
        return this.cname;
    }

    public String getBreakName() {
        return this.bname;
    }

    public String getReturnName() {
        if (this.rname == null) {
            this.rname = this.names.createTempVariable();
        }
        return this.rname;
    }
}

