/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.compiler.js.JsCompiler;
import com.redhat.ceylon.compiler.js.util.JsUtils;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsIdentifierNames {
    private final JsCompiler compiler;
    private static long uniqueID = 0L;
    private static Set<String> trueReservedWords = new HashSet<String>();
    private static Set<String> reservedWords = new HashSet<String>();
    private static Set<String> globals = new HashSet<String>();
    private Map<Module, Long> moduleUIDs = new HashMap<Module, Long>();
    private Map<Declaration, Long> uniqueVarIDs = new HashMap<Declaration, Long>();
    private Map<Declaration, String> uniqueVarNames = new HashMap<Declaration, String>();

    private static long nextUID() {
        if (++uniqueID <= 0L) {
            uniqueID = 1L;
        }
        return uniqueID;
    }

    public static boolean isTrueReservedWord(String token) {
        return trueReservedWords.contains(token);
    }

    public static boolean isReservedWord(String token) {
        return reservedWords.contains(token);
    }

    public JsIdentifierNames(JsCompiler compiler) {
        this.compiler = compiler;
    }

    public String name(Declaration decl) {
        return this.getName(decl, false, false);
    }

    public String name(Parameter param) {
        boolean nonLocal;
        if (param == null) {
            return null;
        }
        String name = param.getName();
        FunctionOrValue decl = param.getModel();
        boolean bl = nonLocal = decl.isShared() && decl.isMember() || decl.isToplevel() && decl instanceof Function;
        if (nonLocal) {
            String suffix = this.nestingSuffix(decl, false);
            if (suffix.length() > 0) {
                name = name + suffix;
            } else if (reservedWords.contains(name)) {
                name = "$_" + name;
            }
        } else {
            name = this.uniquePrivateName(decl, false);
        }
        return JsUtils.escapeStringLiteral(name);
    }

    public String valueName(FunctionOrValue d) {
        return d.isShared() && !d.isActual() ? this.name(d) + "_" : this.privateName(d);
    }

    public String privateName(Declaration decl) {
        return this.getName(decl, false, true);
    }

    public String objectName(Declaration decl) {
        String name = this.getName(decl, true, false);
        if (reservedWords.contains(name)) {
            name = "$_" + name;
        }
        if (decl.isToplevel()) {
            int binMajor = decl.getUnit().getPackage().getModule().getJsMajor();
            if (binMajor > 0 && binMajor < 10) {
                return String.format("get%c%s()", Character.valueOf(Character.toUpperCase(name.charAt(0))), name.substring(1));
            }
            return String.format("%s()", name);
        }
        return name;
    }

    public String getter(Declaration decl, boolean forMetamodel) {
        if (decl == null) {
            return "";
        }
        String name = this.getName(decl, true, false);
        int binMajor = decl.getUnit().getPackage().getModule().getJsMajor();
        if (!(forMetamodel || decl.isClassOrInterfaceMember() || binMajor != 0 && binMajor != 10)) {
            return reservedWords.contains(name) ? "$_" + name : name;
        }
        return String.format("%sget%c%s", forMetamodel ? "$prop$" : "", Character.valueOf(Character.toUpperCase(name.charAt(0))), name.substring(1));
    }

    public String setter(Declaration decl) {
        String name = this.getName(decl, true, false);
        Module mod = decl.getUnit().getPackage().getModule();
        if (mod.getJsMajor() > 0 && (mod.getJsMajor() < 9 || mod.getJsMajor() == 9 && mod.getJsMinor() < 1)) {
            return String.format("set%c%s", Character.valueOf(Character.toUpperCase(name.charAt(0))), name.substring(1));
        }
        return String.format("set$%s", name);
    }

    public String moduleAlias(Module pkg) {
        if (this.compiler.isCompilingLanguageModule() && pkg.getLanguageModule() == pkg) {
            return "";
        }
        StringBuilder sb = new StringBuilder("m$");
        sb.append(Long.toString(this.getUID(pkg), 36));
        return sb.toString();
    }

    public String createTempVariable() {
        return "$" + Long.toString(JsIdentifierNames.nextUID(), 36);
    }

    public String self(TypeDeclaration decl) {
        if (decl instanceof Constructor) {
            decl = (TypeDeclaration)decl.getContainer();
        }
        String name = JsUtils.escapeStringLiteral(decl.getName());
        name = decl.isShared() || decl.isToplevel() ? name + this.nestingSuffix(decl, true) : "$" + Long.toString(this.getUID(decl), 36);
        return String.format("%c%s$", Character.valueOf(Character.toLowerCase(name.charAt(0))), name.substring(1));
    }

    public String scopeSuffix(Scope scope) {
        return String.format("$%s", scope.getQualifiedNameString().replace("::", "$").replace('.', '$'));
    }

    private String nestingSuffix(Declaration decl, boolean forSelf) {
        String suffix = "";
        if (decl instanceof TypeDeclaration && (forSelf || !decl.isAnonymous()) && !ModelUtil.isConstructor(decl)) {
            StringBuilder sb = new StringBuilder();
            Scope scope = ModelUtil.getRealScope(this.originalDeclaration(decl).getContainer());
            while (scope instanceof TypeDeclaration) {
                sb.append('$');
                sb.append(((TypeDeclaration)scope).getName().replaceAll("#", ""));
                scope = scope.getContainer();
            }
            suffix = sb.toString();
        }
        return suffix;
    }

    public void forceName(Declaration decl, String name) {
        if (name == null) {
            this.uniqueVarNames.remove(decl);
        } else {
            this.uniqueVarNames.put(decl, name);
        }
    }

    private String getName(Declaration decl, boolean forGetterSetter, boolean priv) {
        boolean nonLocal;
        if (decl == null) {
            return null;
        }
        String name = decl.getName();
        if (name == null && ModelUtil.isConstructor(decl)) {
            return "$c$";
        }
        if (name.startsWith("anonymous#")) {
            name = "anon$" + name.substring(10);
        }
        if (decl.isDynamic()) {
            return JsUtils.escapeStringLiteral(decl.getName());
        }
        boolean bl = nonLocal = !priv;
        if (nonLocal) {
            boolean bl2 = decl.isMember() ? decl.isShared() || decl instanceof TypeDeclaration : (nonLocal = decl.isToplevel() && (forGetterSetter || decl instanceof Function || decl instanceof ClassOrInterface || decl instanceof TypeAlias));
        }
        if (nonLocal && decl instanceof Class && ((Class)decl).isAnonymous() && !forGetterSetter) {
            nonLocal = false;
        }
        if (nonLocal) {
            String suffix = this.nestingSuffix(decl, false);
            if (suffix.length() > 0) {
                name = name + suffix;
            } else if (!forGetterSetter && !ModelUtil.isConstructor(decl) && reservedWords.contains(name) || this.isJsGlobal(decl)) {
                name = "$_" + name;
            }
        } else {
            name = this.uniquePrivateName(decl, priv);
        }
        Package declPkg = decl.getUnit().getPackage();
        if (decl.isToplevel() && !declPkg.equals(declPkg.getModule().getRootPackage())) {
            Package raiz = declPkg.getModule().getRootPackage();
            String rootName = raiz == null ? (declPkg.getModule().isDefaultModule() ? "" : declPkg.getModule().getNameAsString()) : raiz.getNameAsString();
            String pkgName = declPkg.getNameAsString();
            rootName = pkgName.substring(rootName.length()).replaceAll("\\.", "\\$");
            if (rootName.length() > 0 && rootName.charAt(0) != '$') {
                rootName = '$' + rootName;
            }
            name = name + rootName;
        }
        if (decl instanceof TypeAlias) {
            name = name + "()";
        }
        return JsUtils.escapeStringLiteral(name);
    }

    private String uniquePrivateName(Declaration d, boolean priv) {
        String name = this.uniqueVarNames.get(d);
        if (name != null) {
            return name;
        }
        if (d.isClassOrInterfaceMember() && !this.compiler.isCompilingLanguageModule()) {
            String containerName = d.getUnit().getPackage().getModule().getNameAsString();
            return String.format(priv ? "$%s$%s_" : "$%s$%s", Integer.toString(Math.abs(containerName.hashCode()), 36), Long.toString(this.getUID(d), 36));
        }
        return String.format(priv ? "$%s_" : "$%s", Long.toString(this.getUID(d), 36));
    }

    private Declaration originalDeclaration(Declaration decl) {
        Declaration d;
        Declaration refinedDecl = decl;
        while ((d = refinedDecl.getRefinedDeclaration()) != null && d != refinedDecl) {
            refinedDecl = d;
        }
        return refinedDecl;
    }

    private long getUID(Declaration decl) {
        Long id = this.uniqueVarIDs.get(decl);
        if (id == null) {
            id = JsIdentifierNames.nextUID();
            this.uniqueVarIDs.put(decl, id);
        }
        return id;
    }

    private long getUID(Module pkg) {
        Long id = this.moduleUIDs.get(pkg);
        if (id == null) {
            id = JsIdentifierNames.nextUID();
            this.moduleUIDs.put(pkg, id);
        }
        return id;
    }

    public String typeArgsParamName(Function m) {
        return "$" + Long.toString(Math.abs(m.getQualifiedNameString().hashCode()), 36) + "$";
    }

    public String typeParameterName(TypeParameter tp) {
        String cname = tp.getDeclaration().isAnonymous() ? this.name(tp.getDeclaration()) : tp.getDeclaration().getName();
        return tp.getName() + "$" + cname;
    }

    public String valueConstructorName(TypeDeclaration d) {
        TypeDeclaration c = (TypeDeclaration)d.getContainer();
        return this.name(c) + this.constructorSeparator(d) + this.name(c.getDirectMember(d.getName(), null, false));
    }

    public String constructorSeparator(Declaration c) {
        Module mod = c.getUnit().getPackage().getModule();
        if (mod.getJsMajor() > 0 && (mod.getJsMajor() < 9 || mod.getJsMajor() == 9 && mod.getJsMinor() < 1)) {
            return "_";
        }
        return "$c_";
    }

    public boolean isJsGlobal(Declaration d) {
        return d.isToplevel() && globals.contains(d.getName()) && d.getUnit().getPackage().getModule().getJsMajor() == 0;
    }

    static {
        trueReservedWords.addAll(Arrays.asList("undefined", "boolean", "byte", "char", "const", "debugger", "default", "delete", "do", "double", "enum", "export", "false", "final", "float", "goto", "implements", "instanceof", "int", "long", "native", "new", "null", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "true", "typeof", "var", "volatile", "with", "abstract", "process", "require", "class", "extends", "import", "await", "break", "case", "catch", "continue", "else", "finally", "for", "function", "if", "in", "return", "switch", "this", "throw", "try", "while", "with", "super"));
        reservedWords.addAll(trueReservedWords);
        reservedWords.addAll(Arrays.asList("Date", "Object", "Boolean", "Error", "Number", "RegExp"));
        reservedWords.addAll(Arrays.asList("hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable"));
        reservedWords.add("Function");
        reservedWords.addAll(Arrays.asList("call", "arguments", "caller", "apply", "bind", "eval"));
        reservedWords.addAll(Arrays.asList("toFixed", "valueOf", "toPrecision", "toExponential"));
        reservedWords.add("String");
        reservedWords.addAll(Arrays.asList("charAt", "strike", "fixed", "sub", "charCodeAt", "trimLeft", "toLocaleUpperCase", "toUpperCase", "fontsize", "search", "toLocaleLowerCase", "small", "big", "fontcolor", "blink", "trim", "bold", "match", "substr", "trimRight", "replace", "split", "sup", "link", "localeCompare", "valueOf", "substring", "toLowerCase", "italics", "anchor"));
        reservedWords.add("Array");
        reservedWords.addAll(Arrays.asList("toLocaleString", "splice", "map", "forEach", "reverse", "join", "push", "shift", "pop", "sort", "unshift", "reduceRight", "reduce", "every", "filter"));
        reservedWords.addAll(Arrays.asList("length", "toString", "constructor", "prototype", "concat", "indexOf", "lastIndexOf", "slice", "get"));
        globals.addAll(Arrays.asList("parseFloat", "uneval", "isFinite", "isNaN", "parseInt", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent", "escape", "unescape", "Symbol", "EvalError", "InternalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError", "Math", "DataView", "JSON", "ArrayBuffer"));
    }
}

