/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.js.util.Options;
import java.io.PrintWriter;
import java.io.Writer;

public class JsLogger
implements Logger {
    private PrintWriter out;
    private boolean verbose;

    public JsLogger(Options opts) {
        Writer outWriter = opts.getOutWriter();
        this.out = outWriter == null ? new PrintWriter(System.err, true) : new PrintWriter(outWriter, true);
        this.verbose = opts.isVerbose();
    }

    @Override
    public void error(String str) {
        this.out.print("Error: ");
        this.out.println(str);
    }

    @Override
    public void warning(String str) {
        this.out.print("Warning: ");
        this.out.println(str);
    }

    @Override
    public void info(String str) {
        this.out.print("Note: ");
        this.out.println(str);
    }

    @Override
    public void debug(String str) {
        if (this.verbose) {
            this.out.print("[");
            this.out.print(str);
            this.out.println("]");
        }
    }
}

