/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class JsWriter {
    private final boolean minify;
    private final PrintWriter verboseOut;
    private Writer out;
    private Writer originalOut;
    private int nlcount = 0;

    public JsWriter(Writer output, PrintWriter verboseOut, boolean minify) {
        this.out = output;
        this.verboseOut = verboseOut;
        this.minify = minify;
        this.originalOut = this.out;
    }

    public void write(String code, String ... codez) {
        try {
            if (!"\n".equals(code)) {
                this.nlcount = 0;
            }
            this.out.write(code);
            for (String s : codez) {
                this.out.write(s);
            }
            if (this.verboseOut != null && this.out == this.originalOut) {
                this.verboseOut.print(code);
                for (String s : codez) {
                    this.verboseOut.print(s);
                }
                this.verboseOut.flush();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Generating JS code", ioe);
        }
    }

    public void endLine(boolean semicolon) {
        if (semicolon) {
            this.write(";", new String[0]);
            if (this.minify) {
                return;
            }
        }
        ++this.nlcount;
        if (this.nlcount > 1) {
            return;
        }
        this.write("\n", new String[0]);
    }

    public void beginBlock() {
        this.write("{", new String[0]);
        if (!this.minify) {
            this.endLine(false);
        }
    }

    public void endBlock(boolean semicolon, boolean newline) {
        if (!this.minify) {
            this.endLine(false);
        }
        this.write(semicolon ? "};" : "}", new String[0]);
        if (semicolon && this.minify) {
            return;
        }
        if (newline) {
            this.endLine(false);
        }
    }

    public void spitOut(String s) {
        if (this.verboseOut == null) {
            System.out.println(s);
        } else {
            this.verboseOut.println(s);
        }
    }

    public String generateToString(GenerateJsVisitor.GenerateCallback callback) {
        Writer oldWriter = this.out;
        this.out = new StringWriter();
        callback.generateValue();
        String str = this.out.toString();
        this.out = oldWriter;
        return str;
    }
}

